/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qaudioformat_wrapper.h"

// Extra includes
#include <qaudioformat.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQAudioFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAudioFormat* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAudioFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAudioFormat()
        cptr = new QAudioFormat();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QAudioFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAudioFormat* cpp_arg0 = Shiboken::Converter<QAudioFormat* >::toCpp(pyargs[0]);
        // QAudioFormat(QAudioFormat)
        cptr = new QAudioFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAudioFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAudioFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAudioFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtMultimedia.QAudioFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAudioFormat", overloads);
        return -1;
}

static PyObject* SbkQAudioFormatFunc_byteOrder(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // byteOrder()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    QAudioFormat::Endian cpp_result = cppSelf->QAudioFormat::byteOrder();
    py_result = Shiboken::Converter<QAudioFormat::Endian >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_channels(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // channels()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioFormat::channels();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_codec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // codec()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAudioFormat::codec();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_frequency(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frequency()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioFormat::frequency();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAudioFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_sampleSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sampleSize()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAudioFormat::sampleSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_sampleType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sampleType()const
    QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
    QAudioFormat::SampleType cpp_result = cppSelf->QAudioFormat::sampleType();
    py_result = Shiboken::Converter<QAudioFormat::SampleType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAudioFormatFunc_setByteOrder(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAudioFormat::Endian >::isConvertible(arg)) {
        QAudioFormat::Endian cpp_arg0 = Shiboken::Converter<QAudioFormat::Endian >::toCpp(arg);
        // setByteOrder(QAudioFormat::Endian)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setByteOrder(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setByteOrder_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setByteOrder_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAudioFormat.Endian", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setByteOrder", overloads);
        return 0;
}

static PyObject* SbkQAudioFormatFunc_setChannels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setChannels(int)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setChannels(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setChannels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setChannels_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setChannels", overloads);
        return 0;
}

static PyObject* SbkQAudioFormatFunc_setCodec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCodec(QString)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setCodec(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setCodec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setCodec", overloads);
        return 0;
}

static PyObject* SbkQAudioFormatFunc_setFrequency(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setFrequency(int)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setFrequency(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setFrequency_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setFrequency_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setFrequency", overloads);
        return 0;
}

static PyObject* SbkQAudioFormatFunc_setSampleSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSampleSize(int)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setSampleSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setSampleSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setSampleSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setSampleSize", overloads);
        return 0;
}

static PyObject* SbkQAudioFormatFunc_setSampleType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAudioFormat::SampleType >::isConvertible(arg)) {
        QAudioFormat::SampleType cpp_arg0 = Shiboken::Converter<QAudioFormat::SampleType >::toCpp(arg);
        // setSampleType(QAudioFormat::SampleType)
        QAudioFormat* cppSelf = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);
        cppSelf->QAudioFormat::setSampleType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAudioFormatFunc_setSampleType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAudioFormatFunc_setSampleType_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAudioFormat.SampleType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAudioFormat.setSampleType", overloads);
        return 0;
}

static PyMethodDef SbkQAudioFormat_methods[] = {
    {"byteOrder", (PyCFunction)SbkQAudioFormatFunc_byteOrder, METH_NOARGS},
    {"channels", (PyCFunction)SbkQAudioFormatFunc_channels, METH_NOARGS},
    {"codec", (PyCFunction)SbkQAudioFormatFunc_codec, METH_NOARGS},
    {"frequency", (PyCFunction)SbkQAudioFormatFunc_frequency, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQAudioFormatFunc_isValid, METH_NOARGS},
    {"sampleSize", (PyCFunction)SbkQAudioFormatFunc_sampleSize, METH_NOARGS},
    {"sampleType", (PyCFunction)SbkQAudioFormatFunc_sampleType, METH_NOARGS},
    {"setByteOrder", (PyCFunction)SbkQAudioFormatFunc_setByteOrder, METH_O},
    {"setChannels", (PyCFunction)SbkQAudioFormatFunc_setChannels, METH_O},
    {"setCodec", (PyCFunction)SbkQAudioFormatFunc_setCodec, METH_O},
    {"setFrequency", (PyCFunction)SbkQAudioFormatFunc_setFrequency, METH_O},
    {"setSampleSize", (PyCFunction)SbkQAudioFormatFunc_setSampleSize, METH_O},
    {"setSampleType", (PyCFunction)SbkQAudioFormatFunc_setSampleType, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQAudioFormat_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QAudioFormat& cpp_self = *Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QAudioFormat & >::isConvertible(other)) {
                // operator!=(const QAudioFormat & other) const
                QAudioFormat* cpp_other = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QAudioFormat  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQAudioFormat_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QAudioFormat & >::isConvertible(other)) {
                // operator==(const QAudioFormat & other) const
                QAudioFormat* cpp_other = Shiboken::Converter<QAudioFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QAudioFormat  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQAudioFormat_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQAudioFormat_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAudioFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAudioFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQAudioFormat_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAudioFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAudioFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAudioFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtMultimedia_QAudioFormat_SampleType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAudioFormat_SampleType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SampleType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAudioFormat_SampleType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAudioFormat_SampleType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAudioFormat_SampleType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QAudioFormat_Endian_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAudioFormat_Endian_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAudioFormat_Endian_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Endian",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAudioFormat_Endian_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAudioFormat_Endian_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAudioFormat_Endian_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAudioFormat(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAudioFormat_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAudioFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAudioFormat_Type));
    PyModule_AddObject(module, "QAudioFormat",
        ((PyObject*)&SbkQAudioFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SampleType
    SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX] = &SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type);
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
            "SampleType",((PyObject*)&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type,
        (long) QAudioFormat::Unknown, "Unknown");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "Unknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type.tp_dict,
        "Unknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type,
        (long) QAudioFormat::SignedInt, "SignedInt");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "SignedInt", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type.tp_dict,
        "SignedInt", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type,
        (long) QAudioFormat::UnSignedInt, "UnSignedInt");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "UnSignedInt", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type.tp_dict,
        "UnSignedInt", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type,
        (long) QAudioFormat::Float, "Float");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "Float", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_SampleType_Type.tp_dict,
        "Float", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAudioFormat::SampleType");

    // init enum class: Endian
    SbkPySide_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX] = &SbkPySide_QtMultimedia_QAudioFormat_Endian_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAudioFormat_Endian_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAudioFormat_Endian_Type);
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
            "Endian",((PyObject*)&SbkPySide_QtMultimedia_QAudioFormat_Endian_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_Endian_Type,
        (long) QAudioFormat::BigEndian, "BigEndian");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "BigEndian", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_Endian_Type.tp_dict,
        "BigEndian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAudioFormat_Endian_Type,
        (long) QAudioFormat::LittleEndian, "LittleEndian");
    PyDict_SetItemString(SbkQAudioFormat_Type.super.ht_type.tp_dict,
        "LittleEndian", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAudioFormat_Endian_Type.tp_dict,
        "LittleEndian", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAudioFormat::Endian");

    Shiboken::TypeResolver::createValueTypeResolver<QAudioFormat >("QAudioFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QAudioFormat >(typeid(QAudioFormat).name());
}


} // extern "C"

