/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtreeview_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qheaderview.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qitemselectionmodel.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qscrollbar.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qtreeview.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTreeViewWrapper::QTreeViewWrapper(QWidget * parent) : QTreeView(parent), m_metaObject(0) {
    // ... middle
}

void QTreeViewWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QFrame::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEditor"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::closeEditor(editor, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QAbstractItemDelegate::EndEditHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::commitData(QWidget * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::commitData(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::currentChanged(const QModelIndex & current, const QModelIndex & previous)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::currentChanged(current, previous);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(current),
        Shiboken::Converter<QModelIndex & >::toPython(previous)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dataChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::dataChanged(topLeft, bottomRight);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(topLeft),
        Shiboken::Converter<QModelIndex & >::toPython(bottomRight)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeViewWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::doItemsLayout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "doItemsLayout"));
    if (py_override.isNull()) {
        return this->QTreeView::doItemsLayout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::dragEnterEvent(QDragEnterEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::dragLeaveEvent(QDragLeaveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::dragMoveEvent(QDragMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::drawBranches(QPainter * painter, const QRect & rect, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawBranches"));
    if (py_override.isNull()) {
        return this->QTreeView::drawBranches(painter, rect, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::drawRow(QPainter * painter, const QStyleOptionViewItem & options, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawRow"));
    if (py_override.isNull()) {
        return this->QTreeView::drawRow(painter, options, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(options),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::dropEvent(QDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTreeViewWrapper::edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "edit"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::edit(index, trigger, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QAbstractItemView::EditTrigger >::toPython(trigger),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.edit", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 2));
    return cpp_result;
}

void QTreeViewWrapper::editorDestroyed(QObject * editor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorDestroyed"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::editorDestroyed(editor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QObject * >::toPython(editor)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTreeViewWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTreeViewWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTreeViewWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeViewWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTreeViewWrapper::horizontalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalOffset"));
    if (py_override.isNull()) {
        return this->QTreeView::horizontalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.horizontalOffset", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::horizontalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QTreeView::horizontalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::horizontalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "horizontalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::horizontalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QModelIndex QTreeViewWrapper::indexAt(const QPoint & p) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexAt"));
    if (py_override.isNull()) {
        return this->QTreeView::indexAt(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPoint & >::toPython(p)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.indexAt", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QTreeViewWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QTreeViewWrapper::isIndexHidden(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isIndexHidden"));
    if (py_override.isNull()) {
        return this->QTreeView::isIndexHidden(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.isIndexHidden", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::keyboardSearch(const QString & search)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyboardSearch"));
    if (py_override.isNull()) {
        return this->QTreeView::keyboardSearch(search);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(search)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTreeViewWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QTreeViewWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::mouseDoubleClickEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTreeViewWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QTreeView::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsAboutToBeRemoved"));
    if (py_override.isNull()) {
        return this->QTreeView::rowsAboutToBeRemoved(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Sii)",
        Shiboken::Converter<QModelIndex & >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::rowsInserted(const QModelIndex & parent, int start, int end)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowsInserted"));
    if (py_override.isNull()) {
        return this->QTreeView::rowsInserted(parent, start, end);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Sii)",
        Shiboken::Converter<QModelIndex & >::toPython(parent),
        start,
        end
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::scrollContentsBy(int dx, int dy)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollContentsBy"));
    if (py_override.isNull()) {
        return this->QTreeView::scrollContentsBy(dx, dy);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(ii)",
        dx,
        dy
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "scrollTo"));
    if (py_override.isNull()) {
        return this->QTreeView::scrollTo(index, hint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QAbstractItemView::ScrollHint >::toPython(hint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::selectAll()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectAll"));
    if (py_override.isNull()) {
        return this->QTreeView::selectAll();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QModelIndex > QTreeViewWrapper::selectedIndexes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectedIndexes"));
    if (py_override.isNull()) {
        return this->QTreeView::selectedIndexes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.selectedIndexes", "list", py_result->ob_type->tp_name);
        return QList<QModelIndex >();
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::selectionChanged(const QItemSelection & selected, const QItemSelection & deselected)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionChanged"));
    if (py_override.isNull()) {
        return this->QTreeView::selectionChanged(selected, deselected);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QItemSelection & >::toPython(selected),
        Shiboken::Converter<QItemSelection & >::toPython(deselected)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QItemSelectionModel::SelectionFlag> QTreeViewWrapper::selectionCommand(const QModelIndex & index, const QEvent * event) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selectionCommand"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::selectionCommand(index, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.selectionCommand", SbkType<QFlags<QItemSelectionModel::SelectionFlag> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<QItemSelectionModel::SelectionFlag>();
    }
    QFlags<QItemSelectionModel::SelectionFlag> cpp_result(Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTreeViewWrapper::setModel(QAbstractItemModel * model)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModel"));
    if (py_override.isNull()) {
        return this->QTreeView::setModel(model);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractItemModel * >::toPython(model)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::setRootIndex(const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRootIndex"));
    if (py_override.isNull()) {
        return this->QTreeView::setRootIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> command)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelection"));
    if (py_override.isNull()) {
        return this->QTreeView::setSelection(rect, command);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toPython(command)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::setSelectionModel(QItemSelectionModel * selectionModel)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelectionModel"));
    if (py_override.isNull()) {
        return this->QTreeView::setSelectionModel(selectionModel);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QItemSelectionModel * >::toPython(selectionModel)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QTreeViewWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QTreeViewWrapper::sizeHintForColumn(int column) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForColumn"));
    if (py_override.isNull()) {
        return this->QTreeView::sizeHintForColumn(column);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        column
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.sizeHintForColumn", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QTreeViewWrapper::sizeHintForRow(int row) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHintForRow"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::sizeHintForRow(row);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        row
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.sizeHintForRow", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::startDrag(QFlags<Qt::DropAction> supportedActions)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDrag"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::startDrag(supportedActions);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(supportedActions)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTreeViewWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::updateEditorData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorData"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::updateEditorGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometries"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::updateEditorGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::updateGeometries()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometries"));
    if (py_override.isNull()) {
        return this->QTreeView::updateGeometries();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTreeViewWrapper::verticalOffset() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalOffset"));
    if (py_override.isNull()) {
        return this->QTreeView::verticalOffset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.verticalOffset", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::verticalScrollbarAction(int action)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarAction"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarAction(action);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        action
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTreeViewWrapper::verticalScrollbarValueChanged(int value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "verticalScrollbarValueChanged"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::verticalScrollbarValueChanged(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        value
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStyleOptionViewItem QTreeViewWrapper::viewOptions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewOptions"));
    if (py_override.isNull()) {
        return this->QAbstractItemView::viewOptions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStyleOptionViewItem();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStyleOptionViewItem >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.viewOptions", SbkType<QStyleOptionViewItem >()->tp_name, py_result->ob_type->tp_name);
        return QStyleOptionViewItem();
    }
    QStyleOptionViewItem cpp_result(Shiboken::Converter<QStyleOptionViewItem >::toCpp(py_result));
    return cpp_result;
}

bool QTreeViewWrapper::viewportEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "viewportEvent"));
    if (py_override.isNull()) {
        return this->QTreeView::viewportEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.viewportEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QRect QTreeViewWrapper::visualRect(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRect"));
    if (py_override.isNull()) {
        return this->QTreeView::visualRect(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.visualRect", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

QRegion QTreeViewWrapper::visualRegionForSelection(const QItemSelection & selection) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "visualRegionForSelection"));
    if (py_override.isNull()) {
        return this->QTreeView::visualRegionForSelection(selection);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QItemSelection & >::toPython(selection)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRegion();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRegion >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTreeView.visualRegionForSelection", SbkType<QRegion >()->tp_name, py_result->ob_type->tp_name);
        return QRegion();
    }
    QRegion cpp_result(Shiboken::Converter<QRegion >::toCpp(py_result));
    return cpp_result;
}

void QTreeViewWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QAbstractScrollArea::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTreeViewWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTreeView::staticMetaObject);
}
    return m_metaObject;
}

int QTreeViewWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTreeView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTreeViewWrapper::~QTreeViewWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTreeView_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTreeViewWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTreeView", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTreeView(QWidget*)
        cptr = new QTreeViewWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTreeView(QWidget*)
        cptr = new QTreeViewWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTreeView_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTreeView >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTreeView_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTreeView_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView", overloads);
        return -1;
}

static PyObject* SbkQTreeViewFunc_allColumnsShowFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // allColumnsShowFocus()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::allColumnsShowFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_autoExpandDelay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoExpandDelay()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeView::autoExpandDelay();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_collapse(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // collapse(QModelIndex)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::collapse(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_collapse_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_collapse_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.collapse", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_collapseAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // collapseAll()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::collapseAll();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_columnAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnAt(int)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::columnAt(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_columnAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_columnAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.columnAt", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_columnCountChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "columnCountChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // columnCountChanged(int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::columnCountChanged(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_columnCountChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_columnCountChanged_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.columnCountChanged", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_columnMoved(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // columnMoved()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::columnMoved();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_columnResized(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "columnResized", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // columnResized(int,int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::columnResized(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_columnResized_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_columnResized_TypeError:
        const char* overloads[] = {"int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.columnResized", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_columnViewportPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnViewportPosition(int)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::columnViewportPosition(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_columnViewportPosition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_columnViewportPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.columnViewportPosition", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_columnWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnWidth(int)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::columnWidth(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_columnWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_columnWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.columnWidth", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_currentChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "currentChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // currentChanged(QModelIndex,QModelIndex)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::currentChanged(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_currentChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_currentChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.currentChanged", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_dataChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "dataChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // dataChanged(QModelIndex,QModelIndex)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::dataChanged(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_dataChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_dataChanged_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.dataChanged", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_doItemsLayout(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // doItemsLayout()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::doItemsLayout();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::dragMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.dragMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_drawBranches(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawBranches", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // drawBranches(QPainter*,QRect,QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::drawBranches(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_drawBranches_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_drawBranches_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.drawBranches", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_drawRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawRow", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // drawRow(QPainter*,QStyleOptionViewItem,QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::drawRow(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_drawRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_drawRow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.drawRow", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_drawTree(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawTree", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRegion & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QRegion > cpp_arg1_auto_ptr;
        QRegion* cpp_arg1 = Shiboken::Converter<QRegion* >::toCpp(pyargs[1]);
        if (!SbkQRegion_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QRegion >(cpp_arg1);
        // drawTree(QPainter*,QRegion)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::drawTree(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_drawTree_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_drawTree_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QRegion", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.drawTree", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_expand(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // expand(QModelIndex)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::expand(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_expand_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_expand_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.expand", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_expandAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // expandAll()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::expandAll();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_expandToDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // expandToDepth(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::expandToDepth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_expandToDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_expandToDepth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.expandToDepth", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_expandsOnDoubleClick(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandsOnDoubleClick()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::expandsOnDoubleClick();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_header(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // header()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    QHeaderView * cpp_result = cppSelf->QTreeView::header();
    py_result = Shiboken::Converter<QHeaderView * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_hideColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // hideColumn(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::hideColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_hideColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_hideColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.hideColumn", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_horizontalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalOffset()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeView::horizontalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_horizontalScrollbarAction(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // horizontalScrollbarAction(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::horizontalScrollbarAction(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_horizontalScrollbarAction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_horizontalScrollbarAction_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.horizontalScrollbarAction", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_indentation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indentation()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeView::indentation();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_indexAbove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // indexAbove(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QTreeView::indexAbove(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_indexAbove_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_indexAbove_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.indexAbove", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_indexAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // indexAt(QPoint)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QTreeView::indexAt(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_indexAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_indexAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.indexAt", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_indexBelow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // indexBelow(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QTreeView::indexBelow(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_indexBelow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_indexBelow_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.indexBelow", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_indexRowSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // indexRowSizeHint(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::indexRowSizeHint(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_indexRowSizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_indexRowSizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.indexRowSizeHint", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isAnimated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAnimated()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::isAnimated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_isColumnHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isColumnHidden(int)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::isColumnHidden(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_isColumnHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_isColumnHidden_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.isColumnHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isExpanded(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isExpanded(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::isExpanded(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_isExpanded_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_isExpanded_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.isExpanded", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isFirstColumnSpanned(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isFirstColumnSpanned", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // isFirstColumnSpanned(int,QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::isFirstColumnSpanned(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_isFirstColumnSpanned_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_isFirstColumnSpanned_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.isFirstColumnSpanned", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isHeaderHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHeaderHidden()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::isHeaderHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_isIndexHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // isIndexHidden(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::isIndexHidden(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_isIndexHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_isIndexHidden_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.isIndexHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isRowHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isRowHidden", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // isRowHidden(int,QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::isRowHidden(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_isRowHidden_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_isRowHidden_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.isRowHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_isSortingEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSortingEnabled()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::isSortingEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_itemsExpandable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemsExpandable()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::itemsExpandable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_keyboardSearch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // keyboardSearch(QString)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::keyboardSearch(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_keyboardSearch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_keyboardSearch_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.keyboardSearch", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::mouseDoubleClickEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_moveCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveCursor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractItemView::CursorAction >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[1])) {
        QAbstractItemView::CursorAction cpp_arg0 = Shiboken::Converter<QAbstractItemView::CursorAction >::toCpp(pyargs[0]);
        QFlags<Qt::KeyboardModifier> cpp_arg1 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[1]);
        // moveCursor(QAbstractItemView::CursorAction,QFlags<Qt::KeyboardModifier>)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QTreeView::moveCursor(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_moveCursor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_moveCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView.CursorAction, PySide.QtCore.Qt.KeyboardModifiers", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.moveCursor", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_reexpand(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reexpand()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::reexpand();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_resizeColumnToContents(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resizeColumnToContents(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::resizeColumnToContents(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_resizeColumnToContents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_resizeColumnToContents_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.resizeColumnToContents", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_rootIsDecorated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rootIsDecorated()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::rootIsDecorated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_rowHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowHeight(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::rowHeight(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_rowHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_rowHeight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.rowHeight", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_rowsAboutToBeRemoved(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsAboutToBeRemoved", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsAboutToBeRemoved(QModelIndex,int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::rowsAboutToBeRemoved(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_rowsAboutToBeRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_rowsAboutToBeRemoved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.rowsAboutToBeRemoved", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_rowsInserted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsInserted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsInserted(QModelIndex,int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::rowsInserted(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_rowsInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_rowsInserted_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.rowsInserted", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_rowsRemoved(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rowsRemoved", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rowsRemoved(QModelIndex,int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::rowsRemoved(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_rowsRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_rowsRemoved_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.rowsRemoved", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_scrollContentsBy(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollContentsBy", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // scrollContentsBy(int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::scrollContentsBy(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_scrollContentsBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_scrollContentsBy_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.scrollContentsBy", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_scrollTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scrollTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
            cppSelf->QTreeView::scrollTo(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QAbstractItemView::ScrollHint >::isConvertible(pyargs[1])) {
            QAbstractItemView::ScrollHint cpp_arg1 = Shiboken::Converter<QAbstractItemView::ScrollHint >::toCpp(pyargs[1]);
            // scrollTo(QModelIndex,QAbstractItemView::ScrollHint)
            QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
            cppSelf->QTreeView::scrollTo(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTreeViewFunc_scrollTo_TypeError;
    } else goto SbkQTreeViewFunc_scrollTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_scrollTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QAbstractItemView.ScrollHint = EnsureVisible", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.scrollTo", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::selectAll();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_selectedIndexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedIndexes()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QTreeView::selectedIndexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_selectionChanged(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "selectionChanged", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QItemSelection & >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemSelection & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelection* cpp_arg1 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[1]);
        // selectionChanged(QItemSelection,QItemSelection)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::selectionChanged(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_selectionChanged_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_selectionChanged_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.selectionChanged", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setAllColumnsShowFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAllColumnsShowFocus(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setAllColumnsShowFocus(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setAllColumnsShowFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setAllColumnsShowFocus_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setAllColumnsShowFocus", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setAnimated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAnimated(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setAnimated(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setAnimated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setAnimated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setAnimated", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setAutoExpandDelay(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAutoExpandDelay(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setAutoExpandDelay(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setAutoExpandDelay_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setAutoExpandDelay_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setAutoExpandDelay", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setColumnHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnHidden", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setColumnHidden(int,bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setColumnHidden(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setColumnHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setColumnHidden_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setColumnHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setColumnWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setColumnWidth(int,int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setColumnWidth(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setColumnWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setColumnWidth_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setColumnWidth", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setExpanded(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setExpanded", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setExpanded(QModelIndex,bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setExpanded(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setExpanded_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setExpanded_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setExpanded", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setExpandsOnDoubleClick(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setExpandsOnDoubleClick(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setExpandsOnDoubleClick(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setExpandsOnDoubleClick_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setExpandsOnDoubleClick_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setExpandsOnDoubleClick", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setFirstColumnSpanned(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setFirstColumnSpanned", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
        // setFirstColumnSpanned(int,QModelIndex,bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setFirstColumnSpanned(cpp_arg0, *cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setFirstColumnSpanned_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setFirstColumnSpanned_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setFirstColumnSpanned", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setHeader(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHeaderView * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHeaderView* cpp_arg0 = Shiboken::Converter<QHeaderView* >::toCpp(arg);
        // setHeader(QHeaderView*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setHeader(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setHeader_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setHeader_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHeaderView", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setHeader", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setHeaderHidden(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHeaderHidden(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setHeaderHidden(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setHeaderHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setHeaderHidden_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setHeaderHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setIndentation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIndentation(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setIndentation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setIndentation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setIndentation_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setIndentation", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setItemsExpandable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setItemsExpandable(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setItemsExpandable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setItemsExpandable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setItemsExpandable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setItemsExpandable", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setModel(cpp_arg0);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModel(QAbstractItemModel*)1", arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setModel", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setRootIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setRootIndex(QModelIndex)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setRootIndex(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setRootIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setRootIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setRootIndex", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setRootIsDecorated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setRootIsDecorated(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setRootIsDecorated(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setRootIsDecorated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setRootIsDecorated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setRootIsDecorated", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setRowHidden(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRowHidden", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
        // setRowHidden(int,QModelIndex,bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setRowHidden(cpp_arg0, *cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setRowHidden_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setRowHidden_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setRowHidden", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // setSelection(QRect,QFlags<QItemSelectionModel::SelectionFlag>)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setSelection(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setSelection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setSelection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.setSelection", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setSelectionModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionModel * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionModel* cpp_arg0 = Shiboken::Converter<QItemSelectionModel* >::toCpp(arg);
        // setSelectionModel(QItemSelectionModel*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setSelectionModel(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQTreeViewFunc_setSelectionModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setSelectionModel_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setSelectionModel", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setSortingEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSortingEnabled(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setSortingEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setSortingEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setSortingEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setSortingEnabled", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setUniformRowHeights(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUniformRowHeights(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setUniformRowHeights(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setUniformRowHeights_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setUniformRowHeights_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setUniformRowHeights", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_setWordWrap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWordWrap(bool)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::setWordWrap(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_setWordWrap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_setWordWrap_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.setWordWrap", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_showColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // showColumn(int)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::showColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_showColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_showColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.showColumn", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_sizeHintForColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sizeHintForColumn(int)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTreeView::sizeHintForColumn(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_sizeHintForColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_sizeHintForColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.sizeHintForColumn", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_sortByColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sortByColumn", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
        // sortByColumn(int,Qt::SortOrder)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::sortByColumn(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_sortByColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_sortByColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTreeView.sortByColumn", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        cppSelf->QTreeView::timerEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTreeViewFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.timerEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_uniformRowHeights(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uniformRowHeights()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::uniformRowHeights();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_updateGeometries(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // updateGeometries()
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    cppSelf->QTreeView::updateGeometries();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTreeViewFunc_verticalOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalOffset()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTreeView::verticalOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTreeViewFunc_viewportEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // viewportEvent(QEvent*)
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTreeView::viewportEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_viewportEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_viewportEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.viewportEvent", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_visualRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // visualRect(QModelIndex)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTreeView::visualRect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_visualRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_visualRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.visualRect", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_visualRegionForSelection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelection & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(arg);
        // visualRegionForSelection(QItemSelection)const
        QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
        QRegion cpp_result = cppSelf->QTreeView::visualRegionForSelection(*cpp_arg0);
        py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTreeViewFunc_visualRegionForSelection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTreeViewFunc_visualRegionForSelection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTreeView.visualRegionForSelection", overloads);
        return 0;
}

static PyObject* SbkQTreeViewFunc_wordWrap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wordWrap()const
    QTreeView* cppSelf = Shiboken::Converter<QTreeView* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTreeView::wordWrap();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTreeView_methods[] = {
    {"allColumnsShowFocus", (PyCFunction)SbkQTreeViewFunc_allColumnsShowFocus, METH_NOARGS},
    {"autoExpandDelay", (PyCFunction)SbkQTreeViewFunc_autoExpandDelay, METH_NOARGS},
    {"collapse", (PyCFunction)SbkQTreeViewFunc_collapse, METH_O},
    {"collapseAll", (PyCFunction)SbkQTreeViewFunc_collapseAll, METH_NOARGS},
    {"columnAt", (PyCFunction)SbkQTreeViewFunc_columnAt, METH_O},
    {"columnCountChanged", (PyCFunction)SbkQTreeViewFunc_columnCountChanged, METH_VARARGS},
    {"columnMoved", (PyCFunction)SbkQTreeViewFunc_columnMoved, METH_NOARGS},
    {"columnResized", (PyCFunction)SbkQTreeViewFunc_columnResized, METH_VARARGS},
    {"columnViewportPosition", (PyCFunction)SbkQTreeViewFunc_columnViewportPosition, METH_O},
    {"columnWidth", (PyCFunction)SbkQTreeViewFunc_columnWidth, METH_O},
    {"currentChanged", (PyCFunction)SbkQTreeViewFunc_currentChanged, METH_VARARGS},
    {"dataChanged", (PyCFunction)SbkQTreeViewFunc_dataChanged, METH_VARARGS},
    {"doItemsLayout", (PyCFunction)SbkQTreeViewFunc_doItemsLayout, METH_NOARGS},
    {"dragMoveEvent", (PyCFunction)SbkQTreeViewFunc_dragMoveEvent, METH_O},
    {"drawBranches", (PyCFunction)SbkQTreeViewFunc_drawBranches, METH_VARARGS},
    {"drawRow", (PyCFunction)SbkQTreeViewFunc_drawRow, METH_VARARGS},
    {"drawTree", (PyCFunction)SbkQTreeViewFunc_drawTree, METH_VARARGS},
    {"expand", (PyCFunction)SbkQTreeViewFunc_expand, METH_O},
    {"expandAll", (PyCFunction)SbkQTreeViewFunc_expandAll, METH_NOARGS},
    {"expandToDepth", (PyCFunction)SbkQTreeViewFunc_expandToDepth, METH_O},
    {"expandsOnDoubleClick", (PyCFunction)SbkQTreeViewFunc_expandsOnDoubleClick, METH_NOARGS},
    {"header", (PyCFunction)SbkQTreeViewFunc_header, METH_NOARGS},
    {"hideColumn", (PyCFunction)SbkQTreeViewFunc_hideColumn, METH_O},
    {"horizontalOffset", (PyCFunction)SbkQTreeViewFunc_horizontalOffset, METH_NOARGS},
    {"horizontalScrollbarAction", (PyCFunction)SbkQTreeViewFunc_horizontalScrollbarAction, METH_O},
    {"indentation", (PyCFunction)SbkQTreeViewFunc_indentation, METH_NOARGS},
    {"indexAbove", (PyCFunction)SbkQTreeViewFunc_indexAbove, METH_O},
    {"indexAt", (PyCFunction)SbkQTreeViewFunc_indexAt, METH_O},
    {"indexBelow", (PyCFunction)SbkQTreeViewFunc_indexBelow, METH_O},
    {"indexRowSizeHint", (PyCFunction)SbkQTreeViewFunc_indexRowSizeHint, METH_O},
    {"isAnimated", (PyCFunction)SbkQTreeViewFunc_isAnimated, METH_NOARGS},
    {"isColumnHidden", (PyCFunction)SbkQTreeViewFunc_isColumnHidden, METH_O},
    {"isExpanded", (PyCFunction)SbkQTreeViewFunc_isExpanded, METH_O},
    {"isFirstColumnSpanned", (PyCFunction)SbkQTreeViewFunc_isFirstColumnSpanned, METH_VARARGS},
    {"isHeaderHidden", (PyCFunction)SbkQTreeViewFunc_isHeaderHidden, METH_NOARGS},
    {"isIndexHidden", (PyCFunction)SbkQTreeViewFunc_isIndexHidden, METH_O},
    {"isRowHidden", (PyCFunction)SbkQTreeViewFunc_isRowHidden, METH_VARARGS},
    {"isSortingEnabled", (PyCFunction)SbkQTreeViewFunc_isSortingEnabled, METH_NOARGS},
    {"itemsExpandable", (PyCFunction)SbkQTreeViewFunc_itemsExpandable, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQTreeViewFunc_keyPressEvent, METH_O},
    {"keyboardSearch", (PyCFunction)SbkQTreeViewFunc_keyboardSearch, METH_O},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQTreeViewFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQTreeViewFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQTreeViewFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQTreeViewFunc_mouseReleaseEvent, METH_O},
    {"moveCursor", (PyCFunction)SbkQTreeViewFunc_moveCursor, METH_VARARGS},
    {"paintEvent", (PyCFunction)SbkQTreeViewFunc_paintEvent, METH_O},
    {"reexpand", (PyCFunction)SbkQTreeViewFunc_reexpand, METH_NOARGS},
    {"reset", (PyCFunction)SbkQTreeViewFunc_reset, METH_NOARGS},
    {"resizeColumnToContents", (PyCFunction)SbkQTreeViewFunc_resizeColumnToContents, METH_O},
    {"rootIsDecorated", (PyCFunction)SbkQTreeViewFunc_rootIsDecorated, METH_NOARGS},
    {"rowHeight", (PyCFunction)SbkQTreeViewFunc_rowHeight, METH_O},
    {"rowsAboutToBeRemoved", (PyCFunction)SbkQTreeViewFunc_rowsAboutToBeRemoved, METH_VARARGS},
    {"rowsInserted", (PyCFunction)SbkQTreeViewFunc_rowsInserted, METH_VARARGS},
    {"rowsRemoved", (PyCFunction)SbkQTreeViewFunc_rowsRemoved, METH_VARARGS},
    {"scrollContentsBy", (PyCFunction)SbkQTreeViewFunc_scrollContentsBy, METH_VARARGS},
    {"scrollTo", (PyCFunction)SbkQTreeViewFunc_scrollTo, METH_VARARGS},
    {"selectAll", (PyCFunction)SbkQTreeViewFunc_selectAll, METH_NOARGS},
    {"selectedIndexes", (PyCFunction)SbkQTreeViewFunc_selectedIndexes, METH_NOARGS},
    {"selectionChanged", (PyCFunction)SbkQTreeViewFunc_selectionChanged, METH_VARARGS},
    {"setAllColumnsShowFocus", (PyCFunction)SbkQTreeViewFunc_setAllColumnsShowFocus, METH_O},
    {"setAnimated", (PyCFunction)SbkQTreeViewFunc_setAnimated, METH_O},
    {"setAutoExpandDelay", (PyCFunction)SbkQTreeViewFunc_setAutoExpandDelay, METH_O},
    {"setColumnHidden", (PyCFunction)SbkQTreeViewFunc_setColumnHidden, METH_VARARGS},
    {"setColumnWidth", (PyCFunction)SbkQTreeViewFunc_setColumnWidth, METH_VARARGS},
    {"setExpanded", (PyCFunction)SbkQTreeViewFunc_setExpanded, METH_VARARGS},
    {"setExpandsOnDoubleClick", (PyCFunction)SbkQTreeViewFunc_setExpandsOnDoubleClick, METH_O},
    {"setFirstColumnSpanned", (PyCFunction)SbkQTreeViewFunc_setFirstColumnSpanned, METH_VARARGS},
    {"setHeader", (PyCFunction)SbkQTreeViewFunc_setHeader, METH_O},
    {"setHeaderHidden", (PyCFunction)SbkQTreeViewFunc_setHeaderHidden, METH_O},
    {"setIndentation", (PyCFunction)SbkQTreeViewFunc_setIndentation, METH_O},
    {"setItemsExpandable", (PyCFunction)SbkQTreeViewFunc_setItemsExpandable, METH_O},
    {"setModel", (PyCFunction)SbkQTreeViewFunc_setModel, METH_O},
    {"setRootIndex", (PyCFunction)SbkQTreeViewFunc_setRootIndex, METH_O},
    {"setRootIsDecorated", (PyCFunction)SbkQTreeViewFunc_setRootIsDecorated, METH_O},
    {"setRowHidden", (PyCFunction)SbkQTreeViewFunc_setRowHidden, METH_VARARGS},
    {"setSelection", (PyCFunction)SbkQTreeViewFunc_setSelection, METH_VARARGS},
    {"setSelectionModel", (PyCFunction)SbkQTreeViewFunc_setSelectionModel, METH_O},
    {"setSortingEnabled", (PyCFunction)SbkQTreeViewFunc_setSortingEnabled, METH_O},
    {"setUniformRowHeights", (PyCFunction)SbkQTreeViewFunc_setUniformRowHeights, METH_O},
    {"setWordWrap", (PyCFunction)SbkQTreeViewFunc_setWordWrap, METH_O},
    {"showColumn", (PyCFunction)SbkQTreeViewFunc_showColumn, METH_O},
    {"sizeHintForColumn", (PyCFunction)SbkQTreeViewFunc_sizeHintForColumn, METH_O},
    {"sortByColumn", (PyCFunction)SbkQTreeViewFunc_sortByColumn, METH_VARARGS},
    {"timerEvent", (PyCFunction)SbkQTreeViewFunc_timerEvent, METH_O},
    {"uniformRowHeights", (PyCFunction)SbkQTreeViewFunc_uniformRowHeights, METH_NOARGS},
    {"updateGeometries", (PyCFunction)SbkQTreeViewFunc_updateGeometries, METH_NOARGS},
    {"verticalOffset", (PyCFunction)SbkQTreeViewFunc_verticalOffset, METH_NOARGS},
    {"viewportEvent", (PyCFunction)SbkQTreeViewFunc_viewportEvent, METH_O},
    {"visualRect", (PyCFunction)SbkQTreeViewFunc_visualRect, METH_O},
    {"visualRegionForSelection", (PyCFunction)SbkQTreeViewFunc_visualRegionForSelection, METH_O},
    {"wordWrap", (PyCFunction)SbkQTreeViewFunc_wordWrap, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTreeViewSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTreeView* me = reinterpret_cast<QTreeView*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX]))
        return static_cast<QAbstractItemView*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSCROLLAREA_IDX]))
        return static_cast<QAbstractScrollArea*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QFRAME_IDX]))
        return static_cast<QFrame*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTreeView_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTreeView",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTreeView_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTreeView_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTreeViewSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTreeView >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTreeView(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTREEVIEW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTreeView_Type);

    SbkQTreeView_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMVIEW_IDX];
    SbkQTreeView_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTreeView_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTreeView_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTreeView_Type));
    PyModule_AddObject(module, "QTreeView",
        ((PyObject*)&SbkQTreeView_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTreeView >("QTreeView*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTreeView >(typeid(QTreeView).name());
}


} // extern "C"

