/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstyleoptiontab_wrapper.h"

// Extra includes
#include <qstyleoption.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStyleOptionTab_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyleOptionTab* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyleOptionTab", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyleOptionTab()
        cptr = new QStyleOptionTab();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QStyleOptionTab(int)
        cptr = new QStyleOptionTab(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStyleOptionTab & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStyleOptionTab* cpp_arg0 = Shiboken::Converter<QStyleOptionTab* >::toCpp(pyargs[0]);
        // QStyleOptionTab(QStyleOptionTab)
        cptr = new QStyleOptionTab(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyleOptionTab_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyleOptionTab >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyleOptionTab_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyleOptionTab_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QStyleOptionTab", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyleOptionTab", overloads);
        return -1;
}

static PyMethodDef SbkQStyleOptionTab_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQStyleOptionTab_get_row(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->row);
}
static int SbkQStyleOptionTab_set_row(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'row' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'row', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->row = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_cornerWidgets(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<QStyleOptionTab::CornerWidget> >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->cornerWidgets);
}
static int SbkQStyleOptionTab_set_cornerWidgets(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'cornerWidgets' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cornerWidgets', 'CornerWidgets' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->cornerWidgets = Shiboken::Converter<QFlags<QStyleOptionTab::CornerWidget> >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_position(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionTab::TabPosition >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->position);
}
static int SbkQStyleOptionTab_set_position(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionTab::TabPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'TabPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->position = Shiboken::Converter<QStyleOptionTab::TabPosition >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_icon(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QIcon >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->icon);
}
static int SbkQStyleOptionTab_set_icon(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QIcon >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->icon = Shiboken::Converter<QIcon >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_shape(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTabBar::Shape >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->shape);
}
static int SbkQStyleOptionTab_set_shape(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'shape' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTabBar::Shape >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'shape', 'Shape' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->shape = Shiboken::Converter<QTabBar::Shape >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_text(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->text);
}
static int SbkQStyleOptionTab_set_text(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->text = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQStyleOptionTab_get_selectedPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStyleOptionTab::SelectedPosition >::toPython(Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->selectedPosition);
}
static int SbkQStyleOptionTab_set_selectedPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStyleOptionTab::SelectedPosition >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QStyleOptionTab* >::toCpp((PyObject*)self)->selectedPosition = Shiboken::Converter<QStyleOptionTab::SelectedPosition >::toCpp(value);

    return 0;
}

// Getters and Setters for QStyleOptionTab
static PyGetSetDef SbkQStyleOptionTab_getsetlist[] = {
    {const_cast<char*>("row"), (getter)SbkQStyleOptionTab_get_row, (setter)SbkQStyleOptionTab_set_row},
    {const_cast<char*>("cornerWidgets"), (getter)SbkQStyleOptionTab_get_cornerWidgets, (setter)SbkQStyleOptionTab_set_cornerWidgets},
    {const_cast<char*>("position"), (getter)SbkQStyleOptionTab_get_position, (setter)SbkQStyleOptionTab_set_position},
    {const_cast<char*>("icon"), (getter)SbkQStyleOptionTab_get_icon, (setter)SbkQStyleOptionTab_set_icon},
    {const_cast<char*>("shape"), (getter)SbkQStyleOptionTab_get_shape, (setter)SbkQStyleOptionTab_set_shape},
    {const_cast<char*>("text"), (getter)SbkQStyleOptionTab_get_text, (setter)SbkQStyleOptionTab_set_text},
    {const_cast<char*>("selectedPosition"), (getter)SbkQStyleOptionTab_get_selectedPosition, (setter)SbkQStyleOptionTab_set_selectedPosition},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyleOptionTab_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyleOptionTab",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyleOptionTab_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQStyleOptionTab_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyleOptionTab_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyleOptionTab >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionVersion",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QStyleOptionTab_CornerWidget___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toPython(
        ((QStyleOptionTab::CornerWidgets) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionTab_CornerWidget___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toPython(
        ((QStyleOptionTab::CornerWidgets) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionTab_CornerWidget___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toPython(
        ((QStyleOptionTab::CornerWidgets) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QStyleOptionTab_CornerWidget___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toPython(
        ~ Shiboken::Converter< QStyleOptionTab::CornerWidgets >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QStyleOptionTab_CornerWidget_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QStyleOptionTab_CornerWidget___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionTab_CornerWidget___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QStyleOptionTab_CornerWidget___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QStyleOptionTab_CornerWidget___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QStyleOptionTab_CornerWidget_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_CornerWidget_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CornerWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QStyleOptionTab_CornerWidget_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionTab_CornerWidget_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_CornerWidget_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_CornerWidget_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CornerWidgets",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QStyleOptionTab_TabPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_TabPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionTab_TabPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_TabPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_TabPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectedPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleOptionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStyleOptionTab(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyleOptionTab_Type);

    SbkQStyleOptionTab_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QSTYLEOPTION_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStyleOptionTab_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyleOptionTab_Type));
    PyModule_AddObject(module, "QStyleOptionTab",
        ((PyObject*)&SbkQStyleOptionTab_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleOptionVersion
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONVERSION_IDX] = &SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "StyleOptionVersion",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type,
        (long) QStyleOptionTab::Version, "Version");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "Version", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_StyleOptionVersion_Type.tp_dict,
        "Version", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionTab::StyleOptionVersion");

    // init enum class: CornerWidget
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_CORNERWIDGET_IDX] = &SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "CornerWidget",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type));

    // init flags class: QFlags<QStyleOptionTab::CornerWidget>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSTYLEOPTIONTAB_CORNERWIDGET__IDX] = &SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "CornerWidgets",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_CornerWidgets_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type,
        (long) QStyleOptionTab::NoCornerWidgets, "NoCornerWidgets");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "NoCornerWidgets", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type.tp_dict,
        "NoCornerWidgets", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type,
        (long) QStyleOptionTab::LeftCornerWidget, "LeftCornerWidget");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "LeftCornerWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type.tp_dict,
        "LeftCornerWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type,
        (long) QStyleOptionTab::RightCornerWidget, "RightCornerWidget");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "RightCornerWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_CornerWidget_Type.tp_dict,
        "RightCornerWidget", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionTab::CornerWidget");

    // init enum class: TabPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_TABPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "TabPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type,
        (long) QStyleOptionTab::Beginning, "Beginning");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "Beginning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type.tp_dict,
        "Beginning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type,
        (long) QStyleOptionTab::Middle, "Middle");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "Middle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type.tp_dict,
        "Middle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type,
        (long) QStyleOptionTab::End, "End");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "End", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type.tp_dict,
        "End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type,
        (long) QStyleOptionTab::OnlyOneTab, "OnlyOneTab");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "OnlyOneTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_TabPosition_Type.tp_dict,
        "OnlyOneTab", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionTab::TabPosition");

    // init enum class: SelectedPosition
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_SELECTEDPOSITION_IDX] = &SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "SelectedPosition",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type,
        (long) QStyleOptionTab::NotAdjacent, "NotAdjacent");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "NotAdjacent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type.tp_dict,
        "NotAdjacent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type,
        (long) QStyleOptionTab::NextIsSelected, "NextIsSelected");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "NextIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type.tp_dict,
        "NextIsSelected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type,
        (long) QStyleOptionTab::PreviousIsSelected, "PreviousIsSelected");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "PreviousIsSelected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_SelectedPosition_Type.tp_dict,
        "PreviousIsSelected", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionTab::SelectedPosition");

    // init enum class: StyleOptionType
    SbkPySide_QtGuiTypes[SBK_QSTYLEOPTIONTAB_STYLEOPTIONTYPE_IDX] = &SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type);
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
            "StyleOptionType",((PyObject*)&SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type,
        (long) QStyleOptionTab::Type, "Type");
    PyDict_SetItemString(SbkQStyleOptionTab_Type.super.ht_type.tp_dict,
        "Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStyleOptionTab_StyleOptionType_Type.tp_dict,
        "Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStyleOptionTab::StyleOptionType");

    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionTab >("QStyleOptionTab");
    Shiboken::TypeResolver::createValueTypeResolver<QStyleOptionTab >(typeid(QStyleOptionTab).name());
}


} // extern "C"

