/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qkeysequence_wrapper.h"

// Extra includes
#include <QList>
#include <qdatastream.h>
#include <qkeysequence.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQKeySequence_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QKeySequence* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QKeySequence", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QKeySequence()
        cptr = new QKeySequence();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(pyargs[0])) {
        QKeySequence::StandardKey cpp_arg0 = Shiboken::Converter<QKeySequence::StandardKey >::toCpp(pyargs[0]);
        // QKeySequence(QKeySequence::StandardKey)
        cptr = new QKeySequence(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QKeySequence(int,int,int,int)
            cptr = new QKeySequence(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QKeySequence(int,int,int,int)
                cptr = new QKeySequence(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QKeySequence(int,int,int,int)
                    cptr = new QKeySequence(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // QKeySequence(int,int,int,int)
                    cptr = new QKeySequence(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQKeySequence_Init_TypeError;
            } else goto SbkQKeySequence_Init_TypeError;
        } else goto SbkQKeySequence_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QKeySequence & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[0]);
        if (!SbkQKeySequence_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        // QKeySequence(QKeySequence)
        cptr = new QKeySequence(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QKeySequence(QString)
        cptr = new QKeySequence(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeySequence_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QKeySequence >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQKeySequence_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQKeySequence_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QKeySequence.StandardKey", "PySide.QtGui.QKeySequence", "PySide.QtCore.QString", "int, int = 0, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QKeySequence", overloads);
        return -1;
}

static PyObject* SbkQKeySequenceFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QKeySequence::count();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeySequenceFunc_fromString(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromString", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromString(QString,QKeySequence::SequenceFormat)
            QKeySequence cpp_result = QKeySequence::fromString(*cpp_arg0);
            py_result = Shiboken::Converter<QKeySequence >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QKeySequence::SequenceFormat >::isConvertible(pyargs[1])) {
            QKeySequence::SequenceFormat cpp_arg1 = Shiboken::Converter<QKeySequence::SequenceFormat >::toCpp(pyargs[1]);
            // fromString(QString,QKeySequence::SequenceFormat)
            QKeySequence cpp_result = QKeySequence::fromString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QKeySequence >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQKeySequenceFunc_fromString_TypeError;
    } else goto SbkQKeySequenceFunc_fromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc_fromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QKeySequence.SequenceFormat = PortableText", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QKeySequence.fromString", overloads);
        return 0;
}

static PyObject* SbkQKeySequenceFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QKeySequence::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeySequenceFunc_keyBindings(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(arg)) {
        QKeySequence::StandardKey cpp_arg0 = Shiboken::Converter<QKeySequence::StandardKey >::toCpp(arg);
        // keyBindings(QKeySequence::StandardKey)
        QList<QKeySequence > cpp_result = QKeySequence::keyBindings(cpp_arg0);
        py_result = Shiboken::Converter<QList<QKeySequence > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeySequenceFunc_keyBindings_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc_keyBindings_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence.StandardKey", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.keyBindings", overloads);
        return 0;
}

static PyObject* SbkQKeySequenceFunc_matches(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QKeySequence & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(arg);
        if (!SbkQKeySequence_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        // matches(QKeySequence)const
        QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
        QKeySequence::SequenceMatch cpp_result = cppSelf->QKeySequence::matches(*cpp_arg0);
        py_result = Shiboken::Converter<QKeySequence::SequenceMatch >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeySequenceFunc_matches_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc_matches_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.matches", overloads);
        return 0;
}

static PyObject* SbkQKeySequenceFunc_mnemonic(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // mnemonic(QString)
        QKeySequence cpp_result = QKeySequence::mnemonic(*cpp_arg0);
        py_result = Shiboken::Converter<QKeySequence >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeySequenceFunc_mnemonic_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc_mnemonic_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.mnemonic", overloads);
        return 0;
}

static PyObject* SbkQKeySequenceFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(QKeySequence::SequenceFormat)const
        QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QKeySequence::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QKeySequence::SequenceFormat >::isConvertible(arg)) {
        QKeySequence::SequenceFormat cpp_arg0 = Shiboken::Converter<QKeySequence::SequenceFormat >::toCpp(arg);
        // toString(QKeySequence::SequenceFormat)const
        QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QKeySequence::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeySequenceFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence.SequenceFormat = PortableText", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.toString", overloads);
        return 0;
}

static PyMethodDef SbkQKeySequence_methods[] = {
    {"count", (PyCFunction)SbkQKeySequenceFunc_count, METH_NOARGS},
    {"fromString", (PyCFunction)SbkQKeySequenceFunc_fromString, METH_VARARGS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQKeySequenceFunc_isEmpty, METH_NOARGS},
    {"keyBindings", (PyCFunction)SbkQKeySequenceFunc_keyBindings, METH_O|METH_STATIC},
    {"matches", (PyCFunction)SbkQKeySequenceFunc_matches, METH_O},
    {"mnemonic", (PyCFunction)SbkQKeySequenceFunc_mnemonic, METH_O|METH_STATIC},
    {"toString", (PyCFunction)SbkQKeySequenceFunc_toString, METH_NOARGS|METH_O},
    {0} // Sentinel
};

static PyObject* SbkQKeySequenceFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQKeySequence_Check(arg) && !SbkQKeySequence_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QKeySequence) [reverse operator]
        QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQKeySequenceFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQKeySequenceFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQKeySequence_Check(arg) && !SbkQKeySequence_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QKeySequence&) [reverse operator]
        QKeySequence* cppSelf = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQKeySequenceFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeySequenceFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeySequence.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQKeySequence_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQKeySequenceFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQKeySequenceFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQKeySequence_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QKeySequence& cpp_self = *Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator!=(const QKeySequence & other) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator<(const QKeySequence & ks) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator<=(const QKeySequence & other) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self <= (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator==(const QKeySequence & other) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator>(const QKeySequence & other) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QKeySequence & >::isConvertible(other)) {
                // operator>=(const QKeySequence & other) const
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QKeySequence  >::toCpp(other) : (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<QKeySequence >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QKeySequence > cpp_other_auto_ptr;
                QKeySequence* cpp_other = Shiboken::Converter<QKeySequence* >::toCpp(other);
                if (!SbkQKeySequence_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QKeySequence >(cpp_other);
                result = (cpp_self >= (*cpp_other));
            } else goto SbkQKeySequence_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQKeySequence_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQKeySequence_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QKeySequence",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQKeySequence_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQKeySequence_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQKeySequence_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQKeySequence_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QKeySequence >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QKeySequence_SequenceFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QKeySequence_SequenceFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QKeySequence_SequenceFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SequenceFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QKeySequence_SequenceFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QKeySequence_SequenceFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QKeySequence_SequenceFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QKeySequence_StandardKey_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QKeySequence_StandardKey_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QKeySequence_StandardKey_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardKey",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QKeySequence_StandardKey_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QKeySequence_StandardKey_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QKeySequence_StandardKey_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QKeySequence_SequenceMatch_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QKeySequence_SequenceMatch_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QKeySequence_SequenceMatch_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SequenceMatch",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QKeySequence_SequenceMatch_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QKeySequence_SequenceMatch_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QKeySequence_SequenceMatch_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QKeySequence(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQKeySequence_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQKeySequence_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQKeySequence_Type));
    PyModule_AddObject(module, "QKeySequence",
        ((PyObject*)&SbkQKeySequence_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SequenceFormat
    SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEFORMAT_IDX] = &SbkPySide_QtGui_QKeySequence_SequenceFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QKeySequence_SequenceFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QKeySequence_SequenceFormat_Type);
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
            "SequenceFormat",((PyObject*)&SbkPySide_QtGui_QKeySequence_SequenceFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_SequenceFormat_Type,
        (long) QKeySequence::NativeText, "NativeText");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "NativeText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_SequenceFormat_Type.tp_dict,
        "NativeText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_SequenceFormat_Type,
        (long) QKeySequence::PortableText, "PortableText");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "PortableText", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_SequenceFormat_Type.tp_dict,
        "PortableText", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QKeySequence::SequenceFormat");

    // init enum class: StandardKey
    SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX] = &SbkPySide_QtGui_QKeySequence_StandardKey_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QKeySequence_StandardKey_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QKeySequence_StandardKey_Type);
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
            "StandardKey",((PyObject*)&SbkPySide_QtGui_QKeySequence_StandardKey_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::UnknownKey, "UnknownKey");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "UnknownKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "UnknownKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::HelpContents, "HelpContents");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "HelpContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "HelpContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::WhatsThis, "WhatsThis");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "WhatsThis", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "WhatsThis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Open, "Open");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Open", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Open", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Close, "Close");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Save, "Save");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Save", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Save", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::New, "New");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "New", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "New", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Delete, "Delete");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Delete", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Delete", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Cut, "Cut");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Cut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Cut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Copy, "Copy");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Copy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Copy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Paste, "Paste");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Paste", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Paste", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Undo, "Undo");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Undo", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Undo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Redo, "Redo");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Redo", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Redo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Back, "Back");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Back", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Back", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Forward, "Forward");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Forward", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Forward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Refresh, "Refresh");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Refresh", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Refresh", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::ZoomIn, "ZoomIn");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "ZoomIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "ZoomIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::ZoomOut, "ZoomOut");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "ZoomOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "ZoomOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Print, "Print");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Print", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Print", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::AddTab, "AddTab");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "AddTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "AddTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::NextChild, "NextChild");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "NextChild", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "NextChild", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::PreviousChild, "PreviousChild");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "PreviousChild", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "PreviousChild", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Find, "Find");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Find", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Find", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::FindNext, "FindNext");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "FindNext", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "FindNext", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::FindPrevious, "FindPrevious");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "FindPrevious", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "FindPrevious", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Replace, "Replace");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Replace", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Replace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectAll, "SelectAll");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Bold, "Bold");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Bold", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Bold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Italic, "Italic");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Italic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Italic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Underline, "Underline");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Underline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Underline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToNextChar, "MoveToNextChar");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToNextChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToNextChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToPreviousChar, "MoveToPreviousChar");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToPreviousChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToPreviousChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToNextWord, "MoveToNextWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToNextWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToNextWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToPreviousWord, "MoveToPreviousWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToPreviousWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToPreviousWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToNextLine, "MoveToNextLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToNextLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToNextLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToPreviousLine, "MoveToPreviousLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToPreviousLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToPreviousLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToNextPage, "MoveToNextPage");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToNextPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToNextPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToPreviousPage, "MoveToPreviousPage");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToPreviousPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToPreviousPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToStartOfLine, "MoveToStartOfLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToStartOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToStartOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToEndOfLine, "MoveToEndOfLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToEndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToEndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToStartOfBlock, "MoveToStartOfBlock");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToStartOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToStartOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToEndOfBlock, "MoveToEndOfBlock");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToEndOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToEndOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToStartOfDocument, "MoveToStartOfDocument");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToStartOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToStartOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::MoveToEndOfDocument, "MoveToEndOfDocument");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "MoveToEndOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "MoveToEndOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectNextChar, "SelectNextChar");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectNextChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectNextChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectPreviousChar, "SelectPreviousChar");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectPreviousChar", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectPreviousChar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectNextWord, "SelectNextWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectNextWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectNextWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectPreviousWord, "SelectPreviousWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectPreviousWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectPreviousWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectNextLine, "SelectNextLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectNextLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectNextLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectPreviousLine, "SelectPreviousLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectPreviousLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectPreviousLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectNextPage, "SelectNextPage");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectNextPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectNextPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectPreviousPage, "SelectPreviousPage");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectPreviousPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectPreviousPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectStartOfLine, "SelectStartOfLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectStartOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectStartOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectEndOfLine, "SelectEndOfLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectEndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectEndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectStartOfBlock, "SelectStartOfBlock");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectStartOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectStartOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectEndOfBlock, "SelectEndOfBlock");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectEndOfBlock", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectEndOfBlock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectStartOfDocument, "SelectStartOfDocument");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectStartOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectStartOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SelectEndOfDocument, "SelectEndOfDocument");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SelectEndOfDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SelectEndOfDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::DeleteStartOfWord, "DeleteStartOfWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "DeleteStartOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "DeleteStartOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::DeleteEndOfWord, "DeleteEndOfWord");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "DeleteEndOfWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "DeleteEndOfWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::DeleteEndOfLine, "DeleteEndOfLine");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "DeleteEndOfLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "DeleteEndOfLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::InsertParagraphSeparator, "InsertParagraphSeparator");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "InsertParagraphSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "InsertParagraphSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::InsertLineSeparator, "InsertLineSeparator");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "InsertLineSeparator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "InsertLineSeparator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::SaveAs, "SaveAs");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "SaveAs", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "SaveAs", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Preferences, "Preferences");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Preferences", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Preferences", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_StandardKey_Type,
        (long) QKeySequence::Quit, "Quit");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "Quit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_StandardKey_Type.tp_dict,
        "Quit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QKeySequence::StandardKey");

    // init enum class: SequenceMatch
    SbkPySide_QtGuiTypes[SBK_QKEYSEQUENCE_SEQUENCEMATCH_IDX] = &SbkPySide_QtGui_QKeySequence_SequenceMatch_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type);
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
            "SequenceMatch",((PyObject*)&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type,
        (long) QKeySequence::NoMatch, "NoMatch");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "NoMatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_SequenceMatch_Type.tp_dict,
        "NoMatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type,
        (long) QKeySequence::PartialMatch, "PartialMatch");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "PartialMatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_SequenceMatch_Type.tp_dict,
        "PartialMatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QKeySequence_SequenceMatch_Type,
        (long) QKeySequence::ExactMatch, "ExactMatch");
    PyDict_SetItemString(SbkQKeySequence_Type.super.ht_type.tp_dict,
        "ExactMatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QKeySequence_SequenceMatch_Type.tp_dict,
        "ExactMatch", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QKeySequence::SequenceMatch");

    Shiboken::TypeResolver::createValueTypeResolver<QKeySequence >("QKeySequence");
    Shiboken::TypeResolver::createValueTypeResolver<QKeySequence >(typeid(QKeySequence).name());
}


} // extern "C"

