/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qkeyevent_wrapper.h"

// Extra includes
#include <qevent.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QKeyEventWrapper::QKeyEventWrapper(QEvent::Type type, int key, QFlags<Qt::KeyboardModifier> modifiers, const QString & text, bool autorep, ushort count) : QKeyEvent(type, key, modifiers, text, autorep, count) {
    // ... middle
}

QKeyEventWrapper::~QKeyEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQKeyEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QKeyEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QKeyEvent", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
            cptr = new QKeyEventWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return -1;
            std::auto_ptr<QString > cpp_arg3_auto_ptr;
            QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
            if (!SbkQString_Check(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
            if (numArgs == 4) {
                // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                cptr = new QKeyEventWrapper(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                bool cpp_arg4 = Shiboken::Converter<bool >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                    cptr = new QKeyEventWrapper(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[5])) {
                    ushort cpp_arg5 = Shiboken::Converter<ushort >::toCpp(pyargs[5]);
                    // QKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,QString,bool,ushort)
                    cptr = new QKeyEventWrapper(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQKeyEvent_Init_TypeError;
            } else goto SbkQKeyEvent_Init_TypeError;
        } else goto SbkQKeyEvent_Init_TypeError;
    } else goto SbkQKeyEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QKeyEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQKeyEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQKeyEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, int, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.QString = QString(), bool = false, ushort = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QKeyEvent", overloads);
        return -1;
}

static PyObject* SbkQKeyEventFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QKeyEvent::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_createExtendedKeyEvent(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createExtendedKeyEvent", 6, 9, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8])))
        return 0;

    if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
        quint32 cpp_arg3 = Shiboken::Converter<quint32 >::toCpp(pyargs[3]);
        quint32 cpp_arg4 = Shiboken::Converter<quint32 >::toCpp(pyargs[4]);
        quint32 cpp_arg5 = Shiboken::Converter<quint32 >::toCpp(pyargs[5]);
        if (numArgs == 6) {
            // createExtendedKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
            QKeyEvent * cpp_result = QKeyEvent::createExtendedKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            py_result = Shiboken::Converter<QKeyEvent * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[6])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[6]))
                return 0;
            std::auto_ptr<QString > cpp_arg6_auto_ptr;
            QString* cpp_arg6 = Shiboken::Converter<QString* >::toCpp(pyargs[6]);
            if (!SbkQString_Check(pyargs[6]))
                cpp_arg6_auto_ptr = std::auto_ptr<QString >(cpp_arg6);
            if (numArgs == 7) {
                // createExtendedKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                QKeyEvent * cpp_result = QKeyEvent::createExtendedKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, *cpp_arg6);
                py_result = Shiboken::Converter<QKeyEvent * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[7])) {
                bool cpp_arg7 = Shiboken::Converter<bool >::toCpp(pyargs[7]);
                if (numArgs == 8) {
                    // createExtendedKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                    QKeyEvent * cpp_result = QKeyEvent::createExtendedKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, *cpp_arg6, cpp_arg7);
                    py_result = Shiboken::Converter<QKeyEvent * >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[8])) {
                    ushort cpp_arg8 = Shiboken::Converter<ushort >::toCpp(pyargs[8]);
                    // createExtendedKeyEvent(QEvent::Type,int,QFlags<Qt::KeyboardModifier>,quint32,quint32,quint32,QString,bool,ushort)
                    QKeyEvent * cpp_result = QKeyEvent::createExtendedKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, *cpp_arg6, cpp_arg7, cpp_arg8);
                    py_result = Shiboken::Converter<QKeyEvent * >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQKeyEventFunc_createExtendedKeyEvent_TypeError;
            } else goto SbkQKeyEventFunc_createExtendedKeyEvent_TypeError;
        } else goto SbkQKeyEventFunc_createExtendedKeyEvent_TypeError;
    } else goto SbkQKeyEventFunc_createExtendedKeyEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeyEventFunc_createExtendedKeyEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, int, PySide.QtCore.Qt.KeyboardModifiers, unsigned int, unsigned int, unsigned int, PySide.QtCore.QString = QString(), bool = false, ushort = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QKeyEvent.createExtendedKeyEvent", overloads);
        return 0;
}

static PyObject* SbkQKeyEventFunc_hasExtendedInfo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasExtendedInfo()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QKeyEvent::hasExtendedInfo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_isAutoRepeat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAutoRepeat()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QKeyEvent::isAutoRepeat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QKeyEvent::key();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_matches(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(arg)) {
        QKeySequence::StandardKey cpp_arg0 = Shiboken::Converter<QKeySequence::StandardKey >::toCpp(arg);
        // matches(QKeySequence::StandardKey)const
        QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QKeyEvent::matches(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQKeyEventFunc_matches_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQKeyEventFunc_matches_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence.StandardKey", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QKeyEvent.matches", overloads);
        return 0;
}

static PyObject* SbkQKeyEventFunc_modifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modifiers()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::KeyboardModifier> cpp_result = cppSelf->QKeyEvent::modifiers();
    py_result = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_nativeModifiers(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nativeModifiers()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    quint32 cpp_result = cppSelf->QKeyEvent::nativeModifiers();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_nativeScanCode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nativeScanCode()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    quint32 cpp_result = cppSelf->QKeyEvent::nativeScanCode();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_nativeVirtualKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nativeVirtualKey()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    quint32 cpp_result = cppSelf->QKeyEvent::nativeVirtualKey();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQKeyEventFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QKeyEvent* cppSelf = Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QKeyEvent::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQKeyEvent_methods[] = {
    {"count", (PyCFunction)SbkQKeyEventFunc_count, METH_NOARGS},
    {"createExtendedKeyEvent", (PyCFunction)SbkQKeyEventFunc_createExtendedKeyEvent, METH_VARARGS|METH_STATIC},
    {"hasExtendedInfo", (PyCFunction)SbkQKeyEventFunc_hasExtendedInfo, METH_NOARGS},
    {"isAutoRepeat", (PyCFunction)SbkQKeyEventFunc_isAutoRepeat, METH_NOARGS},
    {"key", (PyCFunction)SbkQKeyEventFunc_key, METH_NOARGS},
    {"matches", (PyCFunction)SbkQKeyEventFunc_matches, METH_O},
    {"modifiers", (PyCFunction)SbkQKeyEventFunc_modifiers, METH_NOARGS},
    {"nativeModifiers", (PyCFunction)SbkQKeyEventFunc_nativeModifiers, METH_NOARGS},
    {"nativeScanCode", (PyCFunction)SbkQKeyEventFunc_nativeScanCode, METH_NOARGS},
    {"nativeVirtualKey", (PyCFunction)SbkQKeyEventFunc_nativeVirtualKey, METH_NOARGS},
    {"text", (PyCFunction)SbkQKeyEventFunc_text, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQKeyEvent_get_k(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->k);
}
static int SbkQKeyEvent_set_k(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'k' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'k', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->k = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQKeyEvent_get_txt(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->txt);
}
static int SbkQKeyEvent_set_txt(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'txt' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'txt', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->txt = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQKeyEvent_get_c(SbkBaseWrapper* self)
{
    return Shiboken::Converter<ushort >::toPython(Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->c);
}
static int SbkQKeyEvent_set_c(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'c' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'c', 'ushort' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->c = Shiboken::Converter<ushort >::toCpp(value);

    return 0;
}

static PyObject* SbkQKeyEvent_get_autor(SbkBaseWrapper* self)
{
    return Shiboken::Converter<unsigned int >::toPython(Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->autor);
}
static int SbkQKeyEvent_set_autor(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'autor' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'autor', 'uint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QKeyEvent* >::toCpp((PyObject*)self)->autor = Shiboken::Converter<unsigned int >::toCpp(value);

    return 0;
}

// Getters and Setters for QKeyEvent
static PyGetSetDef SbkQKeyEvent_getsetlist[] = {
    {const_cast<char*>("k"), (getter)SbkQKeyEvent_get_k, (setter)SbkQKeyEvent_set_k},
    {const_cast<char*>("txt"), (getter)SbkQKeyEvent_get_txt, (setter)SbkQKeyEvent_set_txt},
    {const_cast<char*>("c"), (getter)SbkQKeyEvent_get_c, (setter)SbkQKeyEvent_set_c},
    {const_cast<char*>("autor"), (getter)SbkQKeyEvent_get_autor, (setter)SbkQKeyEvent_set_autor},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQKeyEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QKeyEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQKeyEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQKeyEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQKeyEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QKeyEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQKeyEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQKeyEvent_Type);
     if ( reinterpret_cast<QKeyEvent*>(cptr)->type() == QEvent::KeyPress ||  reinterpret_cast<QKeyEvent*>(cptr)->type() == QEvent::KeyRelease)
        return &SbkQKeyEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QKeyEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QKEYEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQKeyEvent_Type);

    SbkQKeyEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQKeyEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQKeyEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQKeyEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQKeyEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQKeyEvent_Type));
    PyModule_AddObject(module, "QKeyEvent",
        ((PyObject*)&SbkQKeyEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QKeyEvent >("QKeyEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QKeyEvent >(typeid(QKeyEvent).name());
}


} // extern "C"

