/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qitemdelegate_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qitemdelegate.h>
#include <qitemeditorfactory.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QItemDelegateWrapper::QItemDelegateWrapper(QObject * parent) : QItemDelegate(parent), m_metaObject(0) {
    // ... middle
}

void QItemDelegateWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QItemDelegateWrapper::createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createEditor"));
    if (py_override.isNull()) {
        return this->QItemDelegate::createEditor(parent, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(parent),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemDelegate.createEditor", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

void QItemDelegateWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemDelegateWrapper::drawCheck(QPainter * painter, const QStyleOptionViewItem & option, const QRect & rect, Qt::CheckState state) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawCheck"));
    if (py_override.isNull()) {
        return this->QItemDelegate::drawCheck(painter, option, rect, state);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<Qt::CheckState >::toPython(state)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::drawDecoration(QPainter * painter, const QStyleOptionViewItem & option, const QRect & rect, const QPixmap & pixmap) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawDecoration"));
    if (py_override.isNull()) {
        return this->QItemDelegate::drawDecoration(painter, option, rect, pixmap);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QPixmap & >::toPython(pixmap)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::drawDisplay(QPainter * painter, const QStyleOptionViewItem & option, const QRect & rect, const QString & text) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawDisplay"));
    if (py_override.isNull()) {
        return this->QItemDelegate::drawDisplay(painter, option, rect, text);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QRect & >::toPython(rect),
        Shiboken::Converter<QString & >::toPython(text)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::drawFocus(QPainter * painter, const QStyleOptionViewItem & option, const QRect & rect) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "drawFocus"));
    if (py_override.isNull()) {
        return this->QItemDelegate::drawFocus(painter, option, rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QRect & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QItemDelegateWrapper::editorEvent(QEvent * event, QAbstractItemModel * model, const QStyleOptionViewItem & option, const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorEvent"));
    if (py_override.isNull()) {
        return this->QItemDelegate::editorEvent(event, model, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QEvent * >::toPython(event),
        Shiboken::Converter<QAbstractItemModel * >::toPython(model),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemDelegate.editorEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QItemDelegateWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemDelegate.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QItemDelegateWrapper::eventFilter(QObject * object, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QItemDelegate::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(object),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemDelegate.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QItemDelegateWrapper::paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        return this->QItemDelegate::paint(painter, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemDelegateWrapper::setEditorData(QWidget * editor, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setEditorData"));
    if (py_override.isNull()) {
        return this->QItemDelegate::setEditorData(editor, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QItemDelegateWrapper::setModelData(QWidget * editor, QAbstractItemModel * model, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModelData"));
    if (py_override.isNull()) {
        return this->QItemDelegate::setModelData(editor, model, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QAbstractItemModel * >::toPython(model),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QItemDelegateWrapper::sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QItemDelegate::sizeHint(option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemDelegate.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QItemDelegateWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QItemDelegateWrapper::updateEditorGeometry(QWidget * editor, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometry"));
    if (py_override.isNull()) {
        return this->QItemDelegate::updateEditorGeometry(editor, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QItemDelegateWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QItemDelegate::staticMetaObject);
}
    return m_metaObject;
}

int QItemDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QItemDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QItemDelegateWrapper::~QItemDelegateWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQItemDelegate_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemDelegateWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QItemDelegate", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QItemDelegate(QObject*)
        cptr = new QItemDelegateWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QItemDelegate(QObject*)
        cptr = new QItemDelegateWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQItemDelegate_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QItemDelegate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQItemDelegate_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQItemDelegate_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate", overloads);
        return -1;
}

static PyObject* SbkQItemDelegateFunc_check(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "check", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        // check(QStyleOptionViewItem,QRect,QVariant)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QItemDelegate::check(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_check_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_check_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QRect, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.check", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_createEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createEditor", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // createEditor(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QItemDelegate::createEditor(cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQItemDelegateFunc_createEditor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_createEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.createEditor", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_decoration(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "decoration", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // decoration(QStyleOptionViewItem,QVariant)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QPixmap cpp_result = cppSelf->QItemDelegate::decoration(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_decoration_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_decoration_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.decoration", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_drawBackground(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawBackground", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // drawBackground(QPainter*,QStyleOptionViewItem,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::drawBackground(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_drawBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_drawBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.drawBackground", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_drawCheck(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawCheck", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[2]) && Shiboken::Converter<Qt::CheckState >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
        Qt::CheckState cpp_arg3 = Shiboken::Converter<Qt::CheckState >::toCpp(pyargs[3]);
        // drawCheck(QPainter*,QStyleOptionViewItem,QRect,Qt::CheckState)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::drawCheck(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_drawCheck_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_drawCheck_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QRect, PySide.QtCore.Qt.CheckState", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.drawCheck", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_drawDecoration(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawDecoration", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[2]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg3_auto_ptr;
        QPixmap* cpp_arg3 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[3]);
        if (!SbkQPixmap_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg3);
        // drawDecoration(QPainter*,QStyleOptionViewItem,QRect,QPixmap)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::drawDecoration(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_drawDecoration_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_drawDecoration_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QRect, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.drawDecoration", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_drawDisplay(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawDisplay", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[2]) && Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!SbkQString_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // drawDisplay(QPainter*,QStyleOptionViewItem,QRect,QString)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::drawDisplay(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_drawDisplay_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_drawDisplay_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QRect, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.drawDisplay", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_drawFocus(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawFocus", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
        // drawFocus(QPainter*,QStyleOptionViewItem,QRect)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::drawFocus(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_drawFocus_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_drawFocus_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.drawFocus", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_editorEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "editorEvent", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QEvent * >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel * >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[2]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOptionViewItem* cpp_arg2 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        // editorEvent(QEvent*,QAbstractItemModel*,QStyleOptionViewItem,QModelIndex)
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemDelegate::editorEvent(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_editorEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_editorEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent, PySide.QtCore.QAbstractItemModel, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.editorEvent", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemDelegate::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_hasClipping(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasClipping()const
    QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QItemDelegate::hasClipping();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemDelegateFunc_itemEditorFactory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemEditorFactory()const
    QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
    QItemEditorFactory * cpp_result = cppSelf->QItemDelegate::itemEditorFactory();
    py_result = Shiboken::Converter<QItemEditorFactory * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemDelegateFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // paint(QPainter*,QStyleOptionViewItem,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::paint(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.paint", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_rect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "rect", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // rect(QStyleOptionViewItem,QModelIndex,int)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QItemDelegate::rect(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_rect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_rect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.rect", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_setClipping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setClipping(bool)
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::setClipping(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_setClipping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_setClipping_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemDelegate.setClipping", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_setEditorData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEditorData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // setEditorData(QWidget*,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::setEditorData(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_setEditorData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_setEditorData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.setEditorData", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_setItemEditorFactory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemEditorFactory * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemEditorFactory* cpp_arg0 = Shiboken::Converter<QItemEditorFactory* >::toCpp(arg);
        // setItemEditorFactory(QItemEditorFactory*)
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::setItemEditorFactory(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQItemDelegateFunc_setItemEditorFactory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_setItemEditorFactory_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemEditorFactory", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemDelegate.setItemEditorFactory", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_setModelData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setModelData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel * >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // setModelData(QWidget*,QAbstractItemModel*,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::setModelData(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_setModelData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_setModelData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QAbstractItemModel, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.setModelData", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_setOptions(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOptions", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        // setOptions(QModelIndex,QStyleOptionViewItem)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QStyleOptionViewItem cpp_result = cppSelf->QItemDelegate::setOptions(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QStyleOptionViewItem >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_setOptions_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_setOptions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtGui.QStyleOptionViewItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.setOptions", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // sizeHint(QStyleOptionViewItem,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QItemDelegate::sizeHint(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_textRectangle(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "textRectangle", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QRect & >::isConvertible(pyargs[1]) && Shiboken::Converter<QFont & >::isConvertible(pyargs[2]) && Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QFont > cpp_arg2_auto_ptr;
        QFont* cpp_arg2 = Shiboken::Converter<QFont* >::toCpp(pyargs[2]);
        if (!SbkQFont_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QFont >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!SbkQString_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // textRectangle(QPainter*,QRect,QFont,QString)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QItemDelegate::textRectangle(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_textRectangle_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemDelegateFunc_textRectangle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, PySide.QtGui.QFont, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.textRectangle", overloads);
        return 0;
}

static PyObject* SbkQItemDelegateFunc_updateEditorGeometry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "updateEditorGeometry", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // updateEditorGeometry(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QItemDelegate* cppSelf = Shiboken::Converter<QItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QItemDelegate::updateEditorGeometry(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemDelegateFunc_updateEditorGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemDelegateFunc_updateEditorGeometry_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemDelegate.updateEditorGeometry", overloads);
        return 0;
}

static PyMethodDef SbkQItemDelegate_methods[] = {
    {"check", (PyCFunction)SbkQItemDelegateFunc_check, METH_VARARGS},
    {"createEditor", (PyCFunction)SbkQItemDelegateFunc_createEditor, METH_VARARGS},
    {"decoration", (PyCFunction)SbkQItemDelegateFunc_decoration, METH_VARARGS},
    {"drawBackground", (PyCFunction)SbkQItemDelegateFunc_drawBackground, METH_VARARGS},
    {"drawCheck", (PyCFunction)SbkQItemDelegateFunc_drawCheck, METH_VARARGS},
    {"drawDecoration", (PyCFunction)SbkQItemDelegateFunc_drawDecoration, METH_VARARGS},
    {"drawDisplay", (PyCFunction)SbkQItemDelegateFunc_drawDisplay, METH_VARARGS},
    {"drawFocus", (PyCFunction)SbkQItemDelegateFunc_drawFocus, METH_VARARGS},
    {"editorEvent", (PyCFunction)SbkQItemDelegateFunc_editorEvent, METH_VARARGS},
    {"eventFilter", (PyCFunction)SbkQItemDelegateFunc_eventFilter, METH_VARARGS},
    {"hasClipping", (PyCFunction)SbkQItemDelegateFunc_hasClipping, METH_NOARGS},
    {"itemEditorFactory", (PyCFunction)SbkQItemDelegateFunc_itemEditorFactory, METH_NOARGS},
    {"paint", (PyCFunction)SbkQItemDelegateFunc_paint, METH_VARARGS},
    {"rect", (PyCFunction)SbkQItemDelegateFunc_rect, METH_VARARGS},
    {"setClipping", (PyCFunction)SbkQItemDelegateFunc_setClipping, METH_O},
    {"setEditorData", (PyCFunction)SbkQItemDelegateFunc_setEditorData, METH_VARARGS},
    {"setItemEditorFactory", (PyCFunction)SbkQItemDelegateFunc_setItemEditorFactory, METH_O},
    {"setModelData", (PyCFunction)SbkQItemDelegateFunc_setModelData, METH_VARARGS},
    {"setOptions", (PyCFunction)SbkQItemDelegateFunc_setOptions, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQItemDelegateFunc_sizeHint, METH_VARARGS},
    {"textRectangle", (PyCFunction)SbkQItemDelegateFunc_textRectangle, METH_VARARGS},
    {"updateEditorGeometry", (PyCFunction)SbkQItemDelegateFunc_updateEditorGeometry, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemDelegate_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemDelegate",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemDelegate_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemDelegate_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QItemDelegate >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QItemDelegate(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMDELEGATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemDelegate_Type);

    SbkQItemDelegate_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX];
    // Fill type discovery information
    SbkQItemDelegate_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQItemDelegate_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemDelegate_Type));
    PyModule_AddObject(module, "QItemDelegate",
        ((PyObject*)&SbkQItemDelegate_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QItemDelegate >("QItemDelegate*");
    Shiboken::TypeResolver::createObjectTypeResolver<QItemDelegate >(typeid(QItemDelegate).name());
}


} // extern "C"

