/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qgraphicsproxywidget_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicsitem.h>
#include <qgraphicslayout.h>
#include <qgraphicslayoutitem.h>
#include <qgraphicsproxywidget.h>
#include <qgraphicssceneevent.h>
#include <qgraphicswidget.h>
#include <qkeysequence.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsProxyWidgetWrapper::QGraphicsProxyWidgetWrapper(QGraphicsItem * parent, QFlags<Qt::WindowType> wFlags) : QGraphicsProxyWidget(parent, wFlags), m_metaObject(0) {
    // ... middle
}

void QGraphicsProxyWidgetWrapper::advance(int phase)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "advance"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::advance(phase);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        phase
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QRectF QGraphicsProxyWidgetWrapper::boundingRect() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRect"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::boundingRect();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.boundingRect", SbkType<QRectF >()->tp_name, py_result->ob_type->tp_name);
        return QRectF();
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsProxyWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QGraphicsProxyWidgetWrapper::collidesWithItem(const QGraphicsItem * other, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithItem"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithItem(other, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem * >::toPython(other),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.collidesWithItem", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsProxyWidgetWrapper::collidesWithPath(const QPainterPath & path, Qt::ItemSelectionMode mode) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "collidesWithPath"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::collidesWithPath(path, mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QPainterPath & >::toPython(path),
        Shiboken::Converter<Qt::ItemSelectionMode >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.collidesWithPath", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsProxyWidgetWrapper::contains(const QPointF & point) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contains"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::contains(point);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPointF & >::toPython(point)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.contains", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::contextMenuEvent(QGraphicsSceneContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneContextMenuEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::dragEnterEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::dragLeaveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::dragMoveEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::dropEvent(QGraphicsSceneDragDropEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneDragDropEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsProxyWidgetWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsProxyWidgetWrapper::eventFilter(QObject * object, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(object),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsProxyWidgetWrapper::extension(const QVariant & variant) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "extension"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::extension(variant);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(variant)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.extension", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsProxyWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::grabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::grabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsProxyWidgetWrapper::grabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "grabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::grabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::hideEvent(QHideEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::hoverEnterEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverEnterEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::hoverLeaveEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverLeaveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::hoverLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::hoverMoveEvent(QGraphicsSceneHoverEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hoverMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::hoverMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneHoverEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::inputMethodEvent(QInputMethodEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsProxyWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery query) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(query)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsProxyWidgetWrapper::isObscuredBy(const QGraphicsItem * item) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isObscuredBy"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::isObscuredBy(item);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsItem * >::toPython(item)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.isObscuredBy", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QGraphicsProxyWidgetWrapper::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemChange"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::itemChange(change, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toPython(change),
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.itemChange", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::mouseDoubleClickEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::mouseMoveEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::mousePressEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::mouseReleaseEvent(QGraphicsSceneMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::moveEvent(QGraphicsSceneMoveEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneMoveEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPainterPath QGraphicsProxyWidgetWrapper::opaqueArea() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "opaqueArea"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::opaqueArea();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.opaqueArea", SbkType<QPainterPath >()->tp_name, py_result->ob_type->tp_name);
        return QPainterPath();
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::paint(painter, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionGraphicsItem * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::paintWindowFrame(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintWindowFrame"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionGraphicsItem * >::toPython(option),
        Shiboken::Converter<QWidget * >::toPython(widget)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsProxyWidgetWrapper::polishEvent()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "polishEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::polishEvent();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QGraphicsProxyWidgetWrapper::propertyChange(const QString & propertyName, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "propertyChange"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::propertyChange(propertyName, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QString & >::toPython(propertyName),
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.propertyChange", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::resizeEvent(QGraphicsSceneResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsProxyWidgetWrapper::sceneEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::sceneEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.sceneEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QGraphicsProxyWidgetWrapper::sceneEventFilter(QGraphicsItem * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sceneEventFilter"));
    if (py_override.isNull()) {
        return this->QGraphicsItem::sceneEventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QGraphicsItem * >::toPython(watched),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.sceneEventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPainterPath QGraphicsProxyWidgetWrapper::shape() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "shape"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::shape();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPainterPath();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPainterPath >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.shape", SbkType<QPainterPath >()->tp_name, py_result->ob_type->tp_name);
        return QPainterPath();
    }
    QPainterPath cpp_result(Shiboken::Converter<QPainterPath >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QGraphicsProxyWidgetWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF & >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.sizeHint", SbkType<QSizeF >()->tp_name, py_result->ob_type->tp_name);
        return QSizeF();
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QGraphicsProxyWidgetWrapper::type() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "type"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::type();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.type", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsProxyWidgetWrapper::ungrabKeyboardEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabKeyboardEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::ungrabKeyboardEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsProxyWidgetWrapper::ungrabMouseEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ungrabMouseEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::ungrabMouseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsProxyWidgetWrapper::wheelEvent(QGraphicsSceneWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsProxyWidget::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QGraphicsSceneWheelEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsProxyWidgetWrapper::windowFrameEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.windowFrameEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

Qt::WindowFrameSection QGraphicsProxyWidgetWrapper::windowFrameSectionAt(const QPointF & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "windowFrameSectionAt"));
    if (py_override.isNull()) {
        return this->QGraphicsWidget::windowFrameSectionAt(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPointF & >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return Qt::WindowFrameSection();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<Qt::WindowFrameSection >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsProxyWidget.windowFrameSectionAt", SbkType<Qt::WindowFrameSection >()->tp_name, py_result->ob_type->tp_name);
        return Qt::WindowFrameSection();
    }
    Qt::WindowFrameSection cpp_result(Shiboken::Converter<Qt::WindowFrameSection >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QGraphicsProxyWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsProxyWidget::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsProxyWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsProxyWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsProxyWidgetWrapper::~QGraphicsProxyWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsProxyWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsProxyWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGraphicsProxyWidget", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsProxyWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
        cptr = new QGraphicsProxyWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsItem* cpp_arg0 = Shiboken::Converter<QGraphicsItem* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGraphicsProxyWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
            cptr = new QGraphicsProxyWidgetWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QGraphicsProxyWidget(QGraphicsItem*,QFlags<Qt::WindowType>)
            cptr = new QGraphicsProxyWidgetWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQGraphicsProxyWidget_Init_TypeError;
    } else goto SbkQGraphicsProxyWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsProxyWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsProxyWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsProxyWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsProxyWidget", overloads);
        return -1;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneContextMenuEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QGraphicsSceneContextMenuEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_createProxyForChildWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // createProxyForChildWidget(QWidget*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        QGraphicsProxyWidget * cpp_result = cppSelf->QGraphicsProxyWidget::createProxyForChildWidget(cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsProxyWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(arg, py_result);
    } else goto SbkQGraphicsProxyWidgetFunc_createProxyForChildWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_createProxyForChildWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.createProxyForChildWidget", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragEnterEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::dragEnterEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.dragEnterEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragLeaveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::dragLeaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.dragLeaveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dragMoveEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::dragMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.dragMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneDragDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneDragDropEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneDragDropEvent* >::toCpp(arg);
        // dropEvent(QGraphicsSceneDragDropEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::dropEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneDragDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.dropEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsProxyWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.event", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsProxyWidget::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsProxyWidget.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QGraphicsProxyWidget::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.focusNextPrevChild", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::focusOutEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.focusOutEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_grabMouseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // grabMouseEvent(QEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::grabMouseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_grabMouseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_grabMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.grabMouseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_hoverEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverEnterEvent(QGraphicsSceneHoverEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::hoverEnterEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_hoverEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_hoverEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.hoverEnterEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_hoverLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverLeaveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::hoverLeaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_hoverLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_hoverLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.hoverLeaveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_hoverMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneHoverEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneHoverEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneHoverEvent* >::toCpp(arg);
        // hoverMoveEvent(QGraphicsSceneHoverEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::hoverMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_hoverMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_hoverMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneHoverEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.hoverMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_itemChange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemChange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        QGraphicsItem::GraphicsItemChange cpp_arg0 = Shiboken::Converter<QGraphicsItem::GraphicsItemChange >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // itemChange(QGraphicsItem::GraphicsItemChange,QVariant)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QGraphicsProxyWidget::itemChange(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_itemChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_itemChange_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsItem.GraphicsItemChange, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsProxyWidget.itemChange", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::keyReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.keyReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::mouseDoubleClickEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QGraphicsSceneMouseEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mousePressEvent(QGraphicsSceneMouseEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneMouseEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QGraphicsSceneMouseEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_newProxyWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // newProxyWidget(const QWidget*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        QGraphicsProxyWidget * cpp_result = cppSelf->QGraphicsProxyWidget::newProxyWidget(cpp_arg0);
        py_result = Shiboken::Converter<QGraphicsProxyWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(arg, py_result);
    } else goto SbkQGraphicsProxyWidgetFunc_newProxyWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_newProxyWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.newProxyWidget", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionGraphicsItem * >::isConvertible(pyargs[1]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionGraphicsItem* cpp_arg1 = Shiboken::Converter<QStyleOptionGraphicsItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // paint(QPainter*,const QStyleOptionGraphicsItem*,QWidget*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::paint(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionGraphicsItem, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsProxyWidget.paint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneResizeEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneResizeEvent* >::toCpp(arg);
        // resizeEvent(QGraphicsSceneResizeEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_setWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setWidget(QWidget*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::setWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQGraphicsProxyWidgetFunc_setWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_setWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.setWidget", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.showEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsProxyWidget::sizeHint(cpp_arg0);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsProxyWidget::sizeHint(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsProxyWidgetFunc_sizeHint_TypeError;
    } else goto SbkQGraphicsProxyWidgetFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF = QSizeF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsProxyWidget.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_subWidgetRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // subWidgetRect(const QWidget*)const
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsProxyWidget::subWidgetRect(cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_subWidgetRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsProxyWidgetFunc_subWidgetRect_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.subWidgetRect", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsProxyWidget::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_ungrabMouseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // ungrabMouseEvent(QEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::ungrabMouseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_ungrabMouseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_ungrabMouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.ungrabMouseEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGraphicsSceneWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsSceneWheelEvent* cpp_arg0 = Shiboken::Converter<QGraphicsSceneWheelEvent* >::toCpp(arg);
        // wheelEvent(QGraphicsSceneWheelEvent*)
        QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsProxyWidget::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsProxyWidgetFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsProxyWidgetFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsSceneWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsProxyWidget.wheelEvent", overloads);
        return 0;
}

static PyObject* SbkQGraphicsProxyWidgetFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()const
    QGraphicsProxyWidget* cppSelf = Shiboken::Converter<QGraphicsProxyWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QGraphicsProxyWidget::widget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGraphicsProxyWidget_methods[] = {
    {"contextMenuEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_contextMenuEvent, METH_O},
    {"createProxyForChildWidget", (PyCFunction)SbkQGraphicsProxyWidgetFunc_createProxyForChildWidget, METH_O},
    {"dragEnterEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_dropEvent, METH_O},
    {"event", (PyCFunction)SbkQGraphicsProxyWidgetFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQGraphicsProxyWidgetFunc_eventFilter, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQGraphicsProxyWidgetFunc_focusNextPrevChild, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_focusOutEvent, METH_O},
    {"grabMouseEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_grabMouseEvent, METH_O},
    {"hideEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_hideEvent, METH_O},
    {"hoverEnterEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_hoverEnterEvent, METH_O},
    {"hoverLeaveEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_hoverLeaveEvent, METH_O},
    {"hoverMoveEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_hoverMoveEvent, METH_O},
    {"itemChange", (PyCFunction)SbkQGraphicsProxyWidgetFunc_itemChange, METH_VARARGS},
    {"keyPressEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_keyReleaseEvent, METH_O},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_mouseReleaseEvent, METH_O},
    {"newProxyWidget", (PyCFunction)SbkQGraphicsProxyWidgetFunc_newProxyWidget, METH_O},
    {"paint", (PyCFunction)SbkQGraphicsProxyWidgetFunc_paint, METH_VARARGS},
    {"resizeEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_resizeEvent, METH_O},
    {"setGeometry", (PyCFunction)SbkQGraphicsProxyWidgetFunc_setGeometry, METH_O},
    {"setWidget", (PyCFunction)SbkQGraphicsProxyWidgetFunc_setWidget, METH_O},
    {"showEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQGraphicsProxyWidgetFunc_sizeHint, METH_VARARGS},
    {"subWidgetRect", (PyCFunction)SbkQGraphicsProxyWidgetFunc_subWidgetRect, METH_O},
    {"type", (PyCFunction)SbkQGraphicsProxyWidgetFunc_type, METH_NOARGS},
    {"ungrabMouseEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_ungrabMouseEvent, METH_O},
    {"wheelEvent", (PyCFunction)SbkQGraphicsProxyWidgetFunc_wheelEvent, METH_O},
    {"widget", (PyCFunction)SbkQGraphicsProxyWidgetFunc_widget, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQGraphicsProxyWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QGraphicsProxyWidget* me = reinterpret_cast<QGraphicsProxyWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX]))
        return static_cast<QGraphicsWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSOBJECT_IDX]))
        return static_cast<QGraphicsObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSITEM_IDX]))
        return static_cast<QGraphicsItem*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]))
        return static_cast<QGraphicsLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsProxyWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsProxyWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsProxyWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsProxyWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQGraphicsProxyWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsProxyWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGraphicsProxyWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSPROXYWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsProxyWidget_Type);

    SbkQGraphicsProxyWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX];
    SbkQGraphicsProxyWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQGraphicsProxyWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsProxyWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsProxyWidget_Type));
    PyModule_AddObject(module, "QGraphicsProxyWidget",
        ((PyObject*)&SbkQGraphicsProxyWidget_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsProxyWidget >("QGraphicsProxyWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsProxyWidget >(typeid(QGraphicsProxyWidget).name());
}


} // extern "C"

