/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qxmlstreamnotationdeclaration_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxmlstream.h>

using namespace Shiboken;

static int
SbkQXmlStreamNotationDeclaration_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlStreamNotationDeclaration* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlStreamNotationDeclaration", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlStreamNotationDeclaration()
        cptr = new QXmlStreamNotationDeclaration();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlStreamNotationDeclaration & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlStreamNotationDeclaration* cpp_arg0 = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp(pyargs[0]);
        // QXmlStreamNotationDeclaration(QXmlStreamNotationDeclaration)
        cptr = new QXmlStreamNotationDeclaration(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamNotationDeclaration_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlStreamNotationDeclaration >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlStreamNotationDeclaration_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlStreamNotationDeclaration_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QXmlStreamNotationDeclaration", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamNotationDeclaration", overloads);
        return -1;
}

static PyObject* SbkQXmlStreamNotationDeclarationFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QXmlStreamNotationDeclaration* cppSelf = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamNotationDeclaration::name();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamNotationDeclarationFunc_publicId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // publicId()const
    QXmlStreamNotationDeclaration* cppSelf = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamNotationDeclaration::publicId();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamNotationDeclarationFunc_systemId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // systemId()const
    QXmlStreamNotationDeclaration* cppSelf = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)self);
    QStringRef cpp_result = cppSelf->QXmlStreamNotationDeclaration::systemId();
    py_result = Shiboken::Converter<QStringRef >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQXmlStreamNotationDeclaration_methods[] = {
    {"name", (PyCFunction)SbkQXmlStreamNotationDeclarationFunc_name, METH_NOARGS},
    {"publicId", (PyCFunction)SbkQXmlStreamNotationDeclarationFunc_publicId, METH_NOARGS},
    {"systemId", (PyCFunction)SbkQXmlStreamNotationDeclarationFunc_systemId, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQXmlStreamNotationDeclaration_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QXmlStreamNotationDeclaration& cpp_self = *Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QXmlStreamNotationDeclaration & >::isConvertible(other)) {
                // operator!=(const QXmlStreamNotationDeclaration & other) const
                QXmlStreamNotationDeclaration* cpp_other = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlStreamNotationDeclaration  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQXmlStreamNotationDeclaration_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QXmlStreamNotationDeclaration & >::isConvertible(other)) {
                // operator==(const QXmlStreamNotationDeclaration & other) const
                QXmlStreamNotationDeclaration* cpp_other = Shiboken::Converter<QXmlStreamNotationDeclaration* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlStreamNotationDeclaration  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQXmlStreamNotationDeclaration_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQXmlStreamNotationDeclaration_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlStreamNotationDeclaration_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QXmlStreamNotationDeclaration",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQXmlStreamNotationDeclaration_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlStreamNotationDeclaration_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlStreamNotationDeclaration_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlStreamNotationDeclaration >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlStreamNotationDeclaration(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMNOTATIONDECLARATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlStreamNotationDeclaration_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlStreamNotationDeclaration_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlStreamNotationDeclaration_Type));
    PyModule_AddObject(module, "QXmlStreamNotationDeclaration",
        ((PyObject*)&SbkQXmlStreamNotationDeclaration_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamNotationDeclaration >("QXmlStreamNotationDeclaration");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlStreamNotationDeclaration >(typeid(QXmlStreamNotationDeclaration).name());
}


} // extern "C"

