/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qstatemachine_signalevent_wrapper.h"

// Extra includes
#include <QList>
#include <qobject.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

SignalEventWrapper::SignalEventWrapper(QObject * sender, int signalIndex, const QList<QVariant > & arguments) : QStateMachine::SignalEvent(sender, signalIndex, arguments) {
    // ... middle
}

SignalEventWrapper::~SignalEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQStateMachine_SignalEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    SignalEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQStateMachine_SignalEvent_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "SignalEvent", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 3 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QList<QVariant >  >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        QList<QVariant >  cpp_arg2 = Shiboken::Converter<QList<QVariant >  >::toCpp(pyargs[2]);
        // SignalEvent(QObject*,int,QList<QVariant>)
        cptr = new SignalEventWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStateMachine::SignalEvent & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QStateMachine::SignalEvent* cpp_arg0 = Shiboken::Converter<QStateMachine::SignalEvent* >::toCpp(pyargs[0]);
        // SignalEvent(QStateMachine::SignalEvent)
        cptr = new SignalEventWrapper(*reinterpret_cast<SignalEventWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateMachine_SignalEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStateMachine::SignalEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStateMachine_SignalEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStateMachine_SignalEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStateMachine::SignalEvent", "PySide.QtCore.QObject, int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.SignalEvent", overloads);
        return -1;
}

static PyObject* SbkQStateMachine_SignalEventFunc_arguments(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // arguments()const
    QStateMachine::SignalEvent* cppSelf = Shiboken::Converter<QStateMachine::SignalEvent* >::toCpp((PyObject*)self);
    QList<QVariant > cpp_result = cppSelf->QStateMachine::SignalEvent::arguments();
    py_result = Shiboken::Converter<QList<QVariant > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateMachine_SignalEventFunc_sender(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sender()const
    QStateMachine::SignalEvent* cppSelf = Shiboken::Converter<QStateMachine::SignalEvent* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QStateMachine::SignalEvent::sender();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateMachine_SignalEventFunc_signalIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // signalIndex()const
    QStateMachine::SignalEvent* cppSelf = Shiboken::Converter<QStateMachine::SignalEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStateMachine::SignalEvent::signalIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQStateMachine_SignalEvent_methods[] = {
    {"arguments", (PyCFunction)SbkQStateMachine_SignalEventFunc_arguments, METH_NOARGS},
    {"sender", (PyCFunction)SbkQStateMachine_SignalEventFunc_sender, METH_NOARGS},
    {"signalIndex", (PyCFunction)SbkQStateMachine_SignalEventFunc_signalIndex, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQStateMachine_SignalEvent_ObjCopierFunc(const void* ptr){
    return new SignalEventWrapper(*reinterpret_cast<const QStateMachine::SignalEvent*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStateMachine_SignalEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.SignalEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStateMachine_SignalEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStateMachine_SignalEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQStateMachine_SignalEvent_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStateMachine::SignalEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStateMachine_SignalEvent(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_SIGNALEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStateMachine_SignalEvent_Type);

    SbkQStateMachine_SignalEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQStateMachine_SignalEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStateMachine_SignalEvent_Type) < 0)
        return;

    PyDict_SetItemString(module,"SignalEvent", (PyObject*)&SbkQStateMachine_SignalEvent_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QStateMachine::SignalEvent >("QStateMachine::SignalEvent");
    Shiboken::TypeResolver::createValueTypeResolver<QStateMachine::SignalEvent >(typeid(QStateMachine::SignalEvent).name());
}


} // extern "C"

