/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qpropertyanimation_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <QVector>
#include <qanimationgroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qeasingcurve.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpropertyanimation.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPropertyAnimationWrapper::QPropertyAnimationWrapper(QObject * parent) : QPropertyAnimation(parent), m_metaObject(0) {
    // ... middle
}

QPropertyAnimationWrapper::QPropertyAnimationWrapper(QObject * target, const QByteArray & propertyName, QObject * parent) : QPropertyAnimation(target, propertyName, parent), m_metaObject(0) {
    // ... middle
}

void QPropertyAnimationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPropertyAnimationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPropertyAnimationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPropertyAnimationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QPropertyAnimationWrapper::duration() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "duration"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::duration();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPropertyAnimation.duration", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QPropertyAnimationWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QPropertyAnimation::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPropertyAnimation.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QPropertyAnimationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPropertyAnimation.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QVariant QPropertyAnimationWrapper::interpolated(const QVariant & from, const QVariant & to, qreal progress) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "interpolated"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::interpolated(from, to, progress);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSd)",
        Shiboken::Converter<QVariant & >::toPython(from),
        Shiboken::Converter<QVariant & >::toPython(to),
        Shiboken::Converter<double >::toPython(progress)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPropertyAnimation.interpolated", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QPropertyAnimationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QPropertyAnimationWrapper::updateCurrentTime(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentTime"));
    if (py_override.isNull()) {
        return this->QVariantAnimation::updateCurrentTime(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPropertyAnimationWrapper::updateCurrentValue(const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentValue"));
    if (py_override.isNull()) {
        return this->QPropertyAnimation::updateCurrentValue(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPropertyAnimationWrapper::updateDirection(QAbstractAnimation::Direction direction)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateDirection"));
    if (py_override.isNull()) {
        return this->QAbstractAnimation::updateDirection(direction);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractAnimation::Direction >::toPython(direction)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QPropertyAnimationWrapper::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateState"));
    if (py_override.isNull()) {
        return this->QPropertyAnimation::updateState(newState, oldState);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QAbstractAnimation::State >::toPython(newState),
        Shiboken::Converter<QAbstractAnimation::State >::toPython(oldState)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QPropertyAnimationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QPropertyAnimation::staticMetaObject);
}
    return m_metaObject;
}

int QPropertyAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QPropertyAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QPropertyAnimationWrapper::~QPropertyAnimationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQPropertyAnimation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPropertyAnimationWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QPropertyAnimation", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QPropertyAnimation(QObject*)
        cptr = new QPropertyAnimationWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QPropertyAnimation(QObject*)
            cptr = new QPropertyAnimationWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // QPropertyAnimation(QObject*,QByteArray,QObject*)
                cptr = new QPropertyAnimationWrapper(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QPropertyAnimation(QObject*,QByteArray,QObject*)
                cptr = new QPropertyAnimationWrapper(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQPropertyAnimation_Init_TypeError;
        } else goto SbkQPropertyAnimation_Init_TypeError;
    } else goto SbkQPropertyAnimation_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPropertyAnimation >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPropertyAnimation_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPropertyAnimation_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QObject, PySide.QtCore.QByteArray, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPropertyAnimation", overloads);
        return -1;
}

static PyObject* SbkQPropertyAnimationFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPropertyAnimation::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPropertyAnimationFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPropertyAnimationFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPropertyAnimation.event", overloads);
        return 0;
}

static PyObject* SbkQPropertyAnimationFunc_propertyName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyName()const
    QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QPropertyAnimation::propertyName();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPropertyAnimationFunc_setPropertyName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setPropertyName(QByteArray)
        QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
        cppSelf->QPropertyAnimation::setPropertyName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPropertyAnimationFunc_setPropertyName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPropertyAnimationFunc_setPropertyName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPropertyAnimation.setPropertyName", overloads);
        return 0;
}

static PyObject* SbkQPropertyAnimationFunc_setTargetObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // setTargetObject(QObject*)
        QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
        cppSelf->QPropertyAnimation::setTargetObject(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPropertyAnimationFunc_setTargetObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPropertyAnimationFunc_setTargetObject_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPropertyAnimation.setTargetObject", overloads);
        return 0;
}

static PyObject* SbkQPropertyAnimationFunc_targetObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // targetObject()const
    QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
    QObject * cpp_result = cppSelf->QPropertyAnimation::targetObject();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPropertyAnimationFunc_updateCurrentValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // updateCurrentValue(QVariant)
        QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
        cppSelf->QPropertyAnimation::updateCurrentValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPropertyAnimationFunc_updateCurrentValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPropertyAnimationFunc_updateCurrentValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPropertyAnimation.updateCurrentValue", overloads);
        return 0;
}

static PyObject* SbkQPropertyAnimationFunc_updateState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "updateState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[1])) {
        QAbstractAnimation::State cpp_arg0 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[0]);
        QAbstractAnimation::State cpp_arg1 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[1]);
        // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
        QPropertyAnimation* cppSelf = Shiboken::Converter<QPropertyAnimation* >::toCpp((PyObject*)self);
        cppSelf->QPropertyAnimation::updateState(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPropertyAnimationFunc_updateState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPropertyAnimationFunc_updateState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.State, PySide.QtCore.QAbstractAnimation.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPropertyAnimation.updateState", overloads);
        return 0;
}

static PyMethodDef SbkQPropertyAnimation_methods[] = {
    {"event", (PyCFunction)SbkQPropertyAnimationFunc_event, METH_O},
    {"propertyName", (PyCFunction)SbkQPropertyAnimationFunc_propertyName, METH_NOARGS},
    {"setPropertyName", (PyCFunction)SbkQPropertyAnimationFunc_setPropertyName, METH_O},
    {"setTargetObject", (PyCFunction)SbkQPropertyAnimationFunc_setTargetObject, METH_O},
    {"targetObject", (PyCFunction)SbkQPropertyAnimationFunc_targetObject, METH_NOARGS},
    {"updateCurrentValue", (PyCFunction)SbkQPropertyAnimationFunc_updateCurrentValue, METH_O},
    {"updateState", (PyCFunction)SbkQPropertyAnimationFunc_updateState, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPropertyAnimation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QPropertyAnimation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPropertyAnimation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPropertyAnimation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPropertyAnimation >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPropertyAnimation(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPROPERTYANIMATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPropertyAnimation_Type);

    SbkQPropertyAnimation_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QVARIANTANIMATION_IDX];
    // Fill type discovery information
    SbkQPropertyAnimation_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQPropertyAnimation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPropertyAnimation_Type));
    PyModule_AddObject(module, "QPropertyAnimation",
        ((PyObject*)&SbkQPropertyAnimation_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QPropertyAnimation >("QPropertyAnimation*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPropertyAnimation >(typeid(QPropertyAnimation).name());
}


} // extern "C"

