/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qprocess_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qprocess.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QProcessWrapper::QProcessWrapper(QObject * parent) : QProcess(parent), m_metaObject(0) {
    // ... middle
}

bool QProcessWrapper::atEnd() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atEnd"));
    if (py_override.isNull()) {
        return this->QProcess::atEnd();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.atEnd", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::bytesAvailable() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesAvailable"));
    if (py_override.isNull()) {
        return this->QProcess::bytesAvailable();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.bytesAvailable", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::bytesToWrite() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "bytesToWrite"));
    if (py_override.isNull()) {
        return this->QProcess::bytesToWrite();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.bytesToWrite", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QProcessWrapper::canReadLine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canReadLine"));
    if (py_override.isNull()) {
        return this->QProcess::canReadLine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.canReadLine", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QProcessWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QProcessWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QProcess::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QProcessWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QProcessWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QProcessWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QProcessWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QProcessWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QProcessWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QProcess::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.isSequential", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QProcessWrapper::open(QFlags<QIODevice::OpenModeFlag> mode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(mode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.open", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QIODevice::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.pos", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::readData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readData"));
    if (py_override.isNull()) {
        return this->QProcess::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.readData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::readLineData(char * data, qint64 maxlen)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "readLineData"));
    if (py_override.isNull()) {
        return this->QIODevice::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(maxlen)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.readLineData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QProcessWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QIODevice::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.reset", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QProcessWrapper::seek(qint64 pos)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.seek", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QProcessWrapper::setupChildProcess()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setupChildProcess"));
    if (py_override.isNull()) {
        return this->QProcess::setupChildProcess();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

qint64 QProcessWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QIODevice::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.size", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

void QProcessWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QProcessWrapper::waitForBytesWritten(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForBytesWritten"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QProcess::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.waitForBytesWritten", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QProcessWrapper::waitForReadyRead(int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForReadyRead"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QProcess::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msecs
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.waitForReadyRead", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QProcessWrapper::writeData(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        return this->QProcess::writeData(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QProcess.writeData", SbkType<qint64 >()->tp_name, py_result->ob_type->tp_name);
        return qint64(0);
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QProcessWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QProcess::staticMetaObject);
}
    return m_metaObject;
}

int QProcessWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QProcess::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QProcessWrapper::~QProcessWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQProcess_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QProcessWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QProcess", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QProcess(QObject*)
        cptr = new QProcessWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QProcess(QObject*)
        cptr = new QProcessWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQProcess_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QProcess >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQProcess_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQProcess_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess", overloads);
        return -1;
}

static PyObject* SbkQProcessFunc_atEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // atEnd()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QProcess::atEnd();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_bytesAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesAvailable()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QProcess::bytesAvailable();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_bytesToWrite(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesToWrite()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QProcess::bytesToWrite();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_canReadLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canReadLine()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QProcess::canReadLine();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    cppSelf->QProcess::close();
    thread_state_saver.restore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessFunc_closeReadChannel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcess::ProcessChannel >::isConvertible(arg)) {
        QProcess::ProcessChannel cpp_arg0 = Shiboken::Converter<QProcess::ProcessChannel >::toCpp(arg);
        // closeReadChannel(QProcess::ProcessChannel)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::closeReadChannel(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_closeReadChannel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_closeReadChannel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcess.ProcessChannel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.closeReadChannel", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_closeWriteChannel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // closeWriteChannel()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    cppSelf->QProcess::closeWriteChannel();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessFunc_environment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // environment()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QProcess::environment();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcess::ProcessError cpp_result = cppSelf->QProcess::error();
    py_result = Shiboken::Converter<QProcess::ProcessError >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_execute(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "execute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // execute(QString)
            thread_state_saver.save();
            int cpp_result = QProcess::execute(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!SbkQStringList_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            // execute(QString,QStringList)
            thread_state_saver.save();
            int cpp_result = QProcess::execute(*cpp_arg0, *cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQProcessFunc_execute_TypeError;
    } else goto SbkQProcessFunc_execute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_execute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.execute", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_exitCode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exitCode()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QProcess::exitCode();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_exitStatus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exitStatus()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcess::ExitStatus cpp_result = cppSelf->QProcess::exitStatus();
    py_result = Shiboken::Converter<QProcess::ExitStatus >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QProcess::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_kill(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // kill()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    cppSelf->QProcess::kill();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessFunc_processChannelMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processChannelMode()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcess::ProcessChannelMode cpp_result = cppSelf->QProcess::processChannelMode();
    py_result = Shiboken::Converter<QProcess::ProcessChannelMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_processEnvironment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processEnvironment()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcessEnvironment cpp_result = cppSelf->QProcess::processEnvironment();
    py_result = Shiboken::Converter<QProcessEnvironment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_readAllStandardError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAllStandardError()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QByteArray cpp_result = cppSelf->QProcess::readAllStandardError();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_readAllStandardOutput(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // readAllStandardOutput()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    QByteArray cpp_result = cppSelf->QProcess::readAllStandardOutput();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_readChannel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readChannel()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcess::ProcessChannel cpp_result = cppSelf->QProcess::readChannel();
    py_result = Shiboken::Converter<QProcess::ProcessChannel >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_readData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readData(char*,qint64)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QProcess::readData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_readData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_readData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.readData", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setEnvironment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setEnvironment(QStringList)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setEnvironment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setEnvironment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setEnvironment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setEnvironment", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setProcessChannelMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcess::ProcessChannelMode >::isConvertible(arg)) {
        QProcess::ProcessChannelMode cpp_arg0 = Shiboken::Converter<QProcess::ProcessChannelMode >::toCpp(arg);
        // setProcessChannelMode(QProcess::ProcessChannelMode)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setProcessChannelMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setProcessChannelMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setProcessChannelMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcess.ProcessChannelMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setProcessChannelMode", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setProcessEnvironment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcessEnvironment & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QProcessEnvironment* cpp_arg0 = Shiboken::Converter<QProcessEnvironment* >::toCpp(arg);
        // setProcessEnvironment(QProcessEnvironment)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setProcessEnvironment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setProcessEnvironment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setProcessEnvironment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcessEnvironment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setProcessEnvironment", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setProcessState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcess::ProcessState >::isConvertible(arg)) {
        QProcess::ProcessState cpp_arg0 = Shiboken::Converter<QProcess::ProcessState >::toCpp(arg);
        // setProcessState(QProcess::ProcessState)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setProcessState(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setProcessState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setProcessState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcess.ProcessState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setProcessState", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setReadChannel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcess::ProcessChannel >::isConvertible(arg)) {
        QProcess::ProcessChannel cpp_arg0 = Shiboken::Converter<QProcess::ProcessChannel >::toCpp(arg);
        // setReadChannel(QProcess::ProcessChannel)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setReadChannel(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setReadChannel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setReadChannel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcess.ProcessChannel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setReadChannel", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setStandardErrorFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStandardErrorFile", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::setStandardErrorFile(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // setStandardErrorFile(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::setStandardErrorFile(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQProcessFunc_setStandardErrorFile_TypeError;
    } else goto SbkQProcessFunc_setStandardErrorFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setStandardErrorFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.Truncate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.setStandardErrorFile", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setStandardInputFile(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStandardInputFile(QString)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setStandardInputFile(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setStandardInputFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setStandardInputFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setStandardInputFile", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setStandardOutputFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStandardOutputFile", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::setStandardOutputFile(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // setStandardOutputFile(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::setStandardOutputFile(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQProcessFunc_setStandardOutputFile_TypeError;
    } else goto SbkQProcessFunc_setStandardOutputFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setStandardOutputFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.Truncate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.setStandardOutputFile", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setStandardOutputProcess(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QProcess * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QProcess* cpp_arg0 = Shiboken::Converter<QProcess* >::toCpp(arg);
        // setStandardOutputProcess(QProcess*)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setStandardOutputProcess(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setStandardOutputProcess_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setStandardOutputProcess_TypeError:
        const char* overloads[] = {"PySide.QtCore.QProcess", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setStandardOutputProcess", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setWorkingDirectory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWorkingDirectory(QString)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        cppSelf->QProcess::setWorkingDirectory(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_setWorkingDirectory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_setWorkingDirectory_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.setWorkingDirectory", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_setupChildProcess(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // setupChildProcess()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    cppSelf->QProcess::setupChildProcess();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessFunc_start(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "start", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // start(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::start(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!SbkQStringList_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            if (numArgs == 2) {
                // start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
                QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
                cppSelf->QProcess::start(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[2])) {
                QFlags<QIODevice::OpenModeFlag> cpp_arg2 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[2]);
                // start(QString,QStringList,QFlags<QIODevice::OpenModeFlag>)
                QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
                cppSelf->QProcess::start(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQProcessFunc_start_TypeError;
        } else if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[1])) {
            QFlags<QIODevice::OpenModeFlag> cpp_arg1 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[1]);
            // start(QString,QFlags<QIODevice::OpenModeFlag>)
            QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
            cppSelf->QProcess::start(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQProcessFunc_start_TypeError;
    } else goto SbkQProcessFunc_start_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessFunc_start_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", "PySide.QtCore.QString, PySide.QtCore.QStringList, PySide.QtCore.QIODevice.OpenMode = QIODevice.ReadWrite", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.start", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_startDetached(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "startDetached", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // startDetached(QString)
            bool cpp_result = QProcess::startDetached(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
            QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
            if (!SbkQStringList_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
            if (numArgs == 2) {
                // startDetached(QString,QStringList)
                bool cpp_result = QProcess::startDetached(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!SbkQString_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                // startDetached(QString,QStringList,QString,qint64*)
                // Begin code injection
                
                qint64 pid;
                bool retval = QProcess::startDetached((*cpp_arg0), (*cpp_arg1), (*cpp_arg2), &pid);
                py_result = Shiboken::makeTuple(retval, pid);
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else goto SbkQProcessFunc_startDetached_TypeError;
        } else goto SbkQProcessFunc_startDetached_TypeError;
    } else goto SbkQProcessFunc_startDetached_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_startDetached_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QStringList", "PySide.QtCore.QString, PySide.QtCore.QStringList, PySide.QtCore.QString, qint64 = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.startDetached", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QProcess::ProcessState cpp_result = cppSelf->QProcess::state();
    py_result = Shiboken::Converter<QProcess::ProcessState >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_systemEnvironment(PyObject* self)
{
    PyObject* py_result = 0;

    // systemEnvironment()
    QStringList cpp_result = QProcess::systemEnvironment();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_terminate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // terminate()
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    cppSelf->QProcess::terminate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessFunc_waitForBytesWritten(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForBytesWritten(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForBytesWritten();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForBytesWritten(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForBytesWritten(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_waitForBytesWritten_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_waitForBytesWritten_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.waitForBytesWritten", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_waitForFinished(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForFinished(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForFinished();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForFinished(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForFinished(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_waitForFinished_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_waitForFinished_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.waitForFinished", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_waitForReadyRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForReadyRead(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForReadyRead();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForReadyRead(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForReadyRead(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_waitForReadyRead_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_waitForReadyRead_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.waitForReadyRead", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_waitForStarted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // waitForStarted(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForStarted();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForStarted(int)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QProcess::waitForStarted(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_waitForStarted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_waitForStarted_TypeError:
        const char* overloads[] = {"int = 30000", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcess.waitForStarted", overloads);
        return 0;
}

static PyObject* SbkQProcessFunc_workingDirectory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // workingDirectory()const
    QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QProcess::workingDirectory();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessFunc_writeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // writeData(const char*,qint64)
        QProcess* cppSelf = Shiboken::Converter<QProcess* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QProcess::writeData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessFunc_writeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessFunc_writeData_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcess.writeData", overloads);
        return 0;
}

static PyMethodDef SbkQProcess_methods[] = {
    {"atEnd", (PyCFunction)SbkQProcessFunc_atEnd, METH_NOARGS},
    {"bytesAvailable", (PyCFunction)SbkQProcessFunc_bytesAvailable, METH_NOARGS},
    {"bytesToWrite", (PyCFunction)SbkQProcessFunc_bytesToWrite, METH_NOARGS},
    {"canReadLine", (PyCFunction)SbkQProcessFunc_canReadLine, METH_NOARGS},
    {"close", (PyCFunction)SbkQProcessFunc_close, METH_NOARGS},
    {"closeReadChannel", (PyCFunction)SbkQProcessFunc_closeReadChannel, METH_O},
    {"closeWriteChannel", (PyCFunction)SbkQProcessFunc_closeWriteChannel, METH_NOARGS},
    {"environment", (PyCFunction)SbkQProcessFunc_environment, METH_NOARGS},
    {"error", (PyCFunction)SbkQProcessFunc_error, METH_NOARGS},
    {"execute", (PyCFunction)SbkQProcessFunc_execute, METH_VARARGS|METH_STATIC},
    {"exitCode", (PyCFunction)SbkQProcessFunc_exitCode, METH_NOARGS},
    {"exitStatus", (PyCFunction)SbkQProcessFunc_exitStatus, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQProcessFunc_isSequential, METH_NOARGS},
    {"kill", (PyCFunction)SbkQProcessFunc_kill, METH_NOARGS},
    {"processChannelMode", (PyCFunction)SbkQProcessFunc_processChannelMode, METH_NOARGS},
    {"processEnvironment", (PyCFunction)SbkQProcessFunc_processEnvironment, METH_NOARGS},
    {"readAllStandardError", (PyCFunction)SbkQProcessFunc_readAllStandardError, METH_NOARGS},
    {"readAllStandardOutput", (PyCFunction)SbkQProcessFunc_readAllStandardOutput, METH_NOARGS},
    {"readChannel", (PyCFunction)SbkQProcessFunc_readChannel, METH_NOARGS},
    {"readData", (PyCFunction)SbkQProcessFunc_readData, METH_VARARGS},
    {"setEnvironment", (PyCFunction)SbkQProcessFunc_setEnvironment, METH_O},
    {"setProcessChannelMode", (PyCFunction)SbkQProcessFunc_setProcessChannelMode, METH_O},
    {"setProcessEnvironment", (PyCFunction)SbkQProcessFunc_setProcessEnvironment, METH_O},
    {"setProcessState", (PyCFunction)SbkQProcessFunc_setProcessState, METH_O},
    {"setReadChannel", (PyCFunction)SbkQProcessFunc_setReadChannel, METH_O},
    {"setStandardErrorFile", (PyCFunction)SbkQProcessFunc_setStandardErrorFile, METH_VARARGS},
    {"setStandardInputFile", (PyCFunction)SbkQProcessFunc_setStandardInputFile, METH_O},
    {"setStandardOutputFile", (PyCFunction)SbkQProcessFunc_setStandardOutputFile, METH_VARARGS},
    {"setStandardOutputProcess", (PyCFunction)SbkQProcessFunc_setStandardOutputProcess, METH_O},
    {"setWorkingDirectory", (PyCFunction)SbkQProcessFunc_setWorkingDirectory, METH_O},
    {"setupChildProcess", (PyCFunction)SbkQProcessFunc_setupChildProcess, METH_NOARGS},
    {"start", (PyCFunction)SbkQProcessFunc_start, METH_VARARGS},
    {"startDetached", (PyCFunction)SbkQProcessFunc_startDetached, METH_VARARGS|METH_STATIC},
    {"state", (PyCFunction)SbkQProcessFunc_state, METH_NOARGS},
    {"systemEnvironment", (PyCFunction)SbkQProcessFunc_systemEnvironment, METH_NOARGS|METH_STATIC},
    {"terminate", (PyCFunction)SbkQProcessFunc_terminate, METH_NOARGS},
    {"waitForBytesWritten", (PyCFunction)SbkQProcessFunc_waitForBytesWritten, METH_NOARGS|METH_O},
    {"waitForFinished", (PyCFunction)SbkQProcessFunc_waitForFinished, METH_NOARGS|METH_O},
    {"waitForReadyRead", (PyCFunction)SbkQProcessFunc_waitForReadyRead, METH_NOARGS|METH_O},
    {"waitForStarted", (PyCFunction)SbkQProcessFunc_waitForStarted, METH_NOARGS|METH_O},
    {"workingDirectory", (PyCFunction)SbkQProcessFunc_workingDirectory, METH_NOARGS},
    {"writeData", (PyCFunction)SbkQProcessFunc_writeData, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQProcess_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QProcess",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQProcess_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQProcess_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QProcess >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QProcess_ProcessError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QProcess_ProcessError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QProcess_ProcessError_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QProcess_ProcessError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QProcess_ProcessError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QProcess_ProcessError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QProcess_ProcessChannelMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QProcess_ProcessChannelMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QProcess_ProcessChannelMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessChannelMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QProcess_ProcessChannelMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QProcess_ProcessChannelMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QProcess_ProcessChannelMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QProcess_ProcessChannel_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QProcess_ProcessChannel_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QProcess_ProcessChannel_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessChannel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QProcess_ProcessChannel_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QProcess_ProcessChannel_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QProcess_ProcessChannel_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QProcess_ProcessState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QProcess_ProcessState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QProcess_ProcessState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QProcess_ProcessState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QProcess_ProcessState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QProcess_ProcessState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QProcess_ExitStatus_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QProcess_ExitStatus_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QProcess_ExitStatus_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ExitStatus",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QProcess_ExitStatus_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QProcess_ExitStatus_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QProcess_ExitStatus_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QProcess(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPROCESS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQProcess_Type);

    SbkQProcess_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QIODEVICE_IDX];
    // Fill type discovery information
    SbkQProcess_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQProcess_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQProcess_Type));
    PyModule_AddObject(module, "QProcess",
        ((PyObject*)&SbkQProcess_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ProcessError
    SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSERROR_IDX] = &SbkPySide_QtCore_QProcess_ProcessError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QProcess_ProcessError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QProcess_ProcessError_Type);
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
            "ProcessError",((PyObject*)&SbkPySide_QtCore_QProcess_ProcessError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::FailedToStart, "FailedToStart");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "FailedToStart", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "FailedToStart", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::Crashed, "Crashed");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "Crashed", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "Crashed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::Timedout, "Timedout");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "Timedout", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "Timedout", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::ReadError, "ReadError");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "ReadError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "ReadError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::WriteError, "WriteError");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "WriteError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "WriteError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessError_Type,
        (long) QProcess::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessError_Type.tp_dict,
        "UnknownError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QProcess::ProcessError");

    // init enum class: ProcessChannelMode
    SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNELMODE_IDX] = &SbkPySide_QtCore_QProcess_ProcessChannelMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type);
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
            "ProcessChannelMode",((PyObject*)&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type,
        (long) QProcess::SeparateChannels, "SeparateChannels");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "SeparateChannels", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessChannelMode_Type.tp_dict,
        "SeparateChannels", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type,
        (long) QProcess::MergedChannels, "MergedChannels");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "MergedChannels", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessChannelMode_Type.tp_dict,
        "MergedChannels", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessChannelMode_Type,
        (long) QProcess::ForwardedChannels, "ForwardedChannels");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "ForwardedChannels", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessChannelMode_Type.tp_dict,
        "ForwardedChannels", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QProcess::ProcessChannelMode");

    // init enum class: ProcessChannel
    SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSCHANNEL_IDX] = &SbkPySide_QtCore_QProcess_ProcessChannel_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QProcess_ProcessChannel_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QProcess_ProcessChannel_Type);
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
            "ProcessChannel",((PyObject*)&SbkPySide_QtCore_QProcess_ProcessChannel_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessChannel_Type,
        (long) QProcess::StandardOutput, "StandardOutput");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "StandardOutput", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessChannel_Type.tp_dict,
        "StandardOutput", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessChannel_Type,
        (long) QProcess::StandardError, "StandardError");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "StandardError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessChannel_Type.tp_dict,
        "StandardError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QProcess::ProcessChannel");

    // init enum class: ProcessState
    SbkPySide_QtCoreTypes[SBK_QPROCESS_PROCESSSTATE_IDX] = &SbkPySide_QtCore_QProcess_ProcessState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QProcess_ProcessState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QProcess_ProcessState_Type);
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
            "ProcessState",((PyObject*)&SbkPySide_QtCore_QProcess_ProcessState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessState_Type,
        (long) QProcess::NotRunning, "NotRunning");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "NotRunning", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessState_Type.tp_dict,
        "NotRunning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessState_Type,
        (long) QProcess::Starting, "Starting");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "Starting", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessState_Type.tp_dict,
        "Starting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ProcessState_Type,
        (long) QProcess::Running, "Running");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "Running", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ProcessState_Type.tp_dict,
        "Running", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QProcess::ProcessState");

    // init enum class: ExitStatus
    SbkPySide_QtCoreTypes[SBK_QPROCESS_EXITSTATUS_IDX] = &SbkPySide_QtCore_QProcess_ExitStatus_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QProcess_ExitStatus_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QProcess_ExitStatus_Type);
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
            "ExitStatus",((PyObject*)&SbkPySide_QtCore_QProcess_ExitStatus_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ExitStatus_Type,
        (long) QProcess::NormalExit, "NormalExit");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "NormalExit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ExitStatus_Type.tp_dict,
        "NormalExit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QProcess_ExitStatus_Type,
        (long) QProcess::CrashExit, "CrashExit");
    PyDict_SetItemString(SbkQProcess_Type.super.ht_type.tp_dict,
        "CrashExit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QProcess_ExitStatus_Type.tp_dict,
        "CrashExit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QProcess::ExitStatus");

    Shiboken::TypeResolver::createObjectTypeResolver<QProcess >("QProcess*");
    Shiboken::TypeResolver::createObjectTypeResolver<QProcess >(typeid(QProcess).name());
}


} // extern "C"

