/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qfileinfo_wrapper.h"

// Extra includes
#include <QDateTime>
#include <QDir>
#include <qdatetime.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQFileInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFileInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFileInfo", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QFileInfo()
        cptr = new QFileInfo();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QFileInfo(QString)
        cptr = new QFileInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QFile & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QFile* cpp_arg0 = Shiboken::Converter<QFile* >::toCpp(pyargs[0]);
        // QFileInfo(QFile)
        cptr = new QFileInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QFileInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFileInfo > cpp_arg0_auto_ptr;
        QFileInfo* cpp_arg0 = Shiboken::Converter<QFileInfo* >::toCpp(pyargs[0]);
        if (!SbkQFileInfo_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFileInfo >(cpp_arg0);
        // QFileInfo(QFileInfo)
        cptr = new QFileInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QDir & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QDir > cpp_arg0_auto_ptr;
        QDir* cpp_arg0 = Shiboken::Converter<QDir* >::toCpp(pyargs[0]);
        if (!SbkQDir_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QDir >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // QFileInfo(QDir,QString)
        cptr = new QFileInfo(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileInfo_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFileInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFileInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFileInfo_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QDir, PySide.QtCore.QString", "PySide.QtCore.QFile", "PySide.QtCore.QFileInfo", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFileInfo", overloads);
        return -1;
}

static PyObject* SbkQFileInfoFunc_absoluteDir(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // absoluteDir()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QDir cpp_result = cppSelf->QFileInfo::absoluteDir();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_absoluteFilePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // absoluteFilePath()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::absoluteFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_absolutePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // absolutePath()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::absolutePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_baseName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // baseName()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::baseName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_bundleName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bundleName()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::bundleName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_caching(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // caching()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::caching();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_canonicalFilePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canonicalFilePath()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::canonicalFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_canonicalPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canonicalPath()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::canonicalPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_completeBaseName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completeBaseName()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::completeBaseName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_completeSuffix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completeSuffix()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::completeSuffix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_created(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // created()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QFileInfo::created();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_dir(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dir()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QDir cpp_result = cppSelf->QFileInfo::dir();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_exists(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exists()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::exists();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_filePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filePath()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::filePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_group(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // group()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::group();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_groupId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // groupId()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QFileInfo::groupId();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isAbsolute(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAbsolute()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isAbsolute();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isBundle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isBundle()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isBundle();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isDir(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDir()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isDir();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isExecutable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isExecutable()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isExecutable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isFile(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFile()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isFile();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isHidden(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHidden()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isHidden();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isRelative(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRelative()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isRelative();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isRoot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRoot()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isRoot();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isSymLink(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSymLink()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isSymLink();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_lastModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastModified()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QFileInfo::lastModified();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_lastRead(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastRead()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QFileInfo::lastRead();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_makeAbsolute(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // makeAbsolute()
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFileInfo::makeAbsolute();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_owner(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // owner()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::owner();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_ownerId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownerId()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QFileInfo::ownerId();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_permission(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (SbkPySide_QtCore_QFile_Permission_Check(arg)) {
        QFlags<QFile::Permission> cpp_arg0 = Shiboken::Converter<QFlags<QFile::Permission> >::toCpp(arg);
        // permission(QFlags<QFile::Permission>)const
        QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFileInfo::permission(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileInfoFunc_permission_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFileInfoFunc_permission_TypeError:
        const char* overloads[] = {"PySide.QtCore.QFile.Permissions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileInfo.permission", overloads);
        return 0;
}

static PyObject* SbkQFileInfoFunc_permissions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // permissions()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QFlags<QFile::Permission> cpp_result = cppSelf->QFileInfo::permissions();
    py_result = Shiboken::Converter<QFlags<QFile::Permission> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_readLink(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // readLink()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::readLink();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_refresh(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // refresh()
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    cppSelf->QFileInfo::refresh();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFileInfoFunc_setCaching(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCaching(bool)
        QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
        cppSelf->QFileInfo::setCaching(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileInfoFunc_setCaching_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileInfoFunc_setCaching_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileInfo.setCaching", overloads);
        return 0;
}

static PyObject* SbkQFileInfoFunc_setFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setFile", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFile(QString)
        QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
        cppSelf->QFileInfo::setFile(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QFile & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QFile* cpp_arg0 = Shiboken::Converter<QFile* >::toCpp(pyargs[0]);
        // setFile(QFile)
        QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
        cppSelf->QFileInfo::setFile(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QDir & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QDir > cpp_arg0_auto_ptr;
        QDir* cpp_arg0 = Shiboken::Converter<QDir* >::toCpp(pyargs[0]);
        if (!SbkQDir_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QDir >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setFile(QDir,QString)
        QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
        cppSelf->QFileInfo::setFile(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFileInfoFunc_setFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileInfoFunc_setFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir, PySide.QtCore.QString", "PySide.QtCore.QFile", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFileInfo.setFile", overloads);
        return 0;
}

static PyObject* SbkQFileInfoFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFileInfo::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_suffix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // suffix()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::suffix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFileInfoFunc_symLinkTarget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // symLinkTarget()const
    QFileInfo* cppSelf = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFileInfo::symLinkTarget();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFileInfo_methods[] = {
    {"absoluteDir", (PyCFunction)SbkQFileInfoFunc_absoluteDir, METH_NOARGS},
    {"absoluteFilePath", (PyCFunction)SbkQFileInfoFunc_absoluteFilePath, METH_NOARGS},
    {"absolutePath", (PyCFunction)SbkQFileInfoFunc_absolutePath, METH_NOARGS},
    {"baseName", (PyCFunction)SbkQFileInfoFunc_baseName, METH_NOARGS},
    {"bundleName", (PyCFunction)SbkQFileInfoFunc_bundleName, METH_NOARGS},
    {"caching", (PyCFunction)SbkQFileInfoFunc_caching, METH_NOARGS},
    {"canonicalFilePath", (PyCFunction)SbkQFileInfoFunc_canonicalFilePath, METH_NOARGS},
    {"canonicalPath", (PyCFunction)SbkQFileInfoFunc_canonicalPath, METH_NOARGS},
    {"completeBaseName", (PyCFunction)SbkQFileInfoFunc_completeBaseName, METH_NOARGS},
    {"completeSuffix", (PyCFunction)SbkQFileInfoFunc_completeSuffix, METH_NOARGS},
    {"created", (PyCFunction)SbkQFileInfoFunc_created, METH_NOARGS},
    {"dir", (PyCFunction)SbkQFileInfoFunc_dir, METH_NOARGS},
    {"exists", (PyCFunction)SbkQFileInfoFunc_exists, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQFileInfoFunc_fileName, METH_NOARGS},
    {"filePath", (PyCFunction)SbkQFileInfoFunc_filePath, METH_NOARGS},
    {"group", (PyCFunction)SbkQFileInfoFunc_group, METH_NOARGS},
    {"groupId", (PyCFunction)SbkQFileInfoFunc_groupId, METH_NOARGS},
    {"isAbsolute", (PyCFunction)SbkQFileInfoFunc_isAbsolute, METH_NOARGS},
    {"isBundle", (PyCFunction)SbkQFileInfoFunc_isBundle, METH_NOARGS},
    {"isDir", (PyCFunction)SbkQFileInfoFunc_isDir, METH_NOARGS},
    {"isExecutable", (PyCFunction)SbkQFileInfoFunc_isExecutable, METH_NOARGS},
    {"isFile", (PyCFunction)SbkQFileInfoFunc_isFile, METH_NOARGS},
    {"isHidden", (PyCFunction)SbkQFileInfoFunc_isHidden, METH_NOARGS},
    {"isReadable", (PyCFunction)SbkQFileInfoFunc_isReadable, METH_NOARGS},
    {"isRelative", (PyCFunction)SbkQFileInfoFunc_isRelative, METH_NOARGS},
    {"isRoot", (PyCFunction)SbkQFileInfoFunc_isRoot, METH_NOARGS},
    {"isSymLink", (PyCFunction)SbkQFileInfoFunc_isSymLink, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQFileInfoFunc_isWritable, METH_NOARGS},
    {"lastModified", (PyCFunction)SbkQFileInfoFunc_lastModified, METH_NOARGS},
    {"lastRead", (PyCFunction)SbkQFileInfoFunc_lastRead, METH_NOARGS},
    {"makeAbsolute", (PyCFunction)SbkQFileInfoFunc_makeAbsolute, METH_NOARGS},
    {"owner", (PyCFunction)SbkQFileInfoFunc_owner, METH_NOARGS},
    {"ownerId", (PyCFunction)SbkQFileInfoFunc_ownerId, METH_NOARGS},
    {"path", (PyCFunction)SbkQFileInfoFunc_path, METH_NOARGS},
    {"permission", (PyCFunction)SbkQFileInfoFunc_permission, METH_O},
    {"permissions", (PyCFunction)SbkQFileInfoFunc_permissions, METH_NOARGS},
    {"readLink", (PyCFunction)SbkQFileInfoFunc_readLink, METH_NOARGS},
    {"refresh", (PyCFunction)SbkQFileInfoFunc_refresh, METH_NOARGS},
    {"setCaching", (PyCFunction)SbkQFileInfoFunc_setCaching, METH_O},
    {"setFile", (PyCFunction)SbkQFileInfoFunc_setFile, METH_VARARGS},
    {"size", (PyCFunction)SbkQFileInfoFunc_size, METH_NOARGS},
    {"suffix", (PyCFunction)SbkQFileInfoFunc_suffix, METH_NOARGS},
    {"symLinkTarget", (PyCFunction)SbkQFileInfoFunc_symLinkTarget, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQFileInfo_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QFileInfo& cpp_self = *Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QFileInfo & >::isConvertible(other)) {
                // operator!=(const QFileInfo & fileinfo)
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFileInfo  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFileInfo & >::isConvertible(other)) {
                // operator!=(const QFileInfo & fileinfo) const
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFileInfo  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFileInfo >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFileInfo > cpp_other_auto_ptr;
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp(other);
                if (!SbkQFileInfo_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFileInfo >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQFileInfo_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QFileInfo & >::isConvertible(other)) {
                // operator==(const QFileInfo & fileinfo)
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFileInfo  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFileInfo & >::isConvertible(other)) {
                // operator==(const QFileInfo & fileinfo) const
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFileInfo  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFileInfo >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFileInfo > cpp_other_auto_ptr;
                QFileInfo* cpp_other = Shiboken::Converter<QFileInfo* >::toCpp(other);
                if (!SbkQFileInfo_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFileInfo >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQFileInfo_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQFileInfo_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFileInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QFileInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQFileInfo_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFileInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFileInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFileInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QFileInfo(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QFILEINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFileInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFileInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFileInfo_Type));
    PyModule_AddObject(module, "QFileInfo",
        ((PyObject*)&SbkQFileInfo_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QFileInfo >("QFileInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QFileInfo >(typeid(QFileInfo).name());
}


} // extern "C"

