/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qabstractitemmodel_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractItemModelWrapper::QAbstractItemModelWrapper(QObject * parent) : QAbstractItemModel(parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QAbstractItemModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.buddy", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.canFetchMore", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QAbstractItemModelWrapper::columnCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "columnCount"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.columnCount()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.columnCount", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractItemModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QAbstractItemModelWrapper::data(const QModelIndex & index, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.data()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Si)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.data", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractItemModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSiiS)",
        Shiboken::Converter<QMimeData * >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.dropMimeData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractItemModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractItemModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::ItemFlag> QAbstractItemModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.flags", SbkType<QFlags<Qt::ItemFlag> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::ItemFlag>();
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::hasChildren(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasChildren"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::hasChildren(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.hasChildren", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QAbstractItemModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iSi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.headerData", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractItemModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.index()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        column,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.index", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        column,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.insertColumns", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.insertRows", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QAbstractItemModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.itemData", "map", py_result->ob_type->tp_name);
        return QMap<int, QVariant >();
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QAbstractItemModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SiSiS)",
        Shiboken::Converter<QModelIndex & >::toPython(start),
        role,
        Shiboken::Converter<QVariant & >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.match", "list", py_result->ob_type->tp_name);
        return QList<QModelIndex >();
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QAbstractItemModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.mimeData", SbkType<QMimeData * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QMimeData * cpp_result(Shiboken::Converter<QMimeData * >::toCpp(py_result));
    return cpp_result;
}

QStringList QAbstractItemModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.mimeTypes", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QAbstractItemModelWrapper::parent(const QModelIndex & child) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parent"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.parent()' not implemented.");
        return QModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(child)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.parent", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        column,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.removeColumns", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.removeRows", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QAbstractItemModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.rowCount()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.rowCount", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSi)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QVariant & >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.setData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iSSi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant & >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.setHeaderData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.setItemData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iS)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QAbstractItemModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.span", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractItemModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.submit", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QAbstractItemModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModel.supportedDropActions", SbkType<QFlags<Qt::DropAction> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::DropAction>();
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QAbstractItemModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAbstractItemModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractItemModel::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractItemModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractItemModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractItemModelWrapper::~QAbstractItemModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractItemModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractItemModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractItemModel' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractItemModel", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractItemModel(QObject*)
        cptr = new QAbstractItemModelWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractItemModel(QObject*)
        cptr = new QAbstractItemModelWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractItemModel_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractItemModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractItemModel_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractItemModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel", overloads);
        return -1;
}

static PyObject* SbkQAbstractItemModelFunc_beginInsertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginInsertColumns", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // beginInsertColumns(QModelIndex,int,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::beginInsertColumns(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginInsertColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_beginInsertColumns_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginInsertColumns", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginInsertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginInsertRows", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // beginInsertRows(QModelIndex,int,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::beginInsertRows(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginInsertRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_beginInsertRows_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginInsertRows", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginMoveColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginMoveColumns", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        // beginMoveColumns(QModelIndex,int,int,QModelIndex,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::beginMoveColumns(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginMoveColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_beginMoveColumns_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int, PySide.QtCore.QModelIndex, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginMoveColumns", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginMoveRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginMoveRows", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        // beginMoveRows(QModelIndex,int,int,QModelIndex,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::beginMoveRows(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginMoveRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_beginMoveRows_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int, PySide.QtCore.QModelIndex, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginMoveRows", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginRemoveColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginRemoveColumns", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // beginRemoveColumns(QModelIndex,int,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::beginRemoveColumns(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginRemoveColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_beginRemoveColumns_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginRemoveColumns", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginRemoveRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "beginRemoveRows", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // beginRemoveRows(QModelIndex,int,int)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::beginRemoveRows(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_beginRemoveRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_beginRemoveRows_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.beginRemoveRows", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_beginResetModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // beginResetModel()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::beginResetModel();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_buddy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // buddy(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QAbstractItemModel::buddy(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_buddy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_buddy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.buddy", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_canFetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // canFetchMore(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::canFetchMore(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_canFetchMore_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_canFetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.canFetchMore", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_changePersistentIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "changePersistentIndex", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // changePersistentIndex(QModelIndex,QModelIndex)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::changePersistentIndex(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_changePersistentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_changePersistentIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.changePersistentIndex", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_changePersistentIndexList(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "changePersistentIndexList", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QList<QModelIndex >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QList<QModelIndex >  >::isConvertible(pyargs[1])) {
        QList<QModelIndex >  cpp_arg0 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(pyargs[0]);
        QList<QModelIndex >  cpp_arg1 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(pyargs[1]);
        // changePersistentIndexList(QList<QModelIndex>,QList<QModelIndex>)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::changePersistentIndexList(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_changePersistentIndexList_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_changePersistentIndexList_TypeError:
        const char* overloads[] = {"list, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.changePersistentIndexList", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_columnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // columnCount(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.columnCount()' not implemented.");
            return 0;
        }
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->columnCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // columnCount(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.columnCount()' not implemented.");
            return 0;
        }
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->columnCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_columnCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_columnCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.columnCount", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_createIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createIndex", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // createIndex(int,int,int)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QAbstractItemModel::createIndex(cpp_arg0, cpp_arg1, 0);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // createIndex(int,int,int)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QAbstractItemModel::createIndex(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyObject_Check(pyargs[2])) {
            // createIndex(int,int,PyObject*)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            (void)cppSelf; // avoid warnings about unused variables
            // Begin code injection
            
            py_result = Shiboken::Converter<QModelIndex >::toPython(cppSelf->createIndex(cpp_arg0, cpp_arg1, pyargs[3-1]));
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_createIndex_TypeError;
    } else goto SbkQAbstractItemModelFunc_createIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_createIndex_TypeError:
        const char* overloads[] = {"int, int, PyObject", "int, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.createIndex", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // data(QModelIndex,int)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.data()' not implemented.");
                return 0;
            }
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->data(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // data(QModelIndex,int)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.data()' not implemented.");
                return 0;
            }
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->data(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_data_TypeError;
    } else goto SbkQAbstractItemModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.data", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_decodeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "decodeData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2]) && Shiboken::Converter<QDataStream & >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QDataStream* cpp_arg3 = Shiboken::Converter<QDataStream* >::toCpp(pyargs[3]);
        // decodeData(int,int,QModelIndex,QDataStream&)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::decodeData(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_decodeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_decodeData_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex, PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.decodeData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QMimeData * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[0]);
        Qt::DropAction cpp_arg1 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QModelIndex* cpp_arg4 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[4]);
        // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_dropMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction, int, int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.dropMimeData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_encodeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "encodeData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QList<QModelIndex >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QDataStream & >::isConvertible(pyargs[1])) {
        QList<QModelIndex >  cpp_arg0 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDataStream* cpp_arg1 = Shiboken::Converter<QDataStream* >::toCpp(pyargs[1]);
        // encodeData(QList<QModelIndex>,QDataStream&)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::encodeData(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_encodeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_encodeData_TypeError:
        const char* overloads[] = {"list, PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.encodeData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_endInsertColumns(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endInsertColumns()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endInsertColumns();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endInsertRows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endInsertRows()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endInsertRows();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endMoveColumns(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endMoveColumns()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endMoveColumns();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endMoveRows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endMoveRows()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endMoveRows();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endRemoveColumns(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endRemoveColumns()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endRemoveColumns();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endRemoveRows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endRemoveRows()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endRemoveRows();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_endResetModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endResetModel()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::endResetModel();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_fetchMore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // fetchMore(QModelIndex)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::fetchMore(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_fetchMore_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_fetchMore_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.fetchMore", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_flags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // flags(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QFlags<Qt::ItemFlag> cpp_result = cppSelf->QAbstractItemModel::flags(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_flags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_flags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.flags", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_hasChildren(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // hasChildren(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::hasChildren();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // hasChildren(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::hasChildren(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_hasChildren_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_hasChildren_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.hasChildren", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_hasIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "hasIndex", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // hasIndex(int,int,QModelIndex)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::hasIndex(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // hasIndex(int,int,QModelIndex)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::hasIndex(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_hasIndex_TypeError;
    } else goto SbkQAbstractItemModelFunc_hasIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_hasIndex_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.hasIndex", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_headerData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // headerData(int,Qt::Orientation,int)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QAbstractItemModel::headerData(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // headerData(int,Qt::Orientation,int)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QAbstractItemModel::headerData(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_headerData_TypeError;
    } else goto SbkQAbstractItemModelFunc_headerData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_headerData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.headerData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_index(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "index", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // index(int,int,QModelIndex)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.index()' not implemented.");
                return 0;
            }
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->index(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // index(int,int,QModelIndex)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.index()' not implemented.");
                return 0;
            }
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->index(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_index_TypeError;
    } else goto SbkQAbstractItemModelFunc_index_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_index_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.index", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_insertColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumn", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertColumn(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertColumn(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // insertColumn(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertColumn(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_insertColumn_TypeError;
    } else goto SbkQAbstractItemModelFunc_insertColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_insertColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.insertColumn", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertColumns(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertColumns(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_insertColumns_TypeError;
    } else goto SbkQAbstractItemModelFunc_insertColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.insertColumns", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_insertRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertRow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertRow(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertRow(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // insertRow(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertRow(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_insertRow_TypeError;
    } else goto SbkQAbstractItemModelFunc_insertRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_insertRow_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.insertRow", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertRows(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertRows(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::insertRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_insertRows_TypeError;
    } else goto SbkQAbstractItemModelFunc_insertRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_insertRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.insertRows", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_itemData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemData(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QMap<int, QVariant > cpp_result = cppSelf->QAbstractItemModel::itemData(*cpp_arg0);
        py_result = Shiboken::Converter<QMap<int, QVariant > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_itemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_itemData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.itemData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_match(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "match", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            QList<QModelIndex > cpp_result = cppSelf->QAbstractItemModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
                QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
                QList<QModelIndex > cpp_result = cppSelf->QAbstractItemModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[4])) {
                QFlags<Qt::MatchFlag> cpp_arg4 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[4]);
                // match(QModelIndex,int,QVariant,int,QFlags<Qt::MatchFlag>)const
                QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
                QList<QModelIndex > cpp_result = cppSelf->QAbstractItemModel::match(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQAbstractItemModelFunc_match_TypeError;
        } else goto SbkQAbstractItemModelFunc_match_TypeError;
    } else goto SbkQAbstractItemModelFunc_match_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_match_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int, PySide.QtCore.QVariant, int = 1, PySide.QtCore.Qt.MatchFlags = Qt.MatchFlags(Qt.MatchStartsWith|Qt.MatchWrap)", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.match", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_mimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QList<QModelIndex >  >::isConvertible(arg)) {
        QList<QModelIndex >  cpp_arg0 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(arg);
        // mimeData(QList<QModelIndex>)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QMimeData * cpp_result = cppSelf->QAbstractItemModel::mimeData(cpp_arg0);
        py_result = Shiboken::Converter<QMimeData * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQAbstractItemModelFunc_mimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_mimeData_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.mimeData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QAbstractItemModel::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractItemModelFunc_parent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // parent()const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QObject * cpp_result = cppSelf->QAbstractItemModel::parent();
        py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(py_result, self);
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // parent(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.parent()' not implemented.");
            return 0;
        }
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->parent(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_parent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_parent_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.parent", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_persistentIndexList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // persistentIndexList()const
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QAbstractItemModel::persistentIndexList();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractItemModelFunc_removeColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumn", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // removeColumn(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeColumn(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // removeColumn(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeColumn(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_removeColumn_TypeError;
    } else goto SbkQAbstractItemModelFunc_removeColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_removeColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.removeColumn", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeColumns(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeColumns(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_removeColumns_TypeError;
    } else goto SbkQAbstractItemModelFunc_removeColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.removeColumns", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_removeRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeRow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // removeRow(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeRow(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // removeRow(int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeRow(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_removeRow_TypeError;
    } else goto SbkQAbstractItemModelFunc_removeRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_removeRow_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.removeRow", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeRows(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeRows(int,int,QModelIndex)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::removeRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_removeRows_TypeError;
    } else goto SbkQAbstractItemModelFunc_removeRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.removeRows", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_revert(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // revert()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    cppSelf->QAbstractItemModel::revert();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractItemModelFunc_roleNames(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // roleNames()const
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    const QHash<int, QByteArray > & cpp_result = cppSelf->QAbstractItemModel::roleNames();
    py_result = Shiboken::Converter<QHash<int, QByteArray >  >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractItemModelFunc_rowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // rowCount(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.rowCount()' not implemented.");
            return 0;
        }
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->rowCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowCount(QModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractItemModel.rowCount()' not implemented.");
            return 0;
        }
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->rowCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_rowCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_rowCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.rowCount", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setData(QModelIndex,QVariant,int)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::setData(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setData(QModelIndex,QVariant,int)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::setData(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_setData_TypeError;
    } else goto SbkQAbstractItemModelFunc_setData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.setData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_setHeaderData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHeaderData", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QAbstractItemModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_setHeaderData_TypeError;
    } else goto SbkQAbstractItemModelFunc_setHeaderData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_setHeaderData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.setHeaderData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_setItemData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QVariant >  >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        QMap<int, QVariant >  cpp_arg1 = Shiboken::Converter<QMap<int, QVariant >  >::toCpp(pyargs[1]);
        // setItemData(QModelIndex,QMap<int,QVariant>)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractItemModel::setItemData(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_setItemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_setItemData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.setItemData", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_setRoleNames(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHash<int, QByteArray >  >::isConvertible(arg)) {
        QHash<int, QByteArray >  cpp_arg0 = Shiboken::Converter<QHash<int, QByteArray >  >::toCpp(arg);
        // setRoleNames(QHash<int,QByteArray>)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::setRoleNames(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_setRoleNames_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_setRoleNames_TypeError:
        const char* overloads[] = {"dict", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.setRoleNames", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_setSupportedDragActions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // setSupportedDragActions(QFlags<Qt::DropAction>)
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractItemModel::setSupportedDragActions(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_setSupportedDragActions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_setSupportedDragActions_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.setSupportedDragActions", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_sibling(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sibling", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // sibling(int,int,QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QAbstractItemModel::sibling(cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_sibling_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_sibling_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.sibling", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_sort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sort(int,Qt::SortOrder)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            cppSelf->QAbstractItemModel::sort(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sort(int,Qt::SortOrder)
            QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
            cppSelf->QAbstractItemModel::sort(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractItemModelFunc_sort_TypeError;
    } else goto SbkQAbstractItemModelFunc_sort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractItemModelFunc_sort_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractItemModel.sort", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_span(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // span(QModelIndex)const
        QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QAbstractItemModel::span(*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractItemModelFunc_span_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractItemModelFunc_span_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractItemModel.span", overloads);
        return 0;
}

static PyObject* SbkQAbstractItemModelFunc_submit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // submit()
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractItemModel::submit();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractItemModelFunc_supportedDragActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDragActions()const
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QAbstractItemModel::supportedDragActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractItemModelFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QAbstractItemModel* cppSelf = Shiboken::Converter<QAbstractItemModel* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QAbstractItemModel::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAbstractItemModel_methods[] = {
    {"beginInsertColumns", (PyCFunction)SbkQAbstractItemModelFunc_beginInsertColumns, METH_VARARGS},
    {"beginInsertRows", (PyCFunction)SbkQAbstractItemModelFunc_beginInsertRows, METH_VARARGS},
    {"beginMoveColumns", (PyCFunction)SbkQAbstractItemModelFunc_beginMoveColumns, METH_VARARGS},
    {"beginMoveRows", (PyCFunction)SbkQAbstractItemModelFunc_beginMoveRows, METH_VARARGS},
    {"beginRemoveColumns", (PyCFunction)SbkQAbstractItemModelFunc_beginRemoveColumns, METH_VARARGS},
    {"beginRemoveRows", (PyCFunction)SbkQAbstractItemModelFunc_beginRemoveRows, METH_VARARGS},
    {"beginResetModel", (PyCFunction)SbkQAbstractItemModelFunc_beginResetModel, METH_NOARGS},
    {"buddy", (PyCFunction)SbkQAbstractItemModelFunc_buddy, METH_O},
    {"canFetchMore", (PyCFunction)SbkQAbstractItemModelFunc_canFetchMore, METH_O},
    {"changePersistentIndex", (PyCFunction)SbkQAbstractItemModelFunc_changePersistentIndex, METH_VARARGS},
    {"changePersistentIndexList", (PyCFunction)SbkQAbstractItemModelFunc_changePersistentIndexList, METH_VARARGS},
    {"columnCount", (PyCFunction)SbkQAbstractItemModelFunc_columnCount, METH_NOARGS|METH_O},
    {"createIndex", (PyCFunction)SbkQAbstractItemModelFunc_createIndex, METH_VARARGS},
    {"data", (PyCFunction)SbkQAbstractItemModelFunc_data, METH_VARARGS},
    {"decodeData", (PyCFunction)SbkQAbstractItemModelFunc_decodeData, METH_VARARGS},
    {"dropMimeData", (PyCFunction)SbkQAbstractItemModelFunc_dropMimeData, METH_VARARGS},
    {"encodeData", (PyCFunction)SbkQAbstractItemModelFunc_encodeData, METH_VARARGS},
    {"endInsertColumns", (PyCFunction)SbkQAbstractItemModelFunc_endInsertColumns, METH_NOARGS},
    {"endInsertRows", (PyCFunction)SbkQAbstractItemModelFunc_endInsertRows, METH_NOARGS},
    {"endMoveColumns", (PyCFunction)SbkQAbstractItemModelFunc_endMoveColumns, METH_NOARGS},
    {"endMoveRows", (PyCFunction)SbkQAbstractItemModelFunc_endMoveRows, METH_NOARGS},
    {"endRemoveColumns", (PyCFunction)SbkQAbstractItemModelFunc_endRemoveColumns, METH_NOARGS},
    {"endRemoveRows", (PyCFunction)SbkQAbstractItemModelFunc_endRemoveRows, METH_NOARGS},
    {"endResetModel", (PyCFunction)SbkQAbstractItemModelFunc_endResetModel, METH_NOARGS},
    {"fetchMore", (PyCFunction)SbkQAbstractItemModelFunc_fetchMore, METH_O},
    {"flags", (PyCFunction)SbkQAbstractItemModelFunc_flags, METH_O},
    {"hasChildren", (PyCFunction)SbkQAbstractItemModelFunc_hasChildren, METH_NOARGS|METH_O},
    {"hasIndex", (PyCFunction)SbkQAbstractItemModelFunc_hasIndex, METH_VARARGS},
    {"headerData", (PyCFunction)SbkQAbstractItemModelFunc_headerData, METH_VARARGS},
    {"index", (PyCFunction)SbkQAbstractItemModelFunc_index, METH_VARARGS},
    {"insertColumn", (PyCFunction)SbkQAbstractItemModelFunc_insertColumn, METH_VARARGS},
    {"insertColumns", (PyCFunction)SbkQAbstractItemModelFunc_insertColumns, METH_VARARGS},
    {"insertRow", (PyCFunction)SbkQAbstractItemModelFunc_insertRow, METH_VARARGS},
    {"insertRows", (PyCFunction)SbkQAbstractItemModelFunc_insertRows, METH_VARARGS},
    {"itemData", (PyCFunction)SbkQAbstractItemModelFunc_itemData, METH_O},
    {"match", (PyCFunction)SbkQAbstractItemModelFunc_match, METH_VARARGS},
    {"mimeData", (PyCFunction)SbkQAbstractItemModelFunc_mimeData, METH_O},
    {"mimeTypes", (PyCFunction)SbkQAbstractItemModelFunc_mimeTypes, METH_NOARGS},
    {"parent", (PyCFunction)SbkQAbstractItemModelFunc_parent, METH_NOARGS|METH_O},
    {"persistentIndexList", (PyCFunction)SbkQAbstractItemModelFunc_persistentIndexList, METH_NOARGS},
    {"removeColumn", (PyCFunction)SbkQAbstractItemModelFunc_removeColumn, METH_VARARGS},
    {"removeColumns", (PyCFunction)SbkQAbstractItemModelFunc_removeColumns, METH_VARARGS},
    {"removeRow", (PyCFunction)SbkQAbstractItemModelFunc_removeRow, METH_VARARGS},
    {"removeRows", (PyCFunction)SbkQAbstractItemModelFunc_removeRows, METH_VARARGS},
    {"reset", (PyCFunction)SbkQAbstractItemModelFunc_reset, METH_NOARGS},
    {"revert", (PyCFunction)SbkQAbstractItemModelFunc_revert, METH_NOARGS},
    {"roleNames", (PyCFunction)SbkQAbstractItemModelFunc_roleNames, METH_NOARGS},
    {"rowCount", (PyCFunction)SbkQAbstractItemModelFunc_rowCount, METH_NOARGS|METH_O},
    {"setData", (PyCFunction)SbkQAbstractItemModelFunc_setData, METH_VARARGS},
    {"setHeaderData", (PyCFunction)SbkQAbstractItemModelFunc_setHeaderData, METH_VARARGS},
    {"setItemData", (PyCFunction)SbkQAbstractItemModelFunc_setItemData, METH_VARARGS},
    {"setRoleNames", (PyCFunction)SbkQAbstractItemModelFunc_setRoleNames, METH_O},
    {"setSupportedDragActions", (PyCFunction)SbkQAbstractItemModelFunc_setSupportedDragActions, METH_O},
    {"sibling", (PyCFunction)SbkQAbstractItemModelFunc_sibling, METH_VARARGS},
    {"sort", (PyCFunction)SbkQAbstractItemModelFunc_sort, METH_VARARGS},
    {"span", (PyCFunction)SbkQAbstractItemModelFunc_span, METH_O},
    {"submit", (PyCFunction)SbkQAbstractItemModelFunc_submit, METH_NOARGS},
    {"supportedDragActions", (PyCFunction)SbkQAbstractItemModelFunc_supportedDragActions, METH_NOARGS},
    {"supportedDropActions", (PyCFunction)SbkQAbstractItemModelFunc_supportedDropActions, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractItemModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QAbstractItemModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractItemModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractItemModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractItemModel >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractItemModel(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractItemModel_Type);

    SbkQAbstractItemModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractItemModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractItemModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractItemModel_Type));
    PyModule_AddObject(module, "QAbstractItemModel",
        ((PyObject*)&SbkQAbstractItemModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemModel >("QAbstractItemModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractItemModel >(typeid(QAbstractItemModel).name());
}


} // extern "C"

