/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_phonon_python.h"

#include "phonon_volumefadereffect_wrapper.h"

// Extra includes
#include <QList>
#include <effectparameter.h>
#include <objectdescription.h>
#include <path.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

VolumeFaderEffectWrapper::VolumeFaderEffectWrapper(QObject * parent) : Phonon::VolumeFaderEffect(parent), m_metaObject(0) {
    // ... middle
}

void VolumeFaderEffectWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VolumeFaderEffectWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VolumeFaderEffectWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void VolumeFaderEffectWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool VolumeFaderEffectWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VolumeFaderEffect.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool VolumeFaderEffectWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "VolumeFaderEffect.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void VolumeFaderEffectWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* VolumeFaderEffectWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &Phonon::VolumeFaderEffect::staticMetaObject);
}
    return m_metaObject;
}

int VolumeFaderEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = Phonon::VolumeFaderEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

VolumeFaderEffectWrapper::~VolumeFaderEffectWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkPhonon_VolumeFaderEffect_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    VolumeFaderEffectWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "VolumeFaderEffect", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // VolumeFaderEffect(QObject*)
        cptr = new VolumeFaderEffectWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // VolumeFaderEffect(QObject*)
        cptr = new VolumeFaderEffectWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkPhonon_VolumeFaderEffect_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::VolumeFaderEffect >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_VolumeFaderEffect_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_VolumeFaderEffect_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.VolumeFaderEffect", overloads);
        return -1;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_fadeCurve(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fadeCurve()const
    Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
    Phonon::VolumeFaderEffect::FadeCurve cpp_result = cppSelf->Phonon::VolumeFaderEffect::fadeCurve();
    py_result = Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_fadeIn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // fadeIn(int)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::fadeIn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_fadeIn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_fadeIn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderEffect.fadeIn", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_fadeOut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // fadeOut(int)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::fadeOut(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_fadeOut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_fadeOut_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderEffect.fadeOut", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_fadeTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fadeTo", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // fadeTo(float,int)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::fadeTo(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_fadeTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_fadeTo_TypeError:
        const char* overloads[] = {"float, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.VolumeFaderEffect.fadeTo", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_setFadeCurve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::isConvertible(arg)) {
        Phonon::VolumeFaderEffect::FadeCurve cpp_arg0 = Shiboken::Converter<Phonon::VolumeFaderEffect::FadeCurve >::toCpp(arg);
        // setFadeCurve(Phonon::VolumeFaderEffect::FadeCurve)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::setFadeCurve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_setFadeCurve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_setFadeCurve_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::VolumeFaderEffect.FadeCurve", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderEffect.setFadeCurve", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_setVolume(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        float cpp_arg0 = Shiboken::Converter<float >::toCpp(arg);
        // setVolume(float)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::setVolume(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_setVolume_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_setVolume_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderEffect.setVolume", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_setVolumeDecibel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setVolumeDecibel(double)
        Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
        cppSelf->Phonon::VolumeFaderEffect::setVolumeDecibel(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_VolumeFaderEffectFunc_setVolumeDecibel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_VolumeFaderEffectFunc_setVolumeDecibel_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.VolumeFaderEffect.setVolumeDecibel", overloads);
        return 0;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_volume(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // volume()const
    Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
    float cpp_result = cppSelf->Phonon::VolumeFaderEffect::volume();
    py_result = Shiboken::Converter<float >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_VolumeFaderEffectFunc_volumeDecibel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // volumeDecibel()const
    Phonon::VolumeFaderEffect* cppSelf = Shiboken::Converter<Phonon::VolumeFaderEffect* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->Phonon::VolumeFaderEffect::volumeDecibel();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_VolumeFaderEffect_methods[] = {
    {"fadeCurve", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_fadeCurve, METH_NOARGS},
    {"fadeIn", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_fadeIn, METH_O},
    {"fadeOut", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_fadeOut, METH_O},
    {"fadeTo", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_fadeTo, METH_VARARGS},
    {"setFadeCurve", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_setFadeCurve, METH_O},
    {"setVolume", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_setVolume, METH_O},
    {"setVolumeDecibel", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_setVolumeDecibel, METH_O},
    {"volume", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_volume, METH_NOARGS},
    {"volumeDecibel", (PyCFunction)SbkPhonon_VolumeFaderEffectFunc_volumeDecibel, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkPhonon_VolumeFaderEffectSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    Phonon::VolumeFaderEffect* me = reinterpret_cast<Phonon::VolumeFaderEffect*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_EFFECT_IDX]))
        return static_cast<Phonon::Effect*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX]))
        return static_cast<Phonon::MediaNode*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_VolumeFaderEffect_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.VolumeFaderEffect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_VolumeFaderEffect_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_VolumeFaderEffect_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkPhonon_VolumeFaderEffectSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::VolumeFaderEffect >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FadeCurve",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Phonon_VolumeFaderEffect(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_VolumeFaderEffect_Type);

    SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_base = SbkPySide_phononTypes[SBK_PHONON_EFFECT_IDX];
    SbkPhonon_VolumeFaderEffect_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_EFFECT_IDX])->mi_init;

    // Fill type discovery information
    SbkPhonon_VolumeFaderEffect_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_VolumeFaderEffect_Type) < 0)
        return;

    PyDict_SetItemString(module,"VolumeFaderEffect", (PyObject*)&SbkPhonon_VolumeFaderEffect_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: FadeCurve
    SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_FADECURVE_IDX] = &SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type);
    PyDict_SetItemString(SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_dict,
            "FadeCurve",((PyObject*)&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type,
        (long) Phonon::VolumeFaderEffect::Fade3Decibel, "Fade3Decibel");
    PyDict_SetItemString(SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_dict,
        "Fade3Decibel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type.tp_dict,
        "Fade3Decibel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type,
        (long) Phonon::VolumeFaderEffect::Fade6Decibel, "Fade6Decibel");
    PyDict_SetItemString(SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_dict,
        "Fade6Decibel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type.tp_dict,
        "Fade6Decibel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type,
        (long) Phonon::VolumeFaderEffect::Fade9Decibel, "Fade9Decibel");
    PyDict_SetItemString(SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_dict,
        "Fade9Decibel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type.tp_dict,
        "Fade9Decibel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type,
        (long) Phonon::VolumeFaderEffect::Fade12Decibel, "Fade12Decibel");
    PyDict_SetItemString(SbkPhonon_VolumeFaderEffect_Type.super.ht_type.tp_dict,
        "Fade12Decibel", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Type.tp_dict,
        "Fade12Decibel", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::VolumeFaderEffect::FadeCurve");

    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VolumeFaderEffect >("Phonon::VolumeFaderEffect*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::VolumeFaderEffect >(typeid(Phonon::VolumeFaderEffect).name());
}


} // extern "C"

