/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlquery_wrapper.h"

// Extra includes
#include <qabstractmessagehandler.h>
#include <qabstracturiresolver.h>
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qurl.h>
#include <qxmlname.h>
#include <qxmlnamepool.h>
#include <qxmlquery.h>
#include <qxmlresultitems.h>

using namespace Shiboken;

static int
SbkQXmlQuery_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlQuery* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QXmlQuery", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QXmlQuery()
        cptr = new QXmlQuery();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlNamePool & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(pyargs[0]);
        // QXmlQuery(QXmlNamePool)
        cptr = new QXmlQuery(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QXmlQuery::QueryLanguage >::isConvertible(pyargs[0])) {
        QXmlQuery::QueryLanguage cpp_arg0 = Shiboken::Converter<QXmlQuery::QueryLanguage >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
            cptr = new QXmlQuery(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QXmlNamePool & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QXmlNamePool* cpp_arg1 = Shiboken::Converter<QXmlNamePool* >::toCpp(pyargs[1]);
            // QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
            cptr = new QXmlQuery(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQuery_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QXmlQuery & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QXmlQuery > cpp_arg0_auto_ptr;
        QXmlQuery* cpp_arg0 = Shiboken::Converter<QXmlQuery* >::toCpp(pyargs[0]);
        if (!SbkQXmlQuery_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QXmlQuery >(cpp_arg0);
        // QXmlQuery(QXmlQuery)
        cptr = new QXmlQuery(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQuery_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlQuery >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlQuery_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlQuery_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXmlPatterns.QXmlQuery.QueryLanguage, PySide.QtXmlPatterns.QXmlNamePool = QXmlNamePool()", "PySide.QtXmlPatterns.QXmlNamePool", "PySide.QtXmlPatterns.QXmlQuery", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlQuery", overloads);
        return -1;
}

static PyObject* SbkQXmlQueryFunc_bindVariable(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "bindVariable", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QXmlQuery & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QXmlQuery > cpp_arg1_auto_ptr;
            QXmlQuery* cpp_arg1 = Shiboken::Converter<QXmlQuery* >::toCpp(pyargs[1]);
            if (!SbkQXmlQuery_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QXmlQuery >(cpp_arg1);
            // bindVariable(QXmlName,QXmlQuery)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QXmlItem & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QXmlItem > cpp_arg1_auto_ptr;
            QXmlItem* cpp_arg1 = Shiboken::Converter<QXmlItem* >::toCpp(pyargs[1]);
            if (!SbkQXmlItem_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QXmlItem >(cpp_arg1);
            // bindVariable(QXmlName,QXmlItem)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            // bindVariable(QXmlName,QIODevice*)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQueryFunc_bindVariable_TypeError;
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 2 && Shiboken::Converter<QXmlQuery & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QXmlQuery > cpp_arg1_auto_ptr;
            QXmlQuery* cpp_arg1 = Shiboken::Converter<QXmlQuery* >::toCpp(pyargs[1]);
            if (!SbkQXmlQuery_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QXmlQuery >(cpp_arg1);
            // bindVariable(QString,QXmlQuery)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QXmlItem & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QXmlItem > cpp_arg1_auto_ptr;
            QXmlItem* cpp_arg1 = Shiboken::Converter<QXmlItem* >::toCpp(pyargs[1]);
            if (!SbkQXmlItem_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QXmlItem >(cpp_arg1);
            // bindVariable(QString,QXmlItem)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            // bindVariable(QString,QIODevice*)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::bindVariable(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQueryFunc_bindVariable_TypeError;
    } else goto SbkQXmlQueryFunc_bindVariable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlQueryFunc_bindVariable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QIODevice", "PySide.QtCore.QString, PySide.QtXmlPatterns.QXmlItem", "PySide.QtCore.QString, PySide.QtXmlPatterns.QXmlQuery", "PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QIODevice", "PySide.QtXmlPatterns.QXmlName, PySide.QtXmlPatterns.QXmlItem", "PySide.QtXmlPatterns.QXmlName, PySide.QtXmlPatterns.QXmlQuery", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlQuery.bindVariable", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_evaluateTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlResultItems * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlResultItems* cpp_arg0 = Shiboken::Converter<QXmlResultItems* >::toCpp(arg);
        // evaluateTo(QXmlResultItems*)const
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::evaluateTo(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (Shiboken::Converter<QStringList * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // evaluateTo(QStringList*)const
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::evaluateTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // evaluateTo(QString*)const
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::evaluateTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // evaluateTo(QIODevice*)const
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::evaluateTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QAbstractXmlReceiver * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractXmlReceiver* cpp_arg0 = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp(arg);
        // evaluateTo(QAbstractXmlReceiver*)const
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::evaluateTo(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQueryFunc_evaluateTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlQueryFunc_evaluateTo_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractXmlReceiver", "PySide.QtCore.QIODevice", "PySide.QtCore.QString", "PySide.QtCore.QStringList", "PySide.QtXmlPatterns.QXmlResultItems", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlQuery.evaluateTo", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_initialTemplateName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // initialTemplateName()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    QXmlName cpp_result = cppSelf->QXmlQuery::initialTemplateName();
    py_result = Shiboken::Converter<QXmlName >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlQueryFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlQuery::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlQueryFunc_messageHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // messageHandler()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    QAbstractMessageHandler * cpp_result = cppSelf->QXmlQuery::messageHandler();
    py_result = Shiboken::Converter<QAbstractMessageHandler * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlQueryFunc_namePool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namePool()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    QXmlNamePool cpp_result = cppSelf->QXmlQuery::namePool();
    py_result = Shiboken::Converter<QXmlNamePool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlQueryFunc_queryLanguage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // queryLanguage()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    QXmlQuery::QueryLanguage cpp_result = cppSelf->QXmlQuery::queryLanguage();
    py_result = Shiboken::Converter<QXmlQuery::QueryLanguage >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlQueryFunc_setFocus(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlItem & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QXmlItem > cpp_arg0_auto_ptr;
        QXmlItem* cpp_arg0 = Shiboken::Converter<QXmlItem* >::toCpp(arg);
        if (!SbkQXmlItem_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QXmlItem >(cpp_arg0);
        // setFocus(QXmlItem)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::setFocus(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFocus(QString)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::setFocus(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QUrl & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
        if (!SbkQUrl_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // setFocus(QUrl)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::setFocus(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setFocus(QIODevice*)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlQuery::setFocus(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQueryFunc_setFocus_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlQueryFunc_setFocus_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", "PySide.QtCore.QString", "PySide.QtCore.QUrl", "PySide.QtXmlPatterns.QXmlItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlQuery.setFocus", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_setInitialTemplateName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // setInitialTemplateName(QXmlName)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::setInitialTemplateName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setInitialTemplateName(QString)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::setInitialTemplateName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQueryFunc_setInitialTemplateName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlQueryFunc_setInitialTemplateName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlQuery.setInitialTemplateName", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_setMessageHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractMessageHandler * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractMessageHandler* cpp_arg0 = Shiboken::Converter<QAbstractMessageHandler* >::toCpp(arg);
        // setMessageHandler(QAbstractMessageHandler*)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::setMessageHandler(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQueryFunc_setMessageHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlQueryFunc_setMessageHandler_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractMessageHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlQuery.setMessageHandler", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_setQuery(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setQuery", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setQuery(QString,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // setQuery(QString,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQueryFunc_setQuery_TypeError;
    } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        if (numArgs == 1) {
            // setQuery(QUrl,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // setQuery(QUrl,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQueryFunc_setQuery_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setQuery(QIODevice*,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // setQuery(QIODevice*,QUrl)
            QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
            cppSelf->QXmlQuery::setQuery(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlQueryFunc_setQuery_TypeError;
    } else goto SbkQXmlQueryFunc_setQuery_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlQueryFunc_setQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QString, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QUrl, PySide.QtCore.QUrl = QUrl()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlQuery.setQuery", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_setUriResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractUriResolver * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractUriResolver* cpp_arg0 = Shiboken::Converter<QAbstractUriResolver* >::toCpp(arg);
        // setUriResolver(const QAbstractUriResolver*)
        QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
        cppSelf->QXmlQuery::setUriResolver(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlQueryFunc_setUriResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlQueryFunc_setUriResolver_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractUriResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlQuery.setUriResolver", overloads);
        return 0;
}

static PyObject* SbkQXmlQueryFunc_uriResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uriResolver()const
    QXmlQuery* cppSelf = Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)self);
    const QAbstractUriResolver * cpp_result = cppSelf->QXmlQuery::uriResolver();
    py_result = Shiboken::Converter<QAbstractUriResolver * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQXmlQuery_methods[] = {
    {"bindVariable", (PyCFunction)SbkQXmlQueryFunc_bindVariable, METH_VARARGS},
    {"evaluateTo", (PyCFunction)SbkQXmlQueryFunc_evaluateTo, METH_O},
    {"initialTemplateName", (PyCFunction)SbkQXmlQueryFunc_initialTemplateName, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQXmlQueryFunc_isValid, METH_NOARGS},
    {"messageHandler", (PyCFunction)SbkQXmlQueryFunc_messageHandler, METH_NOARGS},
    {"namePool", (PyCFunction)SbkQXmlQueryFunc_namePool, METH_NOARGS},
    {"queryLanguage", (PyCFunction)SbkQXmlQueryFunc_queryLanguage, METH_NOARGS},
    {"setFocus", (PyCFunction)SbkQXmlQueryFunc_setFocus, METH_O},
    {"setInitialTemplateName", (PyCFunction)SbkQXmlQueryFunc_setInitialTemplateName, METH_O},
    {"setMessageHandler", (PyCFunction)SbkQXmlQueryFunc_setMessageHandler, METH_O},
    {"setQuery", (PyCFunction)SbkQXmlQueryFunc_setQuery, METH_VARARGS},
    {"setUriResolver", (PyCFunction)SbkQXmlQueryFunc_setUriResolver, METH_O},
    {"uriResolver", (PyCFunction)SbkQXmlQueryFunc_uriResolver, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlQuery_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlQuery",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlQuery_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlQuery_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlQuery >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QueryLanguage",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QXmlQuery(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlQuery_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlQuery_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlQuery_Type));
    PyModule_AddObject(module, "QXmlQuery",
        ((PyObject*)&SbkQXmlQuery_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: QueryLanguage
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX] = &SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type);
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
            "QueryLanguage",((PyObject*)&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type,
        (long) QXmlQuery::XQuery10, "XQuery10");
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
        "XQuery10", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type.tp_dict,
        "XQuery10", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type,
        (long) QXmlQuery::XSLT20, "XSLT20");
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
        "XSLT20", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type.tp_dict,
        "XSLT20", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type,
        (long) QXmlQuery::XmlSchema11IdentityConstraintSelector, "XmlSchema11IdentityConstraintSelector");
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
        "XmlSchema11IdentityConstraintSelector", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type.tp_dict,
        "XmlSchema11IdentityConstraintSelector", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type,
        (long) QXmlQuery::XmlSchema11IdentityConstraintField, "XmlSchema11IdentityConstraintField");
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
        "XmlSchema11IdentityConstraintField", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type.tp_dict,
        "XmlSchema11IdentityConstraintField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type,
        (long) QXmlQuery::XPath20, "XPath20");
    PyDict_SetItemString(SbkQXmlQuery_Type.super.ht_type.tp_dict,
        "XPath20", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Type.tp_dict,
        "XPath20", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlQuery::QueryLanguage");

    Shiboken::TypeResolver::createValueTypeResolver<QXmlQuery >("QXmlQuery");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlQuery >(typeid(QXmlQuery).name());
}


} // extern "C"

