/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomimplementation_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQDomImplementation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomImplementation* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomImplementation", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomImplementation()
        cptr = new QDomImplementation();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomImplementation & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomImplementation* cpp_arg0 = Shiboken::Converter<QDomImplementation* >::toCpp(pyargs[0]);
        // QDomImplementation(QDomImplementation)
        cptr = new QDomImplementation(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomImplementation_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomImplementation >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomImplementation_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomImplementation_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomImplementation", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomImplementation", overloads);
        return -1;
}

static PyObject* SbkQDomImplementationFunc_createDocument(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createDocument", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QDomDocumentType & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QDomDocumentType* cpp_arg2 = Shiboken::Converter<QDomDocumentType* >::toCpp(pyargs[2]);
        // createDocument(QString,QString,QDomDocumentType)
        QDomImplementation* cppSelf = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)self);
        QDomDocument cpp_result = cppSelf->QDomImplementation::createDocument(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QDomDocument >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomImplementationFunc_createDocument_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomImplementationFunc_createDocument_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtXml.QDomDocumentType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomImplementation.createDocument", overloads);
        return 0;
}

static PyObject* SbkQDomImplementationFunc_createDocumentType(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createDocumentType", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // createDocumentType(QString,QString,QString)
        QDomImplementation* cppSelf = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)self);
        QDomDocumentType cpp_result = cppSelf->QDomImplementation::createDocumentType(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QDomDocumentType >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomImplementationFunc_createDocumentType_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomImplementationFunc_createDocumentType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomImplementation.createDocumentType", overloads);
        return 0;
}

static PyObject* SbkQDomImplementationFunc_hasFeature(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hasFeature", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // hasFeature(QString,QString)const
        QDomImplementation* cppSelf = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDomImplementation::hasFeature(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomImplementationFunc_hasFeature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomImplementationFunc_hasFeature_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomImplementation.hasFeature", overloads);
        return 0;
}

static PyObject* SbkQDomImplementationFunc_invalidDataPolicy(PyObject* self)
{
    PyObject* py_result = 0;

    // invalidDataPolicy()
    QDomImplementation::InvalidDataPolicy cpp_result = QDomImplementation::invalidDataPolicy();
    py_result = Shiboken::Converter<QDomImplementation::InvalidDataPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomImplementationFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()
    QDomImplementation* cppSelf = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomImplementation::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomImplementationFunc_setInvalidDataPolicy(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QDomImplementation::InvalidDataPolicy >::isConvertible(arg)) {
        QDomImplementation::InvalidDataPolicy cpp_arg0 = Shiboken::Converter<QDomImplementation::InvalidDataPolicy >::toCpp(arg);
        // setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)
        QDomImplementation::setInvalidDataPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomImplementationFunc_setInvalidDataPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomImplementationFunc_setInvalidDataPolicy_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomImplementation.InvalidDataPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomImplementation.setInvalidDataPolicy", overloads);
        return 0;
}

static PyMethodDef SbkQDomImplementation_methods[] = {
    {"createDocument", (PyCFunction)SbkQDomImplementationFunc_createDocument, METH_VARARGS},
    {"createDocumentType", (PyCFunction)SbkQDomImplementationFunc_createDocumentType, METH_VARARGS},
    {"hasFeature", (PyCFunction)SbkQDomImplementationFunc_hasFeature, METH_VARARGS},
    {"invalidDataPolicy", (PyCFunction)SbkQDomImplementationFunc_invalidDataPolicy, METH_NOARGS|METH_STATIC},
    {"isNull", (PyCFunction)SbkQDomImplementationFunc_isNull, METH_NOARGS},
    {"setInvalidDataPolicy", (PyCFunction)SbkQDomImplementationFunc_setInvalidDataPolicy, METH_O|METH_STATIC},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQDomImplementation_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QDomImplementation& cpp_self = *Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDomImplementation & >::isConvertible(other)) {
                // operator!=(const QDomImplementation & arg__1) const
                QDomImplementation* cpp_other = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDomImplementation  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQDomImplementation_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDomImplementation & >::isConvertible(other)) {
                // operator==(const QDomImplementation & arg__1) const
                QDomImplementation* cpp_other = Shiboken::Converter<QDomImplementation* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDomImplementation  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQDomImplementation_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQDomImplementation_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomImplementation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomImplementation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDomImplementation_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomImplementation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomImplementation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomImplementation >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InvalidDataPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QDomImplementation(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomImplementation_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDomImplementation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomImplementation_Type));
    PyModule_AddObject(module, "QDomImplementation",
        ((PyObject*)&SbkQDomImplementation_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InvalidDataPolicy
    SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX] = &SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type);
    PyDict_SetItemString(SbkQDomImplementation_Type.super.ht_type.tp_dict,
            "InvalidDataPolicy",((PyObject*)&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type,
        (long) QDomImplementation::AcceptInvalidChars, "AcceptInvalidChars");
    PyDict_SetItemString(SbkQDomImplementation_Type.super.ht_type.tp_dict,
        "AcceptInvalidChars", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type.tp_dict,
        "AcceptInvalidChars", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type,
        (long) QDomImplementation::DropInvalidChars, "DropInvalidChars");
    PyDict_SetItemString(SbkQDomImplementation_Type.super.ht_type.tp_dict,
        "DropInvalidChars", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type.tp_dict,
        "DropInvalidChars", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type,
        (long) QDomImplementation::ReturnNullNode, "ReturnNullNode");
    PyDict_SetItemString(SbkQDomImplementation_Type.super.ht_type.tp_dict,
        "ReturnNullNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Type.tp_dict,
        "ReturnNullNode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDomImplementation::InvalidDataPolicy");

    Shiboken::TypeResolver::createValueTypeResolver<QDomImplementation >("QDomImplementation");
    Shiboken::TypeResolver::createValueTypeResolver<QDomImplementation >(typeid(QDomImplementation).name());
}


} // extern "C"

