/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebhittestresult_wrapper.h"

// Extra includes
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qurl.h>
#include <qwebelement.h>
#include <qwebframe.h>

using namespace Shiboken;

static int
SbkQWebHitTestResult_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebHitTestResult* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebHitTestResult", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QWebHitTestResult()
        cptr = new QWebHitTestResult();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWebHitTestResult & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebHitTestResult* cpp_arg0 = Shiboken::Converter<QWebHitTestResult* >::toCpp(pyargs[0]);
        // QWebHitTestResult(QWebHitTestResult)
        cptr = new QWebHitTestResult(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebHitTestResult_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebHitTestResult >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebHitTestResult_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebHitTestResult_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtWebKit.QWebHitTestResult", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebHitTestResult", overloads);
        return -1;
}

static PyObject* SbkQWebHitTestResultFunc_alternateText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alternateText()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebHitTestResult::alternateText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QWebHitTestResult::boundingRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_element(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // element()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebHitTestResult::element();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_enclosingBlockElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // enclosingBlockElement()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebHitTestResult::enclosingBlockElement();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_frame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frame()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebHitTestResult::frame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_imageUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // imageUrl()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebHitTestResult::imageUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_isContentEditable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isContentEditable()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHitTestResult::isContentEditable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_isContentSelected(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isContentSelected()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHitTestResult::isContentSelected();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHitTestResult::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_linkElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkElement()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebHitTestResult::linkElement();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_linkTargetFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkTargetFrame()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QWebFrame * cpp_result = cppSelf->QWebHitTestResult::linkTargetFrame();
    py_result = Shiboken::Converter<QWebFrame * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_linkText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkText()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebHitTestResult::linkText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_linkTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkTitle()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebHitTestResult::linkTitle();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_linkUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // linkUrl()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebHitTestResult::linkUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_pixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixmap()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QWebHitTestResult::pixmap();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QWebHitTestResult::pos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHitTestResultFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QWebHitTestResult* cppSelf = Shiboken::Converter<QWebHitTestResult* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebHitTestResult::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebHitTestResult_methods[] = {
    {"alternateText", (PyCFunction)SbkQWebHitTestResultFunc_alternateText, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQWebHitTestResultFunc_boundingRect, METH_NOARGS},
    {"element", (PyCFunction)SbkQWebHitTestResultFunc_element, METH_NOARGS},
    {"enclosingBlockElement", (PyCFunction)SbkQWebHitTestResultFunc_enclosingBlockElement, METH_NOARGS},
    {"frame", (PyCFunction)SbkQWebHitTestResultFunc_frame, METH_NOARGS},
    {"imageUrl", (PyCFunction)SbkQWebHitTestResultFunc_imageUrl, METH_NOARGS},
    {"isContentEditable", (PyCFunction)SbkQWebHitTestResultFunc_isContentEditable, METH_NOARGS},
    {"isContentSelected", (PyCFunction)SbkQWebHitTestResultFunc_isContentSelected, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQWebHitTestResultFunc_isNull, METH_NOARGS},
    {"linkElement", (PyCFunction)SbkQWebHitTestResultFunc_linkElement, METH_NOARGS},
    {"linkTargetFrame", (PyCFunction)SbkQWebHitTestResultFunc_linkTargetFrame, METH_NOARGS},
    {"linkText", (PyCFunction)SbkQWebHitTestResultFunc_linkText, METH_NOARGS},
    {"linkTitle", (PyCFunction)SbkQWebHitTestResultFunc_linkTitle, METH_NOARGS},
    {"linkUrl", (PyCFunction)SbkQWebHitTestResultFunc_linkUrl, METH_NOARGS},
    {"pixmap", (PyCFunction)SbkQWebHitTestResultFunc_pixmap, METH_NOARGS},
    {"pos", (PyCFunction)SbkQWebHitTestResultFunc_pos, METH_NOARGS},
    {"title", (PyCFunction)SbkQWebHitTestResultFunc_title, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebHitTestResult_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebHitTestResult",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebHitTestResult_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebHitTestResult_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebHitTestResult >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QWebHitTestResult(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBHITTESTRESULT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebHitTestResult_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebHitTestResult_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebHitTestResult_Type));
    PyModule_AddObject(module, "QWebHitTestResult",
        ((PyObject*)&SbkQWebHitTestResult_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QWebHitTestResult >("QWebHitTestResult");
    Shiboken::TypeResolver::createValueTypeResolver<QWebHitTestResult >(typeid(QWebHitTestResult).name());
}


} // extern "C"

