/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtuitools_python.h"

#include "quiloader_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qactiongroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdir.h>
#include <qiodevice.h>
#include <qlayout.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <quiloader.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QUiLoaderWrapper::QUiLoaderWrapper(QObject * parent) : QUiLoader(parent), m_metaObject(0) {
    // ... middle
}

void QUiLoaderWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUiLoaderWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QAction * QUiLoaderWrapper::createAction(QObject * parent, const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createAction"));
    if (py_override.isNull()) {
        return this->QUiLoader::createAction(parent, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(parent),
        Shiboken::Converter<QString & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QAction * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.createAction", SbkType<QAction * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QAction * cpp_result(Shiboken::Converter<QAction * >::toCpp(py_result));
    return cpp_result;
}

QActionGroup * QUiLoaderWrapper::createActionGroup(QObject * parent, const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createActionGroup"));
    if (py_override.isNull()) {
        return this->QUiLoader::createActionGroup(parent, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(parent),
        Shiboken::Converter<QString & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QActionGroup * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.createActionGroup", SbkType<QActionGroup * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QActionGroup * cpp_result(Shiboken::Converter<QActionGroup * >::toCpp(py_result));
    return cpp_result;
}

QLayout * QUiLoaderWrapper::createLayout(const QString & className, QObject * parent, const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createLayout"));
    if (py_override.isNull()) {
        return this->QUiLoader::createLayout(className, parent, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QString & >::toPython(className),
        Shiboken::Converter<QObject * >::toPython(parent),
        Shiboken::Converter<QString & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.createLayout", SbkType<QLayout * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayout * cpp_result(Shiboken::Converter<QLayout * >::toCpp(py_result));
    return cpp_result;
}

QWidget * QUiLoaderWrapper::createWidget(const QString & className, QWidget * parent, const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createWidget"));
    if (py_override.isNull()) {
        return this->QUiLoader::createWidget(className, parent, name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QString & >::toPython(className),
        Shiboken::Converter<QWidget * >::toPython(parent),
        Shiboken::Converter<QString & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.createWidget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

void QUiLoaderWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QUiLoaderWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QUiLoaderWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QUiLoaderWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QUiLoader.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QUiLoaderWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QUiLoaderWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QUiLoader::staticMetaObject);
}
    return m_metaObject;
}

int QUiLoaderWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QUiLoader::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QUiLoaderWrapper::~QUiLoaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQUiLoader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUiLoaderWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QUiLoader", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QUiLoader(QObject*)
        cptr = new QUiLoaderWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QUiLoader(QObject*)
        cptr = new QUiLoaderWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQUiLoader_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QUiLoader >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUiLoader_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQUiLoader_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader", overloads);
        return -1;
}

static PyObject* SbkQUiLoaderFunc_addPluginPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addPluginPath(QString)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        cppSelf->QUiLoader::addPluginPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUiLoaderFunc_addPluginPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUiLoaderFunc_addPluginPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtUiTools.QUiLoader.addPluginPath", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_availableLayouts(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableLayouts()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QUiLoader::availableLayouts();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_availableWidgets(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableWidgets()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QUiLoader::availableWidgets();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_clearPluginPaths(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearPluginPaths()
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    cppSelf->QUiLoader::clearPluginPaths();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQUiLoaderFunc_createAction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createAction", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // createAction(QObject*,QString)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        QAction * cpp_result = cppSelf->QUiLoader::createAction();
        py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], py_result);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createAction(QObject*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUiLoader::createAction(cpp_arg0);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createAction(QObject*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QAction * cpp_result = cppSelf->QUiLoader::createAction(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QAction * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else goto SbkQUiLoaderFunc_createAction_TypeError;
    } else goto SbkQUiLoaderFunc_createAction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUiLoaderFunc_createAction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader.createAction", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_createActionGroup(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createActionGroup", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // createActionGroup(QObject*,QString)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        QActionGroup * cpp_result = cppSelf->QUiLoader::createActionGroup();
        py_result = Shiboken::Converter<QActionGroup * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], py_result);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createActionGroup(QObject*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QActionGroup * cpp_result = cppSelf->QUiLoader::createActionGroup(cpp_arg0);
            py_result = Shiboken::Converter<QActionGroup * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // createActionGroup(QObject*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QActionGroup * cpp_result = cppSelf->QUiLoader::createActionGroup(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QActionGroup * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], py_result);
        } else goto SbkQUiLoaderFunc_createActionGroup_TypeError;
    } else goto SbkQUiLoaderFunc_createActionGroup_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUiLoaderFunc_createActionGroup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader.createActionGroup", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_createLayout(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createLayout", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // createLayout(QString,QObject*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QLayout * cpp_result = cppSelf->QUiLoader::createLayout(*cpp_arg0);
            py_result = Shiboken::Converter<QLayout * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], py_result);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // createLayout(QString,QObject*,QString)
                QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
                QLayout * cpp_result = cppSelf->QUiLoader::createLayout(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QLayout * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], py_result);
            } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!SbkQString_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                // createLayout(QString,QObject*,QString)
                QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
                QLayout * cpp_result = cppSelf->QUiLoader::createLayout(*cpp_arg0, cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QLayout * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], py_result);
            } else goto SbkQUiLoaderFunc_createLayout_TypeError;
        } else goto SbkQUiLoaderFunc_createLayout_TypeError;
    } else goto SbkQUiLoaderFunc_createLayout_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUiLoaderFunc_createLayout_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QObject = None, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader.createLayout", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_createWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createWidget", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // createWidget(QString,QWidget*,QString)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QWidget * cpp_result = cppSelf->QUiLoader::createWidget(*cpp_arg0);
            py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], py_result);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // createWidget(QString,QWidget*,QString)
                QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
                QWidget * cpp_result = cppSelf->QUiLoader::createWidget(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], py_result);
            } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!SbkQString_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                // createWidget(QString,QWidget*,QString)
                QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
                QWidget * cpp_result = cppSelf->QUiLoader::createWidget(*cpp_arg0, cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], py_result);
            } else goto SbkQUiLoaderFunc_createWidget_TypeError;
        } else goto SbkQUiLoaderFunc_createWidget_TypeError;
    } else goto SbkQUiLoaderFunc_createWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUiLoaderFunc_createWidget_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QWidget = None, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader.createWidget", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_isLanguageChangeEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLanguageChangeEnabled()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUiLoader::isLanguageChangeEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_isScriptingEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isScriptingEnabled()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUiLoader::isScriptingEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_isTranslationEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTranslationEnabled()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUiLoader::isTranslationEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // load(const char*,QWidget*)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        (void)cppSelf; // avoid warnings about unused variables
        // Begin code injection
        
        QFile f(cpp_arg0);
        if (f.open(QIODevice::ReadOnly | QIODevice::Text))
            py_result = Shiboken::Converter<QWidget* >::toPython(cppSelf->load(&f, cpp_arg1));
        else
            PyErr_SetString(PyExc_RuntimeError, "Unable to open ui file");
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], py_result);
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // load(QIODevice*,QWidget*)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QWidget * cpp_result = cppSelf->QUiLoader::load(cpp_arg0);
            py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], py_result);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // load(QIODevice*,QWidget*)
            QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
            QWidget * cpp_result = cppSelf->QUiLoader::load(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], py_result);
        } else goto SbkQUiLoaderFunc_load_TypeError;
    } else goto SbkQUiLoaderFunc_load_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQUiLoaderFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtGui.QWidget = None", "str, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtUiTools.QUiLoader.load", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_pluginPaths(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pluginPaths()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QUiLoader::pluginPaths();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUiLoaderFunc_setLanguageChangeEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setLanguageChangeEnabled(bool)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        cppSelf->QUiLoader::setLanguageChangeEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUiLoaderFunc_setLanguageChangeEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUiLoaderFunc_setLanguageChangeEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtUiTools.QUiLoader.setLanguageChangeEnabled", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_setScriptingEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setScriptingEnabled(bool)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        cppSelf->QUiLoader::setScriptingEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUiLoaderFunc_setScriptingEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUiLoaderFunc_setScriptingEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtUiTools.QUiLoader.setScriptingEnabled", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_setTranslationEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTranslationEnabled(bool)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        cppSelf->QUiLoader::setTranslationEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUiLoaderFunc_setTranslationEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUiLoaderFunc_setTranslationEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtUiTools.QUiLoader.setTranslationEnabled", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_setWorkingDirectory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDir & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QDir > cpp_arg0_auto_ptr;
        QDir* cpp_arg0 = Shiboken::Converter<QDir* >::toCpp(arg);
        if (!SbkQDir_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QDir >(cpp_arg0);
        // setWorkingDirectory(QDir)
        QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
        cppSelf->QUiLoader::setWorkingDirectory(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUiLoaderFunc_setWorkingDirectory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUiLoaderFunc_setWorkingDirectory_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtUiTools.QUiLoader.setWorkingDirectory", overloads);
        return 0;
}

static PyObject* SbkQUiLoaderFunc_workingDirectory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // workingDirectory()const
    QUiLoader* cppSelf = Shiboken::Converter<QUiLoader* >::toCpp((PyObject*)self);
    QDir cpp_result = cppSelf->QUiLoader::workingDirectory();
    py_result = Shiboken::Converter<QDir >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQUiLoader_methods[] = {
    {"addPluginPath", (PyCFunction)SbkQUiLoaderFunc_addPluginPath, METH_O},
    {"availableLayouts", (PyCFunction)SbkQUiLoaderFunc_availableLayouts, METH_NOARGS},
    {"availableWidgets", (PyCFunction)SbkQUiLoaderFunc_availableWidgets, METH_NOARGS},
    {"clearPluginPaths", (PyCFunction)SbkQUiLoaderFunc_clearPluginPaths, METH_NOARGS},
    {"createAction", (PyCFunction)SbkQUiLoaderFunc_createAction, METH_VARARGS},
    {"createActionGroup", (PyCFunction)SbkQUiLoaderFunc_createActionGroup, METH_VARARGS},
    {"createLayout", (PyCFunction)SbkQUiLoaderFunc_createLayout, METH_VARARGS},
    {"createWidget", (PyCFunction)SbkQUiLoaderFunc_createWidget, METH_VARARGS},
    {"isLanguageChangeEnabled", (PyCFunction)SbkQUiLoaderFunc_isLanguageChangeEnabled, METH_NOARGS},
    {"isScriptingEnabled", (PyCFunction)SbkQUiLoaderFunc_isScriptingEnabled, METH_NOARGS},
    {"isTranslationEnabled", (PyCFunction)SbkQUiLoaderFunc_isTranslationEnabled, METH_NOARGS},
    {"load", (PyCFunction)SbkQUiLoaderFunc_load, METH_VARARGS},
    {"pluginPaths", (PyCFunction)SbkQUiLoaderFunc_pluginPaths, METH_NOARGS},
    {"setLanguageChangeEnabled", (PyCFunction)SbkQUiLoaderFunc_setLanguageChangeEnabled, METH_O},
    {"setScriptingEnabled", (PyCFunction)SbkQUiLoaderFunc_setScriptingEnabled, METH_O},
    {"setTranslationEnabled", (PyCFunction)SbkQUiLoaderFunc_setTranslationEnabled, METH_O},
    {"setWorkingDirectory", (PyCFunction)SbkQUiLoaderFunc_setWorkingDirectory, METH_O},
    {"workingDirectory", (PyCFunction)SbkQUiLoaderFunc_workingDirectory, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUiLoader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtUiTools.QUiLoader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUiLoader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUiLoader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QUiLoader >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QUiLoader(PyObject* module)
{
    SbkPySide_QtUiToolsTypes[SBK_QUILOADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUiLoader_Type);

    SbkQUiLoader_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQUiLoader_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQUiLoader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUiLoader_Type));
    PyModule_AddObject(module, "QUiLoader",
        ((PyObject*)&SbkQUiLoader_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QUiLoader >("QUiLoader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QUiLoader >(typeid(QUiLoader).name());
}


} // extern "C"

