/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptstring_wrapper.h"

// Extra includes
#include <qscriptstring.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQScriptString_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptString* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptString", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QScriptString()
        cptr = new QScriptString();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QScriptString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QScriptString* cpp_arg0 = Shiboken::Converter<QScriptString* >::toCpp(pyargs[0]);
        // QScriptString(QScriptString)
        cptr = new QScriptString(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptString_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptString >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptString_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptString_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtScript.QScriptString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptString", overloads);
        return -1;
}

static PyObject* SbkQScriptStringFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QScriptString* cppSelf = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptString::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptStringFunc_toArrayIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toArrayIndex(bool*)const
        QScriptString* cppSelf = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)self);
        quint32 cpp_result = cppSelf->QScriptString::toArrayIndex();
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyBool_Check(arg)) {
        bool * cpp_arg0 = Shiboken::Converter<bool * >::toCpp(arg);
        // toArrayIndex(bool*)const
        QScriptString* cppSelf = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)self);
        quint32 cpp_result = cppSelf->QScriptString::toArrayIndex(cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptStringFunc_toArrayIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptStringFunc_toArrayIndex_TypeError:
        const char* overloads[] = {"bool = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptString.toArrayIndex", overloads);
        return 0;
}

static PyObject* SbkQScriptStringFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QScriptString* cppSelf = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptString::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptString_methods[] = {
    {"isValid", (PyCFunction)SbkQScriptStringFunc_isValid, METH_NOARGS},
    {"toArrayIndex", (PyCFunction)SbkQScriptStringFunc_toArrayIndex, METH_NOARGS|METH_O},
    {"toString", (PyCFunction)SbkQScriptStringFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQScriptString_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QScriptString& cpp_self = *Shiboken::Converter<QScriptString* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QScriptString & >::isConvertible(other)) {
                // operator!=(const QScriptString & other) const
                QScriptString* cpp_other = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QScriptString  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQScriptString_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QScriptString & >::isConvertible(other)) {
                // operator==(const QScriptString & other) const
                QScriptString* cpp_other = Shiboken::Converter<QScriptString* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QScriptString  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQScriptString_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQScriptString_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptString_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptString",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQScriptString_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptString_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptString_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptString >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QScriptString(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTSTRING_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptString_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptString_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptString_Type));
    PyModule_AddObject(module, "QScriptString",
        ((PyObject*)&SbkQScriptString_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QScriptString >("QScriptString");
    Shiboken::TypeResolver::createValueTypeResolver<QScriptString >(typeid(QScriptString).name());
}


} // extern "C"

