/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglcolormap_wrapper.h"

// Extra includes
#include <qcolor.h>
#include <qglcolormap.h>

using namespace Shiboken;

static int
SbkQGLColormap_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLColormap* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGLColormap", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGLColormap()
        cptr = new QGLColormap();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QGLColormap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGLColormap* cpp_arg0 = Shiboken::Converter<QGLColormap* >::toCpp(pyargs[0]);
        // QGLColormap(QGLColormap)
        cptr = new QGLColormap(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormap_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLColormap >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLColormap_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLColormap_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtOpenGL.QGLColormap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLColormap", overloads);
        return -1;
}

static PyObject* SbkQGLColormapFunc_entryColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // entryColor(int)const
        QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QGLColormap::entryColor(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormapFunc_entryColor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLColormapFunc_entryColor_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLColormap.entryColor", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_entryRgb(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // entryRgb(int)const
        QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
        unsigned int cpp_result = cppSelf->QGLColormap::entryRgb(cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormapFunc_entryRgb_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLColormapFunc_entryRgb_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLColormap.entryRgb", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_find(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // find(uint)const
        QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLColormap::find(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormapFunc_find_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLColormapFunc_find_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLColormap.find", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_findNearest(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // findNearest(uint)const
        QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGLColormap::findNearest(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormapFunc_findNearest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGLColormapFunc_findNearest_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLColormap.findNearest", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()
    QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QGLColormap::handle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLColormapFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QGLColormap::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLColormapFunc_setEntry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEntry", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            unsigned int cpp_arg1 = Shiboken::Converter<unsigned int >::toCpp(pyargs[1]);
            // setEntry(int,uint)
            QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
            cppSelf->QGLColormap::setEntry(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // setEntry(int,QColor)
            QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
            cppSelf->QGLColormap::setEntry(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGLColormapFunc_setEntry_TypeError;
    } else goto SbkQGLColormapFunc_setEntry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLColormapFunc_setEntry_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QColor", "int, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLColormap.setEntry", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_setHandle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyLong_Check(arg)) {
        Qt::HANDLE cpp_arg0 = Shiboken::Converter<Qt::HANDLE >::toCpp(arg);
        // setHandle(Qt::HANDLE)
        QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
        cppSelf->QGLColormap::setHandle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLColormapFunc_setHandle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLColormapFunc_setHandle_TypeError:
        const char* overloads[] = {"Qt::HANDLE", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLColormap.setHandle", overloads);
        return 0;
}

static PyObject* SbkQGLColormapFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QGLColormap* cppSelf = Shiboken::Converter<QGLColormap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLColormap::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGLColormap_methods[] = {
    {"entryColor", (PyCFunction)SbkQGLColormapFunc_entryColor, METH_O},
    {"entryRgb", (PyCFunction)SbkQGLColormapFunc_entryRgb, METH_O},
    {"find", (PyCFunction)SbkQGLColormapFunc_find, METH_O},
    {"findNearest", (PyCFunction)SbkQGLColormapFunc_findNearest, METH_O},
    {"handle", (PyCFunction)SbkQGLColormapFunc_handle, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQGLColormapFunc_isEmpty, METH_NOARGS},
    {"setEntry", (PyCFunction)SbkQGLColormapFunc_setEntry, METH_VARARGS},
    {"setHandle", (PyCFunction)SbkQGLColormapFunc_setHandle, METH_O},
    {"size", (PyCFunction)SbkQGLColormapFunc_size, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLColormap_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLColormap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLColormap_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLColormap_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLColormap >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGLColormap(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLColormap_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGLColormap_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLColormap_Type));
    PyModule_AddObject(module, "QGLColormap",
        ((PyObject*)&SbkQGLColormap_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QGLColormap >("QGLColormap");
    Shiboken::TypeResolver::createValueTypeResolver<QGLColormap >(typeid(QGLColormap).name());
}


} // extern "C"

