/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtmaemo5_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtMaemo5_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QMaemo5AbstractPickSelector(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5ListPickSelector(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5DatePickSelector(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5TimePickSelector(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5ValueButton(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5InformationBox(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QMaemo5EditBar(PyObject* module);

PyTypeObject** SbkPySide_QtMaemo5Types;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTMAEMO5_API PyMODINIT_FUNC
initQtMaemo5()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtMaemo5", QtMaemo5_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtMaemo5_IDX_COUNT];
    SbkPySide_QtMaemo5Types = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QMaemo5AbstractPickSelector(module);
    init_QMaemo5ListPickSelector(module);
    init_QMaemo5DatePickSelector(module);
    init_QMaemo5TimePickSelector(module);
    init_QMaemo5ValueButton(module);
    init_QMaemo5InformationBox(module);
    init_QMaemo5EditBar(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtMaemo5");
    }
}

} // extern "C"

