/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTMAEMO5_PYTHON_H
#define SBK_QTMAEMO5_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTMAEMO5_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTMAEMO5_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTMAEMO5_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qmaemo5informationbox.h>
#include <qmaemo5abstractpickselector.h>
#include <qmaemo5editbar.h>
#include <qmaemo5listpickselector.h>
#include <qmaemo5datepickselector.h>
#include <qmaemo5timepickselector.h>
#include <qmaemo5valuebutton.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QMAEMO5ABSTRACTPICKSELECTOR_IDX                          0
#define SBK_QMAEMO5LISTPICKSELECTOR_IDX                              1
#define SBK_QMAEMO5DATEPICKSELECTOR_IDX                              2
#define SBK_QMAEMO5TIMEPICKSELECTOR_IDX                              3
#define SBK_QMAEMO5VALUEBUTTON_IDX                                   4
#define SBK_QMAEMO5VALUEBUTTON_VALUELAYOUT_IDX                       5
#define SBK_QMAEMO5INFORMATIONBOX_IDX                                6
#define SBK_QMAEMO5EDITBAR_IDX                                       7
#define SBK_QtMaemo5_IDX_COUNT                                       8

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtMaemo5Types;

// Macros for type check
#define SbkQMaemo5AbstractPickSelector_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5ABSTRACTPICKSELECTOR_IDX])
#define SbkQMaemo5ListPickSelector_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5LISTPICKSELECTOR_IDX])
#define SbkQMaemo5DatePickSelector_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5DATEPICKSELECTOR_IDX])
#define SbkQMaemo5TimePickSelector_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5TIMEPICKSELECTOR_IDX])
#define SbkPySide_QtMaemo5_QMaemo5ValueButton_ValueLayout_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5VALUEBUTTON_VALUELAYOUT_IDX])
#define SbkQMaemo5ValueButton_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5VALUEBUTTON_IDX])
#define SbkQMaemo5InformationBox_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5INFORMATIONBOX_IDX])
#define SbkQMaemo5EditBar_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtMaemo5Types[SBK_QMAEMO5EDITBAR_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QMaemo5AbstractPickSelector >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5ABSTRACTPICKSELECTOR_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5ListPickSelector >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5LISTPICKSELECTOR_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5DatePickSelector >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5DATEPICKSELECTOR_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5TimePickSelector >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5TIMEPICKSELECTOR_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5ValueButton::ValueLayout >() { return SbkPySide_QtMaemo5Types[SBK_QMAEMO5VALUEBUTTON_VALUELAYOUT_IDX]; }
template<> inline PyTypeObject* SbkType<QMaemo5ValueButton >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5VALUEBUTTON_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5InformationBox >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5INFORMATIONBOX_IDX]); }
template<> inline PyTypeObject* SbkType<QMaemo5EditBar >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtMaemo5Types[SBK_QMAEMO5EDITBAR_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QMaemo5AbstractPickSelector* > : ObjectTypeConverter<QMaemo5AbstractPickSelector >
{
};

template<>
struct Converter<QMaemo5AbstractPickSelector& > : ObjectTypeReferenceConverter<QMaemo5AbstractPickSelector >
{
};

template<>
struct Converter<QMaemo5ListPickSelector* > : ObjectTypeConverter<QMaemo5ListPickSelector >
{
};

template<>
struct Converter<QMaemo5ListPickSelector& > : ObjectTypeReferenceConverter<QMaemo5ListPickSelector >
{
};

template<>
struct Converter<QMaemo5DatePickSelector* > : ObjectTypeConverter<QMaemo5DatePickSelector >
{
};

template<>
struct Converter<QMaemo5DatePickSelector& > : ObjectTypeReferenceConverter<QMaemo5DatePickSelector >
{
};

template<>
struct Converter<QMaemo5TimePickSelector* > : ObjectTypeConverter<QMaemo5TimePickSelector >
{
};

template<>
struct Converter<QMaemo5TimePickSelector& > : ObjectTypeReferenceConverter<QMaemo5TimePickSelector >
{
};

template<>
struct Converter<QMaemo5ValueButton::ValueLayout > : EnumConverter<QMaemo5ValueButton::ValueLayout >
{
};

template<>
struct Converter<QMaemo5ValueButton* > : ObjectTypeConverter<QMaemo5ValueButton >
{
};

template<>
struct Converter<QMaemo5ValueButton& > : ObjectTypeReferenceConverter<QMaemo5ValueButton >
{
};

template<>
struct Converter<QMaemo5InformationBox* > : ObjectTypeConverter<QMaemo5InformationBox >
{
};

template<>
struct Converter<QMaemo5InformationBox& > : ObjectTypeReferenceConverter<QMaemo5InformationBox >
{
};

template<>
struct Converter<QMaemo5EditBar* > : ObjectTypeConverter<QMaemo5EditBar >
{
};

template<>
struct Converter<QMaemo5EditBar& > : ObjectTypeReferenceConverter<QMaemo5EditBar >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTMAEMO5_PYTHON_H

