/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qtexttable_wrapper.h"

// Extra includes
#include <QList>
#include <QTextCursor>
#include <QTextFrame>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qtextcursor.h>
#include <qtextdocument.h>
#include <qtextformat.h>
#include <qtextobject.h>
#include <qtexttable.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextTableWrapper::QTextTableWrapper(QTextDocument * doc) : QTextTable(doc), m_metaObject(0) {
    // ... middle
}

void QTextTableWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextTableWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTextTableWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTextTableWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTextTableWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTextTable.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTextTableWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTextTable.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QTextTableWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QTextTableWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTextTable::staticMetaObject);
}
    return m_metaObject;
}

int QTextTableWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTextTable::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTextTableWrapper::~QTextTableWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTextTable_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextTableWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextTable", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QTextDocument * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextDocument* cpp_arg0 = Shiboken::Converter<QTextDocument* >::toCpp(pyargs[0]);
        // QTextTable(QTextDocument*)
        cptr = new QTextTableWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTable_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextTable >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextTable_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextTable_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable", overloads);
        return -1;
}

static PyObject* SbkQTextTableFunc_appendColumns(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appendColumns(int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::appendColumns(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_appendColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_appendColumns_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTable.appendColumns", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_appendRows(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // appendRows(int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::appendRows(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_appendRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_appendRows_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTable.appendRows", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_cellAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cellAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // cellAt(int)const
            QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
            QTextTableCell cpp_result = cppSelf->QTextTable::cellAt(cpp_arg0);
            py_result = Shiboken::Converter<QTextTableCell >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // cellAt(int,int)const
            QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
            QTextTableCell cpp_result = cppSelf->QTextTable::cellAt(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QTextTableCell >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextTableFunc_cellAt_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QTextCursor & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[0]);
        // cellAt(QTextCursor)const
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        QTextTableCell cpp_result = cppSelf->QTextTable::cellAt(*cpp_arg0);
        py_result = Shiboken::Converter<QTextTableCell >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_cellAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextTableFunc_cellAt_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", "int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.cellAt", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_columns(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columns()const
    QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTable::columns();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // insertColumns(int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::insertColumns(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_insertColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.insertColumns", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // insertRows(int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::insertRows(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_insertRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_insertRows_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.insertRows", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_mergeCells(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQTextTableFunc_mergeCells_TypeError;

    if (!PyArg_UnpackTuple(args, "mergeCells", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // mergeCells(int,int,int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::mergeCells(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextCursor & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(pyargs[0]);
        // mergeCells(QTextCursor)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::mergeCells(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_mergeCells_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_mergeCells_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.mergeCells", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeColumns(int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::removeColumns(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_removeColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.removeColumns", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // removeRows(int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::removeRows(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_removeRows_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.removeRows", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_resize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "resize", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // resize(int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::resize(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_resize_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.resize", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_rowEnd(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextCursor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // rowEnd(QTextCursor)const
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        QTextCursor cpp_result = cppSelf->QTextTable::rowEnd(*cpp_arg0);
        py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_rowEnd_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextTableFunc_rowEnd_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTable.rowEnd", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_rowStart(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTextCursor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCursor* cpp_arg0 = Shiboken::Converter<QTextCursor* >::toCpp(arg);
        // rowStart(QTextCursor)const
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        QTextCursor cpp_result = cppSelf->QTextTable::rowStart(*cpp_arg0);
        py_result = Shiboken::Converter<QTextCursor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_rowStart_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextTableFunc_rowStart_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextCursor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTable.rowStart", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_rows(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rows()const
    QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTable::rows();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextTableFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextTableFormat* cpp_arg0 = Shiboken::Converter<QTextTableFormat* >::toCpp(arg);
        // setFormat(QTextTableFormat)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::setFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextTableFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTable.setFormat", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_splitCell(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "splitCell", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // splitCell(int,int,int,int)
        QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
        cppSelf->QTextTable::splitCell(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFunc_splitCell_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFunc_splitCell_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTable.splitCell", overloads);
        return 0;
}

static PyObject* SbkQTextTableFunc_tableFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QTextTable* cppSelf = Shiboken::Converter<QTextTable* >::toCpp((PyObject*)self);
    QTextTableFormat cpp_result = cppSelf->QTextTable::format();
    py_result = Shiboken::Converter<QTextTableFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextTable_methods[] = {
    {"appendColumns", (PyCFunction)SbkQTextTableFunc_appendColumns, METH_O},
    {"appendRows", (PyCFunction)SbkQTextTableFunc_appendRows, METH_O},
    {"cellAt", (PyCFunction)SbkQTextTableFunc_cellAt, METH_VARARGS},
    {"columns", (PyCFunction)SbkQTextTableFunc_columns, METH_NOARGS},
    {"insertColumns", (PyCFunction)SbkQTextTableFunc_insertColumns, METH_VARARGS},
    {"insertRows", (PyCFunction)SbkQTextTableFunc_insertRows, METH_VARARGS},
    {"mergeCells", (PyCFunction)SbkQTextTableFunc_mergeCells, METH_VARARGS},
    {"removeColumns", (PyCFunction)SbkQTextTableFunc_removeColumns, METH_VARARGS},
    {"removeRows", (PyCFunction)SbkQTextTableFunc_removeRows, METH_VARARGS},
    {"resize", (PyCFunction)SbkQTextTableFunc_resize, METH_VARARGS},
    {"rowEnd", (PyCFunction)SbkQTextTableFunc_rowEnd, METH_O},
    {"rowStart", (PyCFunction)SbkQTextTableFunc_rowStart, METH_O},
    {"rows", (PyCFunction)SbkQTextTableFunc_rows, METH_NOARGS},
    {"setFormat", (PyCFunction)SbkQTextTableFunc_setFormat, METH_O},
    {"splitCell", (PyCFunction)SbkQTextTableFunc_splitCell, METH_VARARGS},
    {"tableFormat", (PyCFunction)SbkQTextTableFunc_tableFormat, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextTable_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextTable",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextTable_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextTable_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextTable >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextTable(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTTABLE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextTable_Type);

    SbkQTextTable_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFRAME_IDX];
    // Fill type discovery information
    SbkQTextTable_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextTable_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextTable_Type));
    PyModule_AddObject(module, "QTextTable",
        ((PyObject*)&SbkQTextTable_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTextTable >("QTextTable*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextTable >(typeid(QTextTable).name());
}


} // extern "C"

