/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qdatastream.h>
#include <qpen.h>
#include <qstring.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextFormatWrapper::QTextFormatWrapper() : QTextFormat() {
    // ... middle
}

QTextFormatWrapper::QTextFormatWrapper(int type) : QTextFormat(type) {
    // ... middle
}

QTextFormatWrapper::~QTextFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextFormat()
        cptr = new QTextFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QTextFormat(int)
        cptr = new QTextFormatWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextFormat(QTextFormat)
        cptr = new QTextFormatWrapper(*reinterpret_cast<QTextFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextFormat", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextFormat", overloads);
        return -1;
}

static PyObject* SbkQTextFormatFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QTextFormat::background();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_boolProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // boolProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextFormat::boolProperty(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_boolProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_boolProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.boolProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_brushProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // brushProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QBrush cpp_result = cppSelf->QTextFormat::brushProperty(cpp_arg0);
        py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_brushProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_brushProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.brushProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_clearBackground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearBackground()
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    cppSelf->QTextFormat::clearBackground();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTextFormatFunc_clearForeground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearForeground()
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    cppSelf->QTextFormat::clearForeground();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTextFormatFunc_clearProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // clearProperty(int)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::clearProperty(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_clearProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_clearProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.clearProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_colorProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // colorProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QTextFormat::colorProperty(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_colorProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_colorProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.colorProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_doubleProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // doubleProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QTextFormat::doubleProperty(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_doubleProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_doubleProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.doubleProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_foreground(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // foreground()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QTextFormat::foreground();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_hasProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // hasProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTextFormat::hasProperty(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_hasProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_hasProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.hasProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_intProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // intProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTextFormat::intProperty(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_intProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_intProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.intProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_isBlockFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isBlockFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isBlockFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isCharFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCharFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isCharFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isFrameFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFrameFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isFrameFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isImageFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isImageFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isImageFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isListFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isListFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isListFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isTableCellFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTableCellFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isTableCellFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isTableFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isTableFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isTableFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_layoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layoutDirection()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QTextFormat::layoutDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_lengthProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // lengthProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QTextLength cpp_result = cppSelf->QTextFormat::lengthProperty(cpp_arg0);
        py_result = Shiboken::Converter<QTextLength >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_lengthProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_lengthProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.lengthProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_lengthVectorProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // lengthVectorProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QVector<QTextLength > cpp_result = cppSelf->QTextFormat::lengthVectorProperty(cpp_arg0);
        py_result = Shiboken::Converter<QVector<QTextLength > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_lengthVectorProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_lengthVectorProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.lengthVectorProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_merge(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTextFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(arg);
        // merge(QTextFormat)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::merge(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_merge_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_merge_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.merge", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_objectIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // objectIndex()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFormat::objectIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_objectType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // objectType()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFormat::objectType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_penProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // penProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QPen cpp_result = cppSelf->QTextFormat::penProperty(cpp_arg0);
        py_result = Shiboken::Converter<QPen >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_penProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_penProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.penProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_properties(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // properties()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QMap<int, QVariant > cpp_result = cppSelf->QTextFormat::properties();
    py_result = Shiboken::Converter<QMap<int, QVariant > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // property(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTextFormat::property(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_property_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.property", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_propertyCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyCount()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFormat::propertyCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setBackground(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.setBackground", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setForeground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setForeground(QBrush)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setForeground(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setForeground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setForeground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.setForeground", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setLayoutDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setLayoutDirection(Qt::LayoutDirection)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setLayoutDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setLayoutDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setLayoutDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.setLayoutDirection", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setLengthVectorProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setLengthVectorProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVector<QTextLength >  >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QVector<QTextLength >  cpp_arg1 = Shiboken::Converter<QVector<QTextLength >  >::toCpp(pyargs[1]);
        // setProperty(int,QVector<QTextLength>)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setProperty(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setLengthVectorProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setLengthVectorProperty_TypeError:
        const char* overloads[] = {"int, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextFormat.setLengthVectorProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setObjectIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setObjectIndex(int)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setObjectIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setObjectIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setObjectIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.setObjectIndex", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setObjectType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setObjectType(int)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setObjectType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setObjectType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setObjectType_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.setObjectType", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setProperty(int,QVariant)
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextFormat::setProperty(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextFormatFunc_setProperty_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextFormat.setProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_stringProperty(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // stringProperty(int)const
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTextFormat::stringProperty(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextFormatFunc_stringProperty_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc_stringProperty_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.stringProperty", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc_toBlockFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toBlockFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextBlockFormat cpp_result = cppSelf->QTextFormat::toBlockFormat();
    py_result = Shiboken::Converter<QTextBlockFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toCharFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toCharFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextCharFormat cpp_result = cppSelf->QTextFormat::toCharFormat();
    py_result = Shiboken::Converter<QTextCharFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toFrameFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toFrameFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextFrameFormat cpp_result = cppSelf->QTextFormat::toFrameFormat();
    py_result = Shiboken::Converter<QTextFrameFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toImageFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toImageFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextImageFormat cpp_result = cppSelf->QTextFormat::toImageFormat();
    py_result = Shiboken::Converter<QTextImageFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toListFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toListFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextListFormat cpp_result = cppSelf->QTextFormat::toListFormat();
    py_result = Shiboken::Converter<QTextListFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toTableCellFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toTableCellFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextTableCellFormat cpp_result = cppSelf->QTextFormat::toTableCellFormat();
    py_result = Shiboken::Converter<QTextTableCellFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_toTableFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toTableFormat()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    QTextTableFormat cpp_result = cppSelf->QTextFormat::toTableFormat();
    py_result = Shiboken::Converter<QTextTableFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextFormatFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextFormat::type();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextFormat_methods[] = {
    {"background", (PyCFunction)SbkQTextFormatFunc_background, METH_NOARGS},
    {"boolProperty", (PyCFunction)SbkQTextFormatFunc_boolProperty, METH_O},
    {"brushProperty", (PyCFunction)SbkQTextFormatFunc_brushProperty, METH_O},
    {"clearBackground", (PyCFunction)SbkQTextFormatFunc_clearBackground, METH_NOARGS},
    {"clearForeground", (PyCFunction)SbkQTextFormatFunc_clearForeground, METH_NOARGS},
    {"clearProperty", (PyCFunction)SbkQTextFormatFunc_clearProperty, METH_O},
    {"colorProperty", (PyCFunction)SbkQTextFormatFunc_colorProperty, METH_O},
    {"doubleProperty", (PyCFunction)SbkQTextFormatFunc_doubleProperty, METH_O},
    {"foreground", (PyCFunction)SbkQTextFormatFunc_foreground, METH_NOARGS},
    {"hasProperty", (PyCFunction)SbkQTextFormatFunc_hasProperty, METH_O},
    {"intProperty", (PyCFunction)SbkQTextFormatFunc_intProperty, METH_O},
    {"isBlockFormat", (PyCFunction)SbkQTextFormatFunc_isBlockFormat, METH_NOARGS},
    {"isCharFormat", (PyCFunction)SbkQTextFormatFunc_isCharFormat, METH_NOARGS},
    {"isFrameFormat", (PyCFunction)SbkQTextFormatFunc_isFrameFormat, METH_NOARGS},
    {"isImageFormat", (PyCFunction)SbkQTextFormatFunc_isImageFormat, METH_NOARGS},
    {"isListFormat", (PyCFunction)SbkQTextFormatFunc_isListFormat, METH_NOARGS},
    {"isTableCellFormat", (PyCFunction)SbkQTextFormatFunc_isTableCellFormat, METH_NOARGS},
    {"isTableFormat", (PyCFunction)SbkQTextFormatFunc_isTableFormat, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextFormatFunc_isValid, METH_NOARGS},
    {"layoutDirection", (PyCFunction)SbkQTextFormatFunc_layoutDirection, METH_NOARGS},
    {"lengthProperty", (PyCFunction)SbkQTextFormatFunc_lengthProperty, METH_O},
    {"lengthVectorProperty", (PyCFunction)SbkQTextFormatFunc_lengthVectorProperty, METH_O},
    {"merge", (PyCFunction)SbkQTextFormatFunc_merge, METH_O},
    {"objectIndex", (PyCFunction)SbkQTextFormatFunc_objectIndex, METH_NOARGS},
    {"objectType", (PyCFunction)SbkQTextFormatFunc_objectType, METH_NOARGS},
    {"penProperty", (PyCFunction)SbkQTextFormatFunc_penProperty, METH_O},
    {"properties", (PyCFunction)SbkQTextFormatFunc_properties, METH_NOARGS},
    {"property", (PyCFunction)SbkQTextFormatFunc_property, METH_O},
    {"propertyCount", (PyCFunction)SbkQTextFormatFunc_propertyCount, METH_NOARGS},
    {"setBackground", (PyCFunction)SbkQTextFormatFunc_setBackground, METH_O},
    {"setForeground", (PyCFunction)SbkQTextFormatFunc_setForeground, METH_O},
    {"setLayoutDirection", (PyCFunction)SbkQTextFormatFunc_setLayoutDirection, METH_O},
    {"setLengthVectorProperty", (PyCFunction)SbkQTextFormatFunc_setLengthVectorProperty, METH_VARARGS},
    {"setObjectIndex", (PyCFunction)SbkQTextFormatFunc_setObjectIndex, METH_O},
    {"setObjectType", (PyCFunction)SbkQTextFormatFunc_setObjectType, METH_O},
    {"setProperty", (PyCFunction)SbkQTextFormatFunc_setProperty, METH_VARARGS},
    {"stringProperty", (PyCFunction)SbkQTextFormatFunc_stringProperty, METH_O},
    {"toBlockFormat", (PyCFunction)SbkQTextFormatFunc_toBlockFormat, METH_NOARGS},
    {"toCharFormat", (PyCFunction)SbkQTextFormatFunc_toCharFormat, METH_NOARGS},
    {"toFrameFormat", (PyCFunction)SbkQTextFormatFunc_toFrameFormat, METH_NOARGS},
    {"toImageFormat", (PyCFunction)SbkQTextFormatFunc_toImageFormat, METH_NOARGS},
    {"toListFormat", (PyCFunction)SbkQTextFormatFunc_toListFormat, METH_NOARGS},
    {"toTableCellFormat", (PyCFunction)SbkQTextFormatFunc_toTableCellFormat, METH_NOARGS},
    {"toTableFormat", (PyCFunction)SbkQTextFormatFunc_toTableFormat, METH_NOARGS},
    {"type", (PyCFunction)SbkQTextFormatFunc_type, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQTextFormatFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQTextFormat_Check(arg) && !SbkQTextFormat_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QTextFormat) [reverse operator]
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextFormatFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQTextFormatFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQTextFormat_Check(arg) && !SbkQTextFormat_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QTextFormat&) [reverse operator]
        QTextFormat* cppSelf = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTextFormatFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextFormatFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextFormat.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQTextFormat_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQTextFormatFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQTextFormatFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQTextFormat_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QTextFormat& cpp_self = *Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QTextFormat & >::isConvertible(other)) {
                // operator!=(const QTextFormat & rhs) const
                QTextFormat* cpp_other = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextFormat  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQTextFormat_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QTextFormat & >::isConvertible(other)) {
                // operator==(const QTextFormat & rhs) const
                QTextFormat* cpp_other = Shiboken::Converter<QTextFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QTextFormat  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQTextFormat_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQTextFormat_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

static void* SbkQTextFormat_ObjCopierFunc(const void* ptr){
    return new QTextFormatWrapper(*reinterpret_cast<const QTextFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQTextFormat_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQTextFormat_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQTextFormat_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQTextFormat_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QTextFormat*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QTextFormat_Property_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFormat_Property_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFormat_Property_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Property",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFormat_Property_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFormat_Property_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFormat_Property_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextFormat_FormatType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFormat_FormatType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFormat_FormatType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FormatType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFormat_FormatType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFormat_FormatType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFormat_FormatType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextFormat_ObjectTypes_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFormat_ObjectTypes_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFormat_ObjectTypes_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ObjectTypes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFormat_ObjectTypes_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFormat_ObjectTypes_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFormat_ObjectTypes_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QTextFormat_PageBreakFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextFormat::PageBreakFlags >::toPython(
        ((QTextFormat::PageBreakFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextFormat::PageBreakFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextFormat_PageBreakFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextFormat::PageBreakFlags >::toPython(
        ((QTextFormat::PageBreakFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextFormat::PageBreakFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextFormat_PageBreakFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextFormat::PageBreakFlags >::toPython(
        ((QTextFormat::PageBreakFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextFormat::PageBreakFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextFormat_PageBreakFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextFormat::PageBreakFlags >::toPython(
        ~ Shiboken::Converter< QTextFormat::PageBreakFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTextFormat_PageBreakFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTextFormat_PageBreakFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTextFormat_PageBreakFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTextFormat_PageBreakFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTextFormat_PageBreakFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTextFormat_PageBreakFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFormat_PageBreakFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PageBreakFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTextFormat_PageBreakFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextFormat_PageBreakFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFormat_PageBreakFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFormat_PageBreakFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextFormat_PageBreakFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PageBreakFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextFormat_PageBreakFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextFormat_PageBreakFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QTextFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextFormat_Type);

    // Fill type discovery information
    SbkQTextFormat_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQTextFormat_Type.type_discovery->addTypeDiscoveryFunction(&SbkQTextFormat_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQTextFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextFormat_Type));
    PyModule_AddObject(module, "QTextFormat",
        ((PyObject*)&SbkQTextFormat_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Property
    SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX] = &SbkPySide_QtGui_QTextFormat_Property_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFormat_Property_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFormat_Property_Type);
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
            "Property",((PyObject*)&SbkPySide_QtGui_QTextFormat_Property_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ObjectIndex, "ObjectIndex");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ObjectIndex", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ObjectIndex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::CssFloat, "CssFloat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "CssFloat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "CssFloat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::LayoutDirection, "LayoutDirection");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "LayoutDirection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "LayoutDirection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::OutlinePen, "OutlinePen");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "OutlinePen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "OutlinePen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BackgroundBrush, "BackgroundBrush");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BackgroundBrush", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BackgroundBrush", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ForegroundBrush, "ForegroundBrush");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ForegroundBrush", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ForegroundBrush", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BackgroundImageUrl, "BackgroundImageUrl");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BackgroundImageUrl", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BackgroundImageUrl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockAlignment, "BlockAlignment");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockTopMargin, "BlockTopMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockTopMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockTopMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockBottomMargin, "BlockBottomMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockBottomMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockBottomMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockLeftMargin, "BlockLeftMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockLeftMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockLeftMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockRightMargin, "BlockRightMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockRightMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockRightMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextIndent, "TextIndent");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextIndent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextIndent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TabPositions, "TabPositions");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TabPositions", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TabPositions", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockIndent, "BlockIndent");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockIndent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockIndent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockNonBreakableLines, "BlockNonBreakableLines");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockNonBreakableLines", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockNonBreakableLines", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::BlockTrailingHorizontalRulerWidth, "BlockTrailingHorizontalRulerWidth");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockTrailingHorizontalRulerWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "BlockTrailingHorizontalRulerWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FirstFontProperty, "FirstFontProperty");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FirstFontProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FirstFontProperty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontCapitalization, "FontCapitalization");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontCapitalization", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontCapitalization", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontLetterSpacing, "FontLetterSpacing");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontLetterSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontLetterSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontWordSpacing, "FontWordSpacing");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontWordSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontWordSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontStyleHint, "FontStyleHint");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontStyleHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontStyleHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontStyleStrategy, "FontStyleStrategy");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontStyleStrategy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontStyleStrategy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontKerning, "FontKerning");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontKerning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontKerning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontFamily, "FontFamily");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontFamily", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontFamily", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontPointSize, "FontPointSize");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontPointSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontPointSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontSizeAdjustment, "FontSizeAdjustment");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontSizeAdjustment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontSizeAdjustment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontSizeIncrement, "FontSizeIncrement");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontSizeIncrement", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontSizeIncrement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontWeight, "FontWeight");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontWeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontWeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontItalic, "FontItalic");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontItalic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontItalic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontUnderline, "FontUnderline");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontUnderline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontUnderline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontOverline, "FontOverline");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontOverline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontOverline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontStrikeOut, "FontStrikeOut");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontStrikeOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontStrikeOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontFixedPitch, "FontFixedPitch");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontFixedPitch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontFixedPitch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FontPixelSize, "FontPixelSize");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FontPixelSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FontPixelSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::LastFontProperty, "LastFontProperty");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "LastFontProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "LastFontProperty", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextUnderlineColor, "TextUnderlineColor");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextUnderlineColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextUnderlineColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextVerticalAlignment, "TextVerticalAlignment");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextVerticalAlignment", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextVerticalAlignment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextOutline, "TextOutline");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextOutline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextOutline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextUnderlineStyle, "TextUnderlineStyle");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextUnderlineStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextUnderlineStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TextToolTip, "TextToolTip");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TextToolTip", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TextToolTip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::IsAnchor, "IsAnchor");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "IsAnchor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "IsAnchor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::AnchorHref, "AnchorHref");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "AnchorHref", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "AnchorHref", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::AnchorName, "AnchorName");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "AnchorName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "AnchorName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ObjectType, "ObjectType");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ObjectType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ObjectType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ListStyle, "ListStyle");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ListStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ListStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ListIndent, "ListIndent");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ListIndent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ListIndent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameBorder, "FrameBorder");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameBorder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameBorder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameMargin, "FrameMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FramePadding, "FramePadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FramePadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FramePadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameWidth, "FrameWidth");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameHeight, "FrameHeight");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameTopMargin, "FrameTopMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameTopMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameTopMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameBottomMargin, "FrameBottomMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameBottomMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameBottomMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameLeftMargin, "FrameLeftMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameLeftMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameLeftMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameRightMargin, "FrameRightMargin");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameRightMargin", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameRightMargin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameBorderBrush, "FrameBorderBrush");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameBorderBrush", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameBorderBrush", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FrameBorderStyle, "FrameBorderStyle");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameBorderStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FrameBorderStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableColumns, "TableColumns");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableColumns", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableColumns", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableColumnWidthConstraints, "TableColumnWidthConstraints");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableColumnWidthConstraints", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableColumnWidthConstraints", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellSpacing, "TableCellSpacing");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellPadding, "TableCellPadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellPadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellPadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableHeaderRowCount, "TableHeaderRowCount");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableHeaderRowCount", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableHeaderRowCount", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellRowSpan, "TableCellRowSpan");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellRowSpan", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellRowSpan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellColumnSpan, "TableCellColumnSpan");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellColumnSpan", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellColumnSpan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellTopPadding, "TableCellTopPadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellTopPadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellTopPadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellBottomPadding, "TableCellBottomPadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellBottomPadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellBottomPadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellLeftPadding, "TableCellLeftPadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellLeftPadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellLeftPadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::TableCellRightPadding, "TableCellRightPadding");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellRightPadding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "TableCellRightPadding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ImageName, "ImageName");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ImageName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ImageName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ImageWidth, "ImageWidth");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ImageWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ImageWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::ImageHeight, "ImageHeight");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ImageHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "ImageHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::FullWidthSelection, "FullWidthSelection");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FullWidthSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "FullWidthSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::PageBreakPolicy, "PageBreakPolicy");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "PageBreakPolicy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "PageBreakPolicy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_Property_Type,
        (long) QTextFormat::UserProperty, "UserProperty");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "UserProperty", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_Property_Type.tp_dict,
        "UserProperty", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFormat::Property");

    // init enum class: FormatType
    SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX] = &SbkPySide_QtGui_QTextFormat_FormatType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFormat_FormatType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFormat_FormatType_Type);
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
            "FormatType",((PyObject*)&SbkPySide_QtGui_QTextFormat_FormatType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::InvalidFormat, "InvalidFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "InvalidFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "InvalidFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::BlockFormat, "BlockFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "BlockFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "BlockFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::CharFormat, "CharFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "CharFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "CharFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::ListFormat, "ListFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ListFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "ListFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::TableFormat, "TableFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "TableFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::FrameFormat, "FrameFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "FrameFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "FrameFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_FormatType_Type,
        (long) QTextFormat::UserFormat, "UserFormat");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "UserFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_FormatType_Type.tp_dict,
        "UserFormat", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFormat::FormatType");

    // init enum class: ObjectTypes
    SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX] = &SbkPySide_QtGui_QTextFormat_ObjectTypes_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type);
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
            "ObjectTypes",((PyObject*)&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type,
        (long) QTextFormat::NoObject, "NoObject");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "NoObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_ObjectTypes_Type.tp_dict,
        "NoObject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type,
        (long) QTextFormat::ImageObject, "ImageObject");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "ImageObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_ObjectTypes_Type.tp_dict,
        "ImageObject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type,
        (long) QTextFormat::TableObject, "TableObject");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_ObjectTypes_Type.tp_dict,
        "TableObject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type,
        (long) QTextFormat::TableCellObject, "TableCellObject");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "TableCellObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_ObjectTypes_Type.tp_dict,
        "TableCellObject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_ObjectTypes_Type,
        (long) QTextFormat::UserObject, "UserObject");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "UserObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_ObjectTypes_Type.tp_dict,
        "UserObject", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFormat::ObjectTypes");

    // init enum class: PageBreakFlag
    SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX] = &SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type);
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
            "PageBreakFlag",((PyObject*)&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type));

    // init flags class: QFlags<QTextFormat::PageBreakFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG__IDX] = &SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type);
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
            "PageBreakFlags",((PyObject*)&SbkPySide_QtGui_QTextFormat_PageBreakFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type,
        (long) QTextFormat::PageBreak_Auto, "PageBreak_Auto");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "PageBreak_Auto", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type.tp_dict,
        "PageBreak_Auto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type,
        (long) QTextFormat::PageBreak_AlwaysBefore, "PageBreak_AlwaysBefore");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "PageBreak_AlwaysBefore", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type.tp_dict,
        "PageBreak_AlwaysBefore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type,
        (long) QTextFormat::PageBreak_AlwaysAfter, "PageBreak_AlwaysAfter");
    PyDict_SetItemString(SbkQTextFormat_Type.super.ht_type.tp_dict,
        "PageBreak_AlwaysAfter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextFormat_PageBreakFlag_Type.tp_dict,
        "PageBreak_AlwaysAfter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextFormat::PageBreakFlag");

    Shiboken::TypeResolver::createValueTypeResolver<QTextFormat >("QTextFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextFormat >(typeid(QTextFormat).name());
}


} // extern "C"

