/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qstylepainter_wrapper.h"

// Extra includes
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qfont.h>
#include <qimage.h>
#include <qline.h>
#include <qmatrix.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainterpath.h>
#include <qpalette.h>
#include <qpen.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qstring.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qstylepainter.h>
#include <qtextoption.h>
#include <qtransform.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQStylePainter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStylePainter* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QStylePainter", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QStylePainter()
        cptr = new QStylePainter();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QStylePainter(QWidget*)
        cptr = new QStylePainter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // QStylePainter(QPaintDevice*,QWidget*)
        cptr = new QStylePainter(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStylePainter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStylePainter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStylePainter_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPaintDevice, PySide.QtGui.QWidget", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter", overloads);
        return -1;
}

static PyObject* SbkQStylePainterFunc_begin(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "begin", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // begin(QWidget*)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStylePainter::begin(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // begin(QPaintDevice*,QWidget*)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStylePainter::begin(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainterFunc_begin_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStylePainterFunc_begin_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice, PySide.QtGui.QWidget", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.begin", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_drawComplexControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawComplexControl", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyle::ComplexControl >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionComplex & >::isConvertible(pyargs[1])) {
        QStyle::ComplexControl cpp_arg0 = Shiboken::Converter<QStyle::ComplexControl >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionComplex* cpp_arg1 = Shiboken::Converter<QStyleOptionComplex* >::toCpp(pyargs[1]);
        // drawComplexControl(QStyle::ComplexControl,QStyleOptionComplex)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        cppSelf->QStylePainter::drawComplexControl(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainterFunc_drawComplexControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStylePainterFunc_drawComplexControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ComplexControl, PySide.QtGui.QStyleOptionComplex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.drawComplexControl", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_drawControl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawControl", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyle::ControlElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption & >::isConvertible(pyargs[1])) {
        QStyle::ControlElement cpp_arg0 = Shiboken::Converter<QStyle::ControlElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        // drawControl(QStyle::ControlElement,QStyleOption)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        cppSelf->QStylePainter::drawControl(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainterFunc_drawControl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStylePainterFunc_drawControl_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.ControlElement, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.drawControl", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_drawItemPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemPixmap", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg2_auto_ptr;
        QPixmap* cpp_arg2 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[2]);
        if (!SbkQPixmap_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg2);
        // drawItemPixmap(QRect,int,QPixmap)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        cppSelf->QStylePainter::drawItemPixmap(*cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainterFunc_drawItemPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStylePainterFunc_drawItemPixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.drawItemPixmap", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_drawItemText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawItemText", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPalette & >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QString & >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QPalette > cpp_arg2_auto_ptr;
        QPalette* cpp_arg2 = Shiboken::Converter<QPalette* >::toCpp(pyargs[2]);
        if (!SbkQPalette_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QPalette >(cpp_arg2);
        bool cpp_arg3 = Shiboken::Converter<bool >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QString > cpp_arg4_auto_ptr;
        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
        if (!SbkQString_Check(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
        if (numArgs == 5) {
            // drawItemText(QRect,int,QPalette,bool,QString,QPalette::ColorRole)
            QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
            cppSelf->QStylePainter::drawItemText(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, *cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPalette::ColorRole >::isConvertible(pyargs[5])) {
            QPalette::ColorRole cpp_arg5 = Shiboken::Converter<QPalette::ColorRole >::toCpp(pyargs[5]);
            // drawItemText(QRect,int,QPalette,bool,QString,QPalette::ColorRole)
            QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
            cppSelf->QStylePainter::drawItemText(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStylePainterFunc_drawItemText_TypeError;
    } else goto SbkQStylePainterFunc_drawItemText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStylePainterFunc_drawItemText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtGui.QPalette, bool, PySide.QtCore.QString, PySide.QtGui.QPalette.ColorRole = QPalette.NoRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.drawItemText", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_drawPrimitive(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawPrimitive", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyle::PrimitiveElement >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOption & >::isConvertible(pyargs[1])) {
        QStyle::PrimitiveElement cpp_arg0 = Shiboken::Converter<QStyle::PrimitiveElement >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOption* cpp_arg1 = Shiboken::Converter<QStyleOption* >::toCpp(pyargs[1]);
        // drawPrimitive(QStyle::PrimitiveElement,QStyleOption)
        QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
        cppSelf->QStylePainter::drawPrimitive(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStylePainterFunc_drawPrimitive_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStylePainterFunc_drawPrimitive_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyle.PrimitiveElement, PySide.QtGui.QStyleOption", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStylePainter.drawPrimitive", overloads);
        return 0;
}

static PyObject* SbkQStylePainterFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QStylePainter* cppSelf = Shiboken::Converter<QStylePainter* >::toCpp((PyObject*)self);
    QStyle * cpp_result = cppSelf->QStylePainter::style();
    py_result = Shiboken::Converter<QStyle * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQStylePainter_methods[] = {
    {"begin", (PyCFunction)SbkQStylePainterFunc_begin, METH_VARARGS},
    {"drawComplexControl", (PyCFunction)SbkQStylePainterFunc_drawComplexControl, METH_VARARGS},
    {"drawControl", (PyCFunction)SbkQStylePainterFunc_drawControl, METH_VARARGS},
    {"drawItemPixmap", (PyCFunction)SbkQStylePainterFunc_drawItemPixmap, METH_VARARGS},
    {"drawItemText", (PyCFunction)SbkQStylePainterFunc_drawItemText, METH_VARARGS},
    {"drawPrimitive", (PyCFunction)SbkQStylePainterFunc_drawPrimitive, METH_VARARGS},
    {"style", (PyCFunction)SbkQStylePainterFunc_style, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStylePainter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStylePainter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStylePainter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStylePainter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStylePainter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStylePainter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEPAINTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStylePainter_Type);

    SbkQStylePainter_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPAINTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQStylePainter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStylePainter_Type));
    PyModule_AddObject(module, "QStylePainter",
        ((PyObject*)&SbkQStylePainter_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QStylePainter >("QStylePainter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStylePainter >(typeid(QStylePainter).name());
}


} // extern "C"

