/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qstackedlayout_wrapper.h"

// Extra includes
#include "glue/qlayout_help_functions.h"
#include <qcoreevent.h>
#include <qlayout.h>
#include <qlayoutitem.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qsize.h>
#include <qstackedlayout.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStackedLayoutWrapper::QStackedLayoutWrapper() : QStackedLayout(), m_metaObject(0) {
    // ... middle
}

QStackedLayoutWrapper::QStackedLayoutWrapper(QLayout * parentLayout) : QStackedLayout(parentLayout), m_metaObject(0) {
    // ... middle
}

QStackedLayoutWrapper::QStackedLayoutWrapper(QWidget * parent) : QStackedLayout(parent), m_metaObject(0) {
    // ... middle
}

void QStackedLayoutWrapper::addItem(QLayoutItem * item)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "addItem"));
    if (py_override.isNull()) {
        return this->QStackedLayout::addItem(item);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QLayoutItem * >::toPython(item)
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));

}

void QStackedLayoutWrapper::childEvent(QChildEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStackedLayoutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QStackedLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QStackedLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.count", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QStackedLayoutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStackedLayoutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStackedLayoutWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStackedLayoutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::Orientation> QStackedLayoutWrapper::expandingDirections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "expandingDirections"));
    if (py_override.isNull()) {
        return this->QLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::Orientation> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.expandingDirections", SbkType<QFlags<Qt::Orientation> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::Orientation>();
    }
    QFlags<Qt::Orientation> cpp_result(Shiboken::Converter<QFlags<Qt::Orientation> >::toCpp(py_result));
    return cpp_result;
}

QRect QStackedLayoutWrapper::geometry() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "geometry"));
    if (py_override.isNull()) {
        return this->QLayout::geometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRect();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRect >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.geometry", SbkType<QRect >()->tp_name, py_result->ob_type->tp_name);
        return QRect();
    }
    QRect cpp_result(Shiboken::Converter<QRect >::toCpp(py_result));
    return cpp_result;
}

bool QStackedLayoutWrapper::hasHeightForWidth() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.hasHeightForWidth", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QStackedLayoutWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QStackedLayoutWrapper::indexOf(QWidget * arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "indexOf"));
    if (py_override.isNull()) {
        return this->QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.indexOf", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QStackedLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStackedLayoutWrapper::isEmpty() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isEmpty"));
    if (py_override.isNull()) {
        return this->QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.isEmpty", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QStackedLayoutWrapper::itemAt(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QStackedLayout::itemAt(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));


    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.itemAt", SbkType<QLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayoutItem * cpp_result(Shiboken::Converter<QLayoutItem * >::toCpp(py_result));

    return cpp_result;
}

QLayout * QStackedLayoutWrapper::layout()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "layout"));
    if (py_override.isNull()) {
        return this->QLayout::layout();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayout * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.layout", SbkType<QLayout * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayout * cpp_result(Shiboken::Converter<QLayout * >::toCpp(py_result));
    return cpp_result;
}

QSize QStackedLayoutWrapper::maximumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "maximumSize"));
    if (py_override.isNull()) {
        return this->QLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.maximumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

int QStackedLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumHeightForWidth"));
    if (py_override.isNull()) {
        return this->QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.minimumHeightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QStackedLayoutWrapper::minimumSize() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSize"));
    if (py_override.isNull()) {
        return this->QStackedLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.minimumSize", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QStackedLayoutWrapper::setGeometry(const QRect & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QStackedLayout::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRect & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QStackedLayoutWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QStackedLayout::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

QSpacerItem * QStackedLayoutWrapper::spacerItem()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "spacerItem"));
    if (py_override.isNull()) {
        return this->QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSpacerItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.spacerItem", SbkType<QSpacerItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QSpacerItem * cpp_result(Shiboken::Converter<QSpacerItem * >::toCpp(py_result));
    return cpp_result;
}

QLayoutItem * QStackedLayoutWrapper::takeAt(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "takeAt"));
    if (py_override.isNull()) {
        return this->QStackedLayout::takeAt(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.takeAt", SbkType<QLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QLayoutItem * cpp_result(Shiboken::Converter<QLayoutItem * >::toCpp(py_result));
    return cpp_result;
}

void QStackedLayoutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QStackedLayoutWrapper::widget()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QStackedLayout::widget();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStackedLayout.widget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QStackedLayoutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStackedLayout::staticMetaObject);
}
    return m_metaObject;
}

int QStackedLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStackedLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStackedLayoutWrapper::~QStackedLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStackedLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStackedLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStackedLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStackedLayout()
        cptr = new QStackedLayoutWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QStackedLayout(QWidget*)
        cptr = new QStackedLayoutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (numArgs == 1 && Shiboken::Converter<QLayout * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLayout* cpp_arg0 = Shiboken::Converter<QLayout* >::toCpp(pyargs[0]);
        // QStackedLayout(QLayout*)
        cptr = new QStackedLayoutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayout_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStackedLayout >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStackedLayout_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStackedLayout_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QLayout", "PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStackedLayout", overloads);
        return -1;
}

static PyObject* SbkQStackedLayoutFunc_addItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLayoutItem* cpp_arg0 = Shiboken::Converter<QLayoutItem* >::toCpp(arg);
        // addItem(QLayoutItem*)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        cppSelf->QStackedLayout::addItem(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStackedLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.addItem", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_addStackedWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // addWidget(QWidget*)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg0);
        
        // End of code injection

        int cpp_result = cppSelf->QStackedLayout::addWidget(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_addStackedWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStackedLayoutFunc_addStackedWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.addStackedWidget", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStackedLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStackedLayout::currentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_currentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentWidget()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QStackedLayout::currentWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_insertWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertWidget", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        // insertWidget(int,QWidget*)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_arg1);
        
        // End of code injection

        int cpp_result = cppSelf->QStackedLayout::insertWidget(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_insertWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStackedLayoutFunc_insertWidget_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStackedLayout.insertWidget", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_itemAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemAt(int)const
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);

        QLayoutItem * cpp_result = cppSelf->QStackedLayout::itemAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem * >::toPython(cpp_result);

        // Begin code injection
        
        addLayoutOwnership(cppSelf, cpp_result);
        
        // End of code injection

        // Ownership transferences.
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStackedLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.itemAt", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_minimumSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSize()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QStackedLayout::minimumSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentIndex(int)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        cppSelf->QStackedLayout::setCurrentIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStackedLayoutFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.setCurrentIndex", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_setCurrentWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setCurrentWidget(QWidget*)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        cppSelf->QStackedLayout::setCurrentWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_setCurrentWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStackedLayoutFunc_setCurrentWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.setCurrentWidget", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setGeometry(QRect)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        cppSelf->QStackedLayout::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStackedLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_setStackingMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStackedLayout::StackingMode >::isConvertible(arg)) {
        QStackedLayout::StackingMode cpp_arg0 = Shiboken::Converter<QStackedLayout::StackingMode >::toCpp(arg);
        // setStackingMode(QStackedLayout::StackingMode)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        cppSelf->QStackedLayout::setStackingMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStackedLayoutFunc_setStackingMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStackedLayoutFunc_setStackingMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStackedLayout.StackingMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.setStackingMode", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QStackedLayout::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_stackingMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stackingMode()const
    QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
    QStackedLayout::StackingMode cpp_result = cppSelf->QStackedLayout::stackingMode();
    py_result = Shiboken::Converter<QStackedLayout::StackingMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStackedLayoutFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        QLayoutItem * cpp_result = cppSelf->QStackedLayout::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QLayoutItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQStackedLayoutFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStackedLayoutFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.takeAt", overloads);
        return 0;
}

static PyObject* SbkQStackedLayoutFunc_widget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // widget()
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QStackedLayout::widget();
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // widget(int)const
        QStackedLayout* cppSelf = Shiboken::Converter<QStackedLayout* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QStackedLayout::widget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStackedLayoutFunc_widget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStackedLayoutFunc_widget_TypeError:
        const char* overloads[] = {"", "int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStackedLayout.widget", overloads);
        return 0;
}

static PyMethodDef SbkQStackedLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQStackedLayoutFunc_addItem, METH_O},
    {"addStackedWidget", (PyCFunction)SbkQStackedLayoutFunc_addStackedWidget, METH_O},
    {"count", (PyCFunction)SbkQStackedLayoutFunc_count, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQStackedLayoutFunc_currentIndex, METH_NOARGS},
    {"currentWidget", (PyCFunction)SbkQStackedLayoutFunc_currentWidget, METH_NOARGS},
    {"insertWidget", (PyCFunction)SbkQStackedLayoutFunc_insertWidget, METH_VARARGS},
    {"itemAt", (PyCFunction)SbkQStackedLayoutFunc_itemAt, METH_O},
    {"minimumSize", (PyCFunction)SbkQStackedLayoutFunc_minimumSize, METH_NOARGS},
    {"setCurrentIndex", (PyCFunction)SbkQStackedLayoutFunc_setCurrentIndex, METH_O},
    {"setCurrentWidget", (PyCFunction)SbkQStackedLayoutFunc_setCurrentWidget, METH_O},
    {"setGeometry", (PyCFunction)SbkQStackedLayoutFunc_setGeometry, METH_O},
    {"setStackingMode", (PyCFunction)SbkQStackedLayoutFunc_setStackingMode, METH_O},
    {"sizeHint", (PyCFunction)SbkQStackedLayoutFunc_sizeHint, METH_NOARGS},
    {"stackingMode", (PyCFunction)SbkQStackedLayoutFunc_stackingMode, METH_NOARGS},
    {"takeAt", (PyCFunction)SbkQStackedLayoutFunc_takeAt, METH_O},
    {"widget", (PyCFunction)SbkQStackedLayoutFunc_widget, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQStackedLayoutSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QStackedLayout* me = reinterpret_cast<QStackedLayout*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX]))
        return static_cast<QLayout*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast<QLayoutItem*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStackedLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStackedLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStackedLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStackedLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQStackedLayoutSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStackedLayout >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QStackedLayout_StackingMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QStackedLayout_StackingMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QStackedLayout_StackingMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StackingMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QStackedLayout_StackingMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QStackedLayout_StackingMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QStackedLayout_StackingMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QStackedLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStackedLayout_Type);

    SbkQStackedLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX];
    SbkQStackedLayout_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUT_IDX])->mi_init;

    // Fill type discovery information
    SbkQStackedLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStackedLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStackedLayout_Type));
    PyModule_AddObject(module, "QStackedLayout",
        ((PyObject*)&SbkQStackedLayout_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StackingMode
    SbkPySide_QtGuiTypes[SBK_QSTACKEDLAYOUT_STACKINGMODE_IDX] = &SbkPySide_QtGui_QStackedLayout_StackingMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QStackedLayout_StackingMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QStackedLayout_StackingMode_Type);
    PyDict_SetItemString(SbkQStackedLayout_Type.super.ht_type.tp_dict,
            "StackingMode",((PyObject*)&SbkPySide_QtGui_QStackedLayout_StackingMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStackedLayout_StackingMode_Type,
        (long) QStackedLayout::StackOne, "StackOne");
    PyDict_SetItemString(SbkQStackedLayout_Type.super.ht_type.tp_dict,
        "StackOne", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStackedLayout_StackingMode_Type.tp_dict,
        "StackOne", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QStackedLayout_StackingMode_Type,
        (long) QStackedLayout::StackAll, "StackAll");
    PyDict_SetItemString(SbkQStackedLayout_Type.super.ht_type.tp_dict,
        "StackAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QStackedLayout_StackingMode_Type.tp_dict,
        "StackAll", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStackedLayout::StackingMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QStackedLayout >("QStackedLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStackedLayout >(typeid(QStackedLayout).name());
}


} // extern "C"

