/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qprintengine_wrapper.h"

// Extra includes
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPrintEngineWrapper::QPrintEngineWrapper() : QPrintEngine() {
    // ... middle
}

bool QPrintEngineWrapper::abort()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "abort"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.abort()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.abort", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QPrintEngineWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.metric()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QPrintEngineWrapper::newPage()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "newPage"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.newPage()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.newPage", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QPrinter::PrinterState QPrintEngineWrapper::printerState() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "printerState"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.printerState()' not implemented.");
        return QPrinter::PrinterState();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QPrinter::PrinterState();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPrinter::PrinterState >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.printerState", SbkType<QPrinter::PrinterState >()->tp_name, py_result->ob_type->tp_name);
        return QPrinter::PrinterState();
    }
    QPrinter::PrinterState cpp_result(Shiboken::Converter<QPrinter::PrinterState >::toCpp(py_result));
    return cpp_result;
}

QVariant QPrintEngineWrapper::property(QPrintEngine::PrintEnginePropertyKey key) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "property"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.property()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::toPython(key)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.property", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QPrintEngineWrapper::setProperty(QPrintEngine::PrintEnginePropertyKey key, const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setProperty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.setProperty()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::toPython(key),
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPrintEngineWrapper::~QPrintEngineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPrintEngine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPrintEngineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QPrintEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QPrintEngine()
    cptr = new QPrintEngineWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPrintEngine >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQPrintEngineFunc_abort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // abort()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.abort()' not implemented.");
        return 0;
    }
    QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->abort();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintEngineFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.metric()' not implemented.");
            return 0;
        }
        QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintEngineFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPrintEngineFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintEngine.metric", overloads);
        return 0;
}

static PyObject* SbkQPrintEngineFunc_newPage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // newPage()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.newPage()' not implemented.");
        return 0;
    }
    QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->newPage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintEngineFunc_printerState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printerState()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.printerState()' not implemented.");
        return 0;
    }
    QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
    QPrinter::PrinterState cpp_result = cppSelf->printerState();
    py_result = Shiboken::Converter<QPrinter::PrinterState >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrintEngineFunc_property(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::isConvertible(arg)) {
        QPrintEngine::PrintEnginePropertyKey cpp_arg0 = Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::toCpp(arg);
        // property(QPrintEngine::PrintEnginePropertyKey)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.property()' not implemented.");
            return 0;
        }
        QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->property(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintEngineFunc_property_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPrintEngineFunc_property_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrintEngine.PrintEnginePropertyKey", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPrintEngine.property", overloads);
        return 0;
}

static PyObject* SbkQPrintEngineFunc_setProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        QPrintEngine::PrintEnginePropertyKey cpp_arg0 = Shiboken::Converter<QPrintEngine::PrintEnginePropertyKey >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setProperty(QPrintEngine::PrintEnginePropertyKey,QVariant)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.setProperty()' not implemented.");
            return 0;
        }
        QPrintEngine* cppSelf = Shiboken::Converter<QPrintEngine* >::toCpp((PyObject*)self);
        cppSelf->setProperty(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrintEngineFunc_setProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPrintEngineFunc_setProperty_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPrintEngine.PrintEnginePropertyKey, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrintEngine.setProperty", overloads);
        return 0;
}

static PyMethodDef SbkQPrintEngine_methods[] = {
    {"abort", (PyCFunction)SbkQPrintEngineFunc_abort, METH_NOARGS},
    {"metric", (PyCFunction)SbkQPrintEngineFunc_metric, METH_O},
    {"newPage", (PyCFunction)SbkQPrintEngineFunc_newPage, METH_NOARGS},
    {"printerState", (PyCFunction)SbkQPrintEngineFunc_printerState, METH_NOARGS},
    {"property", (PyCFunction)SbkQPrintEngineFunc_property, METH_O},
    {"setProperty", (PyCFunction)SbkQPrintEngineFunc_setProperty, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPrintEngine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPrintEngine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPrintEngine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPrintEngine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPrintEngine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQPrintEngine_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQPrintEngine_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QPrintEngine*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PrintEnginePropertyKey",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QPrintEngine(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPrintEngine_Type);

    // Fill type discovery information
    SbkQPrintEngine_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQPrintEngine_Type.type_discovery->addTypeDiscoveryFunction(&SbkQPrintEngine_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQPrintEngine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPrintEngine_Type));
    PyModule_AddObject(module, "QPrintEngine",
        ((PyObject*)&SbkQPrintEngine_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PrintEnginePropertyKey
    SbkPySide_QtGuiTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX] = &SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type);
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
            "PrintEnginePropertyKey",((PyObject*)&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_CollateCopies, "PPK_CollateCopies");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_CollateCopies", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_CollateCopies", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_ColorMode, "PPK_ColorMode");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_ColorMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_ColorMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_Creator, "PPK_Creator");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_Creator", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_Creator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_DocumentName, "PPK_DocumentName");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_DocumentName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_DocumentName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_FullPage, "PPK_FullPage");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_FullPage", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_FullPage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_NumberOfCopies, "PPK_NumberOfCopies");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_NumberOfCopies", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_NumberOfCopies", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_Orientation, "PPK_Orientation");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_Orientation", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_Orientation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_OutputFileName, "PPK_OutputFileName");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_OutputFileName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_OutputFileName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PageOrder, "PPK_PageOrder");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PageOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PageOrder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PageRect, "PPK_PageRect");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PageRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PageRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PageSize, "PPK_PageSize");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PageSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PageSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PaperRect, "PPK_PaperRect");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PaperRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PaperRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PaperSource, "PPK_PaperSource");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PaperSource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PaperSource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PrinterName, "PPK_PrinterName");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PrinterName", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PrinterName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PrinterProgram, "PPK_PrinterProgram");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PrinterProgram", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PrinterProgram", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_Resolution, "PPK_Resolution");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_Resolution", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_Resolution", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_SelectionOption, "PPK_SelectionOption");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_SelectionOption", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_SelectionOption", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_SupportedResolutions, "PPK_SupportedResolutions");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_SupportedResolutions", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_SupportedResolutions", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_WindowsPageSize, "PPK_WindowsPageSize");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_WindowsPageSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_WindowsPageSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_FontEmbedding, "PPK_FontEmbedding");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_FontEmbedding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_FontEmbedding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_SuppressSystemPrintStatus, "PPK_SuppressSystemPrintStatus");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_SuppressSystemPrintStatus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_SuppressSystemPrintStatus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_Duplex, "PPK_Duplex");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_Duplex", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_Duplex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PaperSources, "PPK_PaperSources");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PaperSources", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PaperSources", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_CustomPaperSize, "PPK_CustomPaperSize");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_CustomPaperSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_CustomPaperSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PageMargins, "PPK_PageMargins");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PageMargins", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PageMargins", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_PaperSize, "PPK_PaperSize");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_PaperSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_PaperSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type,
        (long) QPrintEngine::PPK_CustomBase, "PPK_CustomBase");
    PyDict_SetItemString(SbkQPrintEngine_Type.super.ht_type.tp_dict,
        "PPK_CustomBase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPrintEngine_PrintEnginePropertyKey_Type.tp_dict,
        "PPK_CustomBase", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPrintEngine::PrintEnginePropertyKey");

    Shiboken::TypeResolver::createObjectTypeResolver<QPrintEngine >("QPrintEngine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPrintEngine >(typeid(QPrintEngine).name());
}


} // extern "C"

