/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpolygonf_wrapper.h"

// Extra includes
#include <QList>
#include <QMatrix>
#include <QTransform>
#include <QVector>
#include <qdatastream.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>

using namespace Shiboken;

static int
SbkQPolygonF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPolygonF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPolygonF", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPolygonF()
        cptr = new QPolygonF();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QPolygonF(int)
        cptr = new QPolygonF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector<QPointF >  >::isConvertible(pyargs[0])) {
        QVector<QPointF >  cpp_arg0 = Shiboken::Converter<QVector<QPointF >  >::toCpp(pyargs[0]);
        // QPolygonF(QVector<QPointF>)
        cptr = new QPolygonF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // QPolygonF(QRectF)
        cptr = new QPolygonF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPolygon & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!SbkQPolygon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // QPolygonF(QPolygon)
        cptr = new QPolygonF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPolygonF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!SbkQPolygonF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // QPolygonF(QPolygonF)
        cptr = new QPolygonF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonF_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPolygonF >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPolygonF_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPolygonF_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPolygon", "PySide.QtGui.QPolygonF", "PySide.QtCore.QRectF", "list", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF", overloads);
        return -1;
}

static PyObject* SbkQPolygonFFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // append(QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.append", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        const QPointF & cpp_result = cppSelf->QPolygonF::at(cpp_arg0);
        py_result = Shiboken::Converter<QPointF & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.at", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QPolygonF::boundingRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_capacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capacity()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPolygonF::capacity();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    cppSelf->QPolygonF::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // contains(QPointF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygonF::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.contains", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_containsPoint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "containsPoint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::FillRule >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        Qt::FillRule cpp_arg1 = Shiboken::Converter<Qt::FillRule >::toCpp(pyargs[1]);
        // containsPoint(QPointF,Qt::FillRule)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygonF::containsPoint(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_containsPoint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_containsPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.Qt.FillRule", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.containsPoint", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPolygonF::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // count(QPointF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPolygonF::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_count_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.count", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_empty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // empty()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPolygonF::empty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // endsWith(QPointF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygonF::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_endsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.endsWith", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_fill(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fill", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 1) {
            // fill(QPointF,int)
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QVector<QPointF > & cpp_result = cppSelf->QPolygonF::fill(*cpp_arg0);
            py_result = Shiboken::Converter<QVector<QPointF >  >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // fill(QPointF,int)
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QVector<QPointF > & cpp_result = cppSelf->QPolygonF::fill(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVector<QPointF >  >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_fill_TypeError;
    } else goto SbkQPolygonFFunc_fill_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_fill_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.fill", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_fromList(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QList<QPointF >  >::isConvertible(arg)) {
        QList<QPointF >  cpp_arg0 = Shiboken::Converter<QList<QPointF >  >::toCpp(arg);
        // fromList(QList<QPointF>)
        QVector<QPointF > cpp_result = QPolygonF::fromList(cpp_arg0);
        py_result = Shiboken::Converter<QVector<QPointF > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_fromList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_fromList_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.fromList", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 1) {
            // indexOf(QPointF,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygonF::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QPointF,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygonF::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_indexOf_TypeError;
    } else goto SbkQPolygonFFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.indexOf", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // intersected(QPolygonF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPolygonF::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.intersected", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_isClosed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isClosed()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPolygonF::isClosed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPolygonF::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 1) {
            // lastIndexOf(QPointF,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygonF::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QPointF,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygonF::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_lastIndexOf_TypeError;
    } else goto SbkQPolygonFFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.lastIndexOf", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_mid(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mid", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mid(int,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QVector<QPointF > cpp_result = cppSelf->QPolygonF::mid(cpp_arg0);
            py_result = Shiboken::Converter<QVector<QPointF > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // mid(int,int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QVector<QPointF > cpp_result = cppSelf->QPolygonF::mid(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVector<QPointF > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_mid_TypeError;
    } else goto SbkQPolygonFFunc_mid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_mid_TypeError:
        const char* overloads[] = {"int, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.mid", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_pop_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_back()
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    cppSelf->QPolygonF::pop_back();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFFunc_pop_front(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_front()
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    cppSelf->QPolygonF::pop_front();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFFunc_prepend(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // prepend(QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::prepend(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_prepend_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.prepend", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_push_back(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // push_back(QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::push_back(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_push_back_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_push_back_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.push_back", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_push_front(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // push_front(QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::push_front(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_push_front_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_push_front_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.push_front", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_remove(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "remove", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // remove(int)
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            cppSelf->QPolygonF::remove(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // remove(int,int)
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            cppSelf->QPolygonF::remove(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_remove_TypeError;
    } else goto SbkQPolygonFFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_remove_TypeError:
        const char* overloads[] = {"int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.remove", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // replace(int,QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.replace", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_reserve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // reserve(int)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::reserve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_reserve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_reserve_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.reserve", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_resize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resize(int)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::resize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_resize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.resize", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_setSharable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSharable(bool)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::setSharable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_setSharable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_setSharable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.setSharable", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPolygonF::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_squeeze(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // squeeze()
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    cppSelf->QPolygonF::squeeze();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // startsWith(QPointF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygonF::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_startsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.startsWith", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_subtracted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // subtracted(QPolygonF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPolygonF::subtracted(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_subtracted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_subtracted_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.subtracted", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_toList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toList()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    QList<QPointF > cpp_result = cppSelf->QPolygonF::toList();
    py_result = Shiboken::Converter<QList<QPointF > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_toPolygon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPolygon()const
    QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
    QPolygon cpp_result = cppSelf->QPolygonF::toPolygon();
    py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translate(QPointF)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        cppSelf->QPolygonF::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.translate", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translated(qreal,qreal)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPolygonF::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translated(QPointF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPolygonF::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.translated", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // united(QPolygonF)const
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = cppSelf->QPolygonF::united(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.united", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // value(int)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QPointF cpp_result = cppSelf->QPolygonF::value(cpp_arg0);
            py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
            QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
            if (!SbkQPointF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
            // value(int,QPointF)const
            QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
            QPointF cpp_result = cppSelf->QPolygonF::value(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFFunc_value_TypeError;
    } else goto SbkQPolygonFFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc_value_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygonF.value", overloads);
        return 0;
}

static PyMethodDef SbkQPolygonF_methods[] = {
    {"append", (PyCFunction)SbkQPolygonFFunc_append, METH_O},
    {"at", (PyCFunction)SbkQPolygonFFunc_at, METH_O},
    {"boundingRect", (PyCFunction)SbkQPolygonFFunc_boundingRect, METH_NOARGS},
    {"capacity", (PyCFunction)SbkQPolygonFFunc_capacity, METH_NOARGS},
    {"clear", (PyCFunction)SbkQPolygonFFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQPolygonFFunc_contains, METH_O},
    {"containsPoint", (PyCFunction)SbkQPolygonFFunc_containsPoint, METH_VARARGS},
    {"count", (PyCFunction)SbkQPolygonFFunc_count, METH_NOARGS|METH_O},
    {"empty", (PyCFunction)SbkQPolygonFFunc_empty, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQPolygonFFunc_endsWith, METH_O},
    {"fill", (PyCFunction)SbkQPolygonFFunc_fill, METH_VARARGS},
    {"fromList", (PyCFunction)SbkQPolygonFFunc_fromList, METH_O|METH_STATIC},
    {"indexOf", (PyCFunction)SbkQPolygonFFunc_indexOf, METH_VARARGS},
    {"intersected", (PyCFunction)SbkQPolygonFFunc_intersected, METH_O},
    {"isClosed", (PyCFunction)SbkQPolygonFFunc_isClosed, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQPolygonFFunc_isEmpty, METH_NOARGS},
    {"lastIndexOf", (PyCFunction)SbkQPolygonFFunc_lastIndexOf, METH_VARARGS},
    {"mid", (PyCFunction)SbkQPolygonFFunc_mid, METH_VARARGS},
    {"pop_back", (PyCFunction)SbkQPolygonFFunc_pop_back, METH_NOARGS},
    {"pop_front", (PyCFunction)SbkQPolygonFFunc_pop_front, METH_NOARGS},
    {"prepend", (PyCFunction)SbkQPolygonFFunc_prepend, METH_O},
    {"push_back", (PyCFunction)SbkQPolygonFFunc_push_back, METH_O},
    {"push_front", (PyCFunction)SbkQPolygonFFunc_push_front, METH_O},
    {"remove", (PyCFunction)SbkQPolygonFFunc_remove, METH_VARARGS},
    {"replace", (PyCFunction)SbkQPolygonFFunc_replace, METH_VARARGS},
    {"reserve", (PyCFunction)SbkQPolygonFFunc_reserve, METH_O},
    {"resize", (PyCFunction)SbkQPolygonFFunc_resize, METH_O},
    {"setSharable", (PyCFunction)SbkQPolygonFFunc_setSharable, METH_O},
    {"size", (PyCFunction)SbkQPolygonFFunc_size, METH_NOARGS},
    {"squeeze", (PyCFunction)SbkQPolygonFFunc_squeeze, METH_NOARGS},
    {"startsWith", (PyCFunction)SbkQPolygonFFunc_startsWith, METH_O},
    {"subtracted", (PyCFunction)SbkQPolygonFFunc_subtracted, METH_O},
    {"toList", (PyCFunction)SbkQPolygonFFunc_toList, METH_NOARGS},
    {"toPolygon", (PyCFunction)SbkQPolygonFFunc_toPolygon, METH_NOARGS},
    {"translate", (PyCFunction)SbkQPolygonFFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQPolygonFFunc_translated, METH_VARARGS},
    {"united", (PyCFunction)SbkQPolygonFFunc_united, METH_O},
    {"value", (PyCFunction)SbkQPolygonFFunc_value, METH_VARARGS},
    {0} // Sentinel
};

static PyObject* SbkQPolygonFFunc___mul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygonF_Check(arg) && !SbkQPolygonF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rmul__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rmul__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QTransform & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*(QPolygonF,QTransform)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QMatrix & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // operator*(QPolygonF,QMatrix)
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QPolygonF cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPolygonF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFFunc___mul___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.__mul__", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygonF_Check(arg) && !SbkQPolygonF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPolygonF) [reverse operator]
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPolygonFFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQPolygonFFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygonF_Check(arg) && !SbkQPolygonF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPolygonF&) [reverse operator]
        QPolygonF* cppSelf = Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPolygonFFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygonF.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPolygonF_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)SbkQPolygonFFunc___mul__,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPolygonFFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPolygonFFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQPolygonF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QPolygonF& cpp_self = *Shiboken::Converter<QPolygonF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVector<QPointF >  >::isConvertible(other)) {
                // operator!=(const QVector<QPointF > & v) const
                const QVector<QPointF > & cpp_other = Shiboken::Converter<QVector<QPointF >  >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQPolygonF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVector<QPointF >  >::isConvertible(other)) {
                // operator==(const QVector<QPointF > & v) const
                const QVector<QPointF > & cpp_other = Shiboken::Converter<QVector<QPointF >  >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQPolygonF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQPolygonF_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPolygonF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPolygonF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPolygonF_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPolygonF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPolygonF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPolygonF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPolygonF >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPolygonF(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPOLYGONF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPolygonF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPolygonF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPolygonF_Type));
    PyModule_AddObject(module, "QPolygonF",
        ((PyObject*)&SbkQPolygonF_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPolygonF >("QPolygonF");
    Shiboken::TypeResolver::createValueTypeResolver<QPolygonF >(typeid(QPolygonF).name());
}


} // extern "C"

