/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qmdisubwindow_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmdiarea.h>
#include <qmdisubwindow.h>
#include <qmenu.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMdiSubWindowWrapper::QMdiSubWindowWrapper(QWidget * parent, QFlags<Qt::WindowType> flags) : QMdiSubWindow(parent, flags), m_metaObject(0) {
    // ... middle
}

void QMdiSubWindowWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::changeEvent(QEvent * changeEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::changeEvent(changeEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(changeEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::childEvent(QChildEvent * childEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::childEvent(childEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(childEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::closeEvent(QCloseEvent * closeEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::closeEvent(closeEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(closeEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::contextMenuEvent(QContextMenuEvent * contextMenuEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::contextMenuEvent(contextMenuEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(contextMenuEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMdiSubWindowWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QMdiSubWindowWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QMdiSubWindowWrapper::eventFilter(QObject * object, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(object),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::focusInEvent(QFocusEvent * focusInEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::focusInEvent(focusInEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(focusInEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMdiSubWindowWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::focusOutEvent(QFocusEvent * focusOutEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::focusOutEvent(focusOutEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(focusOutEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMdiSubWindowWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::hideEvent(QHideEvent * hideEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::hideEvent(hideEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(hideEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QMdiSubWindowWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::keyPressEvent(QKeyEvent * keyEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::keyPressEvent(keyEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(keyEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::leaveEvent(QEvent * leaveEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::leaveEvent(leaveEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(leaveEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QMdiSubWindowWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QMdiSubWindowWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::mouseDoubleClickEvent(QMouseEvent * mouseEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::mouseDoubleClickEvent(mouseEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(mouseEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::mouseMoveEvent(QMouseEvent * mouseEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::mouseMoveEvent(mouseEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(mouseEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::mousePressEvent(QMouseEvent * mouseEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::mousePressEvent(mouseEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(mouseEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::mouseReleaseEvent(QMouseEvent * mouseEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::mouseReleaseEvent(mouseEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(mouseEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::moveEvent(QMoveEvent * moveEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::moveEvent(moveEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(moveEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QPaintEngine * QMdiSubWindowWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::paintEvent(QPaintEvent * paintEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::paintEvent(paintEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(paintEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::resizeEvent(QResizeEvent * resizeEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::resizeEvent(resizeEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(resizeEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::showEvent(QShowEvent * showEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::showEvent(showEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(showEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QMdiSubWindowWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMdiSubWindow.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QMdiSubWindowWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMdiSubWindowWrapper::timerEvent(QTimerEvent * timerEvent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QMdiSubWindow::timerEvent(timerEvent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(timerEvent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMdiSubWindowWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMdiSubWindowWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMdiSubWindow::staticMetaObject);
}
    return m_metaObject;
}

int QMdiSubWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMdiSubWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMdiSubWindowWrapper::~QMdiSubWindowWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMdiSubWindow_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMdiSubWindowWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QMdiSubWindow", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QMdiSubWindow(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QMdiSubWindowWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QMdiSubWindow(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QMdiSubWindowWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QMdiSubWindow(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QMdiSubWindowWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQMdiSubWindow_Init_TypeError;
    } else goto SbkQMdiSubWindow_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMdiSubWindow >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMdiSubWindow_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMdiSubWindow_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiSubWindow", overloads);
        return -1;
}

static PyObject* SbkQMdiSubWindowFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_childEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QChildEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QChildEvent* cpp_arg0 = Shiboken::Converter<QChildEvent* >::toCpp(arg);
        // childEvent(QChildEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::childEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_childEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_childEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QChildEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.childEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_closeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCloseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCloseEvent* cpp_arg0 = Shiboken::Converter<QCloseEvent* >::toCpp(arg);
        // closeEvent(QCloseEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::closeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_closeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_closeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCloseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.closeEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiSubWindow::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMdiSubWindowFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.event", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiSubWindow::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMdiSubWindowFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiSubWindow.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::focusOutEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.focusOutEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_isShaded(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isShaded()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMdiSubWindow::isShaded();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_keyboardPageStep(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyboardPageStep()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMdiSubWindow::keyboardPageStep();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_keyboardSingleStep(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keyboardSingleStep()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMdiSubWindow::keyboardSingleStep();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_leaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // leaveEvent(QEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::leaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_leaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_leaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.leaveEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_maximizedButtonsWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximizedButtonsWidget()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QMdiSubWindow::maximizedButtonsWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_maximizedSystemMenuIconWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximizedSystemMenuIconWidget()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QMdiSubWindow::maximizedSystemMenuIconWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_mdiArea(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mdiArea()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QMdiArea * cpp_result = cppSelf->QMdiSubWindow::mdiArea();
    py_result = Shiboken::Converter<QMdiArea * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMdiSubWindow::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::mouseDoubleClickEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_moveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMoveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMoveEvent* cpp_arg0 = Shiboken::Converter<QMoveEvent* >::toCpp(arg);
        // moveEvent(QMoveEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::moveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_moveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_moveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.moveEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_setKeyboardPageStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setKeyboardPageStep(int)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::setKeyboardPageStep(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_setKeyboardPageStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_setKeyboardPageStep_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.setKeyboardPageStep", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_setKeyboardSingleStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setKeyboardSingleStep(int)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::setKeyboardSingleStep(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_setKeyboardSingleStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_setKeyboardSingleStep_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.setKeyboardSingleStep", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_setOption(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOption", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMdiSubWindow::SubWindowOption >::isConvertible(pyargs[0])) {
        QMdiSubWindow::SubWindowOption cpp_arg0 = Shiboken::Converter<QMdiSubWindow::SubWindowOption >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOption(QMdiSubWindow::SubWindowOption,bool)
            QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
            cppSelf->QMdiSubWindow::setOption(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOption(QMdiSubWindow::SubWindowOption,bool)
            QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
            cppSelf->QMdiSubWindow::setOption(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQMdiSubWindowFunc_setOption_TypeError;
    } else goto SbkQMdiSubWindowFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiSubWindow.SubWindowOption, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMdiSubWindow.setOption", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_setSystemMenu(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMenu * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMenu* cpp_arg0 = Shiboken::Converter<QMenu* >::toCpp(arg);
        // setSystemMenu(QMenu*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::setSystemMenu(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMdiSubWindowFunc_setSystemMenu_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_setSystemMenu_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMenu", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.setSystemMenu", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_setWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setWidget(QWidget*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::setWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMdiSubWindowFunc_setWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_setWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.setWidget", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.showEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_showShaded(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showShaded()
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    cppSelf->QMdiSubWindow::showShaded();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMdiSubWindowFunc_showSystemMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showSystemMenu()
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    cppSelf->QMdiSubWindow::showSystemMenu();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMdiSubWindowFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMdiSubWindow::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_systemMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // systemMenu()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QMdiSubWindow::systemMenu();
    py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMdiSubWindowFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QMdiSubWindow::SubWindowOption >::isConvertible(arg)) {
        QMdiSubWindow::SubWindowOption cpp_arg0 = Shiboken::Converter<QMdiSubWindow::SubWindowOption >::toCpp(arg);
        // testOption(QMdiSubWindow::SubWindowOption)const
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMdiSubWindow::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMdiSubWindowFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMdiSubWindow.SubWindowOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.testOption", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_timerEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTimerEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTimerEvent* cpp_arg0 = Shiboken::Converter<QTimerEvent* >::toCpp(arg);
        // timerEvent(QTimerEvent*)
        QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
        cppSelf->QMdiSubWindow::timerEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMdiSubWindowFunc_timerEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMdiSubWindowFunc_timerEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTimerEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMdiSubWindow.timerEvent", overloads);
        return 0;
}

static PyObject* SbkQMdiSubWindowFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()const
    QMdiSubWindow* cppSelf = Shiboken::Converter<QMdiSubWindow* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QMdiSubWindow::widget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQMdiSubWindow_methods[] = {
    {"changeEvent", (PyCFunction)SbkQMdiSubWindowFunc_changeEvent, METH_O},
    {"childEvent", (PyCFunction)SbkQMdiSubWindowFunc_childEvent, METH_O},
    {"closeEvent", (PyCFunction)SbkQMdiSubWindowFunc_closeEvent, METH_O},
    {"contextMenuEvent", (PyCFunction)SbkQMdiSubWindowFunc_contextMenuEvent, METH_O},
    {"event", (PyCFunction)SbkQMdiSubWindowFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQMdiSubWindowFunc_eventFilter, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQMdiSubWindowFunc_focusInEvent, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQMdiSubWindowFunc_focusOutEvent, METH_O},
    {"hideEvent", (PyCFunction)SbkQMdiSubWindowFunc_hideEvent, METH_O},
    {"isShaded", (PyCFunction)SbkQMdiSubWindowFunc_isShaded, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQMdiSubWindowFunc_keyPressEvent, METH_O},
    {"keyboardPageStep", (PyCFunction)SbkQMdiSubWindowFunc_keyboardPageStep, METH_NOARGS},
    {"keyboardSingleStep", (PyCFunction)SbkQMdiSubWindowFunc_keyboardSingleStep, METH_NOARGS},
    {"leaveEvent", (PyCFunction)SbkQMdiSubWindowFunc_leaveEvent, METH_O},
    {"maximizedButtonsWidget", (PyCFunction)SbkQMdiSubWindowFunc_maximizedButtonsWidget, METH_NOARGS},
    {"maximizedSystemMenuIconWidget", (PyCFunction)SbkQMdiSubWindowFunc_maximizedSystemMenuIconWidget, METH_NOARGS},
    {"mdiArea", (PyCFunction)SbkQMdiSubWindowFunc_mdiArea, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQMdiSubWindowFunc_minimumSizeHint, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQMdiSubWindowFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQMdiSubWindowFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQMdiSubWindowFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQMdiSubWindowFunc_mouseReleaseEvent, METH_O},
    {"moveEvent", (PyCFunction)SbkQMdiSubWindowFunc_moveEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQMdiSubWindowFunc_paintEvent, METH_O},
    {"resizeEvent", (PyCFunction)SbkQMdiSubWindowFunc_resizeEvent, METH_O},
    {"setKeyboardPageStep", (PyCFunction)SbkQMdiSubWindowFunc_setKeyboardPageStep, METH_O},
    {"setKeyboardSingleStep", (PyCFunction)SbkQMdiSubWindowFunc_setKeyboardSingleStep, METH_O},
    {"setOption", (PyCFunction)SbkQMdiSubWindowFunc_setOption, METH_VARARGS},
    {"setSystemMenu", (PyCFunction)SbkQMdiSubWindowFunc_setSystemMenu, METH_O},
    {"setWidget", (PyCFunction)SbkQMdiSubWindowFunc_setWidget, METH_O},
    {"showEvent", (PyCFunction)SbkQMdiSubWindowFunc_showEvent, METH_O},
    {"showShaded", (PyCFunction)SbkQMdiSubWindowFunc_showShaded, METH_NOARGS},
    {"showSystemMenu", (PyCFunction)SbkQMdiSubWindowFunc_showSystemMenu, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQMdiSubWindowFunc_sizeHint, METH_NOARGS},
    {"systemMenu", (PyCFunction)SbkQMdiSubWindowFunc_systemMenu, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQMdiSubWindowFunc_testOption, METH_O},
    {"timerEvent", (PyCFunction)SbkQMdiSubWindowFunc_timerEvent, METH_O},
    {"widget", (PyCFunction)SbkQMdiSubWindowFunc_widget, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQMdiSubWindowSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QMdiSubWindow* me = reinterpret_cast<QMdiSubWindow*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMdiSubWindow_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMdiSubWindow",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMdiSubWindow_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMdiSubWindow_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQMdiSubWindowSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMdiSubWindow >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toPython(
        ((QMdiSubWindow::SubWindowOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toPython(
        ((QMdiSubWindow::SubWindowOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toPython(
        ((QMdiSubWindow::SubWindowOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toPython(
        ~ Shiboken::Converter< QMdiSubWindow::SubWindowOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QMdiSubWindow_SubWindowOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubWindowOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubWindowOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QMdiSubWindow(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMdiSubWindow_Type);

    SbkQMdiSubWindow_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQMdiSubWindow_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQMdiSubWindow_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMdiSubWindow_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMdiSubWindow_Type));
    PyModule_AddObject(module, "QMdiSubWindow",
        ((PyObject*)&SbkQMdiSubWindow_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SubWindowOption
    SbkPySide_QtGuiTypes[SBK_QMDISUBWINDOW_SUBWINDOWOPTION_IDX] = &SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type);
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
            "SubWindowOption",((PyObject*)&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type));

    // init flags class: QFlags<QMdiSubWindow::SubWindowOption>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QMDISUBWINDOW_SUBWINDOWOPTION__IDX] = &SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type);
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
            "SubWindowOptions",((PyObject*)&SbkPySide_QtGui_QMdiSubWindow_SubWindowOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type,
        (long) QMdiSubWindow::AllowOutsideAreaHorizontally, "AllowOutsideAreaHorizontally");
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
        "AllowOutsideAreaHorizontally", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type.tp_dict,
        "AllowOutsideAreaHorizontally", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type,
        (long) QMdiSubWindow::AllowOutsideAreaVertically, "AllowOutsideAreaVertically");
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
        "AllowOutsideAreaVertically", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type.tp_dict,
        "AllowOutsideAreaVertically", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type,
        (long) QMdiSubWindow::RubberBandResize, "RubberBandResize");
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
        "RubberBandResize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type.tp_dict,
        "RubberBandResize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type,
        (long) QMdiSubWindow::RubberBandMove, "RubberBandMove");
    PyDict_SetItemString(SbkQMdiSubWindow_Type.super.ht_type.tp_dict,
        "RubberBandMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMdiSubWindow_SubWindowOption_Type.tp_dict,
        "RubberBandMove", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMdiSubWindow::SubWindowOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QMdiSubWindow >("QMdiSubWindow*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMdiSubWindow >(typeid(QMdiSubWindow).name());
}


} // extern "C"

