/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qinputmethodevent_wrapper.h"
#include "qinputmethodevent_attribute_wrapper.h"

// Extra includes
#include <QInputMethodEvent>
#include <QList>
#include <qevent.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QInputMethodEventWrapper::QInputMethodEventWrapper() : QInputMethodEvent() {
    // ... middle
}

QInputMethodEventWrapper::QInputMethodEventWrapper(const QString & preeditText, const QList<QInputMethodEvent::Attribute > & attributes) : QInputMethodEvent(preeditText, attributes) {
    // ... middle
}

QInputMethodEventWrapper::~QInputMethodEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQInputMethodEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QInputMethodEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QInputMethodEvent", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QInputMethodEvent()
        cptr = new QInputMethodEventWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QList<QInputMethodEvent::Attribute >  >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QList<QInputMethodEvent::Attribute >  cpp_arg1 = Shiboken::Converter<QList<QInputMethodEvent::Attribute >  >::toCpp(pyargs[1]);
        // QInputMethodEvent(QString,QList<QInputMethodEvent::Attribute>)
        cptr = new QInputMethodEventWrapper(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QInputMethodEvent & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(pyargs[0]);
        // QInputMethodEvent(QInputMethodEvent)
        cptr = new QInputMethodEventWrapper(*reinterpret_cast<QInputMethodEventWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputMethodEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QInputMethodEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQInputMethodEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQInputMethodEvent_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QInputMethodEvent", "PySide.QtCore.QString, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputMethodEvent", overloads);
        return -1;
}

static PyObject* SbkQInputMethodEventFunc_attributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attributes()const
    QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
    const QList<QInputMethodEvent::Attribute > & cpp_result = cppSelf->QInputMethodEvent::attributes();
    py_result = Shiboken::Converter<QList<QInputMethodEvent::Attribute >  >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputMethodEventFunc_commitString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // commitString()const
    QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
    const QString & cpp_result = cppSelf->QInputMethodEvent::commitString();
    py_result = Shiboken::Converter<QString & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputMethodEventFunc_preeditString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // preeditString()const
    QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
    const QString & cpp_result = cppSelf->QInputMethodEvent::preeditString();
    py_result = Shiboken::Converter<QString & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputMethodEventFunc_replacementLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // replacementLength()const
    QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputMethodEvent::replacementLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputMethodEventFunc_replacementStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // replacementStart()const
    QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputMethodEvent::replacementStart();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputMethodEventFunc_setCommitString(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCommitString", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setCommitString(QString,int,int)
            QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
            cppSelf->QInputMethodEvent::setCommitString(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // setCommitString(QString,int,int)
                QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
                cppSelf->QInputMethodEvent::setCommitString(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // setCommitString(QString,int,int)
                QInputMethodEvent* cppSelf = Shiboken::Converter<QInputMethodEvent* >::toCpp((PyObject*)self);
                cppSelf->QInputMethodEvent::setCommitString(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQInputMethodEventFunc_setCommitString_TypeError;
        } else goto SbkQInputMethodEventFunc_setCommitString_TypeError;
    } else goto SbkQInputMethodEventFunc_setCommitString_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputMethodEventFunc_setCommitString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputMethodEvent.setCommitString", overloads);
        return 0;
}

static PyMethodDef SbkQInputMethodEvent_methods[] = {
    {"attributes", (PyCFunction)SbkQInputMethodEventFunc_attributes, METH_NOARGS},
    {"commitString", (PyCFunction)SbkQInputMethodEventFunc_commitString, METH_NOARGS},
    {"preeditString", (PyCFunction)SbkQInputMethodEventFunc_preeditString, METH_NOARGS},
    {"replacementLength", (PyCFunction)SbkQInputMethodEventFunc_replacementLength, METH_NOARGS},
    {"replacementStart", (PyCFunction)SbkQInputMethodEventFunc_replacementStart, METH_NOARGS},
    {"setCommitString", (PyCFunction)SbkQInputMethodEventFunc_setCommitString, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQInputMethodEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QInputMethodEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQInputMethodEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQInputMethodEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QInputMethodEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQInputMethodEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQInputMethodEvent_Type);
     if ( reinterpret_cast<QInputMethodEvent*>(cptr)->type() == QEvent::InputMethod)
        return &SbkQInputMethodEvent_Type;
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QInputMethodEvent_AttributeType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QInputMethodEvent_AttributeType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AttributeType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QInputMethodEvent_AttributeType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QInputMethodEvent_AttributeType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QInputMethodEvent_AttributeType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QInputMethodEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQInputMethodEvent_Type);

    SbkQInputMethodEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQInputMethodEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQInputMethodEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQInputMethodEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQInputMethodEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQInputMethodEvent_Type));
    PyModule_AddObject(module, "QInputMethodEvent",
        ((PyObject*)&SbkQInputMethodEvent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: AttributeType
    SbkPySide_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTETYPE_IDX] = &SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type);
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
            "AttributeType",((PyObject*)&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type,
        (long) QInputMethodEvent::TextFormat, "TextFormat");
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
        "TextFormat", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type.tp_dict,
        "TextFormat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type,
        (long) QInputMethodEvent::Cursor, "Cursor");
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
        "Cursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type.tp_dict,
        "Cursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type,
        (long) QInputMethodEvent::Language, "Language");
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
        "Language", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type.tp_dict,
        "Language", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type,
        (long) QInputMethodEvent::Ruby, "Ruby");
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
        "Ruby", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type.tp_dict,
        "Ruby", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type,
        (long) QInputMethodEvent::Selection, "Selection");
    PyDict_SetItemString(SbkQInputMethodEvent_Type.super.ht_type.tp_dict,
        "Selection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputMethodEvent_AttributeType_Type.tp_dict,
        "Selection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QInputMethodEvent::AttributeType");

    Shiboken::TypeResolver::createObjectTypeResolver<QInputMethodEvent >("QInputMethodEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QInputMethodEvent >(typeid(QInputMethodEvent).name());
}


} // extern "C"

