/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qinputdialog_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qinputdialog.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QInputDialogWrapper::QInputDialogWrapper(QWidget * parent, QFlags<Qt::WindowType> flags) : QInputDialog(parent, flags), m_metaObject(0) {
    // ... middle
}

void QInputDialogWrapper::accept()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "accept"));
    if (py_override.isNull()) {
        return this->QDialog::accept();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QDialog::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QInputDialogWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::done(int result)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "done"));
    if (py_override.isNull()) {
        return this->QInputDialog::done(result);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        result
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QInputDialogWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QInputDialogWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QInputDialogWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QInputDialogWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QInputDialogWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QDialog::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QInputDialogWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QInputDialogWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QInputDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QInputDialogWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::reject()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reject"));
    if (py_override.isNull()) {
        return this->QDialog::reject();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QDialog::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QInputDialog::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QDialog::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QInputDialogWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QInputDialog::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QInputDialog.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QInputDialogWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QInputDialogWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QInputDialogWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QInputDialogWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QInputDialog::staticMetaObject);
}
    return m_metaObject;
}

int QInputDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QInputDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QInputDialogWrapper::~QInputDialogWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQInputDialog_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QInputDialogWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QInputDialog", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QInputDialog(QWidget*,QFlags<Qt::WindowType>)
        cptr = new QInputDialogWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QInputDialog(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QInputDialogWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[1])) {
            QFlags<Qt::WindowType> cpp_arg1 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[1]);
            // QInputDialog(QWidget*,QFlags<Qt::WindowType>)
            cptr = new QInputDialogWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[0], self);
        } else goto SbkQInputDialog_Init_TypeError;
    } else goto SbkQInputDialog_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QInputDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQInputDialog_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQInputDialog_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog", overloads);
        return -1;
}

static PyObject* SbkQInputDialogFunc_cancelButtonText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cancelButtonText()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QInputDialog::cancelButtonText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_comboBoxItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // comboBoxItems()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QInputDialog::comboBoxItems();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_done(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // done(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::done(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_done_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_done_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.done", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_doubleDecimals(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleDecimals()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputDialog::doubleDecimals();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_doubleMaximum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleMaximum()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QInputDialog::doubleMaximum();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_doubleMinimum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleMinimum()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QInputDialog::doubleMinimum();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_doubleValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doubleValue()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    double cpp_result = cppSelf->QInputDialog::doubleValue();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_getDouble(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getDouble", 2, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
            // Begin code injection
            
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
            bool ok_;
            double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), 0, -2147483647, 2147483647, 1, &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            double cpp_arg3 = Shiboken::Converter<double >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
                // Begin code injection
                
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                bool ok_;
                double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, -2147483647, 2147483647, 1, &ok_, 0);
                py_result = Shiboken::makeTuple(retval_, ok_);
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                double cpp_arg4 = Shiboken::Converter<double >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, 2147483647, 1, &ok_, 0);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[5])) {
                    double cpp_arg5 = Shiboken::Converter<double >::toCpp(pyargs[5]);
                    if (numArgs == 6) {
                        // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
                        // Begin code injection
                        
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                        bool ok_;
                        double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, 1, &ok_, 0);
                        py_result = Shiboken::makeTuple(retval_, ok_);
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                        
                        // End of code injection


                        //CppGenerator::writeParentChildManagement
                    } else if (PyNumber_Check(pyargs[6])) {
                        int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                        if (numArgs == 7) {
                            // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, 0);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[7])) {
                            QFlags<Qt::WindowType> cpp_arg7 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[7]);
                            // getDouble(QWidget*,QString,QString,double,double,double,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            double retval_ = QInputDialog::getDouble(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, cpp_arg7);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else goto SbkQInputDialogFunc_getDouble_TypeError;
                    } else goto SbkQInputDialogFunc_getDouble_TypeError;
                } else goto SbkQInputDialogFunc_getDouble_TypeError;
            } else goto SbkQInputDialogFunc_getDouble_TypeError;
        } else goto SbkQInputDialogFunc_getDouble_TypeError;
    } else goto SbkQInputDialogFunc_getDouble_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_getDouble_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, float = 0, float = -2147483647, float = 2147483647, int = 1, bool, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.getDouble", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_getInt(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getInt", 2, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
            // Begin code injection
            
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
            bool ok_;
            int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), 0, -2147483647, 2147483647, 1, &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                // Begin code injection
                
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                bool ok_;
                int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, -2147483647, 2147483647, 1, &ok_, 0);
                py_result = Shiboken::makeTuple(retval_, ok_);
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, 2147483647, 1, &ok_, 0);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[5])) {
                    int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                    if (numArgs == 6) {
                        // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                        // Begin code injection
                        
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                        bool ok_;
                        int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, 1, &ok_, 0);
                        py_result = Shiboken::makeTuple(retval_, ok_);
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                        
                        // End of code injection


                        //CppGenerator::writeParentChildManagement
                    } else if (PyNumber_Check(pyargs[6])) {
                        int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                        if (numArgs == 7) {
                            // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, 0);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[7])) {
                            QFlags<Qt::WindowType> cpp_arg7 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[7]);
                            // getInt(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            int retval_ = QInputDialog::getInt(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, cpp_arg7);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else goto SbkQInputDialogFunc_getInt_TypeError;
                    } else goto SbkQInputDialogFunc_getInt_TypeError;
                } else goto SbkQInputDialogFunc_getInt_TypeError;
            } else goto SbkQInputDialogFunc_getInt_TypeError;
        } else goto SbkQInputDialogFunc_getInt_TypeError;
    } else goto SbkQInputDialogFunc_getInt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_getInt_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, int = 0, int = -2147483647, int = 2147483647, int = 1, bool, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.getInt", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_getInteger(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getInteger", 2, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
            // Begin code injection
            
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
            bool ok_;
            int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), 0, -2147483647, 2147483647, 1, &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                // Begin code injection
                
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                bool ok_;
                int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, -2147483647, 2147483647, 1, &ok_, 0);
                py_result = Shiboken::makeTuple(retval_, ok_);
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, 2147483647, 1, &ok_, 0);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[5])) {
                    int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                    if (numArgs == 6) {
                        // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                        // Begin code injection
                        
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                        bool ok_;
                        int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, 1, &ok_, 0);
                        py_result = Shiboken::makeTuple(retval_, ok_);
                        // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                        
                        // End of code injection


                        //CppGenerator::writeParentChildManagement
                    } else if (PyNumber_Check(pyargs[6])) {
                        int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                        if (numArgs == 7) {
                            // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, 0);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[7])) {
                            QFlags<Qt::WindowType> cpp_arg7 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[7]);
                            // getInteger(QWidget*,QString,QString,int,int,int,int,bool*,QFlags<Qt::WindowType>)
                            // Begin code injection
                            
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - START
                            bool ok_;
                            int retval_ = QInputDialog::getInteger(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, &ok_, cpp_arg7);
                            py_result = Shiboken::makeTuple(retval_, ok_);
                            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,arg,bool*,arg - END
                            
                            // End of code injection


                            //CppGenerator::writeParentChildManagement
                        } else goto SbkQInputDialogFunc_getInteger_TypeError;
                    } else goto SbkQInputDialogFunc_getInteger_TypeError;
                } else goto SbkQInputDialogFunc_getInteger_TypeError;
            } else goto SbkQInputDialogFunc_getInteger_TypeError;
        } else goto SbkQInputDialogFunc_getInteger_TypeError;
    } else goto SbkQInputDialogFunc_getInteger_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_getInteger_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, int = 0, int = -2147483647, int = 2147483647, int = 1, bool, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.getInteger", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_getItem(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getItem", 3, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg3_auto_ptr;
        QStringList* cpp_arg3 = Shiboken::Converter<QStringList* >::toCpp(pyargs[3]);
        if (!SbkQStringList_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QStringList >(cpp_arg3);
        if (numArgs == 4) {
            // getItem(QWidget*,QString,QString,QStringList,int,bool,bool*,QFlags<Qt::WindowType>)
            // Begin code injection
            
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - START
            bool ok_;
            QString retval_ = QInputDialog::getItem(cpp_arg0, (*cpp_arg1), (*cpp_arg2), (*cpp_arg3), 0, true, &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // getItem(QWidget*,QString,QString,QStringList,int,bool,bool*,QFlags<Qt::WindowType>)
                // Begin code injection
                
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - START
                bool ok_;
                QString retval_ = QInputDialog::getItem(cpp_arg0, (*cpp_arg1), (*cpp_arg2), (*cpp_arg3), cpp_arg4, true, &ok_, 0);
                py_result = Shiboken::makeTuple(retval_, ok_);
                // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - END
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                bool cpp_arg5 = Shiboken::Converter<bool >::toCpp(pyargs[5]);
                if (numArgs == 6) {
                    // getItem(QWidget*,QString,QString,QStringList,int,bool,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    QString retval_ = QInputDialog::getItem(cpp_arg0, (*cpp_arg1), (*cpp_arg2), (*cpp_arg3), cpp_arg4, cpp_arg5, &ok_, 0);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[6])) {
                    QFlags<Qt::WindowType> cpp_arg6 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[6]);
                    // getItem(QWidget*,QString,QString,QStringList,int,bool,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    QString retval_ = QInputDialog::getItem(cpp_arg0, (*cpp_arg1), (*cpp_arg2), (*cpp_arg3), cpp_arg4, cpp_arg5, &ok_, cpp_arg6);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else goto SbkQInputDialogFunc_getItem_TypeError;
            } else goto SbkQInputDialogFunc_getItem_TypeError;
        } else goto SbkQInputDialogFunc_getItem_TypeError;
    } else goto SbkQInputDialogFunc_getItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_getItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QStringList, int = 0, bool = true, bool, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.getItem", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_getText(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getText", 2, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (numArgs == 3) {
            // getText(QWidget*,QString,QString,QLineEdit::EchoMode,QString,bool*,QFlags<Qt::WindowType>)
            // Begin code injection
            
            // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - START
            bool ok_;
            QString retval_ = QInputDialog::getText(cpp_arg0, (*cpp_arg1), (*cpp_arg2), QLineEdit::Normal, QString(), &ok_, 0);
            py_result = Shiboken::makeTuple(retval_, ok_);
            // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLineEdit::EchoMode >::isConvertible(pyargs[3])) {
            QLineEdit::EchoMode cpp_arg3 = Shiboken::Converter<QLineEdit::EchoMode >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // getText(QWidget*,QString,QString,QLineEdit::EchoMode,QString,bool*,QFlags<Qt::WindowType>)
                // Begin code injection
                
                // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - START
                bool ok_;
                QString retval_ = QInputDialog::getText(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, QString(), &ok_, 0);
                py_result = Shiboken::makeTuple(retval_, ok_);
                // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - END
                
                // End of code injection


                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[4])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                    return 0;
                std::auto_ptr<QString > cpp_arg4_auto_ptr;
                QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
                if (!SbkQString_Check(pyargs[4]))
                    cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
                if (numArgs == 5) {
                    // getText(QWidget*,QString,QString,QLineEdit::EchoMode,QString,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    QString retval_ = QInputDialog::getText(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, (*cpp_arg4), &ok_, 0);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else if (SbkPySide_QtCore_Qt_WindowType_Check(pyargs[5])) {
                    QFlags<Qt::WindowType> cpp_arg5 = Shiboken::Converter<QFlags<Qt::WindowType> >::toCpp(pyargs[5]);
                    // getText(QWidget*,QString,QString,QLineEdit::EchoMode,QString,bool*,QFlags<Qt::WindowType>)
                    // Begin code injection
                    
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - START
                    bool ok_;
                    QString retval_ = QInputDialog::getText(cpp_arg0, (*cpp_arg1), (*cpp_arg2), cpp_arg3, (*cpp_arg4), &ok_, cpp_arg5);
                    py_result = Shiboken::makeTuple(retval_, ok_);
                    // TEMPLATE - fix_arg,arg,arg,arg,arg,bool*,arg - END
                    
                    // End of code injection


                    //CppGenerator::writeParentChildManagement
                } else goto SbkQInputDialogFunc_getText_TypeError;
            } else goto SbkQInputDialogFunc_getText_TypeError;
        } else goto SbkQInputDialogFunc_getText_TypeError;
    } else goto SbkQInputDialogFunc_getText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_getText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtGui.QLineEdit.EchoMode = QLineEdit.Normal, PySide.QtCore.QString = QString(), bool, PySide.QtCore.Qt.WindowFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.getText", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_inputMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputMode()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QInputDialog::InputMode cpp_result = cppSelf->QInputDialog::inputMode();
    py_result = Shiboken::Converter<QInputDialog::InputMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_intMaximum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // intMaximum()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputDialog::intMaximum();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_intMinimum(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // intMinimum()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputDialog::intMinimum();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_intStep(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // intStep()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputDialog::intStep();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_intValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // intValue()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QInputDialog::intValue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_isComboBoxEditable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isComboBoxEditable()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QInputDialog::isComboBoxEditable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_labelText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // labelText()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QInputDialog::labelText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QInputDialog::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_okButtonText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // okButtonText()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QInputDialog::okButtonText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQInputDialogFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // open()
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::open();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // open(QObject*,const char*)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::open(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_open_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_open_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.open", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setCancelButtonText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCancelButtonText(QString)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setCancelButtonText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setCancelButtonText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setCancelButtonText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setCancelButtonText", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setComboBoxEditable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setComboBoxEditable(bool)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setComboBoxEditable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setComboBoxEditable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setComboBoxEditable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setComboBoxEditable", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setComboBoxItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setComboBoxItems(QStringList)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setComboBoxItems(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setComboBoxItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setComboBoxItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setComboBoxItems", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setDoubleDecimals(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setDoubleDecimals(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setDoubleDecimals(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setDoubleDecimals_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setDoubleDecimals_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setDoubleDecimals", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setDoubleMaximum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setDoubleMaximum(double)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setDoubleMaximum(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setDoubleMaximum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setDoubleMaximum_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setDoubleMaximum", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setDoubleMinimum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setDoubleMinimum(double)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setDoubleMinimum(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setDoubleMinimum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setDoubleMinimum_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setDoubleMinimum", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setDoubleRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDoubleRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
        double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
        // setDoubleRange(double,double)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setDoubleRange(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setDoubleRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setDoubleRange_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.setDoubleRange", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setDoubleValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // setDoubleValue(double)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setDoubleValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setDoubleValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setDoubleValue_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setDoubleValue", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setInputMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputDialog::InputMode >::isConvertible(arg)) {
        QInputDialog::InputMode cpp_arg0 = Shiboken::Converter<QInputDialog::InputMode >::toCpp(arg);
        // setInputMode(QInputDialog::InputMode)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setInputMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setInputMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setInputMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputDialog.InputMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setInputMode", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setIntMaximum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIntMaximum(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setIntMaximum(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setIntMaximum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setIntMaximum_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setIntMaximum", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setIntMinimum(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIntMinimum(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setIntMinimum(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setIntMinimum_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setIntMinimum_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setIntMinimum", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setIntRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setIntRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setIntRange(int,int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setIntRange(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setIntRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setIntRange_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.setIntRange", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setIntStep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIntStep(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setIntStep(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setIntStep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setIntStep_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setIntStep", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setIntValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIntValue(int)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setIntValue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setIntValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setIntValue_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setIntValue", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setLabelText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setLabelText(QString)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setLabelText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setLabelText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setLabelText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setLabelText", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setOkButtonText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOkButtonText(QString)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setOkButtonText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setOkButtonText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setOkButtonText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setOkButtonText", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setOption(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setOption", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QInputDialog::InputDialogOption >::isConvertible(pyargs[0])) {
        QInputDialog::InputDialogOption cpp_arg0 = Shiboken::Converter<QInputDialog::InputDialogOption >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setOption(QInputDialog::InputDialogOption,bool)
            QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
            cppSelf->QInputDialog::setOption(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setOption(QInputDialog::InputDialogOption,bool)
            QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
            cppSelf->QInputDialog::setOption(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQInputDialogFunc_setOption_TypeError;
    } else goto SbkQInputDialogFunc_setOption_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputDialog.InputDialogOption, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QInputDialog.setOption", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setTextEchoMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLineEdit::EchoMode >::isConvertible(arg)) {
        QLineEdit::EchoMode cpp_arg0 = Shiboken::Converter<QLineEdit::EchoMode >::toCpp(arg);
        // setTextEchoMode(QLineEdit::EchoMode)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setTextEchoMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setTextEchoMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setTextEchoMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLineEdit.EchoMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setTextEchoMode", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setTextValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setTextValue(QString)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setTextValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setTextValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setTextValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setTextValue", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        cppSelf->QInputDialog::setVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQInputDialogFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.setVisible", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QInputDialog::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_testOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QInputDialog::InputDialogOption >::isConvertible(arg)) {
        QInputDialog::InputDialogOption cpp_arg0 = Shiboken::Converter<QInputDialog::InputDialogOption >::toCpp(arg);
        // testOption(QInputDialog::InputDialogOption)const
        QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QInputDialog::testOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQInputDialogFunc_testOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQInputDialogFunc_testOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputDialog.InputDialogOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QInputDialog.testOption", overloads);
        return 0;
}

static PyObject* SbkQInputDialogFunc_textEchoMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textEchoMode()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QLineEdit::EchoMode cpp_result = cppSelf->QInputDialog::textEchoMode();
    py_result = Shiboken::Converter<QLineEdit::EchoMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQInputDialogFunc_textValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textValue()const
    QInputDialog* cppSelf = Shiboken::Converter<QInputDialog* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QInputDialog::textValue();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQInputDialog_methods[] = {
    {"cancelButtonText", (PyCFunction)SbkQInputDialogFunc_cancelButtonText, METH_NOARGS},
    {"comboBoxItems", (PyCFunction)SbkQInputDialogFunc_comboBoxItems, METH_NOARGS},
    {"done", (PyCFunction)SbkQInputDialogFunc_done, METH_O},
    {"doubleDecimals", (PyCFunction)SbkQInputDialogFunc_doubleDecimals, METH_NOARGS},
    {"doubleMaximum", (PyCFunction)SbkQInputDialogFunc_doubleMaximum, METH_NOARGS},
    {"doubleMinimum", (PyCFunction)SbkQInputDialogFunc_doubleMinimum, METH_NOARGS},
    {"doubleValue", (PyCFunction)SbkQInputDialogFunc_doubleValue, METH_NOARGS},
    {"getDouble", (PyCFunction)SbkQInputDialogFunc_getDouble, METH_VARARGS|METH_STATIC},
    {"getInt", (PyCFunction)SbkQInputDialogFunc_getInt, METH_VARARGS|METH_STATIC},
    {"getInteger", (PyCFunction)SbkQInputDialogFunc_getInteger, METH_VARARGS|METH_STATIC},
    {"getItem", (PyCFunction)SbkQInputDialogFunc_getItem, METH_VARARGS|METH_STATIC},
    {"getText", (PyCFunction)SbkQInputDialogFunc_getText, METH_VARARGS|METH_STATIC},
    {"inputMode", (PyCFunction)SbkQInputDialogFunc_inputMode, METH_NOARGS},
    {"intMaximum", (PyCFunction)SbkQInputDialogFunc_intMaximum, METH_NOARGS},
    {"intMinimum", (PyCFunction)SbkQInputDialogFunc_intMinimum, METH_NOARGS},
    {"intStep", (PyCFunction)SbkQInputDialogFunc_intStep, METH_NOARGS},
    {"intValue", (PyCFunction)SbkQInputDialogFunc_intValue, METH_NOARGS},
    {"isComboBoxEditable", (PyCFunction)SbkQInputDialogFunc_isComboBoxEditable, METH_NOARGS},
    {"labelText", (PyCFunction)SbkQInputDialogFunc_labelText, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQInputDialogFunc_minimumSizeHint, METH_NOARGS},
    {"okButtonText", (PyCFunction)SbkQInputDialogFunc_okButtonText, METH_NOARGS},
    {"open", (PyCFunction)SbkQInputDialogFunc_open, METH_VARARGS},
    {"setCancelButtonText", (PyCFunction)SbkQInputDialogFunc_setCancelButtonText, METH_O},
    {"setComboBoxEditable", (PyCFunction)SbkQInputDialogFunc_setComboBoxEditable, METH_O},
    {"setComboBoxItems", (PyCFunction)SbkQInputDialogFunc_setComboBoxItems, METH_O},
    {"setDoubleDecimals", (PyCFunction)SbkQInputDialogFunc_setDoubleDecimals, METH_O},
    {"setDoubleMaximum", (PyCFunction)SbkQInputDialogFunc_setDoubleMaximum, METH_O},
    {"setDoubleMinimum", (PyCFunction)SbkQInputDialogFunc_setDoubleMinimum, METH_O},
    {"setDoubleRange", (PyCFunction)SbkQInputDialogFunc_setDoubleRange, METH_VARARGS},
    {"setDoubleValue", (PyCFunction)SbkQInputDialogFunc_setDoubleValue, METH_O},
    {"setInputMode", (PyCFunction)SbkQInputDialogFunc_setInputMode, METH_O},
    {"setIntMaximum", (PyCFunction)SbkQInputDialogFunc_setIntMaximum, METH_O},
    {"setIntMinimum", (PyCFunction)SbkQInputDialogFunc_setIntMinimum, METH_O},
    {"setIntRange", (PyCFunction)SbkQInputDialogFunc_setIntRange, METH_VARARGS},
    {"setIntStep", (PyCFunction)SbkQInputDialogFunc_setIntStep, METH_O},
    {"setIntValue", (PyCFunction)SbkQInputDialogFunc_setIntValue, METH_O},
    {"setLabelText", (PyCFunction)SbkQInputDialogFunc_setLabelText, METH_O},
    {"setOkButtonText", (PyCFunction)SbkQInputDialogFunc_setOkButtonText, METH_O},
    {"setOption", (PyCFunction)SbkQInputDialogFunc_setOption, METH_VARARGS},
    {"setTextEchoMode", (PyCFunction)SbkQInputDialogFunc_setTextEchoMode, METH_O},
    {"setTextValue", (PyCFunction)SbkQInputDialogFunc_setTextValue, METH_O},
    {"setVisible", (PyCFunction)SbkQInputDialogFunc_setVisible, METH_O},
    {"sizeHint", (PyCFunction)SbkQInputDialogFunc_sizeHint, METH_NOARGS},
    {"testOption", (PyCFunction)SbkQInputDialogFunc_testOption, METH_O},
    {"textEchoMode", (PyCFunction)SbkQInputDialogFunc_textEchoMode, METH_NOARGS},
    {"textValue", (PyCFunction)SbkQInputDialogFunc_textValue, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQInputDialogSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QInputDialog* me = reinterpret_cast<QInputDialog*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX]))
        return static_cast<QDialog*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQInputDialog_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QInputDialog",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQInputDialog_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQInputDialog_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQInputDialogSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QInputDialog >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QInputDialog_InputMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QInputDialog_InputMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QInputDialog_InputMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QInputDialog_InputMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QInputDialog_InputMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QInputDialog_InputMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QInputDialog_InputDialogOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QInputDialog_InputDialogOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QInputDialog_InputDialogOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputDialogOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QInputDialog_InputDialogOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QInputDialog_InputDialogOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QInputDialog_InputDialogOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QInputDialog(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQInputDialog_Type);

    SbkQInputDialog_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDIALOG_IDX];
    SbkQInputDialog_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQInputDialog_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQInputDialog_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQInputDialog_Type));
    PyModule_AddObject(module, "QInputDialog",
        ((PyObject*)&SbkQInputDialog_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InputMode
    SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTMODE_IDX] = &SbkPySide_QtGui_QInputDialog_InputMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QInputDialog_InputMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QInputDialog_InputMode_Type);
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
            "InputMode",((PyObject*)&SbkPySide_QtGui_QInputDialog_InputMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputDialog_InputMode_Type,
        (long) QInputDialog::TextInput, "TextInput");
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
        "TextInput", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputDialog_InputMode_Type.tp_dict,
        "TextInput", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputDialog_InputMode_Type,
        (long) QInputDialog::IntInput, "IntInput");
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
        "IntInput", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputDialog_InputMode_Type.tp_dict,
        "IntInput", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputDialog_InputMode_Type,
        (long) QInputDialog::DoubleInput, "DoubleInput");
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
        "DoubleInput", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputDialog_InputMode_Type.tp_dict,
        "DoubleInput", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QInputDialog::InputMode");

    // init enum class: InputDialogOption
    SbkPySide_QtGuiTypes[SBK_QINPUTDIALOG_INPUTDIALOGOPTION_IDX] = &SbkPySide_QtGui_QInputDialog_InputDialogOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QInputDialog_InputDialogOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QInputDialog_InputDialogOption_Type);
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
            "InputDialogOption",((PyObject*)&SbkPySide_QtGui_QInputDialog_InputDialogOption_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputDialog_InputDialogOption_Type,
        (long) QInputDialog::NoButtons, "NoButtons");
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
        "NoButtons", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputDialog_InputDialogOption_Type.tp_dict,
        "NoButtons", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QInputDialog_InputDialogOption_Type,
        (long) QInputDialog::UseListViewForComboBoxItems, "UseListViewForComboBoxItems");
    PyDict_SetItemString(SbkQInputDialog_Type.super.ht_type.tp_dict,
        "UseListViewForComboBoxItems", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QInputDialog_InputDialogOption_Type.tp_dict,
        "UseListViewForComboBoxItems", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QInputDialog::InputDialogOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QInputDialog >("QInputDialog*");
    Shiboken::TypeResolver::createObjectTypeResolver<QInputDialog >(typeid(QInputDialog).name());
}


} // extern "C"

