/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qconicalgradient_wrapper.h"

// Extra includes
#include <QPair>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQConicalGradient_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QConicalGradient* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QConicalGradient", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QConicalGradient()
        cptr = new QConicalGradient();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // QConicalGradient(qreal,qreal,qreal)
        cptr = new QConicalGradient(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // QConicalGradient(QPointF,qreal)
        cptr = new QConicalGradient(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QConicalGradient & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QConicalGradient* cpp_arg0 = Shiboken::Converter<QConicalGradient* >::toCpp(pyargs[0]);
        // QConicalGradient(QConicalGradient)
        cptr = new QConicalGradient(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQConicalGradient_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QConicalGradient >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQConicalGradient_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQConicalGradient_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QConicalGradient", "", "PySide.QtCore.QPointF, float", "float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QConicalGradient", overloads);
        return -1;
}

static PyObject* SbkQConicalGradientFunc_angle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // angle()const
    QConicalGradient* cppSelf = Shiboken::Converter<QConicalGradient* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QConicalGradient::angle();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQConicalGradientFunc_center(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // center()const
    QConicalGradient* cppSelf = Shiboken::Converter<QConicalGradient* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QConicalGradient::center();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQConicalGradientFunc_setAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAngle(qreal)
        QConicalGradient* cppSelf = Shiboken::Converter<QConicalGradient* >::toCpp((PyObject*)self);
        cppSelf->QConicalGradient::setAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQConicalGradientFunc_setAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQConicalGradientFunc_setAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QConicalGradient.setAngle", overloads);
        return 0;
}

static PyObject* SbkQConicalGradientFunc_setCenter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCenter", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setCenter(qreal,qreal)
        QConicalGradient* cppSelf = Shiboken::Converter<QConicalGradient* >::toCpp((PyObject*)self);
        cppSelf->QConicalGradient::setCenter(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setCenter(QPointF)
        QConicalGradient* cppSelf = Shiboken::Converter<QConicalGradient* >::toCpp((PyObject*)self);
        cppSelf->QConicalGradient::setCenter(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQConicalGradientFunc_setCenter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQConicalGradientFunc_setCenter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QConicalGradient.setCenter", overloads);
        return 0;
}

static PyMethodDef SbkQConicalGradient_methods[] = {
    {"angle", (PyCFunction)SbkQConicalGradientFunc_angle, METH_NOARGS},
    {"center", (PyCFunction)SbkQConicalGradientFunc_center, METH_NOARGS},
    {"setAngle", (PyCFunction)SbkQConicalGradientFunc_setAngle, METH_O},
    {"setCenter", (PyCFunction)SbkQConicalGradientFunc_setCenter, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQConicalGradient_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QConicalGradient",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQConicalGradient_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQConicalGradient_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QConicalGradient >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QConicalGradient(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCONICALGRADIENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQConicalGradient_Type);

    SbkQConicalGradient_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRADIENT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQConicalGradient_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQConicalGradient_Type));
    PyModule_AddObject(module, "QConicalGradient",
        ((PyObject*)&SbkQConicalGradient_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QConicalGradient >("QConicalGradient");
    Shiboken::TypeResolver::createValueTypeResolver<QConicalGradient >(typeid(QConicalGradient).name());
}


} // extern "C"

