/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qcompleter_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qbytearray.h>
#include <qcompleter.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qrect.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QCompleterWrapper::QCompleterWrapper(QAbstractItemModel * model, QObject * parent) : QCompleter(model, parent), m_metaObject(0) {
    // ... middle
}

QCompleterWrapper::QCompleterWrapper(QObject * parent) : QCompleter(parent), m_metaObject(0) {
    // ... middle
}

QCompleterWrapper::QCompleterWrapper(const QStringList & completions, QObject * parent) : QCompleter(completions, parent), m_metaObject(0) {
    // ... middle
}

void QCompleterWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCompleterWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCompleterWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCompleterWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QCompleterWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QCompleter::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QCompleterWrapper::eventFilter(QObject * o, QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QCompleter::eventFilter(o, e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(o),
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QCompleterWrapper::pathFromIndex(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pathFromIndex"));
    if (py_override.isNull()) {
        return this->QCompleter::pathFromIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.pathFromIndex", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QStringList QCompleterWrapper::splitPath(const QString & path) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "splitPath"));
    if (py_override.isNull()) {
        return this->QCompleter::splitPath(path);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(path)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QCompleter.splitPath", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

void QCompleterWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QCompleterWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QCompleter::staticMetaObject);
}
    return m_metaObject;
}

int QCompleterWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QCompleter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QCompleterWrapper::~QCompleterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQCompleter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCompleterWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QCompleter", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QCompleter(QObject*)
        cptr = new QCompleterWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QStringList & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!SbkQStringList_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // QCompleter(QStringList,QObject*)
            cptr = new QCompleterWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QCompleter(QStringList,QObject*)
            cptr = new QCompleterWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQCompleter_Init_TypeError;
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QCompleter(QObject*)
        cptr = new QCompleterWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QAbstractItemModel * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QCompleter(QAbstractItemModel*,QObject*)
            cptr = new QCompleterWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QCompleter(QAbstractItemModel*,QObject*)
            cptr = new QCompleterWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQCompleter_Init_TypeError;
    } else goto SbkQCompleter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QCompleter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQCompleter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQCompleter_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel, PySide.QtCore.QObject = None", "PySide.QtCore.QObject = None", "PySide.QtCore.QStringList, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCompleter", overloads);
        return -1;
}

static PyObject* SbkQCompleterFunc_caseSensitivity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // caseSensitivity()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    Qt::CaseSensitivity cpp_result = cppSelf->QCompleter::caseSensitivity();
    py_result = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_complete(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // complete(QRect)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::complete();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // complete(QRect)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::complete(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_complete_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_complete_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect = QRect()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.complete", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_completionColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionColumn()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCompleter::completionColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_completionCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionCount()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCompleter::completionCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_completionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionMode()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QCompleter::CompletionMode cpp_result = cppSelf->QCompleter::completionMode();
    py_result = Shiboken::Converter<QCompleter::CompletionMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_completionModel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionModel()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QCompleter::completionModel();
    py_result = Shiboken::Converter<QAbstractItemModel * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_completionPrefix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionPrefix()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QCompleter::completionPrefix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_completionRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completionRole()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCompleter::completionRole();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_currentCompletion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentCompletion()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QCompleter::currentCompletion();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QCompleter::currentIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_currentRow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentRow()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCompleter::currentRow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCompleter::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCompleterFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.event", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCompleter::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCompleterFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCompleter.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_maxVisibleItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxVisibleItems()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QCompleter::maxVisibleItems();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QCompleter::model();
    py_result = Shiboken::Converter<QAbstractItemModel * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_modelSorting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modelSorting()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QCompleter::ModelSorting cpp_result = cppSelf->QCompleter::modelSorting();
    py_result = Shiboken::Converter<QCompleter::ModelSorting >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_pathFromIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // pathFromIndex(QModelIndex)const
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QCompleter::pathFromIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_pathFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCompleterFunc_pathFromIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.pathFromIndex", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_popup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // popup()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QAbstractItemView * cpp_result = cppSelf->QCompleter::popup();
    py_result = Shiboken::Converter<QAbstractItemView * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_setCaseSensitivity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);
        // setCaseSensitivity(Qt::CaseSensitivity)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setCaseSensitivity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCaseSensitivity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCaseSensitivity", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setCompletionColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCompletionColumn(int)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setCompletionColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCompletionColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setCompletionColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCompletionColumn", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setCompletionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCompleter::CompletionMode >::isConvertible(arg)) {
        QCompleter::CompletionMode cpp_arg0 = Shiboken::Converter<QCompleter::CompletionMode >::toCpp(arg);
        // setCompletionMode(QCompleter::CompletionMode)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setCompletionMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCompletionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setCompletionMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCompleter.CompletionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCompletionMode", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setCompletionPrefix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCompletionPrefix(QString)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setCompletionPrefix(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCompletionPrefix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setCompletionPrefix_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCompletionPrefix", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setCompletionRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCompletionRole(int)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setCompletionRole(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCompletionRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setCompletionRole_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCompletionRole", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setCurrentRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentRow(int)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCompleter::setCurrentRow(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setCurrentRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCompleterFunc_setCurrentRow_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setCurrentRow", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setMaxVisibleItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaxVisibleItems(int)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setMaxVisibleItems(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setMaxVisibleItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setMaxVisibleItems_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setMaxVisibleItems", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setModel(cpp_arg0);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModel(QAbstractItemModel*)1", arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setModel", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setModelSorting(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCompleter::ModelSorting >::isConvertible(arg)) {
        QCompleter::ModelSorting cpp_arg0 = Shiboken::Converter<QCompleter::ModelSorting >::toCpp(arg);
        // setModelSorting(QCompleter::ModelSorting)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setModelSorting(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setModelSorting_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setModelSorting_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCompleter.ModelSorting", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setModelSorting", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setPopup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemView* cpp_arg0 = Shiboken::Converter<QAbstractItemView* >::toCpp(arg);
        // setPopup(QAbstractItemView*)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setPopup(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQCompleterFunc_setPopup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setPopup_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setPopup", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setWidget(QWidget*)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQCompleterFunc_setWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setWidget", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_setWrapAround(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWrapAround(bool)
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        cppSelf->QCompleter::setWrapAround(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_setWrapAround_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCompleterFunc_setWrapAround_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.setWrapAround", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_splitPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // splitPath(QString)const
        QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QCompleter::splitPath(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCompleterFunc_splitPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCompleterFunc_splitPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCompleter.splitPath", overloads);
        return 0;
}

static PyObject* SbkQCompleterFunc_widget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widget()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QCompleter::widget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCompleterFunc_wrapAround(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wrapAround()const
    QCompleter* cppSelf = Shiboken::Converter<QCompleter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QCompleter::wrapAround();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQCompleter_methods[] = {
    {"caseSensitivity", (PyCFunction)SbkQCompleterFunc_caseSensitivity, METH_NOARGS},
    {"complete", (PyCFunction)SbkQCompleterFunc_complete, METH_NOARGS|METH_O},
    {"completionColumn", (PyCFunction)SbkQCompleterFunc_completionColumn, METH_NOARGS},
    {"completionCount", (PyCFunction)SbkQCompleterFunc_completionCount, METH_NOARGS},
    {"completionMode", (PyCFunction)SbkQCompleterFunc_completionMode, METH_NOARGS},
    {"completionModel", (PyCFunction)SbkQCompleterFunc_completionModel, METH_NOARGS},
    {"completionPrefix", (PyCFunction)SbkQCompleterFunc_completionPrefix, METH_NOARGS},
    {"completionRole", (PyCFunction)SbkQCompleterFunc_completionRole, METH_NOARGS},
    {"currentCompletion", (PyCFunction)SbkQCompleterFunc_currentCompletion, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQCompleterFunc_currentIndex, METH_NOARGS},
    {"currentRow", (PyCFunction)SbkQCompleterFunc_currentRow, METH_NOARGS},
    {"event", (PyCFunction)SbkQCompleterFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQCompleterFunc_eventFilter, METH_VARARGS},
    {"maxVisibleItems", (PyCFunction)SbkQCompleterFunc_maxVisibleItems, METH_NOARGS},
    {"model", (PyCFunction)SbkQCompleterFunc_model, METH_NOARGS},
    {"modelSorting", (PyCFunction)SbkQCompleterFunc_modelSorting, METH_NOARGS},
    {"pathFromIndex", (PyCFunction)SbkQCompleterFunc_pathFromIndex, METH_O},
    {"popup", (PyCFunction)SbkQCompleterFunc_popup, METH_NOARGS},
    {"setCaseSensitivity", (PyCFunction)SbkQCompleterFunc_setCaseSensitivity, METH_O},
    {"setCompletionColumn", (PyCFunction)SbkQCompleterFunc_setCompletionColumn, METH_O},
    {"setCompletionMode", (PyCFunction)SbkQCompleterFunc_setCompletionMode, METH_O},
    {"setCompletionPrefix", (PyCFunction)SbkQCompleterFunc_setCompletionPrefix, METH_O},
    {"setCompletionRole", (PyCFunction)SbkQCompleterFunc_setCompletionRole, METH_O},
    {"setCurrentRow", (PyCFunction)SbkQCompleterFunc_setCurrentRow, METH_O},
    {"setMaxVisibleItems", (PyCFunction)SbkQCompleterFunc_setMaxVisibleItems, METH_O},
    {"setModel", (PyCFunction)SbkQCompleterFunc_setModel, METH_O},
    {"setModelSorting", (PyCFunction)SbkQCompleterFunc_setModelSorting, METH_O},
    {"setPopup", (PyCFunction)SbkQCompleterFunc_setPopup, METH_O},
    {"setWidget", (PyCFunction)SbkQCompleterFunc_setWidget, METH_O},
    {"setWrapAround", (PyCFunction)SbkQCompleterFunc_setWrapAround, METH_O},
    {"splitPath", (PyCFunction)SbkQCompleterFunc_splitPath, METH_O},
    {"widget", (PyCFunction)SbkQCompleterFunc_widget, METH_NOARGS},
    {"wrapAround", (PyCFunction)SbkQCompleterFunc_wrapAround, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCompleter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QCompleter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCompleter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCompleter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QCompleter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QCompleter_ModelSorting_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QCompleter_ModelSorting_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QCompleter_ModelSorting_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ModelSorting",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QCompleter_ModelSorting_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QCompleter_ModelSorting_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QCompleter_ModelSorting_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QCompleter_CompletionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QCompleter_CompletionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QCompleter_CompletionMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CompletionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QCompleter_CompletionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QCompleter_CompletionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QCompleter_CompletionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QCompleter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCOMPLETER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCompleter_Type);

    SbkQCompleter_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQCompleter_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQCompleter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCompleter_Type));
    PyModule_AddObject(module, "QCompleter",
        ((PyObject*)&SbkQCompleter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ModelSorting
    SbkPySide_QtGuiTypes[SBK_QCOMPLETER_MODELSORTING_IDX] = &SbkPySide_QtGui_QCompleter_ModelSorting_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QCompleter_ModelSorting_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QCompleter_ModelSorting_Type);
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
            "ModelSorting",((PyObject*)&SbkPySide_QtGui_QCompleter_ModelSorting_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_ModelSorting_Type,
        (long) QCompleter::UnsortedModel, "UnsortedModel");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "UnsortedModel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_ModelSorting_Type.tp_dict,
        "UnsortedModel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_ModelSorting_Type,
        (long) QCompleter::CaseSensitivelySortedModel, "CaseSensitivelySortedModel");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "CaseSensitivelySortedModel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_ModelSorting_Type.tp_dict,
        "CaseSensitivelySortedModel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_ModelSorting_Type,
        (long) QCompleter::CaseInsensitivelySortedModel, "CaseInsensitivelySortedModel");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "CaseInsensitivelySortedModel", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_ModelSorting_Type.tp_dict,
        "CaseInsensitivelySortedModel", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCompleter::ModelSorting");

    // init enum class: CompletionMode
    SbkPySide_QtGuiTypes[SBK_QCOMPLETER_COMPLETIONMODE_IDX] = &SbkPySide_QtGui_QCompleter_CompletionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QCompleter_CompletionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QCompleter_CompletionMode_Type);
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
            "CompletionMode",((PyObject*)&SbkPySide_QtGui_QCompleter_CompletionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_CompletionMode_Type,
        (long) QCompleter::PopupCompletion, "PopupCompletion");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "PopupCompletion", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_CompletionMode_Type.tp_dict,
        "PopupCompletion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_CompletionMode_Type,
        (long) QCompleter::UnfilteredPopupCompletion, "UnfilteredPopupCompletion");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "UnfilteredPopupCompletion", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_CompletionMode_Type.tp_dict,
        "UnfilteredPopupCompletion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QCompleter_CompletionMode_Type,
        (long) QCompleter::InlineCompletion, "InlineCompletion");
    PyDict_SetItemString(SbkQCompleter_Type.super.ht_type.tp_dict,
        "InlineCompletion", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QCompleter_CompletionMode_Type.tp_dict,
        "InlineCompletion", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCompleter::CompletionMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QCompleter >("QCompleter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCompleter >(typeid(QCompleter).name());
}


} // extern "C"

