/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qaccessibleevent_wrapper.h"

// Extra includes
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAccessibleEventWrapper::QAccessibleEventWrapper(QEvent::Type type, int child) : QAccessibleEvent(type, child) {
    // ... middle
}

QAccessibleEventWrapper::~QAccessibleEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAccessibleEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAccessibleEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QAccessibleEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QAccessibleEvent(QEvent::Type,int)
        cptr = new QAccessibleEventWrapper(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAccessibleEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAccessibleEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAccessibleEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAccessibleEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAccessibleEvent", overloads);
        return -1;
}

static PyObject* SbkQAccessibleEventFunc_child(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // child()const
    QAccessibleEvent* cppSelf = Shiboken::Converter<QAccessibleEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QAccessibleEvent::child();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAccessibleEventFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setValue(QString)
        QAccessibleEvent* cppSelf = Shiboken::Converter<QAccessibleEvent* >::toCpp((PyObject*)self);
        cppSelf->QAccessibleEvent::setValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAccessibleEventFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAccessibleEventFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAccessibleEvent.setValue", overloads);
        return 0;
}

static PyObject* SbkQAccessibleEventFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QAccessibleEvent* cppSelf = Shiboken::Converter<QAccessibleEvent* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAccessibleEvent::value();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAccessibleEvent_methods[] = {
    {"child", (PyCFunction)SbkQAccessibleEventFunc_child, METH_NOARGS},
    {"setValue", (PyCFunction)SbkQAccessibleEventFunc_setValue, METH_O},
    {"value", (PyCFunction)SbkQAccessibleEventFunc_value, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAccessibleEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAccessibleEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAccessibleEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAccessibleEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAccessibleEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAccessibleEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAccessibleEvent_Type);
     if ( reinterpret_cast<QAccessibleEvent*>(cptr)->type() == QEvent::AccessibilityDescription ||  reinterpret_cast<QAccessibleEvent*>(cptr)->type() == QEvent::AccessibilityHelp)
        return &SbkQAccessibleEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QAccessibleEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QACCESSIBLEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAccessibleEvent_Type);

    SbkQAccessibleEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQAccessibleEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQAccessibleEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAccessibleEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAccessibleEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAccessibleEvent_Type));
    PyModule_AddObject(module, "QAccessibleEvent",
        ((PyObject*)&SbkQAccessibleEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAccessibleEvent >("QAccessibleEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAccessibleEvent >(typeid(QAccessibleEvent).name());
}


} // extern "C"

