/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsysinfo_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQSysInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSysInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QSysInfo()
    cptr = new QSysInfo();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSysInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyMethodDef SbkQSysInfo_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSysInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSysInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSysInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSysInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSysInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QSysInfo_Endian_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSysInfo_Endian_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSysInfo_Endian_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Endian",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSysInfo_Endian_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSysInfo_Endian_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QSysInfo_Endian_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QSysInfo_Sizes_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QSysInfo_Sizes_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QSysInfo_Sizes_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Sizes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QSysInfo_Sizes_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QSysInfo_Sizes_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QSysInfo_Sizes_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QSysInfo(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSYSINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSysInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSysInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSysInfo_Type));
    PyModule_AddObject(module, "QSysInfo",
        ((PyObject*)&SbkQSysInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Endian
    SbkPySide_QtCoreTypes[SBK_QSYSINFO_ENDIAN_IDX] = &SbkPySide_QtCore_QSysInfo_Endian_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSysInfo_Endian_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSysInfo_Endian_Type);
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
            "Endian",((PyObject*)&SbkPySide_QtCore_QSysInfo_Endian_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSysInfo_Endian_Type,
        (long) QSysInfo::BigEndian, "BigEndian");
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
        "BigEndian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSysInfo_Endian_Type.tp_dict,
        "BigEndian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSysInfo_Endian_Type,
        (long) QSysInfo::LittleEndian, "LittleEndian");
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
        "LittleEndian", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSysInfo_Endian_Type.tp_dict,
        "LittleEndian", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSysInfo_Endian_Type,
        (long) QSysInfo::ByteOrder, "ByteOrder");
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
        "ByteOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSysInfo_Endian_Type.tp_dict,
        "ByteOrder", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSysInfo::Endian");

    // init enum class: Sizes
    SbkPySide_QtCoreTypes[SBK_QSYSINFO_SIZES_IDX] = &SbkPySide_QtCore_QSysInfo_Sizes_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QSysInfo_Sizes_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QSysInfo_Sizes_Type);
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
            "Sizes",((PyObject*)&SbkPySide_QtCore_QSysInfo_Sizes_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QSysInfo_Sizes_Type,
        (long) QSysInfo::WordSize, "WordSize");
    PyDict_SetItemString(SbkQSysInfo_Type.super.ht_type.tp_dict,
        "WordSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QSysInfo_Sizes_Type.tp_dict,
        "WordSize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSysInfo::Sizes");

    Shiboken::TypeResolver::createObjectTypeResolver<QSysInfo >("QSysInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSysInfo >(typeid(QSysInfo).name());
}


} // extern "C"

