/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qstate_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractstate.h>
#include <qabstracttransition.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsignaltransition.h>
#include <qstate.h>
#include <qstatemachine.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStateWrapper::QStateWrapper(QState * parent) : QState(parent), m_metaObject(0) {
    // ... middle
}

QStateWrapper::QStateWrapper(QState::ChildMode childMode, QState * parent) : QState(childMode, parent), m_metaObject(0) {
    // ... middle
}

void QStateWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStateWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStateWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStateWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QState::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QState.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStateWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QState.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QStateWrapper::onEntry(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onEntry"));
    if (py_override.isNull()) {
        return this->QState::onEntry(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateWrapper::onExit(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onExit"));
    if (py_override.isNull()) {
        return this->QState::onExit(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QStateWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QState::staticMetaObject);
}
    return m_metaObject;
}

int QStateWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QState::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStateWrapper::~QStateWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQState_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStateWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QState", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QState(QState*)
        cptr = new QStateWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QState::ChildMode >::isConvertible(pyargs[0])) {
        QState::ChildMode cpp_arg0 = Shiboken::Converter<QState::ChildMode >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QState(QState::ChildMode,QState*)
            cptr = new QStateWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QState * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QState* cpp_arg1 = Shiboken::Converter<QState* >::toCpp(pyargs[1]);
            // QState(QState::ChildMode,QState*)
            cptr = new QStateWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQState_Init_TypeError;
    } else if (Shiboken::Converter<QState * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QState* cpp_arg0 = Shiboken::Converter<QState* >::toCpp(pyargs[0]);
        // QState(QState*)
        cptr = new QStateWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQState_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QState >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQState_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQState_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QState = None", "PySide.QtCore.QState.ChildMode, PySide.QtCore.QState = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QState", overloads);
        return -1;
}

static PyObject* SbkQStateFunc_addTransition(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQStateFunc_addTransition_TypeError;

    if (!PyArg_UnpackTuple(args, "addTransition", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<QAbstractState * >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QAbstractState* cpp_arg2 = Shiboken::Converter<QAbstractState* >::toCpp(pyargs[2]);
        // addTransition(QObject*,const char*,QAbstractState*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        // Begin code injection
        
        QString signalName(cpp_arg1);
        if (PySide::SignalManager::registerMetaMethod(cpp_arg0, signalName.mid(1).toAscii().data(), QMetaMethod::Signal)) {
          py_result = Shiboken::Converter<QSignalTransition* >::toPython(cppSelf->addTransition(cpp_arg0, cpp_arg1, cpp_arg2));
        } else {
          py_result = Py_None;
        }
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (numArgs == 1 && Shiboken::Converter<QAbstractTransition * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractTransition* cpp_arg0 = Shiboken::Converter<QAbstractTransition* >::toCpp(pyargs[0]);
        // addTransition(QAbstractTransition*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::addTransition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (numArgs == 1 && Shiboken::Converter<QAbstractState * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(pyargs[0]);
        // addTransition(QAbstractState*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        QAbstractTransition * cpp_result = cppSelf->QState::addTransition(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractTransition * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQStateFunc_addTransition_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStateFunc_addTransition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", "PySide.QtCore.QAbstractTransition", "PySide.QtCore.QObject, str, PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QState.addTransition", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_assignProperty(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "assignProperty", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        // assignProperty(QObject*,const char*,QVariant)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::assignProperty(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_assignProperty_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_assignProperty_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, str, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QState.assignProperty", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_childMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childMode()const
    QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
    QState::ChildMode cpp_result = cppSelf->QState::childMode();
    py_result = Shiboken::Converter<QState::ChildMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateFunc_errorState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorState()const
    QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
    QAbstractState * cpp_result = cppSelf->QState::errorState();
    py_result = Shiboken::Converter<QAbstractState * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QState::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStateFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.event", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_initialState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // initialState()const
    QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
    QAbstractState * cpp_result = cppSelf->QState::initialState();
    py_result = Shiboken::Converter<QAbstractState * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStateFunc_onEntry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onEntry(QEvent*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::onEntry(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_onEntry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_onEntry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.onEntry", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_onExit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onExit(QEvent*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::onExit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_onExit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_onExit_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.onExit", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_removeTransition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractTransition * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractTransition* cpp_arg0 = Shiboken::Converter<QAbstractTransition* >::toCpp(arg);
        // removeTransition(QAbstractTransition*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::removeTransition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQStateFunc_removeTransition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_removeTransition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractTransition", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.removeTransition", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_setChildMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QState::ChildMode >::isConvertible(arg)) {
        QState::ChildMode cpp_arg0 = Shiboken::Converter<QState::ChildMode >::toCpp(arg);
        // setChildMode(QState::ChildMode)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::setChildMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_setChildMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_setChildMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QState.ChildMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.setChildMode", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_setErrorState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractState * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(arg);
        // setErrorState(QAbstractState*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::setErrorState(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_setErrorState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_setErrorState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.setErrorState", overloads);
        return 0;
}

static PyObject* SbkQStateFunc_setInitialState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractState * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(arg);
        // setInitialState(QAbstractState*)
        QState* cppSelf = Shiboken::Converter<QState* >::toCpp((PyObject*)self);
        cppSelf->QState::setInitialState(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStateFunc_setInitialState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateFunc_setInitialState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QState.setInitialState", overloads);
        return 0;
}

static PyMethodDef SbkQState_methods[] = {
    {"addTransition", (PyCFunction)SbkQStateFunc_addTransition, METH_VARARGS},
    {"assignProperty", (PyCFunction)SbkQStateFunc_assignProperty, METH_VARARGS},
    {"childMode", (PyCFunction)SbkQStateFunc_childMode, METH_NOARGS},
    {"errorState", (PyCFunction)SbkQStateFunc_errorState, METH_NOARGS},
    {"event", (PyCFunction)SbkQStateFunc_event, METH_O},
    {"initialState", (PyCFunction)SbkQStateFunc_initialState, METH_NOARGS},
    {"onEntry", (PyCFunction)SbkQStateFunc_onEntry, METH_O},
    {"onExit", (PyCFunction)SbkQStateFunc_onExit, METH_O},
    {"removeTransition", (PyCFunction)SbkQStateFunc_removeTransition, METH_O},
    {"setChildMode", (PyCFunction)SbkQStateFunc_setChildMode, METH_O},
    {"setErrorState", (PyCFunction)SbkQStateFunc_setErrorState, METH_O},
    {"setInitialState", (PyCFunction)SbkQStateFunc_setInitialState, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQState_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQState_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQState_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QState >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QState_ChildMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QState_ChildMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QState_ChildMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ChildMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QState_ChildMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QState_ChildMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QState_ChildMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QState(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQState_Type);

    SbkQState_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTSTATE_IDX];
    // Fill type discovery information
    SbkQState_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQState_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQState_Type));
    PyModule_AddObject(module, "QState",
        ((PyObject*)&SbkQState_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ChildMode
    SbkPySide_QtCoreTypes[SBK_QSTATE_CHILDMODE_IDX] = &SbkPySide_QtCore_QState_ChildMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QState_ChildMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QState_ChildMode_Type);
    PyDict_SetItemString(SbkQState_Type.super.ht_type.tp_dict,
            "ChildMode",((PyObject*)&SbkPySide_QtCore_QState_ChildMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QState_ChildMode_Type,
        (long) QState::ExclusiveStates, "ExclusiveStates");
    PyDict_SetItemString(SbkQState_Type.super.ht_type.tp_dict,
        "ExclusiveStates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QState_ChildMode_Type.tp_dict,
        "ExclusiveStates", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QState_ChildMode_Type,
        (long) QState::ParallelStates, "ParallelStates");
    PyDict_SetItemString(SbkQState_Type.super.ht_type.tp_dict,
        "ParallelStates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QState_ChildMode_Type.tp_dict,
        "ParallelStates", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QState::ChildMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QState >("QState*");
    Shiboken::TypeResolver::createObjectTypeResolver<QState >(typeid(QState).name());
}


} // extern "C"

