/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qsize_wrapper.h"

// Extra includes
#include <qsize.h>

using namespace Shiboken;

static int
SbkQSize_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSize* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QSize", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QSize()
        cptr = new QSize();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QSize(int,int)
        cptr = new QSize(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // QSize(QSize)
        cptr = new QSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSize_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSize >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSize_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSize_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", "", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSize", overloads);
        return -1;
}

static PyObject* SbkQSizeFunc_boundedTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // boundedTo(QSize)const
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QSize::boundedTo(*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc_boundedTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc_boundedTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.boundedTo", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc_expandedTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // expandedTo(QSize)const
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QSize::expandedTo(*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc_expandedTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc_expandedTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.expandedTo", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSize::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizeFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSize::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizeFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSize::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizeFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSize::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizeFunc_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        Qt::AspectRatioMode cpp_arg2 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[2]);
        // scale(int,int,Qt::AspectRatioMode)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        cppSelf->QSize::scale(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QSize & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::AspectRatioMode >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        Qt::AspectRatioMode cpp_arg1 = Shiboken::Converter<Qt::AspectRatioMode >::toCpp(pyargs[1]);
        // scale(QSize,Qt::AspectRatioMode)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        cppSelf->QSize::scale(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc_scale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFunc_scale_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtCore.Qt.AspectRatioMode", "int, int, PySide.QtCore.Qt.AspectRatioMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSize.scale", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setHeight(int)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        cppSelf->QSize::setHeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFunc_setHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.setHeight", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setWidth(int)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        cppSelf->QSize::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizeFunc_setWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.setWidth", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc_transpose(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // transpose()
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    cppSelf->QSize::transpose();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQSizeFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSize::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQSize_methods[] = {
    {"boundedTo", (PyCFunction)SbkQSizeFunc_boundedTo, METH_O},
    {"expandedTo", (PyCFunction)SbkQSizeFunc_expandedTo, METH_O},
    {"height", (PyCFunction)SbkQSizeFunc_height, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQSizeFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQSizeFunc_isNull, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSizeFunc_isValid, METH_NOARGS},
    {"scale", (PyCFunction)SbkQSizeFunc_scale, METH_VARARGS},
    {"setHeight", (PyCFunction)SbkQSizeFunc_setHeight, METH_O},
    {"setWidth", (PyCFunction)SbkQSizeFunc_setWidth, METH_O},
    {"transpose", (PyCFunction)SbkQSizeFunc_transpose, METH_NOARGS},
    {"width", (PyCFunction)SbkQSizeFunc_width, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQSizeFunc___mul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rmul__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rmul__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QSize,qreal)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        const QSize cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QSize) [reverse operator]
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        const QSize cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___mul___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc___mul___TypeError:
        const char* overloads[] = {"float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__mul__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___imul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQSizeFunc___imul___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__imul__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator+(QSize,QSize)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        const QSize cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__add__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___iadd__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator+=(QSize)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQSizeFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__iadd__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___sub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rsub__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rsub__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator-(QSize,QSize)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        const QSize cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___sub___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__sub__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___isub__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // operator-=(QSize)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQSizeFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__isub__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___div__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rdiv__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rdiv__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QSize,qreal)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        const QSize cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___div___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizeFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__div__", overloads);
        return 0;
}

static PyObject* SbkQSizeFunc___idiv__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSize_Check(arg) && !SbkQSize_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QSize* cppSelf = Shiboken::Converter<QSize* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizeFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQSizeFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSize.__idiv__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQSize_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQSizeFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQSizeFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQSizeFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQSizeFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQSizeFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQSizeFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQSizeFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQSizeFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQSize_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QSize& cpp_self = *Shiboken::Converter<QSize* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSize & >::isConvertible(other)) {
                // operator!=(const QSize & s2)
                QSize* cpp_other = Shiboken::Converter<QSize* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSize  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQSize_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSize & >::isConvertible(other)) {
                // operator==(const QSize & s2)
                QSize* cpp_other = Shiboken::Converter<QSize* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSize  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQSize_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQSize_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSize_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSize",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQSize_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSize_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSize_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSize_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSize >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSize(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSIZE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSize_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSize_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSize_Type));
    PyModule_AddObject(module, "QSize",
        ((PyObject*)&SbkQSize_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSize >("QSize");
    Shiboken::TypeResolver::createValueTypeResolver<QSize >(typeid(QSize).name());
}


} // extern "C"

