/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qrect_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>

using namespace Shiboken;

static int
SbkQRect_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRect* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQRect_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QRect", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QRect()
        cptr = new QRect();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // QRect(int,int,int,int)
        cptr = new QRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
            // QRect(QPoint,QSize)
            cptr = new QRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            // QRect(QPoint,QPoint)
            cptr = new QRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQRect_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // QRect(QRect)
        cptr = new QRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRect_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QRect >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRect_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQRect_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "", "PySide.QtCore.QPoint, PySide.QtCore.QPoint", "PySide.QtCore.QPoint, PySide.QtCore.QSize", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect", overloads);
        return -1;
}

static PyObject* SbkQRectFunc_adjust(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "adjust", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // adjust(int,int,int,int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::adjust(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_adjust_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_adjust_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.adjust", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_adjusted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "adjusted", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // adjusted(int,int,int,int)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::adjusted(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_adjusted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_adjusted_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.adjusted", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_bottom(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottom()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::bottom();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_bottomLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomLeft()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QRect::bottomLeft();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_bottomRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomRight()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QRect::bottomRight();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_center(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // center()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QRect::center();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_contains(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "contains", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // contains(int,int)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
            // contains(int,int,bool)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQRectFunc_contains_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // contains(QRect,bool)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // contains(QRect,bool)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQRectFunc_contains_TypeError;
    } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // contains(QPoint,bool)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // contains(QPoint,bool)const
            QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QRect::contains(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQRectFunc_contains_TypeError;
    } else goto SbkQRectFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, bool = false", "PySide.QtCore.QRect, bool = false", "int, int", "int, int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.contains", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_intersect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersect(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::intersect(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_intersect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_intersect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.intersect", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersected(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.intersected", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_intersects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // intersects(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRect::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_intersects_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_intersects_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.intersects", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRect::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRect::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRect::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_left(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // left()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::left();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_moveBottom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // moveBottom(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveBottom(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveBottom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveBottom_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveBottom", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveBottomLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // moveBottomLeft(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveBottomLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveBottomLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveBottomLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveBottomLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveBottomRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // moveBottomRight(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveBottomRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveBottomRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveBottomRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveBottomRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveCenter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // moveCenter(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveCenter(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveCenter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveCenter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveCenter", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // moveLeft(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveLeft(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveLeft_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // moveRight(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveRight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveRight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // moveTo(int,int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveTo(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // moveTo(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveTo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.moveTo", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveTop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // moveTop(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveTop(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveTop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveTop_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveTop", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveTopLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // moveTopLeft(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveTopLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveTopLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveTopLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveTopLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_moveTopRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // moveTopRight(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::moveTopRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_moveTopRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_moveTopRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.moveTopRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_normalized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalized()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QRect::normalized();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_right(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // right()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::right();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_setBottom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBottom(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setBottom(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setBottom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setBottom_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setBottom", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setBottomLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setBottomLeft(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setBottomLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setBottomLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setBottomLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setBottomLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setBottomRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setBottomRight(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setBottomRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setBottomRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setBottomRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setBottomRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setCoords(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCoords", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setCoords(int,int,int,int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setCoords(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setCoords_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setCoords_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.setCoords", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setHeight(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setHeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setHeight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setLeft(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setLeft(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setLeft_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setRect(int,int,int,int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setRect_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.setRect", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRight(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setRight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setRight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setSize(QSize)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setSize", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setTop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setTop(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setTop(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setTop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setTop_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setTop", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setTopLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setTopLeft(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setTopLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setTopLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setTopLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setTopLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setTopRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setTopRight(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setTopRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setTopRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setTopRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setTopRight", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setWidth(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setWidth", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setX(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setX(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setX_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setX", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setY(int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::setY(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_setY_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.setY", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QRect::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_top(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // top()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::top();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_topLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topLeft()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QRect::topLeft();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_topRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topRight()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QRect::topRight();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translate(int,int)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translate(QPoint)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        cppSelf->QRect::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.translate", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translated(int,int)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translated(QPoint)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRect.translated", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_unite(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // unite(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::unite(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_unite_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_unite_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.unite", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // united(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QRect::united(*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.united", overloads);
        return 0;
}

static PyObject* SbkQRectFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QRect::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQRect_methods[] = {
    {"adjust", (PyCFunction)SbkQRectFunc_adjust, METH_VARARGS},
    {"adjusted", (PyCFunction)SbkQRectFunc_adjusted, METH_VARARGS},
    {"bottom", (PyCFunction)SbkQRectFunc_bottom, METH_NOARGS},
    {"bottomLeft", (PyCFunction)SbkQRectFunc_bottomLeft, METH_NOARGS},
    {"bottomRight", (PyCFunction)SbkQRectFunc_bottomRight, METH_NOARGS},
    {"center", (PyCFunction)SbkQRectFunc_center, METH_NOARGS},
    {"contains", (PyCFunction)SbkQRectFunc_contains, METH_VARARGS},
    {"height", (PyCFunction)SbkQRectFunc_height, METH_NOARGS},
    {"intersect", (PyCFunction)SbkQRectFunc_intersect, METH_O},
    {"intersected", (PyCFunction)SbkQRectFunc_intersected, METH_O},
    {"intersects", (PyCFunction)SbkQRectFunc_intersects, METH_O},
    {"isEmpty", (PyCFunction)SbkQRectFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQRectFunc_isNull, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQRectFunc_isValid, METH_NOARGS},
    {"left", (PyCFunction)SbkQRectFunc_left, METH_NOARGS},
    {"moveBottom", (PyCFunction)SbkQRectFunc_moveBottom, METH_O},
    {"moveBottomLeft", (PyCFunction)SbkQRectFunc_moveBottomLeft, METH_O},
    {"moveBottomRight", (PyCFunction)SbkQRectFunc_moveBottomRight, METH_O},
    {"moveCenter", (PyCFunction)SbkQRectFunc_moveCenter, METH_O},
    {"moveLeft", (PyCFunction)SbkQRectFunc_moveLeft, METH_O},
    {"moveRight", (PyCFunction)SbkQRectFunc_moveRight, METH_O},
    {"moveTo", (PyCFunction)SbkQRectFunc_moveTo, METH_VARARGS},
    {"moveTop", (PyCFunction)SbkQRectFunc_moveTop, METH_O},
    {"moveTopLeft", (PyCFunction)SbkQRectFunc_moveTopLeft, METH_O},
    {"moveTopRight", (PyCFunction)SbkQRectFunc_moveTopRight, METH_O},
    {"normalized", (PyCFunction)SbkQRectFunc_normalized, METH_NOARGS},
    {"right", (PyCFunction)SbkQRectFunc_right, METH_NOARGS},
    {"setBottom", (PyCFunction)SbkQRectFunc_setBottom, METH_O},
    {"setBottomLeft", (PyCFunction)SbkQRectFunc_setBottomLeft, METH_O},
    {"setBottomRight", (PyCFunction)SbkQRectFunc_setBottomRight, METH_O},
    {"setCoords", (PyCFunction)SbkQRectFunc_setCoords, METH_VARARGS},
    {"setHeight", (PyCFunction)SbkQRectFunc_setHeight, METH_O},
    {"setLeft", (PyCFunction)SbkQRectFunc_setLeft, METH_O},
    {"setRect", (PyCFunction)SbkQRectFunc_setRect, METH_VARARGS},
    {"setRight", (PyCFunction)SbkQRectFunc_setRight, METH_O},
    {"setSize", (PyCFunction)SbkQRectFunc_setSize, METH_O},
    {"setTop", (PyCFunction)SbkQRectFunc_setTop, METH_O},
    {"setTopLeft", (PyCFunction)SbkQRectFunc_setTopLeft, METH_O},
    {"setTopRight", (PyCFunction)SbkQRectFunc_setTopRight, METH_O},
    {"setWidth", (PyCFunction)SbkQRectFunc_setWidth, METH_O},
    {"setX", (PyCFunction)SbkQRectFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQRectFunc_setY, METH_O},
    {"size", (PyCFunction)SbkQRectFunc_size, METH_NOARGS},
    {"top", (PyCFunction)SbkQRectFunc_top, METH_NOARGS},
    {"topLeft", (PyCFunction)SbkQRectFunc_topLeft, METH_NOARGS},
    {"topRight", (PyCFunction)SbkQRectFunc_topRight, METH_NOARGS},
    {"translate", (PyCFunction)SbkQRectFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQRectFunc_translated, METH_VARARGS},
    {"unite", (PyCFunction)SbkQRectFunc_unite, METH_O},
    {"united", (PyCFunction)SbkQRectFunc_united, METH_O},
    {"width", (PyCFunction)SbkQRectFunc_width, METH_NOARGS},
    {"x", (PyCFunction)SbkQRectFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQRectFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQRectFunc___and__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRect_Check(arg) && !SbkQRect_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator&(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc___and___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc___and___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.__and__", overloads);
        return 0;
}

static PyObject* SbkQRectFunc___iand__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRect_Check(arg) && !SbkQRect_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator&=(QRect)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        (*cppSelf) &= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc___iand___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQRectFunc___iand___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.__iand__", overloads);
        return 0;
}

static PyObject* SbkQRectFunc___or__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRect_Check(arg) && !SbkQRect_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator|(QRect)const
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        QRect cpp_result = (*cppSelf) | (*cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc___or___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFunc___or___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.__or__", overloads);
        return 0;
}

static PyObject* SbkQRectFunc___ior__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRect_Check(arg) && !SbkQRect_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // operator|=(QRect)
        QRect* cppSelf = Shiboken::Converter<QRect* >::toCpp((PyObject*)self);
        (*cppSelf) |= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFunc___ior___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQRectFunc___ior___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRect.__ior__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQRect_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQRectFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQRectFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQRectFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQRectFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQRect_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QRect& cpp_self = *Shiboken::Converter<QRect* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QRect & >::isConvertible(other)) {
                // operator!=(const QRect & arg__2)
                QRect* cpp_other = Shiboken::Converter<QRect* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRect  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQRect_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QRect & >::isConvertible(other)) {
                // operator==(const QRect & arg__2)
                QRect* cpp_other = Shiboken::Converter<QRect* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRect  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQRect_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQRect_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRect_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QRect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQRect_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQRect_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRect_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRect_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QRect >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QRect(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QRECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRect_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQRect_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRect_Type));
    PyModule_AddObject(module, "QRect",
        ((PyObject*)&SbkQRect_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QRect >("QRect");
    Shiboken::TypeResolver::createValueTypeResolver<QRect >(typeid(QRect).name());
}


} // extern "C"

