/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qdatetime_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQDateTime_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDateTime* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDateTime", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QDateTime()
        cptr = new QDateTime();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDateTime & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
        // QDateTime(QDateTime)
        cptr = new QDateTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QDate & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDateTime(QDate)
            cptr = new QDateTime(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QTime & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QTime* cpp_arg1 = Shiboken::Converter<QTime* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QDateTime(QDate,QTime,Qt::TimeSpec)
                cptr = new QDateTime(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::TimeSpec >::isConvertible(pyargs[2])) {
                Qt::TimeSpec cpp_arg2 = Shiboken::Converter<Qt::TimeSpec >::toCpp(pyargs[2]);
                // QDateTime(QDate,QTime,Qt::TimeSpec)
                cptr = new QDateTime(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQDateTime_Init_TypeError;
        } else goto SbkQDateTime_Init_TypeError;
    } else goto SbkQDateTime_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDateTime >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDateTime_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDateTime_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QDate", "PySide.QtCore.QDate, PySide.QtCore.QTime, PySide.QtCore.Qt.TimeSpec = Qt.LocalTime", "PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDateTime", overloads);
        return -1;
}

static PyObject* SbkQDateTimeFunc_addDays(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addDays(int)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::addDays(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_addDays_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_addDays_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.addDays", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_addMSecs(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // addMSecs(qint64)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::addMSecs(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_addMSecs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_addMSecs_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.addMSecs", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_addMonths(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addMonths(int)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::addMonths(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_addMonths_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_addMonths_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.addMonths", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_addSecs(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addSecs(int)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::addSecs(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_addSecs_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_addSecs_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.addSecs", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_addYears(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addYears(int)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::addYears(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_addYears_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_addYears_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.addYears", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_currentDateTime(PyObject* self)
{
    PyObject* py_result = 0;

    // currentDateTime()
    QDateTime cpp_result = QDateTime::currentDateTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_date(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // date()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QDateTime::date();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_daysTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // daysTo(QDateTime)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QDateTime::daysTo(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_daysTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_daysTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.daysTo", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_fromString(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromString", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromString(QString,Qt::DateFormat)
            QDateTime cpp_result = QDateTime::fromString(*cpp_arg0);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // fromString(QString,QString)
            QDateTime cpp_result = QDateTime::fromString(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(pyargs[1])) {
            Qt::DateFormat cpp_arg1 = Shiboken::Converter<Qt::DateFormat >::toCpp(pyargs[1]);
            // fromString(QString,Qt::DateFormat)
            QDateTime cpp_result = QDateTime::fromString(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDateTimeFunc_fromString_TypeError;
    } else goto SbkQDateTimeFunc_fromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_fromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QDateTime.fromString", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_fromTime_t(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // fromTime_t(uint)
        QDateTime cpp_result = QDateTime::fromTime_t(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_fromTime_t_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_fromTime_t_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.fromTime_t", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDateTime::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDateTime::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_secsTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // secsTo(QDateTime)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QDateTime::secsTo(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_secsTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_secsTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.secsTo", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_setDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setDate(QDate)
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        cppSelf->QDateTime::setDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_setDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeFunc_setDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.setDate", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_setTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // setTime(QTime)
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        cppSelf->QDateTime::setTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_setTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeFunc_setTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.setTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_setTimeSpec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TimeSpec >::isConvertible(arg)) {
        Qt::TimeSpec cpp_arg0 = Shiboken::Converter<Qt::TimeSpec >::toCpp(arg);
        // setTimeSpec(Qt::TimeSpec)
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        cppSelf->QDateTime::setTimeSpec(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_setTimeSpec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeFunc_setTimeSpec_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TimeSpec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.setTimeSpec", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_setTime_t(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // setTime_t(uint)
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        cppSelf->QDateTime::setTime_t(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_setTime_t_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeFunc_setTime_t_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.setTime_t", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_setUtcOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setUtcOffset(int)
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        cppSelf->QDateTime::setUtcOffset(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_setUtcOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeFunc_setUtcOffset_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.setUtcOffset", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_time(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // time()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    QTime cpp_result = cppSelf->QDateTime::time();
    py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_timeSpec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // timeSpec()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    Qt::TimeSpec cpp_result = cppSelf->QDateTime::timeSpec();
    py_result = Shiboken::Converter<Qt::TimeSpec >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_toLocalTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLocalTime()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QDateTime::toLocalTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(Qt::DateFormat)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDateTime::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toString(QString)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDateTime::toString(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::DateFormat >::isConvertible(arg)) {
        Qt::DateFormat cpp_arg0 = Shiboken::Converter<Qt::DateFormat >::toCpp(arg);
        // toString(Qt::DateFormat)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDateTime::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_toString_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DateFormat = Qt.TextDate", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.toString", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_toTimeSpec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::TimeSpec >::isConvertible(arg)) {
        Qt::TimeSpec cpp_arg0 = Shiboken::Converter<Qt::TimeSpec >::toCpp(arg);
        // toTimeSpec(Qt::TimeSpec)const
        QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTime::toTimeSpec(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeFunc_toTimeSpec_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeFunc_toTimeSpec_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TimeSpec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QDateTime.toTimeSpec", overloads);
        return 0;
}

static PyObject* SbkQDateTimeFunc_toTime_t(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toTime_t()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QDateTime::toTime_t();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_toUTC(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toUTC()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QDateTime::toUTC();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeFunc_utcOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // utcOffset()const
    QDateTime* cppSelf = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDateTime::utcOffset();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDateTime_methods[] = {
    {"addDays", (PyCFunction)SbkQDateTimeFunc_addDays, METH_O},
    {"addMSecs", (PyCFunction)SbkQDateTimeFunc_addMSecs, METH_O},
    {"addMonths", (PyCFunction)SbkQDateTimeFunc_addMonths, METH_O},
    {"addSecs", (PyCFunction)SbkQDateTimeFunc_addSecs, METH_O},
    {"addYears", (PyCFunction)SbkQDateTimeFunc_addYears, METH_O},
    {"currentDateTime", (PyCFunction)SbkQDateTimeFunc_currentDateTime, METH_NOARGS|METH_STATIC},
    {"date", (PyCFunction)SbkQDateTimeFunc_date, METH_NOARGS},
    {"daysTo", (PyCFunction)SbkQDateTimeFunc_daysTo, METH_O},
    {"fromString", (PyCFunction)SbkQDateTimeFunc_fromString, METH_VARARGS|METH_STATIC},
    {"fromTime_t", (PyCFunction)SbkQDateTimeFunc_fromTime_t, METH_O|METH_STATIC},
    {"isNull", (PyCFunction)SbkQDateTimeFunc_isNull, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQDateTimeFunc_isValid, METH_NOARGS},
    {"secsTo", (PyCFunction)SbkQDateTimeFunc_secsTo, METH_O},
    {"setDate", (PyCFunction)SbkQDateTimeFunc_setDate, METH_O},
    {"setTime", (PyCFunction)SbkQDateTimeFunc_setTime, METH_O},
    {"setTimeSpec", (PyCFunction)SbkQDateTimeFunc_setTimeSpec, METH_O},
    {"setTime_t", (PyCFunction)SbkQDateTimeFunc_setTime_t, METH_O},
    {"setUtcOffset", (PyCFunction)SbkQDateTimeFunc_setUtcOffset, METH_O},
    {"time", (PyCFunction)SbkQDateTimeFunc_time, METH_NOARGS},
    {"timeSpec", (PyCFunction)SbkQDateTimeFunc_timeSpec, METH_NOARGS},
    {"toLocalTime", (PyCFunction)SbkQDateTimeFunc_toLocalTime, METH_NOARGS},
    {"toString", (PyCFunction)SbkQDateTimeFunc_toString, METH_NOARGS|METH_O},
    {"toTimeSpec", (PyCFunction)SbkQDateTimeFunc_toTimeSpec, METH_O},
    {"toTime_t", (PyCFunction)SbkQDateTimeFunc_toTime_t, METH_NOARGS},
    {"toUTC", (PyCFunction)SbkQDateTimeFunc_toUTC, METH_NOARGS},
    {"utcOffset", (PyCFunction)SbkQDateTimeFunc_utcOffset, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQDateTime_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QDateTime& cpp_self = *Shiboken::Converter<QDateTime* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator!=(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator<(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator<=(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self <= (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator==(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator>(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self > (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QDateTime & >::isConvertible(other)) {
                // operator>=(const QDateTime & other) const
                QDateTime* cpp_other = Shiboken::Converter<QDateTime* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDateTime  >::toCpp(other) : (cpp_self >= (*cpp_other));
            } else goto SbkQDateTime_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQDateTime_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDateTime_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QDateTime",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDateTime_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDateTime_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDateTime_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDateTime >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDateTime(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QDATETIME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDateTime_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDateTime_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDateTime_Type));
    PyModule_AddObject(module, "QDateTime",
        ((PyObject*)&SbkQDateTime_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDateTime >("QDateTime");
    Shiboken::TypeResolver::createValueTypeResolver<QDateTime >(typeid(QDateTime).name());
}


} // extern "C"

