/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlnamespacesupport_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qstringlist.h>
#include <qxml.h>

using namespace Shiboken;

static int
SbkQXmlNamespaceSupport_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlNamespaceSupport* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QXmlNamespaceSupport()
    cptr = new QXmlNamespaceSupport();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_popContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // popContext()
    QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
    cppSelf->QXmlNamespaceSupport::popContext();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_prefix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prefix(QString)const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlNamespaceSupport::prefix(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQXmlNamespaceSupportFunc_prefix_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlNamespaceSupportFunc_prefix_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlNamespaceSupport.prefix", overloads);
        return 0;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_prefixes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // prefixes()const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QXmlNamespaceSupport::prefixes();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prefixes(QString)const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QXmlNamespaceSupport::prefixes(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQXmlNamespaceSupportFunc_prefixes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlNamespaceSupportFunc_prefixes_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlNamespaceSupport.prefixes", overloads);
        return 0;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_processName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "processName", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // processName(QString,bool,QString&,QString&)const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        cppSelf->QXmlNamespaceSupport::processName(*cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
    } else goto SbkQXmlNamespaceSupportFunc_processName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlNamespaceSupportFunc_processName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlNamespaceSupport.processName", overloads);
        return 0;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_pushContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pushContext()
    QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
    cppSelf->QXmlNamespaceSupport::pushContext();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
    cppSelf->QXmlNamespaceSupport::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_setPrefix(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPrefix", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setPrefix(QString,QString)
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        cppSelf->QXmlNamespaceSupport::setPrefix(*cpp_arg0, *cpp_arg1);
    } else goto SbkQXmlNamespaceSupportFunc_setPrefix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlNamespaceSupportFunc_setPrefix_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlNamespaceSupport.setPrefix", overloads);
        return 0;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_splitName(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "splitName", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // splitName(QString,QString&,QString&)const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        cppSelf->QXmlNamespaceSupport::splitName(*cpp_arg0, *cpp_arg1, *cpp_arg2);
    } else goto SbkQXmlNamespaceSupportFunc_splitName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlNamespaceSupportFunc_splitName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlNamespaceSupport.splitName", overloads);
        return 0;
}

static PyObject*
SbkQXmlNamespaceSupportFunc_uri(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // uri(QString)const
        QXmlNamespaceSupport* cppSelf = Shiboken::Converter<QXmlNamespaceSupport* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlNamespaceSupport::uri(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQXmlNamespaceSupportFunc_uri_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlNamespaceSupportFunc_uri_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlNamespaceSupport.uri", overloads);
        return 0;
}

static PyMethodDef SbkQXmlNamespaceSupport_methods[] = {
    {"popContext", (PyCFunction)SbkQXmlNamespaceSupportFunc_popContext, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQXmlNamespaceSupportFunc_prefix, METH_O},
    {"prefixes", (PyCFunction)SbkQXmlNamespaceSupportFunc_prefixes, METH_NOARGS|METH_O},
    {"processName", (PyCFunction)SbkQXmlNamespaceSupportFunc_processName, METH_VARARGS},
    {"pushContext", (PyCFunction)SbkQXmlNamespaceSupportFunc_pushContext, METH_NOARGS},
    {"reset", (PyCFunction)SbkQXmlNamespaceSupportFunc_reset, METH_NOARGS},
    {"setPrefix", (PyCFunction)SbkQXmlNamespaceSupportFunc_setPrefix, METH_VARARGS},
    {"splitName", (PyCFunction)SbkQXmlNamespaceSupportFunc_splitName, METH_VARARGS},
    {"uri", (PyCFunction)SbkQXmlNamespaceSupportFunc_uri, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlNamespaceSupport_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlNamespaceSupport",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlNamespaceSupport >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlNamespaceSupport_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlNamespaceSupport_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QXmlNamespaceSupport(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLNAMESPACESUPPORT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlNamespaceSupport_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlNamespaceSupport_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlNamespaceSupport_Type));
    PyModule_AddObject(module, "QXmlNamespaceSupport",
        ((PyObject*)&SbkQXmlNamespaceSupport_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlNamespaceSupport >("QXmlNamespaceSupport*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlNamespaceSupport >(typeid(QXmlNamespaceSupport).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

