/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmllexicalhandler_wrapper.h"

// Extra includes
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlLexicalHandlerWrapper::QXmlLexicalHandlerWrapper() : QXmlLexicalHandler() {
    // ... middle
}

bool QXmlLexicalHandlerWrapper::comment(const QString & ch)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "comment"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.comment()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(ch)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.comment");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::endCDATA()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endCDATA"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endCDATA()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.endCDATA");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::endDTD()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDTD"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endDTD()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.endDTD");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::endEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endEntity"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endEntity()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.endEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QXmlLexicalHandlerWrapper::errorString() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "errorString"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.errorString()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.errorString");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::startCDATA()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startCDATA"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startCDATA()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.startCDATA");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::startDTD(const QString & name, const QString & publicId, const QString & systemId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDTD"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startDTD()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOO)",
        Shiboken::Converter<QString& >::toPython(name),
        Shiboken::Converter<QString& >::toPython(publicId),
        Shiboken::Converter<QString& >::toPython(systemId)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.startDTD");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QXmlLexicalHandlerWrapper::startEntity(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startEntity"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startEntity()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlLexicalHandler.startEntity");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlLexicalHandlerWrapper::~QXmlLexicalHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlLexicalHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlLexicalHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QXmlLexicalHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QXmlLexicalHandler()
    cptr = new QXmlLexicalHandlerWrapper();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_comment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // comment(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.comment()' not implemented.");
            return 0;
        }
        QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->comment(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlLexicalHandlerFunc_comment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlLexicalHandlerFunc_comment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlLexicalHandler.comment", overloads);
        return 0;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_endCDATA(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endCDATA()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endCDATA()' not implemented.");
        return 0;
    }
    QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->endCDATA();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_endDTD(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endDTD()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endDTD()' not implemented.");
        return 0;
    }
    QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->endDTD();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_endEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // endEntity(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.endEntity()' not implemented.");
            return 0;
        }
        QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->endEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlLexicalHandlerFunc_endEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlLexicalHandlerFunc_endEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlLexicalHandler.endEntity", overloads);
        return 0;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.errorString()' not implemented.");
        return 0;
    }
    QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_startCDATA(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startCDATA()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startCDATA()' not implemented.");
        return 0;
    }
    QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->startCDATA();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_startDTD(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "startDTD", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // startDTD(QString,QString,QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startDTD()' not implemented.");
            return 0;
        }
        QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->startDTD(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlLexicalHandlerFunc_startDTD_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlLexicalHandlerFunc_startDTD_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlLexicalHandler.startDTD", overloads);
        return 0;
}

static PyObject*
SbkQXmlLexicalHandlerFunc_startEntity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // startEntity(QString)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QXmlLexicalHandler.startEntity()' not implemented.");
            return 0;
        }
        QXmlLexicalHandler* cppSelf = Shiboken::Converter<QXmlLexicalHandler* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->startEntity(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQXmlLexicalHandlerFunc_startEntity_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlLexicalHandlerFunc_startEntity_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlLexicalHandler.startEntity", overloads);
        return 0;
}

static PyMethodDef SbkQXmlLexicalHandler_methods[] = {
    {"comment", (PyCFunction)SbkQXmlLexicalHandlerFunc_comment, METH_O},
    {"endCDATA", (PyCFunction)SbkQXmlLexicalHandlerFunc_endCDATA, METH_NOARGS},
    {"endDTD", (PyCFunction)SbkQXmlLexicalHandlerFunc_endDTD, METH_NOARGS},
    {"endEntity", (PyCFunction)SbkQXmlLexicalHandlerFunc_endEntity, METH_O},
    {"errorString", (PyCFunction)SbkQXmlLexicalHandlerFunc_errorString, METH_NOARGS},
    {"startCDATA", (PyCFunction)SbkQXmlLexicalHandlerFunc_startCDATA, METH_NOARGS},
    {"startDTD", (PyCFunction)SbkQXmlLexicalHandlerFunc_startDTD, METH_VARARGS},
    {"startEntity", (PyCFunction)SbkQXmlLexicalHandlerFunc_startEntity, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlLexicalHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlLexicalHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlLexicalHandlerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlLexicalHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlLexicalHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQXmlLexicalHandler_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlLexicalHandler_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlLexicalHandler*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QXmlLexicalHandler(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlLexicalHandler_Type);

    // Fill type discovery information
    SbkQXmlLexicalHandler_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlLexicalHandler_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlLexicalHandler_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlLexicalHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlLexicalHandler_Type));
    PyModule_AddObject(module, "QXmlLexicalHandler",
        ((PyObject*)&SbkQXmlLexicalHandler_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlLexicalHandler >("QXmlLexicalHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlLexicalHandler >(typeid(QXmlLexicalHandler).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

