/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlinputsource_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qchar.h>
#include <qiodevice.h>
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlInputSourceWrapper::QXmlInputSourceWrapper() : QXmlInputSource() {
    // ... middle
}

QXmlInputSourceWrapper::QXmlInputSourceWrapper(QIODevice * dev) : QXmlInputSource(dev) {
    // ... middle
}

QString QXmlInputSourceWrapper::data() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::data();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlInputSource.data");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

void QXmlInputSourceWrapper::fetchData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchData"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::fetchData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QXmlInputSourceWrapper::fromRawData(const QByteArray & data, bool beginning)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fromRawData"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::fromRawData(data, beginning);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QByteArray& >::toPython(data),
        Shiboken::Converter<bool >::toPython(beginning)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlInputSource.fromRawData");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QChar QXmlInputSourceWrapper::next()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "next"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::next();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QChar();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QChar >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QXmlInputSource.next");
        return QChar()        ;
    }
    QChar cpp_result(Shiboken::Converter<QChar >::toCpp(py_result));
    return cpp_result;
}

void QXmlInputSourceWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::reset();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlInputSourceWrapper::setData(const QByteArray & dat)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::setData(dat);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QByteArray& >::toPython(dat)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlInputSourceWrapper::setData(const QString & dat)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QXmlInputSource::setData(dat);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(dat)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QXmlInputSourceWrapper::~QXmlInputSourceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlInputSource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlInputSourceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlInputSource", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlInputSource()
        cptr = new QXmlInputSourceWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // QXmlInputSource(QIODevice*)
        cptr = new QXmlInputSourceWrapper(cpp_arg0);
    } else goto SbkQXmlInputSource_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlInputSource_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQXmlInputSource_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlInputSource", overloads);
        return -1;
}

static PyObject*
SbkQXmlInputSourceFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QXmlInputSource::data();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlInputSourceFunc_fetchData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // fetchData()
    QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
    cppSelf->QXmlInputSource::fetchData();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlInputSourceFunc_fromRawData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromRawData", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // fromRawData(QByteArray,bool)
            QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlInputSource::fromRawData(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // fromRawData(QByteArray,bool)
            QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlInputSource::fromRawData(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQXmlInputSourceFunc_fromRawData_TypeError;
    } else goto SbkQXmlInputSourceFunc_fromRawData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQXmlInputSourceFunc_fromRawData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlInputSource.fromRawData", overloads);
        return 0;
}

static PyObject*
SbkQXmlInputSourceFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // next()
    QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
    QChar cpp_result = cppSelf->QXmlInputSource::next();
    py_result = Shiboken::Converter<QChar >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQXmlInputSourceFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
    cppSelf->QXmlInputSource::reset();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQXmlInputSourceFunc_setData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!Shiboken::Converter<QByteArray& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setData(QByteArray)
        QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
        cppSelf->QXmlInputSource::setData(*cpp_arg0);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setData(QString)
        QXmlInputSource* cppSelf = Shiboken::Converter<QXmlInputSource* >::toCpp((PyObject*)self);
        cppSelf->QXmlInputSource::setData(*cpp_arg0);
    } else goto SbkQXmlInputSourceFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlInputSourceFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlInputSource.setData", overloads);
        return 0;
}

static PyMethodDef SbkQXmlInputSource_methods[] = {
    {"data", (PyCFunction)SbkQXmlInputSourceFunc_data, METH_NOARGS},
    {"fetchData", (PyCFunction)SbkQXmlInputSourceFunc_fetchData, METH_NOARGS},
    {"fromRawData", (PyCFunction)SbkQXmlInputSourceFunc_fromRawData, METH_VARARGS},
    {"next", (PyCFunction)SbkQXmlInputSourceFunc_next, METH_NOARGS},
    {"reset", (PyCFunction)SbkQXmlInputSourceFunc_reset, METH_NOARGS},
    {"setData", (PyCFunction)SbkQXmlInputSourceFunc_setData, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlInputSource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlInputSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QXmlInputSourceWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlInputSource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlInputSource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQXmlInputSource_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlInputSource_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlInputSource*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void)
init_QXmlInputSource(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLINPUTSOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlInputSource_Type);

    // Fill type discovery information
    SbkQXmlInputSource_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlInputSource_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlInputSource_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlInputSource_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlInputSource_Type));
    PyModule_AddObject(module, "QXmlInputSource",
        ((PyObject*)&SbkQXmlInputSource_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlInputSource >("QXmlInputSource*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlInputSource >(typeid(QXmlInputSource).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

