/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomnodelist_wrapper.h"

// Extra includes
#include <qdom.h>

using namespace Shiboken;

static int
SbkQDomNodeList_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomNodeList* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomNodeList", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomNodeList()
        cptr = new QDomNodeList();
    } else if (numArgs == 1 && Shiboken::Converter<QDomNodeList& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomNodeList* cpp_arg0 = Shiboken::Converter<QDomNodeList* >::toCpp(pyargs[0]);
        // QDomNodeList(QDomNodeList)
        cptr = new QDomNodeList(*cpp_arg0);
    } else goto SbkQDomNodeList_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomNodeList_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDomNodeList_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomNodeList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNodeList", overloads);
        return -1;
}

static PyObject*
SbkQDomNodeListFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNodeList::at(cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeListFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeListFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNodeList.at", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeListFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNodeList::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeListFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNodeList::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeListFunc_item(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // item(int)const
        QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNodeList::item(cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeListFunc_item_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeListFunc_item_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNodeList.item", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeListFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QDomNodeList::length();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeListFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QDomNodeList* cppSelf = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNodeList::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQDomNodeList_methods[] = {
    {"at", (PyCFunction)SbkQDomNodeListFunc_at, METH_O},
    {"count", (PyCFunction)SbkQDomNodeListFunc_count, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQDomNodeListFunc_isEmpty, METH_NOARGS},
    {"item", (PyCFunction)SbkQDomNodeListFunc_item, METH_O},
    {"length", (PyCFunction)SbkQDomNodeListFunc_length, METH_NOARGS},
    {"size", (PyCFunction)SbkQDomNodeListFunc_size, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQDomNodeList_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QDomNodeList& cpp_self = *Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDomNodeList& >::isConvertible(other)) {
                QDomNodeList* cpp_other = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQDomNodeList_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDomNodeList& >::isConvertible(other)) {
                QDomNodeList* cpp_other = Shiboken::Converter<QDomNodeList* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQDomNodeList_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQDomNodeList_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomNodeList_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomNodeList",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDomNodeList >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDomNodeList_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomNodeList_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomNodeList_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QDomNodeList(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMNODELIST_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomNodeList_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDomNodeList_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomNodeList_Type));
    PyModule_AddObject(module, "QDomNodeList",
        ((PyObject*)&SbkQDomNodeList_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomNodeList >("QDomNodeList");
    Shiboken::TypeResolver::createValueTypeResolver<QDomNodeList >(typeid(QDomNodeList).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

