/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomnode_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomNode_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomNode* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomNode", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomNode()
        cptr = new QDomNode();
    } else if (numArgs == 1 && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[0]);
        // QDomNode(QDomNode)
        cptr = new QDomNode(*cpp_arg0);
    } else goto SbkQDomNode_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomNode_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQDomNode_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode", overloads);
        return -1;
}

static PyObject*
SbkQDomNodeFunc_appendChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomNode& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(arg);
        // appendChild(QDomNode)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::appendChild(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_appendChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_appendChild_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.appendChild", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_attributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attributes()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNamedNodeMap cpp_result = cppSelf->QDomNode::attributes();
    py_result = Shiboken::Converter<QDomNamedNodeMap >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_childNodes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // childNodes()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNodeList cpp_result = cppSelf->QDomNode::childNodes();
    py_result = Shiboken::Converter<QDomNodeList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    cppSelf->QDomNode::clear();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQDomNodeFunc_cloneNode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // cloneNode(bool)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::cloneNode();
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // cloneNode(bool)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::cloneNode(cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_cloneNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_cloneNode_TypeError:
        const char* overloads[] = {"bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.cloneNode", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_columnNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnNumber()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNode::columnNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_firstChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstChild()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode cpp_result = cppSelf->QDomNode::firstChild();
    py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_firstChildElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // firstChildElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::firstChildElement();
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // firstChildElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::firstChildElement(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_firstChildElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_firstChildElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.firstChildElement", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_hasAttributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAttributes()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::hasAttributes();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_hasChildNodes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasChildNodes()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::hasChildNodes();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_insertAfter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertAfter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[0]) && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDomNode* cpp_arg1 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[1]);
        // insertAfter(QDomNode,QDomNode)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::insertAfter(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_insertAfter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_insertAfter_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode, PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode.insertAfter", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_insertBefore(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertBefore", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[0]) && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDomNode* cpp_arg1 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[1]);
        // insertBefore(QDomNode,QDomNode)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::insertBefore(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_insertBefore_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_insertBefore_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode, PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode.insertBefore", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_isAttr(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAttr()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isAttr();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isCDATASection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCDATASection()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isCDATASection();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isCharacterData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCharacterData()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isCharacterData();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isComment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isComment()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isComment();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDocument()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isDocument();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isDocumentFragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDocumentFragment()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isDocumentFragment();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isDocumentType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDocumentType()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isDocumentType();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isElement()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isElement();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isEntity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEntity()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isEntity();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isEntityReference(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEntityReference()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isEntityReference();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isNotation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNotation()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isNotation();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isProcessingInstruction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isProcessingInstruction()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isProcessingInstruction();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_isSupported(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isSupported", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // isSupported(QString,QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDomNode::isSupported(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_isSupported_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_isSupported_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode.isSupported", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_isText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isText()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNode::isText();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_lastChild(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastChild()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode cpp_result = cppSelf->QDomNode::lastChild();
    py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_lastChildElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // lastChildElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::lastChildElement();
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // lastChildElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::lastChildElement(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_lastChildElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_lastChildElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.lastChildElement", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_lineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineNumber()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNode::lineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_localName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // localName()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomNode::localName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_namedItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // namedItem(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::namedItem(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_namedItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_namedItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.namedItem", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_namespaceURI(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namespaceURI()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomNode::namespaceURI();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_nextSibling(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextSibling()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode cpp_result = cppSelf->QDomNode::nextSibling();
    py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_nextSiblingElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // nextSiblingElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::nextSiblingElement();
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // nextSiblingElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::nextSiblingElement(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_nextSiblingElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_nextSiblingElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.nextSiblingElement", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_nodeName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nodeName()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomNode::nodeName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_nodeType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nodeType()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode::NodeType cpp_result = cppSelf->QDomNode::nodeType();
    py_result = Shiboken::Converter<QDomNode::NodeType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_nodeValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nodeValue()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomNode::nodeValue();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_normalize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // normalize()
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    cppSelf->QDomNode::normalize();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQDomNodeFunc_ownerDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ownerDocument()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomDocument cpp_result = cppSelf->QDomNode::ownerDocument();
    py_result = Shiboken::Converter<QDomDocument >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_parentNode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentNode()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode cpp_result = cppSelf->QDomNode::parentNode();
    py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_prefix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefix()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomNode::prefix();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_previousSibling(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // previousSibling()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNode cpp_result = cppSelf->QDomNode::previousSibling();
    py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_previousSiblingElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // previousSiblingElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::previousSiblingElement();
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // previousSiblingElement(QString)const
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomNode::previousSiblingElement(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_previousSiblingElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_previousSiblingElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.previousSiblingElement", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_removeChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomNode& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(arg);
        // removeChild(QDomNode)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::removeChild(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_removeChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_removeChild_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.removeChild", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_replaceChild(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replaceChild", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[0]) && Shiboken::Converter<QDomNode& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDomNode* cpp_arg1 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[1]);
        // replaceChild(QDomNode,QDomNode)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNode::replaceChild(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
    } else goto SbkQDomNodeFunc_replaceChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc_replaceChild_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode, PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode.replaceChild", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_save(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "save", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QTextStream& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTextStream* cpp_arg0 = Shiboken::Converter<QTextStream* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // save(QTextStream&,int)const
            QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QDomNode::save(*cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
        } else if (numArgs == 3 && Shiboken::Converter<QDomNode::EncodingPolicy >::isConvertible(pyargs[2])) {
            QDomNode::EncodingPolicy cpp_arg2 = Shiboken::Converter<QDomNode::EncodingPolicy >::toCpp(pyargs[2]);
            // save(QTextStream&,int,QDomNode::EncodingPolicy)const
            QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QDomNode::save(*cpp_arg0, cpp_arg1, cpp_arg2);
            thread_state_saver.restore();
        } else goto SbkQDomNodeFunc_save_TypeError;
    } else goto SbkQDomNodeFunc_save_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomNodeFunc_save_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream, int", "PySide.QtCore.QTextStream, int, PySide.QtXml.QDomNode.EncodingPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNode.save", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_setNodeValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setNodeValue(QString)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        cppSelf->QDomNode::setNodeValue(*cpp_arg0);
    } else goto SbkQDomNodeFunc_setNodeValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomNodeFunc_setNodeValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.setNodeValue", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_setPrefix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPrefix(QString)
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        cppSelf->QDomNode::setPrefix(*cpp_arg0);
    } else goto SbkQDomNodeFunc_setPrefix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomNodeFunc_setPrefix_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.setPrefix", overloads);
        return 0;
}

static PyObject*
SbkQDomNodeFunc_toAttr(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAttr()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomAttr cpp_result = cppSelf->QDomNode::toAttr();
    py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toCDATASection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toCDATASection()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomCDATASection cpp_result = cppSelf->QDomNode::toCDATASection();
    py_result = Shiboken::Converter<QDomCDATASection >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toCharacterData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toCharacterData()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomCharacterData cpp_result = cppSelf->QDomNode::toCharacterData();
    py_result = Shiboken::Converter<QDomCharacterData >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toComment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toComment()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomComment cpp_result = cppSelf->QDomNode::toComment();
    py_result = Shiboken::Converter<QDomComment >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toDocument()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomDocument cpp_result = cppSelf->QDomNode::toDocument();
    py_result = Shiboken::Converter<QDomDocument >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toDocumentFragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toDocumentFragment()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomDocumentFragment cpp_result = cppSelf->QDomNode::toDocumentFragment();
    py_result = Shiboken::Converter<QDomDocumentFragment >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toDocumentType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toDocumentType()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomDocumentType cpp_result = cppSelf->QDomNode::toDocumentType();
    py_result = Shiboken::Converter<QDomDocumentType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toElement()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomElement cpp_result = cppSelf->QDomNode::toElement();
    py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toEntity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toEntity()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomEntity cpp_result = cppSelf->QDomNode::toEntity();
    py_result = Shiboken::Converter<QDomEntity >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toEntityReference(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toEntityReference()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomEntityReference cpp_result = cppSelf->QDomNode::toEntityReference();
    py_result = Shiboken::Converter<QDomEntityReference >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toNotation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toNotation()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomNotation cpp_result = cppSelf->QDomNode::toNotation();
    py_result = Shiboken::Converter<QDomNotation >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toProcessingInstruction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toProcessingInstruction()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomProcessingInstruction cpp_result = cppSelf->QDomNode::toProcessingInstruction();
    py_result = Shiboken::Converter<QDomProcessingInstruction >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQDomNodeFunc_toText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toText()const
    QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
    QDomText cpp_result = cppSelf->QDomNode::toText();
    py_result = Shiboken::Converter<QDomText >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQDomNode_methods[] = {
    {"appendChild", (PyCFunction)SbkQDomNodeFunc_appendChild, METH_O},
    {"attributes", (PyCFunction)SbkQDomNodeFunc_attributes, METH_NOARGS},
    {"childNodes", (PyCFunction)SbkQDomNodeFunc_childNodes, METH_NOARGS},
    {"clear", (PyCFunction)SbkQDomNodeFunc_clear, METH_NOARGS},
    {"cloneNode", (PyCFunction)SbkQDomNodeFunc_cloneNode, METH_NOARGS|METH_O},
    {"columnNumber", (PyCFunction)SbkQDomNodeFunc_columnNumber, METH_NOARGS},
    {"firstChild", (PyCFunction)SbkQDomNodeFunc_firstChild, METH_NOARGS},
    {"firstChildElement", (PyCFunction)SbkQDomNodeFunc_firstChildElement, METH_NOARGS|METH_O},
    {"hasAttributes", (PyCFunction)SbkQDomNodeFunc_hasAttributes, METH_NOARGS},
    {"hasChildNodes", (PyCFunction)SbkQDomNodeFunc_hasChildNodes, METH_NOARGS},
    {"insertAfter", (PyCFunction)SbkQDomNodeFunc_insertAfter, METH_VARARGS},
    {"insertBefore", (PyCFunction)SbkQDomNodeFunc_insertBefore, METH_VARARGS},
    {"isAttr", (PyCFunction)SbkQDomNodeFunc_isAttr, METH_NOARGS},
    {"isCDATASection", (PyCFunction)SbkQDomNodeFunc_isCDATASection, METH_NOARGS},
    {"isCharacterData", (PyCFunction)SbkQDomNodeFunc_isCharacterData, METH_NOARGS},
    {"isComment", (PyCFunction)SbkQDomNodeFunc_isComment, METH_NOARGS},
    {"isDocument", (PyCFunction)SbkQDomNodeFunc_isDocument, METH_NOARGS},
    {"isDocumentFragment", (PyCFunction)SbkQDomNodeFunc_isDocumentFragment, METH_NOARGS},
    {"isDocumentType", (PyCFunction)SbkQDomNodeFunc_isDocumentType, METH_NOARGS},
    {"isElement", (PyCFunction)SbkQDomNodeFunc_isElement, METH_NOARGS},
    {"isEntity", (PyCFunction)SbkQDomNodeFunc_isEntity, METH_NOARGS},
    {"isEntityReference", (PyCFunction)SbkQDomNodeFunc_isEntityReference, METH_NOARGS},
    {"isNotation", (PyCFunction)SbkQDomNodeFunc_isNotation, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQDomNodeFunc_isNull, METH_NOARGS},
    {"isProcessingInstruction", (PyCFunction)SbkQDomNodeFunc_isProcessingInstruction, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQDomNodeFunc_isSupported, METH_VARARGS},
    {"isText", (PyCFunction)SbkQDomNodeFunc_isText, METH_NOARGS},
    {"lastChild", (PyCFunction)SbkQDomNodeFunc_lastChild, METH_NOARGS},
    {"lastChildElement", (PyCFunction)SbkQDomNodeFunc_lastChildElement, METH_NOARGS|METH_O},
    {"lineNumber", (PyCFunction)SbkQDomNodeFunc_lineNumber, METH_NOARGS},
    {"localName", (PyCFunction)SbkQDomNodeFunc_localName, METH_NOARGS},
    {"namedItem", (PyCFunction)SbkQDomNodeFunc_namedItem, METH_O},
    {"namespaceURI", (PyCFunction)SbkQDomNodeFunc_namespaceURI, METH_NOARGS},
    {"nextSibling", (PyCFunction)SbkQDomNodeFunc_nextSibling, METH_NOARGS},
    {"nextSiblingElement", (PyCFunction)SbkQDomNodeFunc_nextSiblingElement, METH_NOARGS|METH_O},
    {"nodeName", (PyCFunction)SbkQDomNodeFunc_nodeName, METH_NOARGS},
    {"nodeType", (PyCFunction)SbkQDomNodeFunc_nodeType, METH_NOARGS},
    {"nodeValue", (PyCFunction)SbkQDomNodeFunc_nodeValue, METH_NOARGS},
    {"normalize", (PyCFunction)SbkQDomNodeFunc_normalize, METH_NOARGS},
    {"ownerDocument", (PyCFunction)SbkQDomNodeFunc_ownerDocument, METH_NOARGS},
    {"parentNode", (PyCFunction)SbkQDomNodeFunc_parentNode, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQDomNodeFunc_prefix, METH_NOARGS},
    {"previousSibling", (PyCFunction)SbkQDomNodeFunc_previousSibling, METH_NOARGS},
    {"previousSiblingElement", (PyCFunction)SbkQDomNodeFunc_previousSiblingElement, METH_NOARGS|METH_O},
    {"removeChild", (PyCFunction)SbkQDomNodeFunc_removeChild, METH_O},
    {"replaceChild", (PyCFunction)SbkQDomNodeFunc_replaceChild, METH_VARARGS},
    {"save", (PyCFunction)SbkQDomNodeFunc_save, METH_VARARGS},
    {"setNodeValue", (PyCFunction)SbkQDomNodeFunc_setNodeValue, METH_O},
    {"setPrefix", (PyCFunction)SbkQDomNodeFunc_setPrefix, METH_O},
    {"toAttr", (PyCFunction)SbkQDomNodeFunc_toAttr, METH_NOARGS},
    {"toCDATASection", (PyCFunction)SbkQDomNodeFunc_toCDATASection, METH_NOARGS},
    {"toCharacterData", (PyCFunction)SbkQDomNodeFunc_toCharacterData, METH_NOARGS},
    {"toComment", (PyCFunction)SbkQDomNodeFunc_toComment, METH_NOARGS},
    {"toDocument", (PyCFunction)SbkQDomNodeFunc_toDocument, METH_NOARGS},
    {"toDocumentFragment", (PyCFunction)SbkQDomNodeFunc_toDocumentFragment, METH_NOARGS},
    {"toDocumentType", (PyCFunction)SbkQDomNodeFunc_toDocumentType, METH_NOARGS},
    {"toElement", (PyCFunction)SbkQDomNodeFunc_toElement, METH_NOARGS},
    {"toEntity", (PyCFunction)SbkQDomNodeFunc_toEntity, METH_NOARGS},
    {"toEntityReference", (PyCFunction)SbkQDomNodeFunc_toEntityReference, METH_NOARGS},
    {"toNotation", (PyCFunction)SbkQDomNodeFunc_toNotation, METH_NOARGS},
    {"toProcessingInstruction", (PyCFunction)SbkQDomNodeFunc_toProcessingInstruction, METH_NOARGS},
    {"toText", (PyCFunction)SbkQDomNodeFunc_toText, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQDomNodeFunc___lshift__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQDomNode_Check(arg) && !SbkQDomNode_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && SbkBaseWrapper_Check(arg)) {
        py_result = PyObject_CallMethod(arg, const_cast<char*>("__rlshift__"), "O", self);
        if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) ||PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
        } else {
                return py_result; // Propagate the error
        }
    }
    if (isReverse && Shiboken::Converter<QTextStream& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextStream* cpp_arg0 = Shiboken::Converter<QTextStream* >::toCpp(arg);
        // operator<<(QTextStream&,QDomNode) [reverse operator]
        QDomNode* cppSelf = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);
        QTextStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QTextStream& >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQDomNodeFunc___lshift___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQDomNodeFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNode.__lshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQDomNode_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQDomNodeFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQDomNode_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QDomNode& cpp_self = *Shiboken::Converter<QDomNode* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDomNode& >::isConvertible(other)) {
                QDomNode* cpp_other = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQDomNode_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDomNode& >::isConvertible(other)) {
                QDomNode* cpp_other = Shiboken::Converter<QDomNode* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQDomNode_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQDomNode_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomNode_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomNode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QDomNode >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQDomNode_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDomNode_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomNode_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomNode_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtXml_QDomNode_NodeType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXml_QDomNode_NodeType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXml_QDomNode_NodeType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NodeType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXml_QDomNode_NodeType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXml_QDomNode_NodeType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtXml_QDomNode_NodeType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtXml_QDomNode_EncodingPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXml_QDomNode_EncodingPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXml_QDomNode_EncodingPolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EncodingPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXml_QDomNode_EncodingPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXml_QDomNode_EncodingPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtXml_QDomNode_EncodingPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QDomNode(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomNode_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDomNode_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomNode_Type));
    PyModule_AddObject(module, "QDomNode",
        ((PyObject*)&SbkQDomNode_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: NodeType
    SbkPySide_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX] = &SbkPySide_QtXml_QDomNode_NodeType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXml_QDomNode_NodeType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXml_QDomNode_NodeType_Type);
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
            "NodeType",((PyObject*)&SbkPySide_QtXml_QDomNode_NodeType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::ElementNode, "ElementNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "ElementNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "ElementNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::AttributeNode, "AttributeNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "AttributeNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "AttributeNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::TextNode, "TextNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "TextNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "TextNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::CDATASectionNode, "CDATASectionNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "CDATASectionNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "CDATASectionNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::EntityReferenceNode, "EntityReferenceNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "EntityReferenceNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "EntityReferenceNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::EntityNode, "EntityNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "EntityNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "EntityNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::ProcessingInstructionNode, "ProcessingInstructionNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "ProcessingInstructionNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "ProcessingInstructionNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::CommentNode, "CommentNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "CommentNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "CommentNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::DocumentNode, "DocumentNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "DocumentNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "DocumentNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::DocumentTypeNode, "DocumentTypeNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "DocumentTypeNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "DocumentTypeNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::DocumentFragmentNode, "DocumentFragmentNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "DocumentFragmentNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "DocumentFragmentNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::NotationNode, "NotationNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "NotationNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "NotationNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::BaseNode, "BaseNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "BaseNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "BaseNode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_NodeType_Type,
        (long) QDomNode::CharacterDataNode, "CharacterDataNode");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "CharacterDataNode", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_NodeType_Type.tp_dict,
        "CharacterDataNode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDomNode::NodeType");

    // init enum class: EncodingPolicy
    SbkPySide_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX] = &SbkPySide_QtXml_QDomNode_EncodingPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXml_QDomNode_EncodingPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXml_QDomNode_EncodingPolicy_Type);
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
            "EncodingPolicy",((PyObject*)&SbkPySide_QtXml_QDomNode_EncodingPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_EncodingPolicy_Type,
        (long) QDomNode::EncodingFromDocument, "EncodingFromDocument");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "EncodingFromDocument", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_EncodingPolicy_Type.tp_dict,
        "EncodingFromDocument", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXml_QDomNode_EncodingPolicy_Type,
        (long) QDomNode::EncodingFromTextStream, "EncodingFromTextStream");
    PyDict_SetItemString(SbkQDomNode_Type.super.ht_type.tp_dict,
        "EncodingFromTextStream", enum_item);
    PyDict_SetItemString(SbkPySide_QtXml_QDomNode_EncodingPolicy_Type.tp_dict,
        "EncodingFromTextStream", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDomNode::EncodingPolicy");

    Shiboken::TypeResolver::createValueTypeResolver<QDomNode >("QDomNode");
    Shiboken::TypeResolver::createValueTypeResolver<QDomNode >(typeid(QDomNode).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

