/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTSVG_PYTHON_H
#define SBK_QTSVG_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>

#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTSVG_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTSVG_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTSVG_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Class Includes
#include <qsvgrenderer.h>
#include <qsvgwidget.h>
#include <qsvggenerator.h>
#include <qgraphicssvgitem.h>

// Conversion Includes - Primitive Types
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QMap>
#include <QPair>
#include <QList>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QSet>
#include <QVector>

extern "C"
{

// Type indices
#define SBK_QSVGRENDERER_IDX                                         0
#define SBK_QSVGWIDGET_IDX                                           1
#define SBK_QSVGGENERATOR_IDX                                        2
#define SBK_QGRAPHICSSVGITEM_IDX                                     3
#define SBK_QtSvg_IDX_COUNT                                          4

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtSvgTypes;

// Useful macros
#define SbkQSvgRenderer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGRENDERER_IDX])
#define SbkQSvgRenderer_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGRENDERER_IDX])
#define SbkQSvgWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGWIDGET_IDX])
#define SbkQSvgWidget_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGWIDGET_IDX])
#define SbkQSvgGenerator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGGENERATOR_IDX])
#define SbkQSvgGenerator_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QSVGGENERATOR_IDX])
#define SbkQGraphicsSvgItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QGRAPHICSSVGITEM_IDX])
#define SbkQGraphicsSvgItem_CheckExact(op) ((op)->ob_type == (PyTypeObject*)SbkPySide_QtSvgTypes[SBK_QGRAPHICSSVGITEM_IDX])

} // extern "C"

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<>
inline PyTypeObject* SbkType<QSvgRenderer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSvgTypes[SBK_QSVGRENDERER_IDX]); }
template<>
inline PyTypeObject* SbkType<QSvgWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSvgTypes[SBK_QSVGWIDGET_IDX]); }
template<>
inline PyTypeObject* SbkType<QSvgGenerator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSvgTypes[SBK_QSVGGENERATOR_IDX]); }
template<>
inline PyTypeObject* SbkType<QGraphicsSvgItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtSvgTypes[SBK_QGRAPHICSSVGITEM_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QSvgRenderer* > : ObjectTypeConverter<QSvgRenderer >
{
};

template<>
struct Converter<QSvgRenderer& > : ObjectTypeReferenceConverter<QSvgRenderer >
{
};


template<>
struct Converter<QSvgWidget* > : ObjectTypeConverter<QSvgWidget >
{
};

template<>
struct Converter<QSvgWidget& > : ObjectTypeReferenceConverter<QSvgWidget >
{
};


template<>
struct Converter<QSvgGenerator* > : ObjectTypeConverter<QSvgGenerator >
{
};

template<>
struct Converter<QSvgGenerator& > : ObjectTypeReferenceConverter<QSvgGenerator >
{
};


template<>
struct Converter<QGraphicsSvgItem* > : ObjectTypeConverter<QGraphicsSvgItem >
{
};

template<>
struct Converter<QGraphicsSvgItem& > : ObjectTypeReferenceConverter<QGraphicsSvgItem >
{
};



} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTSVG_PYTHON_H

