/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtsql_python.h"

#include "qsqldriver_wrapper.h"

// Extra includes
#include <QList>
#include <QSize>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsqldriver.h>
#include <qsqlerror.h>
#include <qsqlfield.h>
#include <qsqlindex.h>
#include <qsqlrecord.h>
#include <qsqlresult.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSqlDriverWrapper::QSqlDriverWrapper(QObject * parent) : QSqlDriver(parent), m_metaObject(0) {
    // ... middle
}

bool QSqlDriverWrapper::beginTransaction()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "beginTransaction"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlDriver::beginTransaction();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.beginTransaction");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlDriverWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSqlDriverWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.close()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QSqlDriverWrapper::commitTransaction()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "commitTransaction"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlDriver::commitTransaction();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.commitTransaction");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlDriverWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSqlResult * QSqlDriverWrapper::createResult() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createResult"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.createResult()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSqlResult* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.createResult");
        return 0        ;
    }
    QSqlResult* cpp_result(Shiboken::Converter<QSqlResult* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QSqlDriverWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSqlDriverWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QSqlDriverWrapper::escapeIdentifier(const QString & identifier, QSqlDriver::IdentifierType type) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "escapeIdentifier"));
    if (py_override.isNull()) {
        return this->QSqlDriver::escapeIdentifier(identifier, type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(identifier),
        Shiboken::Converter<QSqlDriver::IdentifierType >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.escapeIdentifier");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QSqlDriverWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QSqlDriverWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

QString QSqlDriverWrapper::formatValue(const QSqlField & field, bool trimStrings) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "formatValue"));
    if (py_override.isNull()) {
        return this->QSqlDriver::formatValue(field, trimStrings);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QSqlField& >::toPython(field),
        Shiboken::Converter<bool >::toPython(trimStrings)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.formatValue");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QSqlDriverWrapper::hasFeature(QSqlDriver::DriverFeature f) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasFeature"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.hasFeature()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSqlDriver::DriverFeature >::toPython(f)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.hasFeature");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlDriverWrapper::isOpen() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isOpen"));
    if (py_override.isNull()) {
        return this->QSqlDriver::isOpen();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.isOpen");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSqlDriverWrapper::open(const QString & db, const QString & user, const QString & password, const QString & host, int port, const QString & connOpts)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOOiO)",
        Shiboken::Converter<QString& >::toPython(db),
        Shiboken::Converter<QString& >::toPython(user),
        Shiboken::Converter<QString& >::toPython(password),
        Shiboken::Converter<QString& >::toPython(host),
        port,
        Shiboken::Converter<QString& >::toPython(connOpts)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QSqlIndex QSqlDriverWrapper::primaryIndex(const QString & tableName) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "primaryIndex"));
    if (py_override.isNull()) {
        return this->QSqlDriver::primaryIndex(tableName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(tableName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSqlIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSqlIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.primaryIndex");
        return QSqlIndex()        ;
    }
    QSqlIndex cpp_result(Shiboken::Converter<QSqlIndex >::toCpp(py_result));
    return cpp_result;
}

QSqlRecord QSqlDriverWrapper::record(const QString & tableName) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "record"));
    if (py_override.isNull()) {
        return this->QSqlDriver::record(tableName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(tableName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSqlRecord();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSqlRecord >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.record");
        return QSqlRecord()        ;
    }
    QSqlRecord cpp_result(Shiboken::Converter<QSqlRecord >::toCpp(py_result));
    return cpp_result;
}

bool QSqlDriverWrapper::rollbackTransaction()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rollbackTransaction"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QSqlDriver::rollbackTransaction();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.rollbackTransaction");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QSqlDriverWrapper::setLastError(const QSqlError & e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setLastError"));
    if (py_override.isNull()) {
        return this->QSqlDriver::setLastError(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSqlError& >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlDriverWrapper::setOpen(bool o)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setOpen"));
    if (py_override.isNull()) {
        return this->QSqlDriver::setOpen(o);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(o)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSqlDriverWrapper::setOpenError(bool e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setOpenError"));
    if (py_override.isNull()) {
        return this->QSqlDriver::setOpenError(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QSqlDriverWrapper::sqlStatement(QSqlDriver::StatementType type, const QString & tableName, const QSqlRecord & rec, bool preparedStatement) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sqlStatement"));
    if (py_override.isNull()) {
        return this->QSqlDriver::sqlStatement(type, tableName, rec, preparedStatement);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OOOO)",
        Shiboken::Converter<QSqlDriver::StatementType >::toPython(type),
        Shiboken::Converter<QString& >::toPython(tableName),
        Shiboken::Converter<QSqlRecord& >::toPython(rec),
        Shiboken::Converter<bool >::toPython(preparedStatement)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.sqlStatement");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QStringList QSqlDriverWrapper::tables(QSql::TableType tableType) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tables"));
    if (py_override.isNull()) {
        return this->QSqlDriver::tables(tableType);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QSql::TableType >::toPython(tableType)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QSqlDriver.tables");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

void QSqlDriverWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSqlDriverWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSqlDriver::staticMetaObject);
}
    return m_metaObject;
}

int QSqlDriverWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSqlDriver::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSqlDriverWrapper::~QSqlDriverWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSqlDriver_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlDriverWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSqlDriver' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSqlDriver", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSqlDriver(QObject*)
        cptr = new QSqlDriverWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSqlDriver(QObject*)
        cptr = new QSqlDriverWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSqlDriver_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlDriver_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlDriver_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver", overloads);
        return -1;
}

static PyObject*
SbkQSqlDriverFunc_beginTransaction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // beginTransaction()
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDriver::beginTransaction();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // close()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.close()' not implemented.");
        return 0;
    }
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    cppSelf->close();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlDriverFunc_commitTransaction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // commitTransaction()
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDriver::commitTransaction();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_createResult(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createResult()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.createResult()' not implemented.");
        return 0;
    }
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    QSqlResult * cpp_result = cppSelf->createResult();
    py_result = Shiboken::Converter<QSqlResult* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_escapeIdentifier(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "escapeIdentifier", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriver::IdentifierType >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSqlDriver::IdentifierType cpp_arg1 = Shiboken::Converter<QSqlDriver::IdentifierType >::toCpp(pyargs[1]);
        // escapeIdentifier(QString,QSqlDriver::IdentifierType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlDriver::escapeIdentifier(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_escapeIdentifier_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_escapeIdentifier_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriver.IdentifierType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.escapeIdentifier", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_formatValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "formatValue", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QSqlField& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSqlField* cpp_arg0 = Shiboken::Converter<QSqlField* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // formatValue(QSqlField,bool)const
            QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QSqlDriver::formatValue(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // formatValue(QSqlField,bool)const
            QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QSqlDriver::formatValue(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else goto SbkQSqlDriverFunc_formatValue_TypeError;
    } else goto SbkQSqlDriverFunc_formatValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_formatValue_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlField, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.formatValue", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_hasFeature(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSqlDriver::DriverFeature >::isConvertible(arg)) {
        QSqlDriver::DriverFeature cpp_arg0 = Shiboken::Converter<QSqlDriver::DriverFeature >::toCpp(arg);
        // hasFeature(QSqlDriver::DriverFeature)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.hasFeature()' not implemented.");
            return 0;
        }
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->hasFeature(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_hasFeature_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_hasFeature_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDriver.DriverFeature", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.hasFeature", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_isIdentifierEscaped(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isIdentifierEscaped", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriver::IdentifierType >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSqlDriver::IdentifierType cpp_arg1 = Shiboken::Converter<QSqlDriver::IdentifierType >::toCpp(pyargs[1]);
        // isIdentifierEscaped(QString,QSqlDriver::IdentifierType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::isIdentifierEscaped(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_isIdentifierEscaped_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_isIdentifierEscaped_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriver.IdentifierType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.isIdentifierEscaped", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_isIdentifierEscapedImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isIdentifierEscapedImplementation", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriver::IdentifierType >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSqlDriver::IdentifierType cpp_arg1 = Shiboken::Converter<QSqlDriver::IdentifierType >::toCpp(pyargs[1]);
        // isIdentifierEscapedImplementation(QString,QSqlDriver::IdentifierType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::isIdentifierEscapedImplementation(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_isIdentifierEscapedImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_isIdentifierEscapedImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriver.IdentifierType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.isIdentifierEscapedImplementation", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_isOpen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpen()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlDriver::isOpen();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_isOpenError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpenError()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlDriver::isOpenError();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_lastError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastError()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    QSqlError cpp_result = cppSelf->QSqlDriver::lastError();
    py_result = Shiboken::Converter<QSqlError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_numericalPrecisionPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numericalPrecisionPolicy()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    QSql::NumericalPrecisionPolicy cpp_result = cppSelf->QSqlDriver::numericalPrecisionPolicy();
    py_result = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "open", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // open(QString,QString,QString,QString,int,QString)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                return 0;
            }
            QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->open(*cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // open(QString,QString,QString,QString,int,QString)
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                    return 0;
                }
                QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
                thread_state_saver.save();
                bool cpp_result = cppSelf->open(*cpp_arg0, *cpp_arg1);
                thread_state_saver.restore();
                py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QString > cpp_arg2_auto_ptr;
                QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
                if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
                if (numArgs == 3) {
                    // open(QString,QString,QString,QString,int,QString)
                    if (SbkBaseWrapper_containsCppWrapper(self)) {
                        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                        return 0;
                    }
                    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
                    thread_state_saver.save();
                    bool cpp_result = cppSelf->open(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                    thread_state_saver.restore();
                    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[3])) {
                    if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                        return 0;
                    std::auto_ptr<QString > cpp_arg3_auto_ptr;
                    QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                    if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
                        cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                    if (numArgs == 4) {
                        // open(QString,QString,QString,QString,int,QString)
                        if (SbkBaseWrapper_containsCppWrapper(self)) {
                            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                            return 0;
                        }
                        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
                        thread_state_saver.save();
                        bool cpp_result = cppSelf->open(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                        thread_state_saver.restore();
                        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                    } else if (PyNumber_Check(pyargs[4])) {
                        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                        if (numArgs == 5) {
                            // open(QString,QString,QString,QString,int,QString)
                            if (SbkBaseWrapper_containsCppWrapper(self)) {
                                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                                return 0;
                            }
                            QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
                            thread_state_saver.save();
                            bool cpp_result = cppSelf->open(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[5])) {
                            if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                                return 0;
                            std::auto_ptr<QString > cpp_arg5_auto_ptr;
                            QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
                            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[5]))
                                cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
                            // open(QString,QString,QString,QString,int,QString)
                            if (SbkBaseWrapper_containsCppWrapper(self)) {
                                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriver.open()' not implemented.");
                                return 0;
                            }
                            QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
                            thread_state_saver.save();
                            bool cpp_result = cppSelf->open(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5);
                            thread_state_saver.restore();
                            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
                        } else goto SbkQSqlDriverFunc_open_TypeError;
                    } else goto SbkQSqlDriverFunc_open_TypeError;
                } else goto SbkQSqlDriverFunc_open_TypeError;
            } else goto SbkQSqlDriverFunc_open_TypeError;
        } else goto SbkQSqlDriverFunc_open_TypeError;
    } else goto SbkQSqlDriverFunc_open_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_open_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString(), int = -1, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.open", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_primaryIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // primaryIndex(QString)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QSqlIndex cpp_result = cppSelf->QSqlDriver::primaryIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QSqlIndex >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_primaryIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_primaryIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.primaryIndex", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_record(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // record(QString)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QSqlRecord cpp_result = cppSelf->QSqlDriver::record(*cpp_arg0);
        py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_record_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_record_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.record", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_rollbackTransaction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // rollbackTransaction()
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDriver::rollbackTransaction();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_setLastError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSqlError& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSqlError* cpp_arg0 = Shiboken::Converter<QSqlError* >::toCpp(arg);
        // setLastError(QSqlError)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        cppSelf->QSqlDriver::setLastError(*cpp_arg0);
    } else goto SbkQSqlDriverFunc_setLastError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDriverFunc_setLastError_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlError", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.setLastError", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_setNumericalPrecisionPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSql::NumericalPrecisionPolicy >::isConvertible(arg)) {
        QSql::NumericalPrecisionPolicy cpp_arg0 = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toCpp(arg);
        // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        cppSelf->QSqlDriver::setNumericalPrecisionPolicy(cpp_arg0);
    } else goto SbkQSqlDriverFunc_setNumericalPrecisionPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDriverFunc_setNumericalPrecisionPolicy_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.NumericalPrecisionPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.setNumericalPrecisionPolicy", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_setOpen(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOpen(bool)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        cppSelf->QSqlDriver::setOpen(cpp_arg0);
    } else goto SbkQSqlDriverFunc_setOpen_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDriverFunc_setOpen_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.setOpen", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_setOpenError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOpenError(bool)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        cppSelf->QSqlDriver::setOpenError(cpp_arg0);
    } else goto SbkQSqlDriverFunc_setOpenError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDriverFunc_setOpenError_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.setOpenError", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_sqlStatement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sqlStatement", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QSqlDriver::StatementType >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1]) && Shiboken::Converter<QSqlRecord& >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        QSqlDriver::StatementType cpp_arg0 = Shiboken::Converter<QSqlDriver::StatementType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QSqlRecord* cpp_arg2 = Shiboken::Converter<QSqlRecord* >::toCpp(pyargs[2]);
        bool cpp_arg3 = Shiboken::Converter<bool >::toCpp(pyargs[3]);
        // sqlStatement(QSqlDriver::StatementType,QString,QSqlRecord,bool)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlDriver::sqlStatement(cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_sqlStatement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_sqlStatement_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDriver.StatementType, PySide.QtCore.QString, PySide.QtSql.QSqlRecord, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.sqlStatement", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_stripDelimiters(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "stripDelimiters", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriver::IdentifierType >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSqlDriver::IdentifierType cpp_arg1 = Shiboken::Converter<QSqlDriver::IdentifierType >::toCpp(pyargs[1]);
        // stripDelimiters(QString,QSqlDriver::IdentifierType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlDriver::stripDelimiters(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_stripDelimiters_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_stripDelimiters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriver.IdentifierType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.stripDelimiters", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_stripDelimitersImplementation(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "stripDelimitersImplementation", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriver::IdentifierType >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        QSqlDriver::IdentifierType cpp_arg1 = Shiboken::Converter<QSqlDriver::IdentifierType >::toCpp(pyargs[1]);
        // stripDelimitersImplementation(QString,QSqlDriver::IdentifierType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QSqlDriver::stripDelimitersImplementation(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_stripDelimitersImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_stripDelimitersImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriver.IdentifierType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDriver.stripDelimitersImplementation", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_subscribeToNotification(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // subscribeToNotification(QString)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::subscribeToNotification(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_subscribeToNotification_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_subscribeToNotification_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.subscribeToNotification", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_subscribeToNotificationImplementation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // subscribeToNotificationImplementation(QString)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::subscribeToNotificationImplementation(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_subscribeToNotificationImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_subscribeToNotificationImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.subscribeToNotificationImplementation", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_subscribedToNotifications(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // subscribedToNotifications()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSqlDriver::subscribedToNotifications();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_subscribedToNotificationsImplementation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // subscribedToNotificationsImplementation()const
    QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QSqlDriver::subscribedToNotificationsImplementation();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDriverFunc_tables(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSql::TableType >::isConvertible(arg)) {
        QSql::TableType cpp_arg0 = Shiboken::Converter<QSql::TableType >::toCpp(arg);
        // tables(QSql::TableType)const
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QSqlDriver::tables(cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_tables_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_tables_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.TableType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.tables", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_unsubscribeFromNotification(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // unsubscribeFromNotification(QString)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::unsubscribeFromNotification(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_unsubscribeFromNotification_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_unsubscribeFromNotification_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.unsubscribeFromNotification", overloads);
        return 0;
}

static PyObject*
SbkQSqlDriverFunc_unsubscribeFromNotificationImplementation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // unsubscribeFromNotificationImplementation(QString)
        QSqlDriver* cppSelf = Shiboken::Converter<QSqlDriver* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSqlDriver::unsubscribeFromNotificationImplementation(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDriverFunc_unsubscribeFromNotificationImplementation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDriverFunc_unsubscribeFromNotificationImplementation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDriver.unsubscribeFromNotificationImplementation", overloads);
        return 0;
}

static PyMethodDef SbkQSqlDriver_methods[] = {
    {"beginTransaction", (PyCFunction)SbkQSqlDriverFunc_beginTransaction, METH_NOARGS},
    {"close", (PyCFunction)SbkQSqlDriverFunc_close, METH_NOARGS},
    {"commitTransaction", (PyCFunction)SbkQSqlDriverFunc_commitTransaction, METH_NOARGS},
    {"createResult", (PyCFunction)SbkQSqlDriverFunc_createResult, METH_NOARGS},
    {"escapeIdentifier", (PyCFunction)SbkQSqlDriverFunc_escapeIdentifier, METH_VARARGS},
    {"formatValue", (PyCFunction)SbkQSqlDriverFunc_formatValue, METH_VARARGS},
    {"hasFeature", (PyCFunction)SbkQSqlDriverFunc_hasFeature, METH_O},
    {"isIdentifierEscaped", (PyCFunction)SbkQSqlDriverFunc_isIdentifierEscaped, METH_VARARGS},
    {"isIdentifierEscapedImplementation", (PyCFunction)SbkQSqlDriverFunc_isIdentifierEscapedImplementation, METH_VARARGS},
    {"isOpen", (PyCFunction)SbkQSqlDriverFunc_isOpen, METH_NOARGS},
    {"isOpenError", (PyCFunction)SbkQSqlDriverFunc_isOpenError, METH_NOARGS},
    {"lastError", (PyCFunction)SbkQSqlDriverFunc_lastError, METH_NOARGS},
    {"numericalPrecisionPolicy", (PyCFunction)SbkQSqlDriverFunc_numericalPrecisionPolicy, METH_NOARGS},
    {"open", (PyCFunction)SbkQSqlDriverFunc_open, METH_VARARGS},
    {"primaryIndex", (PyCFunction)SbkQSqlDriverFunc_primaryIndex, METH_O},
    {"record", (PyCFunction)SbkQSqlDriverFunc_record, METH_O},
    {"rollbackTransaction", (PyCFunction)SbkQSqlDriverFunc_rollbackTransaction, METH_NOARGS},
    {"setLastError", (PyCFunction)SbkQSqlDriverFunc_setLastError, METH_O},
    {"setNumericalPrecisionPolicy", (PyCFunction)SbkQSqlDriverFunc_setNumericalPrecisionPolicy, METH_O},
    {"setOpen", (PyCFunction)SbkQSqlDriverFunc_setOpen, METH_O},
    {"setOpenError", (PyCFunction)SbkQSqlDriverFunc_setOpenError, METH_O},
    {"sqlStatement", (PyCFunction)SbkQSqlDriverFunc_sqlStatement, METH_VARARGS},
    {"stripDelimiters", (PyCFunction)SbkQSqlDriverFunc_stripDelimiters, METH_VARARGS},
    {"stripDelimitersImplementation", (PyCFunction)SbkQSqlDriverFunc_stripDelimitersImplementation, METH_VARARGS},
    {"subscribeToNotification", (PyCFunction)SbkQSqlDriverFunc_subscribeToNotification, METH_O},
    {"subscribeToNotificationImplementation", (PyCFunction)SbkQSqlDriverFunc_subscribeToNotificationImplementation, METH_O},
    {"subscribedToNotifications", (PyCFunction)SbkQSqlDriverFunc_subscribedToNotifications, METH_NOARGS},
    {"subscribedToNotificationsImplementation", (PyCFunction)SbkQSqlDriverFunc_subscribedToNotificationsImplementation, METH_NOARGS},
    {"tables", (PyCFunction)SbkQSqlDriverFunc_tables, METH_O},
    {"unsubscribeFromNotification", (PyCFunction)SbkQSqlDriverFunc_unsubscribeFromNotification, METH_O},
    {"unsubscribeFromNotificationImplementation", (PyCFunction)SbkQSqlDriverFunc_unsubscribeFromNotificationImplementation, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlDriver_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlDriver",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlDriverWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlDriver_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlDriver_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtSql_QSqlDriver_StatementType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlDriver_StatementType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlDriver_StatementType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StatementType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlDriver_StatementType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlDriver_StatementType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlDriver_StatementType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtSql_QSqlDriver_IdentifierType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlDriver_IdentifierType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlDriver_IdentifierType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IdentifierType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlDriver_IdentifierType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlDriver_IdentifierType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlDriver_IdentifierType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtSql_QSqlDriver_DriverFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtSql_QSqlDriver_DriverFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtSql_QSqlDriver_DriverFeature_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DriverFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtSql_QSqlDriver_DriverFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtSql_QSqlDriver_DriverFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtSql_QSqlDriver_DriverFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QSqlDriver(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlDriver_Type);

    SbkQSqlDriver_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQSqlDriver_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSqlDriver_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlDriver_Type));
    PyModule_AddObject(module, "QSqlDriver",
        ((PyObject*)&SbkQSqlDriver_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StatementType
    SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_STATEMENTTYPE_IDX] = &SbkPySide_QtSql_QSqlDriver_StatementType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlDriver_StatementType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlDriver_StatementType_Type);
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
            "StatementType",((PyObject*)&SbkPySide_QtSql_QSqlDriver_StatementType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_StatementType_Type,
        (long) QSqlDriver::WhereStatement, "WhereStatement");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "WhereStatement", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_StatementType_Type.tp_dict,
        "WhereStatement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_StatementType_Type,
        (long) QSqlDriver::SelectStatement, "SelectStatement");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "SelectStatement", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_StatementType_Type.tp_dict,
        "SelectStatement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_StatementType_Type,
        (long) QSqlDriver::UpdateStatement, "UpdateStatement");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "UpdateStatement", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_StatementType_Type.tp_dict,
        "UpdateStatement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_StatementType_Type,
        (long) QSqlDriver::InsertStatement, "InsertStatement");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "InsertStatement", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_StatementType_Type.tp_dict,
        "InsertStatement", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_StatementType_Type,
        (long) QSqlDriver::DeleteStatement, "DeleteStatement");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "DeleteStatement", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_StatementType_Type.tp_dict,
        "DeleteStatement", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlDriver::StatementType");

    // init enum class: IdentifierType
    SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_IDENTIFIERTYPE_IDX] = &SbkPySide_QtSql_QSqlDriver_IdentifierType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlDriver_IdentifierType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlDriver_IdentifierType_Type);
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
            "IdentifierType",((PyObject*)&SbkPySide_QtSql_QSqlDriver_IdentifierType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_IdentifierType_Type,
        (long) QSqlDriver::FieldName, "FieldName");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "FieldName", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_IdentifierType_Type.tp_dict,
        "FieldName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_IdentifierType_Type,
        (long) QSqlDriver::TableName, "TableName");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "TableName", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_IdentifierType_Type.tp_dict,
        "TableName", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlDriver::IdentifierType");

    // init enum class: DriverFeature
    SbkPySide_QtSqlTypes[SBK_QSQLDRIVER_DRIVERFEATURE_IDX] = &SbkPySide_QtSql_QSqlDriver_DriverFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type);
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
            "DriverFeature",((PyObject*)&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::Transactions, "Transactions");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "Transactions", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "Transactions", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::QuerySize, "QuerySize");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "QuerySize", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "QuerySize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::BLOB, "BLOB");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "BLOB", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "BLOB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::Unicode, "Unicode");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "Unicode", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "Unicode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::PreparedQueries, "PreparedQueries");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "PreparedQueries", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "PreparedQueries", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::NamedPlaceholders, "NamedPlaceholders");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "NamedPlaceholders", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "NamedPlaceholders", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::PositionalPlaceholders, "PositionalPlaceholders");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "PositionalPlaceholders", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "PositionalPlaceholders", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::LastInsertId, "LastInsertId");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "LastInsertId", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "LastInsertId", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::BatchOperations, "BatchOperations");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "BatchOperations", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "BatchOperations", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::SimpleLocking, "SimpleLocking");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "SimpleLocking", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "SimpleLocking", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::LowPrecisionNumbers, "LowPrecisionNumbers");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "LowPrecisionNumbers", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "LowPrecisionNumbers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::EventNotifications, "EventNotifications");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "EventNotifications", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "EventNotifications", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::FinishQuery, "FinishQuery");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "FinishQuery", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "FinishQuery", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtSql_QSqlDriver_DriverFeature_Type,
        (long) QSqlDriver::MultipleResultSets, "MultipleResultSets");
    PyDict_SetItemString(SbkQSqlDriver_Type.super.ht_type.tp_dict,
        "MultipleResultSets", enum_item);
    PyDict_SetItemString(SbkPySide_QtSql_QSqlDriver_DriverFeature_Type.tp_dict,
        "MultipleResultSets", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSqlDriver::DriverFeature");

    Shiboken::TypeResolver::createObjectTypeResolver<QSqlDriver >("QSqlDriver*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSqlDriver >(typeid(QSqlDriver).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

