/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtsql_python.h"

#include "qsqldatabase_wrapper.h"

// Extra includes
#include <QSize>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <qsqldatabase.h>
#include <qsqldriver.h>
#include <qsqlerror.h>
#include <qsqlindex.h>
#include <qsqlquery.h>
#include <qsqlrecord.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQSqlDatabase_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSqlDatabase* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSqlDatabase", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSqlDatabase()
        cptr = new QSqlDatabase();
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QSqlDatabase(QString)
        cptr = new QSqlDatabase(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QSqlDatabase& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlDatabase* cpp_arg0 = Shiboken::Converter<QSqlDatabase* >::toCpp(pyargs[0]);
        // QSqlDatabase(QSqlDatabase)
        cptr = new QSqlDatabase(*cpp_arg0);
    } else if (numArgs == 1 && Shiboken::Converter<QSqlDriver* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSqlDriver* cpp_arg0 = Shiboken::Converter<QSqlDriver* >::toCpp(pyargs[0]);
        // QSqlDatabase(QSqlDriver*)
        cptr = new QSqlDatabase(cpp_arg0);
    } else goto SbkQSqlDatabase_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSqlDatabase_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQSqlDatabase_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtSql.QSqlDriver", "PySide.QtSql.QSqlDatabase", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase", overloads);
        return -1;
}

static PyObject*
SbkQSqlDatabaseFunc_addDatabase(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addDatabase", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addDatabase(QString,QString)
            QSqlDatabase cpp_result = QSqlDatabase::addDatabase(*cpp_arg0);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // addDatabase(QString,QString)
            QSqlDatabase cpp_result = QSqlDatabase::addDatabase(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else goto SbkQSqlDatabaseFunc_addDatabase_TypeError;
    } else if (Shiboken::Converter<QSqlDriver* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSqlDriver* cpp_arg0 = Shiboken::Converter<QSqlDriver* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // addDatabase(QSqlDriver*,QString)
            QSqlDatabase cpp_result = QSqlDatabase::addDatabase(cpp_arg0);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // addDatabase(QSqlDriver*,QString)
            QSqlDatabase cpp_result = QSqlDatabase::addDatabase(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else goto SbkQSqlDatabaseFunc_addDatabase_TypeError;
    } else goto SbkQSqlDatabaseFunc_addDatabase_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_addDatabase_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDriver, PySide.QtCore.QString = QLatin1String(QSqlDatabase.defaultConnection)", "PySide.QtCore.QString, PySide.QtCore.QString = QLatin1String(QSqlDatabase.defaultConnection)", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase.addDatabase", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_cloneDatabase(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cloneDatabase", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QSqlDatabase& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSqlDatabase* cpp_arg0 = Shiboken::Converter<QSqlDatabase* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // cloneDatabase(QSqlDatabase,QString)
        QSqlDatabase cpp_result = QSqlDatabase::cloneDatabase(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_cloneDatabase_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_cloneDatabase_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSqlDatabase, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase.cloneDatabase", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // close()
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    cppSelf->QSqlDatabase::close();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQSqlDatabaseFunc_commit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // commit()
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDatabase::commit();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_connectOptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // connectOptions()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::connectOptions();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_connectionName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // connectionName()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::connectionName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_connectionNames(PyObject* self)
{
    PyObject* py_result = 0;

    // connectionNames()
    QStringList cpp_result = QSqlDatabase::connectionNames();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_contains(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // contains(QString)
        bool cpp_result = QSqlDatabase::contains();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // contains(QString)
        bool cpp_result = QSqlDatabase::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QLatin1String(QSqlDatabase.defaultConnection)", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.contains", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_database(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "database", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // database(QString,bool)
        QSqlDatabase cpp_result = QSqlDatabase::database();
        py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // database(QString,bool)
            QSqlDatabase cpp_result = QSqlDatabase::database(*cpp_arg0);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // database(QString,bool)
            QSqlDatabase cpp_result = QSqlDatabase::database(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QSqlDatabase >::toPython(cpp_result);
        } else goto SbkQSqlDatabaseFunc_database_TypeError;
    } else goto SbkQSqlDatabaseFunc_database_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_database_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QLatin1String(QSqlDatabase.defaultConnection), bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase.database", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_databaseName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // databaseName()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::databaseName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_driver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // driver()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QSqlDriver * cpp_result = cppSelf->QSqlDatabase::driver();
    py_result = Shiboken::Converter<QSqlDriver* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_driverName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // driverName()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::driverName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_drivers(PyObject* self)
{
    PyObject* py_result = 0;

    // drivers()
    QStringList cpp_result = QSqlDatabase::drivers();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_exec_(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exec(QString)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QSqlQuery cpp_result = cppSelf->QSqlDatabase::exec();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QSqlQuery >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // exec(QString)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        QSqlQuery cpp_result = cppSelf->QSqlDatabase::exec(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<QSqlQuery >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_exec__TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_exec__TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.exec_", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_hostName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hostName()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::hostName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_isDriverAvailable(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isDriverAvailable(QString)
        bool cpp_result = QSqlDatabase::isDriverAvailable(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_isDriverAvailable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_isDriverAvailable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.isDriverAvailable", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_isOpen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpen()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlDatabase::isOpen();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_isOpenError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isOpenError()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlDatabase::isOpenError();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSqlDatabase::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_lastError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastError()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QSqlError cpp_result = cppSelf->QSqlDatabase::lastError();
    py_result = Shiboken::Converter<QSqlError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_numericalPrecisionPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numericalPrecisionPolicy()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QSql::NumericalPrecisionPolicy cpp_result = cppSelf->QSqlDatabase::numericalPrecisionPolicy();
    py_result = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQSqlDatabaseFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // open()
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlDatabase::open();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // open(QString,QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QSqlDatabase::open(*cpp_arg0, *cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_open_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_open_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase.open", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_password(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // password()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::password();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_port(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // port()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSqlDatabase::port();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_primaryIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // primaryIndex(QString)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        QSqlIndex cpp_result = cppSelf->QSqlDatabase::primaryIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QSqlIndex >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_primaryIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_primaryIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.primaryIndex", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_record(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // record(QString)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        QSqlRecord cpp_result = cppSelf->QSqlDatabase::record(*cpp_arg0);
        py_result = Shiboken::Converter<QSqlRecord >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_record_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_record_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.record", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_registerSqlDriver(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "registerSqlDriver", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && Shiboken::Converter<QSqlDriverCreatorBase* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QSqlDriverCreatorBase* cpp_arg1 = Shiboken::Converter<QSqlDriverCreatorBase* >::toCpp(pyargs[1]);
        // registerSqlDriver(QString,QSqlDriverCreatorBase*)
        QSqlDatabase::registerSqlDriver(*cpp_arg0, cpp_arg1);

        // Ownership transferences.
        BindingManager::instance().invalidateWrapper(pyargs[1]);
    } else goto SbkQSqlDatabaseFunc_registerSqlDriver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_registerSqlDriver_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtSql.QSqlDriverCreatorBase", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtSql.QSqlDatabase.registerSqlDriver", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_removeDatabase(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeDatabase(QString)
        QSqlDatabase::removeDatabase(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_removeDatabase_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_removeDatabase_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.removeDatabase", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_rollback(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // rollback()
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDatabase::rollback();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_setConnectOptions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setConnectOptions(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setConnectOptions();
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setConnectOptions(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setConnectOptions(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setConnectOptions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setConnectOptions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setConnectOptions", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setDatabaseName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDatabaseName(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setDatabaseName(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setDatabaseName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setDatabaseName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setDatabaseName", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setHostName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setHostName(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setHostName(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setHostName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setHostName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setHostName", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setNumericalPrecisionPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSql::NumericalPrecisionPolicy >::isConvertible(arg)) {
        QSql::NumericalPrecisionPolicy cpp_arg0 = Shiboken::Converter<QSql::NumericalPrecisionPolicy >::toCpp(arg);
        // setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setNumericalPrecisionPolicy(cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setNumericalPrecisionPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setNumericalPrecisionPolicy_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.NumericalPrecisionPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setNumericalPrecisionPolicy", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setPassword(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPassword(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setPassword(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setPassword_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setPassword_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setPassword", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setPort(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPort(int)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setPort(cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setPort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setPort_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setPort", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_setUserName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setUserName(QString)
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        cppSelf->QSqlDatabase::setUserName(*cpp_arg0);
    } else goto SbkQSqlDatabaseFunc_setUserName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSqlDatabaseFunc_setUserName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.setUserName", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_tables(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // tables(QSql::TableType)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QSqlDatabase::tables();
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else if (Shiboken::Converter<QSql::TableType >::isConvertible(arg)) {
        QSql::TableType cpp_arg0 = Shiboken::Converter<QSql::TableType >::toCpp(arg);
        // tables(QSql::TableType)const
        QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QSqlDatabase::tables(cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQSqlDatabaseFunc_tables_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQSqlDatabaseFunc_tables_TypeError:
        const char* overloads[] = {"PySide.QtSql.QSql.TableType = QSql.Tables", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtSql.QSqlDatabase.tables", overloads);
        return 0;
}

static PyObject*
SbkQSqlDatabaseFunc_transaction(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // transaction()
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QSqlDatabase::transaction();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQSqlDatabaseFunc_userName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userName()const
    QSqlDatabase* cppSelf = Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QSqlDatabase::userName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQSqlDatabase_methods[] = {
    {"addDatabase", (PyCFunction)SbkQSqlDatabaseFunc_addDatabase, METH_VARARGS|METH_STATIC},
    {"cloneDatabase", (PyCFunction)SbkQSqlDatabaseFunc_cloneDatabase, METH_VARARGS|METH_STATIC},
    {"close", (PyCFunction)SbkQSqlDatabaseFunc_close, METH_NOARGS},
    {"commit", (PyCFunction)SbkQSqlDatabaseFunc_commit, METH_NOARGS},
    {"connectOptions", (PyCFunction)SbkQSqlDatabaseFunc_connectOptions, METH_NOARGS},
    {"connectionName", (PyCFunction)SbkQSqlDatabaseFunc_connectionName, METH_NOARGS},
    {"connectionNames", (PyCFunction)SbkQSqlDatabaseFunc_connectionNames, METH_NOARGS|METH_STATIC},
    {"contains", (PyCFunction)SbkQSqlDatabaseFunc_contains, METH_NOARGS|METH_O|METH_STATIC},
    {"database", (PyCFunction)SbkQSqlDatabaseFunc_database, METH_VARARGS|METH_STATIC},
    {"databaseName", (PyCFunction)SbkQSqlDatabaseFunc_databaseName, METH_NOARGS},
    {"driver", (PyCFunction)SbkQSqlDatabaseFunc_driver, METH_NOARGS},
    {"driverName", (PyCFunction)SbkQSqlDatabaseFunc_driverName, METH_NOARGS},
    {"drivers", (PyCFunction)SbkQSqlDatabaseFunc_drivers, METH_NOARGS|METH_STATIC},
    {"exec_", (PyCFunction)SbkQSqlDatabaseFunc_exec_, METH_NOARGS|METH_O},
    {"hostName", (PyCFunction)SbkQSqlDatabaseFunc_hostName, METH_NOARGS},
    {"isDriverAvailable", (PyCFunction)SbkQSqlDatabaseFunc_isDriverAvailable, METH_O|METH_STATIC},
    {"isOpen", (PyCFunction)SbkQSqlDatabaseFunc_isOpen, METH_NOARGS},
    {"isOpenError", (PyCFunction)SbkQSqlDatabaseFunc_isOpenError, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQSqlDatabaseFunc_isValid, METH_NOARGS},
    {"lastError", (PyCFunction)SbkQSqlDatabaseFunc_lastError, METH_NOARGS},
    {"numericalPrecisionPolicy", (PyCFunction)SbkQSqlDatabaseFunc_numericalPrecisionPolicy, METH_NOARGS},
    {"open", (PyCFunction)SbkQSqlDatabaseFunc_open, METH_VARARGS},
    {"password", (PyCFunction)SbkQSqlDatabaseFunc_password, METH_NOARGS},
    {"port", (PyCFunction)SbkQSqlDatabaseFunc_port, METH_NOARGS},
    {"primaryIndex", (PyCFunction)SbkQSqlDatabaseFunc_primaryIndex, METH_O},
    {"record", (PyCFunction)SbkQSqlDatabaseFunc_record, METH_O},
    {"registerSqlDriver", (PyCFunction)SbkQSqlDatabaseFunc_registerSqlDriver, METH_VARARGS|METH_STATIC},
    {"removeDatabase", (PyCFunction)SbkQSqlDatabaseFunc_removeDatabase, METH_O|METH_STATIC},
    {"rollback", (PyCFunction)SbkQSqlDatabaseFunc_rollback, METH_NOARGS},
    {"setConnectOptions", (PyCFunction)SbkQSqlDatabaseFunc_setConnectOptions, METH_NOARGS|METH_O},
    {"setDatabaseName", (PyCFunction)SbkQSqlDatabaseFunc_setDatabaseName, METH_O},
    {"setHostName", (PyCFunction)SbkQSqlDatabaseFunc_setHostName, METH_O},
    {"setNumericalPrecisionPolicy", (PyCFunction)SbkQSqlDatabaseFunc_setNumericalPrecisionPolicy, METH_O},
    {"setPassword", (PyCFunction)SbkQSqlDatabaseFunc_setPassword, METH_O},
    {"setPort", (PyCFunction)SbkQSqlDatabaseFunc_setPort, METH_O},
    {"setUserName", (PyCFunction)SbkQSqlDatabaseFunc_setUserName, METH_O},
    {"tables", (PyCFunction)SbkQSqlDatabaseFunc_tables, METH_NOARGS|METH_O},
    {"transaction", (PyCFunction)SbkQSqlDatabaseFunc_transaction, METH_NOARGS},
    {"userName", (PyCFunction)SbkQSqlDatabaseFunc_userName, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQSqlDatabase_get_defaultConnection(SbkBaseWrapper* self)
{
    return Shiboken::Converter<const char * >::toPython(Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self)->defaultConnection);
}
static int SbkQSqlDatabase_set_defaultConnection(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'defaultConnection' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<const char * >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'defaultConnection', 'char' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QSqlDatabase* >::toCpp((PyObject*)self)->defaultConnection = Shiboken::Converter<const char * >::toCpp(value);

    return 0;
}

// Getters and Setters for QSqlDatabase
static PyGetSetDef SbkQSqlDatabase_getsetlist[] = {
    {const_cast<char*>("defaultConnection"), (getter)SbkQSqlDatabase_get_defaultConnection, (setter)SbkQSqlDatabase_set_defaultConnection},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSqlDatabase_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtSql.QSqlDatabase",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QSqlDatabase >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSqlDatabase_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQSqlDatabase_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSqlDatabase_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QSqlDatabase(PyObject* module)
{
    SbkPySide_QtSqlTypes[SBK_QSQLDATABASE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSqlDatabase_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSqlDatabase_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSqlDatabase_Type));
    PyModule_AddObject(module, "QSqlDatabase",
        ((PyObject*)&SbkQSqlDatabase_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QSqlDatabase >("QSqlDatabase");
    Shiboken::TypeResolver::createValueTypeResolver<QSqlDatabase >(typeid(QSqlDatabase).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

