/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtopengl_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtOpenGL_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QGL(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLFramebufferObjectFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLShader(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLContext(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLColormap(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLFormat(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLPixelBuffer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLFramebufferObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLShaderProgram(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGLWidget(PyObject* module);

PyTypeObject** SbkPySide_QtOpenGLTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTOPENGL_API PyMODINIT_FUNC
initQtOpenGL()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtOpenGL", QtOpenGL_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtOpenGL_IDX_COUNT];
    SbkPySide_QtOpenGLTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QGLFramebufferObjectFormat(module);
    init_QGLShader(module);
    init_QGLContext(module);
    init_QGLColormap(module);
    init_QGLFormat(module);
    init_QGLPixelBuffer(module);
    init_QGLFramebufferObject(module);
    init_QGLShaderProgram(module);
    init_QGLWidget(module);


    // Initialize namespaces as uninstantiable classes in the type system
    init_QGL(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtOpenGL");
    }
}

} // extern "C"

