/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qurlinfo_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qstring.h>
#include <qurl.h>
#include <qurlinfo.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QUrlInfoWrapper::QUrlInfoWrapper() : QUrlInfo() {
    // ... middle
}

QUrlInfoWrapper::QUrlInfoWrapper(const QString & name, int permissions, const QString & owner, const QString & group, qint64 size, const QDateTime & lastModified, const QDateTime & lastRead, bool isDir, bool isFile, bool isSymLink, bool isWritable, bool isReadable, bool isExecutable) : QUrlInfo(name, permissions, owner, group, size, lastModified, lastRead, isDir, isFile, isSymLink, isWritable, isReadable, isExecutable) {
    // ... middle
}

QUrlInfoWrapper::QUrlInfoWrapper(const QUrl & url, int permissions, const QString & owner, const QString & group, qint64 size, const QDateTime & lastModified, const QDateTime & lastRead, bool isDir, bool isFile, bool isSymLink, bool isWritable, bool isReadable, bool isExecutable) : QUrlInfo(url, permissions, owner, group, size, lastModified, lastRead, isDir, isFile, isSymLink, isWritable, isReadable, isExecutable) {
    // ... middle
}

void QUrlInfoWrapper::setDir(bool b)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setDir"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setDir(b);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(b)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setFile(bool b)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setFile"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setFile(b);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(b)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setGroup(const QString & s)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGroup"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setGroup(s);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(s)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setLastModified(const QDateTime & dt)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setLastModified"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setLastModified(dt);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QDateTime& >::toPython(dt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setName(const QString & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setName"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setName(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setOwner(const QString & s)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setOwner"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setOwner(s);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(s)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setPermissions(int p)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setPermissions"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setPermissions(p);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        p
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setReadable(bool b)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setReadable"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setReadable(b);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(b)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setSize(qint64 size)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSize"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setSize(size);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(size)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setSymLink(bool b)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSymLink"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setSymLink(b);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(b)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QUrlInfoWrapper::setWritable(bool b)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setWritable"));
    if (py_override.isNull()) {
        return this->QUrlInfo::setWritable(b);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<bool >::toPython(b)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QUrlInfoWrapper::~QUrlInfoWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQUrlInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUrlInfoWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10 || numArgs == 11 || numArgs == 12)
        goto SbkQUrlInfo_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QUrlInfo", 0, 13, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9]), &(pyargs[10]), &(pyargs[11]), &(pyargs[12])))
        return -1;

    if (numArgs == 0) {
        // QUrlInfo()
        cptr = new QUrlInfoWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QUrlInfo* cpp_arg0 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[0]);
        // QUrlInfo(QUrlInfo)
        cptr = new QUrlInfoWrapper(*cpp_arg0);
    } else if (numArgs == 13 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QDateTime& >::isConvertible(pyargs[5]) && Shiboken::Converter<QDateTime& >::isConvertible(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8]) && PyNumber_Check(pyargs[9]) && PyNumber_Check(pyargs[10]) && PyNumber_Check(pyargs[11]) && PyNumber_Check(pyargs[12])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        qint64 cpp_arg4 = Shiboken::Converter<qint64 >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return -1;
        QDateTime* cpp_arg5 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[5]);
        if (Shiboken::cppObjectIsInvalid(pyargs[6]))
            return -1;
        QDateTime* cpp_arg6 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[6]);
        bool cpp_arg7 = Shiboken::Converter<bool >::toCpp(pyargs[7]);
        bool cpp_arg8 = Shiboken::Converter<bool >::toCpp(pyargs[8]);
        bool cpp_arg9 = Shiboken::Converter<bool >::toCpp(pyargs[9]);
        bool cpp_arg10 = Shiboken::Converter<bool >::toCpp(pyargs[10]);
        bool cpp_arg11 = Shiboken::Converter<bool >::toCpp(pyargs[11]);
        bool cpp_arg12 = Shiboken::Converter<bool >::toCpp(pyargs[12]);
        // QUrlInfo(QString,int,QString,QString,qint64,QDateTime,QDateTime,bool,bool,bool,bool,bool,bool)
        cptr = new QUrlInfoWrapper(*cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5, *cpp_arg6, cpp_arg7, cpp_arg8, cpp_arg9, cpp_arg10, cpp_arg11, cpp_arg12);
    } else if (numArgs == 13 && Shiboken::Converter<QUrl& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString& >::isConvertible(pyargs[2]) && Shiboken::Converter<QString& >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QDateTime& >::isConvertible(pyargs[5]) && Shiboken::Converter<QDateTime& >::isConvertible(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8]) && PyNumber_Check(pyargs[9]) && PyNumber_Check(pyargs[10]) && PyNumber_Check(pyargs[11]) && PyNumber_Check(pyargs[12])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QUrl& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        qint64 cpp_arg4 = Shiboken::Converter<qint64 >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return -1;
        QDateTime* cpp_arg5 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[5]);
        if (Shiboken::cppObjectIsInvalid(pyargs[6]))
            return -1;
        QDateTime* cpp_arg6 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[6]);
        bool cpp_arg7 = Shiboken::Converter<bool >::toCpp(pyargs[7]);
        bool cpp_arg8 = Shiboken::Converter<bool >::toCpp(pyargs[8]);
        bool cpp_arg9 = Shiboken::Converter<bool >::toCpp(pyargs[9]);
        bool cpp_arg10 = Shiboken::Converter<bool >::toCpp(pyargs[10]);
        bool cpp_arg11 = Shiboken::Converter<bool >::toCpp(pyargs[11]);
        bool cpp_arg12 = Shiboken::Converter<bool >::toCpp(pyargs[12]);
        // QUrlInfo(QUrl,int,QString,QString,qint64,QDateTime,QDateTime,bool,bool,bool,bool,bool,bool)
        cptr = new QUrlInfoWrapper(*cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3, cpp_arg4, *cpp_arg5, *cpp_arg6, cpp_arg7, cpp_arg8, cpp_arg9, cpp_arg10, cpp_arg11, cpp_arg12);
    } else goto SbkQUrlInfo_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUrlInfo_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQUrlInfo_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString, int, PySide.QtCore.QString, PySide.QtCore.QString, long long, PySide.QtCore.QDateTime, PySide.QtCore.QDateTime, bool, bool, bool, bool, bool, bool", "PySide.QtCore.QUrl, int, PySide.QtCore.QString, PySide.QtCore.QString, long long, PySide.QtCore.QDateTime, PySide.QtCore.QDateTime, bool, bool, bool, bool, bool, bool", "PySide.QtNetwork.QUrlInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QUrlInfo", overloads);
        return -1;
}

static PyObject*
SbkQUrlInfoFunc_equal(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "equal", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[0]) && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QUrlInfo* cpp_arg0 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QUrlInfo* cpp_arg1 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // equal(QUrlInfo,QUrlInfo,int)
        bool cpp_result = QUrlInfo::equal(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQUrlInfoFunc_equal_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQUrlInfoFunc_equal_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QUrlInfo, PySide.QtNetwork.QUrlInfo, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QUrlInfo.equal", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_greaterThan(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "greaterThan", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[0]) && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QUrlInfo* cpp_arg0 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QUrlInfo* cpp_arg1 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // greaterThan(QUrlInfo,QUrlInfo,int)
        bool cpp_result = QUrlInfo::greaterThan(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQUrlInfoFunc_greaterThan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQUrlInfoFunc_greaterThan_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QUrlInfo, PySide.QtNetwork.QUrlInfo, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QUrlInfo.greaterThan", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_group(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // group()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrlInfo::group();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isDir(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDir()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isDir();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isExecutable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isExecutable()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isExecutable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isFile(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFile()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isFile();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isSymLink(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSymLink()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isSymLink();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUrlInfo::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_lastModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastModified()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QUrlInfo::lastModified();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_lastRead(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastRead()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QUrlInfo::lastRead();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_lessThan(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "lessThan", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[0]) && Shiboken::Converter<QUrlInfo& >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QUrlInfo* cpp_arg0 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QUrlInfo* cpp_arg1 = Shiboken::Converter<QUrlInfo* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // lessThan(QUrlInfo,QUrlInfo,int)
        bool cpp_result = QUrlInfo::lessThan(*cpp_arg0, *cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQUrlInfoFunc_lessThan_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQUrlInfoFunc_lessThan_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QUrlInfo, PySide.QtNetwork.QUrlInfo, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QUrlInfo.lessThan", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrlInfo::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_owner(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // owner()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUrlInfo::owner();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_permissions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // permissions()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QUrlInfo::permissions();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQUrlInfoFunc_setDir(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDir(bool)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setDir(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setDir_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setDir_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setDir", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setFile(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFile(bool)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setFile(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setFile_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setFile", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setGroup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setGroup(QString)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setGroup(*cpp_arg0);
    } else goto SbkQUrlInfoFunc_setGroup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setGroup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setGroup", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setLastModified(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setLastModified(QDateTime)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setLastModified(*cpp_arg0);
    } else goto SbkQUrlInfoFunc_setLastModified_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setLastModified_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setLastModified", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setLastRead(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setLastRead(QDateTime)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setLastRead(*cpp_arg0);
    } else goto SbkQUrlInfoFunc_setLastRead_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setLastRead_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setLastRead", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setName(QString)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setName(*cpp_arg0);
    } else goto SbkQUrlInfoFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setName", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setOwner(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOwner(QString)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setOwner(*cpp_arg0);
    } else goto SbkQUrlInfoFunc_setOwner_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setOwner_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setOwner", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setPermissions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPermissions(int)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setPermissions(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setPermissions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setPermissions_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setPermissions", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setReadable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadable(bool)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setReadable(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setReadable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setReadable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setReadable", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setSize(qint64)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setSize(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setSize", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setSymLink(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSymLink(bool)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setSymLink(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setSymLink_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setSymLink_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setSymLink", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_setWritable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWritable(bool)
        QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
        cppSelf->QUrlInfo::setWritable(cpp_arg0);
    } else goto SbkQUrlInfoFunc_setWritable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQUrlInfoFunc_setWritable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QUrlInfo.setWritable", overloads);
        return 0;
}

static PyObject*
SbkQUrlInfoFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QUrlInfo* cppSelf = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QUrlInfo::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQUrlInfo_methods[] = {
    {"equal", (PyCFunction)SbkQUrlInfoFunc_equal, METH_VARARGS|METH_STATIC},
    {"greaterThan", (PyCFunction)SbkQUrlInfoFunc_greaterThan, METH_VARARGS|METH_STATIC},
    {"group", (PyCFunction)SbkQUrlInfoFunc_group, METH_NOARGS},
    {"isDir", (PyCFunction)SbkQUrlInfoFunc_isDir, METH_NOARGS},
    {"isExecutable", (PyCFunction)SbkQUrlInfoFunc_isExecutable, METH_NOARGS},
    {"isFile", (PyCFunction)SbkQUrlInfoFunc_isFile, METH_NOARGS},
    {"isReadable", (PyCFunction)SbkQUrlInfoFunc_isReadable, METH_NOARGS},
    {"isSymLink", (PyCFunction)SbkQUrlInfoFunc_isSymLink, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQUrlInfoFunc_isValid, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQUrlInfoFunc_isWritable, METH_NOARGS},
    {"lastModified", (PyCFunction)SbkQUrlInfoFunc_lastModified, METH_NOARGS},
    {"lastRead", (PyCFunction)SbkQUrlInfoFunc_lastRead, METH_NOARGS},
    {"lessThan", (PyCFunction)SbkQUrlInfoFunc_lessThan, METH_VARARGS|METH_STATIC},
    {"name", (PyCFunction)SbkQUrlInfoFunc_name, METH_NOARGS},
    {"owner", (PyCFunction)SbkQUrlInfoFunc_owner, METH_NOARGS},
    {"permissions", (PyCFunction)SbkQUrlInfoFunc_permissions, METH_NOARGS},
    {"setDir", (PyCFunction)SbkQUrlInfoFunc_setDir, METH_O},
    {"setFile", (PyCFunction)SbkQUrlInfoFunc_setFile, METH_O},
    {"setGroup", (PyCFunction)SbkQUrlInfoFunc_setGroup, METH_O},
    {"setLastModified", (PyCFunction)SbkQUrlInfoFunc_setLastModified, METH_O},
    {"setLastRead", (PyCFunction)SbkQUrlInfoFunc_setLastRead, METH_O},
    {"setName", (PyCFunction)SbkQUrlInfoFunc_setName, METH_O},
    {"setOwner", (PyCFunction)SbkQUrlInfoFunc_setOwner, METH_O},
    {"setPermissions", (PyCFunction)SbkQUrlInfoFunc_setPermissions, METH_O},
    {"setReadable", (PyCFunction)SbkQUrlInfoFunc_setReadable, METH_O},
    {"setSize", (PyCFunction)SbkQUrlInfoFunc_setSize, METH_O},
    {"setSymLink", (PyCFunction)SbkQUrlInfoFunc_setSymLink, METH_O},
    {"setWritable", (PyCFunction)SbkQUrlInfoFunc_setWritable, METH_O},
    {"size", (PyCFunction)SbkQUrlInfoFunc_size, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQUrlInfo_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QUrlInfo& cpp_self = *Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QUrlInfo& >::isConvertible(other)) {
                QUrlInfo* cpp_other = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQUrlInfo_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QUrlInfo& >::isConvertible(other)) {
                QUrlInfo* cpp_other = Shiboken::Converter<QUrlInfo* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQUrlInfo_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQUrlInfo_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

static void* SbkQUrlInfo_ObjCopierFunc(const void* ptr){
    return new QUrlInfoWrapper(*reinterpret_cast<const QUrlInfo*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUrlInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QUrlInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QUrlInfoWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQUrlInfo_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUrlInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUrlInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQUrlInfo_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static SbkBaseWrapperType* SbkQUrlInfo_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQUrlInfo_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QUrlInfo*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PermissionSpec",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QUrlInfo(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QURLINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUrlInfo_Type);

    // Fill type discovery information
    SbkQUrlInfo_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQUrlInfo_Type.type_discovery->addTypeDiscoveryFunction(&SbkQUrlInfo_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQUrlInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUrlInfo_Type));
    PyModule_AddObject(module, "QUrlInfo",
        ((PyObject*)&SbkQUrlInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PermissionSpec
    SbkPySide_QtNetworkTypes[SBK_QURLINFO_PERMISSIONSPEC_IDX] = &SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type);
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
            "PermissionSpec",((PyObject*)&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ReadOwner, "ReadOwner");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ReadOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ReadOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::WriteOwner, "WriteOwner");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "WriteOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "WriteOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ExeOwner, "ExeOwner");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ExeOwner", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ExeOwner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ReadGroup, "ReadGroup");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ReadGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ReadGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::WriteGroup, "WriteGroup");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "WriteGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "WriteGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ExeGroup, "ExeGroup");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ExeGroup", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ExeGroup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ReadOther, "ReadOther");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ReadOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ReadOther", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::WriteOther, "WriteOther");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "WriteOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "WriteOther", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type,
        (long) QUrlInfo::ExeOther, "ExeOther");
    PyDict_SetItemString(SbkQUrlInfo_Type.super.ht_type.tp_dict,
        "ExeOther", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QUrlInfo_PermissionSpec_Type.tp_dict,
        "ExeOther", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QUrlInfo::PermissionSpec");

    Shiboken::TypeResolver::createValueTypeResolver<QUrlInfo >("QUrlInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QUrlInfo >(typeid(QUrlInfo).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

