/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qtcpserver_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qhostaddress.h>
#include <qnetworkproxy.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qtcpserver.h>
#include <qtcpsocket.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTcpServerWrapper::QTcpServerWrapper(QObject * parent) : QTcpServer(parent), m_metaObject(0) {
    // ... middle
}

void QTcpServerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTcpServerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTcpServerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTcpServerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QTcpServerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTcpServer.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QTcpServerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTcpServer.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QTcpServerWrapper::hasPendingConnections() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasPendingConnections"));
    if (py_override.isNull()) {
        return this->QTcpServer::hasPendingConnections();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTcpServer.hasPendingConnections");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTcpServerWrapper::incomingConnection(int handle)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "incomingConnection"));
    if (py_override.isNull()) {
        return this->QTcpServer::incomingConnection(handle);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        handle
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QTcpSocket * QTcpServerWrapper::nextPendingConnection()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "nextPendingConnection"));
    if (py_override.isNull()) {
        return this->QTcpServer::nextPendingConnection();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QTcpSocket* >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QTcpServer.nextPendingConnection");
        return 0        ;
    }
    QTcpSocket* cpp_result(Shiboken::Converter<QTcpSocket* >::toCpp(py_result));
    Shiboken::setParent(BindingManager::instance().retrieveWrapper(this), py_result);
    return cpp_result;
}

void QTcpServerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QTcpServerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTcpServer::staticMetaObject);
}
    return m_metaObject;
}

int QTcpServerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTcpServer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTcpServerWrapper::~QTcpServerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTcpServer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTcpServerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTcpServer", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTcpServer(QObject*)
        cptr = new QTcpServerWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QTcpServer(QObject*)
        cptr = new QTcpServerWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTcpServer_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTcpServer_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTcpServer_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QTcpServer", overloads);
        return -1;
}

static PyObject*
SbkQTcpServerFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // close()
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    cppSelf->QTcpServer::close();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTcpServerFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTcpServer::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_hasPendingConnections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPendingConnections()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTcpServer::hasPendingConnections();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_incomingConnection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // incomingConnection(int)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        cppSelf->QTcpServer::incomingConnection(cpp_arg0);
    } else goto SbkQTcpServerFunc_incomingConnection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTcpServerFunc_incomingConnection_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QTcpServer.incomingConnection", overloads);
        return 0;
}

static PyObject*
SbkQTcpServerFunc_isListening(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isListening()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTcpServer::isListening();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_listen(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "listen", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // listen(QHostAddress,quint16)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTcpServer::listen();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QHostAddress& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QHostAddress& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        if (numArgs == 1) {
            // listen(QHostAddress,quint16)
            QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTcpServer::listen(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (PyNumber_Check(pyargs[1])) {
            quint16 cpp_arg1 = Shiboken::Converter<quint16 >::toCpp(pyargs[1]);
            // listen(QHostAddress,quint16)
            QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QTcpServer::listen(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQTcpServerFunc_listen_TypeError;
    } else goto SbkQTcpServerFunc_listen_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTcpServerFunc_listen_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress = QHostAddress.Any, unsigned short = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QTcpServer.listen", overloads);
        return 0;
}

static PyObject*
SbkQTcpServerFunc_maxPendingConnections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxPendingConnections()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTcpServer::maxPendingConnections();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_nextPendingConnection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextPendingConnection()
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    QTcpSocket * cpp_result = cppSelf->QTcpServer::nextPendingConnection();
    py_result = Shiboken::Converter<QTcpSocket* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_proxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proxy()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    QNetworkProxy cpp_result = cppSelf->QTcpServer::proxy();
    py_result = Shiboken::Converter<QNetworkProxy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_serverAddress(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // serverAddress()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QTcpServer::serverAddress();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_serverError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // serverError()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    QAbstractSocket::SocketError cpp_result = cppSelf->QTcpServer::serverError();
    py_result = Shiboken::Converter<QAbstractSocket::SocketError >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_serverPort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // serverPort()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    quint16 cpp_result = cppSelf->QTcpServer::serverPort();
    py_result = Shiboken::Converter<unsigned short >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_setMaxPendingConnections(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaxPendingConnections(int)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        cppSelf->QTcpServer::setMaxPendingConnections(cpp_arg0);
    } else goto SbkQTcpServerFunc_setMaxPendingConnections_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTcpServerFunc_setMaxPendingConnections_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QTcpServer.setMaxPendingConnections", overloads);
        return 0;
}

static PyObject*
SbkQTcpServerFunc_setProxy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkProxy& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(arg);
        if (!Shiboken::Converter<QNetworkProxy& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // setProxy(QNetworkProxy)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        cppSelf->QTcpServer::setProxy(*cpp_arg0);
    } else goto SbkQTcpServerFunc_setProxy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTcpServerFunc_setProxy_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QTcpServer.setProxy", overloads);
        return 0;
}

static PyObject*
SbkQTcpServerFunc_setSocketDescriptor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSocketDescriptor(int)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTcpServer::setSocketDescriptor(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQTcpServerFunc_setSocketDescriptor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTcpServerFunc_setSocketDescriptor_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QTcpServer.setSocketDescriptor", overloads);
        return 0;
}

static PyObject*
SbkQTcpServerFunc_socketDescriptor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // socketDescriptor()const
    QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTcpServer::socketDescriptor();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTcpServerFunc_waitForNewConnection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // waitForNewConnection(int,bool*)
        QTcpServer* cppSelf = Shiboken::Converter<QTcpServer* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,bool* - START
        bool ok_;
        bool retval_ = cppSelf->waitForNewConnection(cpp_arg0, &ok_);
        py_result = Shiboken::makeTuple(retval_, ok_);
        // TEMPLATE - fix_args,bool* - END
        
        // End of code injection


    } else goto SbkQTcpServerFunc_waitForNewConnection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQTcpServerFunc_waitForNewConnection_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QTcpServer.waitForNewConnection", overloads);
        return 0;
}

static PyMethodDef SbkQTcpServer_methods[] = {
    {"close", (PyCFunction)SbkQTcpServerFunc_close, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQTcpServerFunc_errorString, METH_NOARGS},
    {"hasPendingConnections", (PyCFunction)SbkQTcpServerFunc_hasPendingConnections, METH_NOARGS},
    {"incomingConnection", (PyCFunction)SbkQTcpServerFunc_incomingConnection, METH_O},
    {"isListening", (PyCFunction)SbkQTcpServerFunc_isListening, METH_NOARGS},
    {"listen", (PyCFunction)SbkQTcpServerFunc_listen, METH_VARARGS},
    {"maxPendingConnections", (PyCFunction)SbkQTcpServerFunc_maxPendingConnections, METH_NOARGS},
    {"nextPendingConnection", (PyCFunction)SbkQTcpServerFunc_nextPendingConnection, METH_NOARGS},
    {"proxy", (PyCFunction)SbkQTcpServerFunc_proxy, METH_NOARGS},
    {"serverAddress", (PyCFunction)SbkQTcpServerFunc_serverAddress, METH_NOARGS},
    {"serverError", (PyCFunction)SbkQTcpServerFunc_serverError, METH_NOARGS},
    {"serverPort", (PyCFunction)SbkQTcpServerFunc_serverPort, METH_NOARGS},
    {"setMaxPendingConnections", (PyCFunction)SbkQTcpServerFunc_setMaxPendingConnections, METH_O},
    {"setProxy", (PyCFunction)SbkQTcpServerFunc_setProxy, METH_O},
    {"setSocketDescriptor", (PyCFunction)SbkQTcpServerFunc_setSocketDescriptor, METH_O},
    {"socketDescriptor", (PyCFunction)SbkQTcpServerFunc_socketDescriptor, METH_NOARGS},
    {"waitForNewConnection", (PyCFunction)SbkQTcpServerFunc_waitForNewConnection, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTcpServer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QTcpServer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTcpServerWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTcpServer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTcpServer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QTcpServer(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QTCPSERVER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTcpServer_Type);

    SbkQTcpServer_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQTcpServer_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTcpServer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTcpServer_Type));
    PyModule_AddObject(module, "QTcpServer",
        ((PyObject*)&SbkQTcpServer_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QTcpServer >("QTcpServer*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTcpServer >(typeid(QTcpServer).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

